/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.eval;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.saxon.trans.XPathException;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.ComponentNotFoundException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.Sequencable;
import org.teiid.core.types.Streamable;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.XMLType;
import org.teiid.core.types.basic.StringToSQLXMLTransform;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.AbstractSetCriteria;
import org.teiid.query.sql.lang.CollectionValueIterator;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ContextReference;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.QueryString;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.symbol.TextLine;
import org.teiid.query.sql.symbol.XMLElement;
import org.teiid.query.sql.symbol.XMLForest;
import org.teiid.query.sql.symbol.XMLNamespaces;
import org.teiid.query.sql.symbol.XMLParse;
import org.teiid.query.sql.symbol.XMLQuery;
import org.teiid.query.sql.symbol.XMLSerialize;
import org.teiid.query.sql.util.ValueIterator;
import org.teiid.query.sql.util.ValueIteratorSource;
import org.teiid.query.util.CommandContext;
import org.teiid.query.xquery.saxon.SaxonXQueryExpression;
import org.teiid.translator.WSConnection;

public class Evaluator {
    private static final char[] REGEX_RESERVED = new char[]{'$', '(', ')', '*', '.', '?', '[', '\\', ']', '^', '{', '|', '}'};
    private static final MatchCriteria.PatternTranslator LIKE_TO_REGEX = new MatchCriteria.PatternTranslator(".*", ".", REGEX_RESERVED, '\\');
    private Map elements;
    protected ProcessorDataManager dataMgr;
    protected CommandContext context;

    public static boolean evaluate(Criteria criteria) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        return new Evaluator(Collections.emptyMap(), null, null).evaluate(criteria, Collections.emptyList());
    }

    public static Object evaluate(Expression expression) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        return new Evaluator(Collections.emptyMap(), null, null).evaluate(expression, Collections.emptyList());
    }

    public Evaluator(Map elements, ProcessorDataManager dataMgr, CommandContext context) {
        this.context = context;
        this.dataMgr = dataMgr;
        this.elements = elements;
    }

    public void initialize(CommandContext context, ProcessorDataManager dataMgr) {
        this.context = context;
        this.dataMgr = dataMgr;
    }

    public boolean evaluate(Criteria criteria, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        return Boolean.TRUE.equals(this.evaluateTVL(criteria, tuple));
    }

    public Boolean evaluateTVL(Criteria criteria, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        if (criteria instanceof CompoundCriteria) {
            return this.evaluate((CompoundCriteria)criteria, tuple);
        }
        if (criteria instanceof NotCriteria) {
            return this.evaluate((NotCriteria)criteria, tuple);
        }
        if (criteria instanceof CompareCriteria) {
            return this.evaluate((CompareCriteria)criteria, tuple);
        }
        if (criteria instanceof MatchCriteria) {
            return this.evaluate((MatchCriteria)criteria, tuple);
        }
        if (criteria instanceof AbstractSetCriteria) {
            return this.evaluate((AbstractSetCriteria)criteria, tuple);
        }
        if (criteria instanceof IsNullCriteria) {
            return this.evaluate((IsNullCriteria)criteria, tuple);
        }
        if (criteria instanceof SubqueryCompareCriteria) {
            return this.evaluate((SubqueryCompareCriteria)criteria, tuple);
        }
        if (criteria instanceof ExistsCriteria) {
            return this.evaluate((ExistsCriteria)criteria, tuple);
        }
        if (criteria instanceof ExpressionCriteria) {
            return (Boolean)this.evaluate(((ExpressionCriteria)criteria).getExpression(), tuple);
        }
        throw new ExpressionEvaluationException("ERR.015.006.0010", QueryPlugin.Util.getString("ERR.015.006.0010", new Object[]{criteria}));
    }

    public Boolean evaluate(CompoundCriteria criteria, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        Boolean result;
        List<Criteria> subCrits = criteria.getCriteria();
        Iterator<Criteria> subCritIter = subCrits.iterator();
        boolean and = criteria.getOperator() == 0;
        Boolean bl = result = and ? Boolean.TRUE : Boolean.FALSE;
        while (subCritIter.hasNext()) {
            Criteria subCrit = subCritIter.next();
            Boolean value = this.evaluateTVL(subCrit, tuple);
            if (value == null) {
                result = null;
                continue;
            }
            if (!value.booleanValue()) {
                if (!and) continue;
                return Boolean.FALSE;
            }
            if (and) continue;
            return Boolean.TRUE;
        }
        return result;
    }

    public Boolean evaluate(NotCriteria criteria, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        Criteria subCrit = criteria.getCriteria();
        Boolean result = this.evaluateTVL(subCrit, tuple);
        if (result == null) {
            return null;
        }
        if (result.booleanValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean evaluate(CompareCriteria criteria, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        Object leftValue = null;
        try {
            leftValue = this.evaluate(criteria.getLeftExpression(), tuple);
        }
        catch (ExpressionEvaluationException e) {
            throw new ExpressionEvaluationException((Throwable)((Object)e), "ERR.015.006.0011", QueryPlugin.Util.getString("ERR.015.006.0011", new Object[]{"left", criteria}));
        }
        if (leftValue == null) {
            return null;
        }
        Object rightValue = null;
        try {
            rightValue = this.evaluate(criteria.getRightExpression(), tuple);
        }
        catch (ExpressionEvaluationException e) {
            throw new ExpressionEvaluationException((Throwable)((Object)e), "ERR.015.006.0011", QueryPlugin.Util.getString("ERR.015.006.0011", new Object[]{"right", criteria}));
        }
        if (rightValue == null) {
            return null;
        }
        return Evaluator.compare(criteria, leftValue, rightValue);
    }

    public static Boolean compare(CompareCriteria criteria, Object leftValue, Object rightValue) throws ExpressionEvaluationException {
        switch (criteria.getOperator()) {
            case 1: {
                return Evaluator.compareValues(leftValue, rightValue) == 0;
            }
            case 2: {
                return Evaluator.compareValues(leftValue, rightValue) != 0;
            }
            case 3: {
                return Evaluator.compareValues(leftValue, rightValue) < 0;
            }
            case 5: {
                return Evaluator.compareValues(leftValue, rightValue) <= 0;
            }
            case 4: {
                return Evaluator.compareValues(leftValue, rightValue) > 0;
            }
            case 6: {
                return Evaluator.compareValues(leftValue, rightValue) >= 0;
            }
        }
        throw new ExpressionEvaluationException("ERR.015.006.0012", QueryPlugin.Util.getString("ERR.015.006.0012", new Object[]{criteria.getOperator()}));
    }

    private static final int compareValues(Object leftValue, Object rightValue) {
        assert (leftValue instanceof Comparable);
        assert (rightValue instanceof Comparable);
        if (leftValue == rightValue) {
            return 0;
        }
        return ((Comparable)leftValue).compareTo(rightValue);
    }

    public Boolean evaluate(MatchCriteria criteria, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        boolean result = false;
        Object value = null;
        try {
            value = this.evaluate(criteria.getLeftExpression(), tuple);
        }
        catch (ExpressionEvaluationException e) {
            throw new ExpressionEvaluationException((Throwable)((Object)e), "ERR.015.006.0011", QueryPlugin.Util.getString("ERR.015.006.0011", new Object[]{"left", criteria}));
        }
        if (value == null) {
            return null;
        }
        CharSequence leftValue = null;
        if (value instanceof CharSequence) {
            leftValue = (CharSequence)value;
        } else {
            try {
                leftValue = ((Sequencable)value).getCharSequence();
            }
            catch (SQLException err) {
                throw new ExpressionEvaluationException(err, err.getMessage());
            }
        }
        String rightValue = null;
        try {
            rightValue = (String)this.evaluate(criteria.getRightExpression(), tuple);
        }
        catch (ExpressionEvaluationException e) {
            throw new ExpressionEvaluationException((Throwable)((Object)e), "ERR.015.006.0011", QueryPlugin.Util.getString("ERR.015.006.0011", new Object[]{"right", criteria}));
        }
        if (rightValue == null) {
            return null;
        }
        result = this.match(rightValue, criteria.getEscapeChar(), leftValue);
        return result ^ criteria.isNegated();
    }

    private boolean match(String pattern, char escape, CharSequence search) throws ExpressionEvaluationException {
        StringBuffer rePattern = LIKE_TO_REGEX.translate(pattern, escape);
        rePattern.insert(0, '^');
        rePattern.append('$');
        try {
            Pattern patternRegex = Pattern.compile(rePattern.toString(), 32);
            Matcher matcher = patternRegex.matcher(search);
            return matcher.matches();
        }
        catch (PatternSyntaxException e) {
            throw new ExpressionEvaluationException(e, "ERR.015.006.0014", QueryPlugin.Util.getString("ERR.015.006.0014", new Object[]{pattern, e.getMessage()}));
        }
    }

    private Boolean evaluate(AbstractSetCriteria criteria, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        Object leftValue = null;
        try {
            leftValue = this.evaluate(criteria.getExpression(), tuple);
        }
        catch (ExpressionEvaluationException e) {
            throw new ExpressionEvaluationException((Throwable)((Object)e), "ERR.015.006.0015", QueryPlugin.Util.getString("ERR.015.006.0015", new Object[]{criteria}));
        }
        if (leftValue == null) {
            return null;
        }
        Boolean result = Boolean.FALSE;
        ValueIterator valueIter = null;
        if (criteria instanceof SetCriteria) {
            SetCriteria set = (SetCriteria)criteria;
            if (set.isAllConstants()) {
                boolean exists = set.getValues().contains(new Constant(leftValue, criteria.getExpression().getType()));
                if (!exists) {
                    if (set.getValues().contains(Constant.NULL_CONSTANT)) {
                        return null;
                    }
                    return criteria.isNegated();
                }
                return !criteria.isNegated();
            }
            valueIter = new CollectionValueIterator(((SetCriteria)criteria).getValues());
        } else {
            if (criteria instanceof DependentSetCriteria) {
                Set<Object> values;
                ContextReference ref = (ContextReference)((Object)criteria);
                ValueIteratorSource vis = (ValueIteratorSource)this.getContext(criteria).getVariableContext().getGlobalValue(ref.getContextSymbol());
                try {
                    values = vis.getCachedSet(ref.getValueExpression());
                }
                catch (TeiidProcessingException e) {
                    throw new ExpressionEvaluationException(e, e.getMessage());
                }
                if (values != null) {
                    return values.contains(leftValue);
                }
                return true;
            }
            if (criteria instanceof SubquerySetCriteria) {
                try {
                    valueIter = this.evaluateSubquery((SubquerySetCriteria)criteria, tuple);
                }
                catch (TeiidProcessingException e) {
                    throw new ExpressionEvaluationException(e, e.getMessage());
                }
            } else {
                throw new AssertionError((Object)"unknown set criteria type");
            }
        }
        while (valueIter.hasNext()) {
            Object possibleValue = valueIter.next();
            Object value = null;
            if (possibleValue instanceof Expression) {
                try {
                    value = this.evaluate((Expression)possibleValue, tuple);
                }
                catch (ExpressionEvaluationException e) {
                    throw new ExpressionEvaluationException((Throwable)((Object)e), "ERR.015.006.0015", QueryPlugin.Util.getString("ERR.015.006.0015", new Object[]{possibleValue}));
                }
            } else {
                value = possibleValue;
            }
            if (value != null) {
                if (Evaluator.compareValues(leftValue, value) != 0) continue;
                return !criteria.isNegated();
            }
            result = null;
        }
        if (result == null) {
            return null;
        }
        return criteria.isNegated();
    }

    public boolean evaluate(IsNullCriteria criteria, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        Object value = null;
        try {
            value = this.evaluate(criteria.getExpression(), tuple);
        }
        catch (ExpressionEvaluationException e) {
            throw new ExpressionEvaluationException((Throwable)((Object)e), "ERR.015.006.0015", QueryPlugin.Util.getString("ERR.015.006.0015", new Object[]{criteria}));
        }
        return value == null ^ criteria.isNegated();
    }

    private Boolean evaluate(SubqueryCompareCriteria criteria, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        ValueIterator valueIter;
        Object leftValue = null;
        try {
            leftValue = this.evaluate(criteria.getLeftExpression(), tuple);
        }
        catch (ExpressionEvaluationException e) {
            throw new ExpressionEvaluationException((Throwable)((Object)e), "ERR.015.006.0015", QueryPlugin.Util.getString("ERR.015.006.0015", new Object[]{criteria}));
        }
        if (leftValue == null) {
            return null;
        }
        Boolean result = Boolean.FALSE;
        if (criteria.getPredicateQuantifier() == 4) {
            result = Boolean.TRUE;
        }
        try {
            valueIter = this.evaluateSubquery(criteria, tuple);
        }
        catch (TeiidProcessingException e) {
            throw new ExpressionEvaluationException(e, e.getMessage());
        }
        block20: while (valueIter.hasNext()) {
            Object value = valueIter.next();
            if (value != null) {
                int compare = Evaluator.compareValues(leftValue, value);
                switch (criteria.getOperator()) {
                    case 1: {
                        result = compare == 0;
                        break;
                    }
                    case 2: {
                        result = compare != 0;
                        break;
                    }
                    case 3: {
                        result = compare < 0;
                        break;
                    }
                    case 5: {
                        result = compare <= 0;
                        break;
                    }
                    case 4: {
                        result = compare > 0;
                        break;
                    }
                    case 6: {
                        result = compare >= 0;
                        break;
                    }
                    default: {
                        throw new ExpressionEvaluationException("ERR.015.006.0012", QueryPlugin.Util.getString("ERR.015.006.0012", new Object[]{criteria.getOperator()}));
                    }
                }
                switch (criteria.getPredicateQuantifier()) {
                    case 4: {
                        if (!Boolean.FALSE.equals(result)) continue block20;
                        return Boolean.FALSE;
                    }
                    case 2: {
                        if (!Boolean.TRUE.equals(result)) continue block20;
                        return Boolean.TRUE;
                    }
                    default: {
                        throw new ExpressionEvaluationException("ERR.015.006.0057", QueryPlugin.Util.getString("ERR.015.006.0057", new Object[]{criteria.getPredicateQuantifier()}));
                    }
                }
            }
            switch (criteria.getPredicateQuantifier()) {
                case 4: {
                    return null;
                }
                case 2: {
                    result = null;
                    continue block20;
                }
            }
            throw new ExpressionEvaluationException("ERR.015.006.0057", QueryPlugin.Util.getString("ERR.015.006.0057", new Object[]{criteria.getPredicateQuantifier()}));
        }
        return result;
    }

    public boolean evaluate(ExistsCriteria criteria, List<?> tuple) throws BlockedException, TeiidComponentException, ExpressionEvaluationException {
        ValueIterator valueIter;
        try {
            valueIter = this.evaluateSubquery(criteria, tuple);
        }
        catch (TeiidProcessingException e) {
            throw new ExpressionEvaluationException(e, e.getMessage());
        }
        return valueIter.hasNext();
    }

    public Object evaluate(Expression expression, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        try {
            return this.internalEvaluate(expression, tuple);
        }
        catch (ExpressionEvaluationException e) {
            throw new ExpressionEvaluationException((Throwable)((Object)e), QueryPlugin.Util.getString("ExpressionEvaluator.Eval_failed", new Object[]{expression, e.getMessage()}));
        }
    }

    private Object internalEvaluate(Expression expression, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        if (expression instanceof SingleElementSymbol) {
            Integer index;
            if (this.elements != null && (index = (Integer)this.elements.get(expression)) != null) {
                return tuple.get(index);
            }
            if (expression instanceof ExpressionSymbol && !(expression instanceof AggregateSymbol)) {
                ExpressionSymbol exprSyb = (ExpressionSymbol)expression;
                Expression expr = exprSyb.getExpression();
                return this.internalEvaluate(expr, tuple);
            }
            return this.getContext(expression).getFromContext(expression);
        }
        if (expression instanceof Constant) {
            return ((Constant)expression).getValue();
        }
        if (expression instanceof Function) {
            return this.evaluate((Function)expression, tuple);
        }
        if (expression instanceof CaseExpression) {
            return this.evaluate((CaseExpression)expression, tuple);
        }
        if (expression instanceof SearchedCaseExpression) {
            return this.evaluate((SearchedCaseExpression)expression, tuple);
        }
        if (expression instanceof Reference) {
            Reference ref = (Reference)expression;
            if (ref.isPositional() && ref.getExpression() == null) {
                return this.getContext(ref).getVariableContext().getGlobalValue(ref.getContextSymbol());
            }
            return this.internalEvaluate(ref.getExpression(), tuple);
        }
        if (expression instanceof Criteria) {
            return this.evaluate((Criteria)expression, tuple);
        }
        if (expression instanceof ScalarSubquery) {
            return this.evaluate((ScalarSubquery)expression, tuple);
        }
        if (expression instanceof Criteria) {
            return this.evaluate((Criteria)expression, tuple);
        }
        if (expression instanceof TextLine) {
            return this.evaluateTextLine(tuple, (TextLine)expression);
        }
        if (expression instanceof XMLElement) {
            return this.evaluateXMLElement(tuple, (XMLElement)expression);
        }
        if (expression instanceof XMLForest) {
            return this.evaluateXMLForest(tuple, (XMLForest)expression);
        }
        if (expression instanceof XMLSerialize) {
            return this.evaluateXMLSerialize(tuple, (XMLSerialize)expression);
        }
        if (expression instanceof XMLQuery) {
            return this.evaluateXMLQuery(tuple, (XMLQuery)expression);
        }
        if (expression instanceof QueryString) {
            return this.evaluateQueryString(tuple, (QueryString)expression);
        }
        if (expression instanceof XMLParse) {
            return this.evaluateXMLParse(tuple, (XMLParse)expression);
        }
        throw new TeiidComponentException("ERR.015.006.0016", QueryPlugin.Util.getString("ERR.015.006.0016", new Object[]{expression.getClass().getName()}));
    }

    private Object evaluateXMLParse(List<?> tuple, XMLParse xp) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        Object value = this.internalEvaluate(xp.getExpression(), tuple);
        if (value == null) {
            return null;
        }
        XMLType.Type type = XMLType.Type.DOCUMENT;
        SQLXMLImpl result = null;
        try {
            if (value instanceof String) {
                String string = (String)value;
                result = new SQLXMLImpl(string);
                result.setEncoding("UTF-8");
                if (!xp.isWellFormed()) {
                    StringReader r = new StringReader(string);
                    type = this.validate(xp, r);
                }
            } else {
                InputStreamFactory isf = null;
                Streamable s = (Streamable)value;
                isf = Evaluator.getInputStreamFactory(s);
                result = new SQLXMLImpl(isf);
                if (!xp.isWellFormed()) {
                    Reader r = result.getCharacterStream();
                    type = this.validate(xp, r);
                }
            }
        }
        catch (TransformationException e) {
            throw new ExpressionEvaluationException(e, e.getMessage());
        }
        catch (SQLException e) {
            throw new ExpressionEvaluationException(e, e.getMessage());
        }
        if (!xp.isDocument()) {
            type = XMLType.Type.CONTENT;
        }
        XMLType xml = new XMLType((SQLXML)result);
        xml.setType(type);
        return xml;
    }

    public static InputStreamFactory getInputStreamFactory(Streamable<?> s) {
        if (s instanceof ClobType) {
            return new InputStreamFactory.ClobInputStreamFactory((Clob)s.getReference());
        }
        if (s instanceof BlobType) {
            return new InputStreamFactory.BlobInputStreamFactory((Blob)s.getReference());
        }
        return new InputStreamFactory.SQLXMLInputStreamFactory((SQLXML)s.getReference());
    }

    private XMLType.Type validate(XMLParse xp, Reader r) throws TransformationException {
        if (!xp.isDocument()) {
            LinkedList<Reader> readers = new LinkedList<Reader>();
            readers.add(new StringReader("<r>"));
            readers.add(r);
            readers.add(new StringReader("</r>"));
            r = new SequenceReader(readers);
        }
        return StringToSQLXMLTransform.isXml((Reader)r);
    }

    private Object evaluateQueryString(List<?> tuple, QueryString queryString) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        NameValuePair<Object>[] pairs = this.getNameValuePairs(tuple, queryString.getArgs(), false);
        String path = (String)this.internalEvaluate(queryString.getPath(), tuple);
        if (path == null) {
            path = "";
        }
        boolean appendedAny = false;
        StringBuilder result = new StringBuilder();
        for (NameValuePair<Object> nameValuePair : pairs) {
            if (nameValuePair.value == null) continue;
            if (appendedAny) {
                result.append('&');
            }
            appendedAny = true;
            result.append(WSConnection.Util.httpURLEncode((String)nameValuePair.name)).append('=').append(WSConnection.Util.httpURLEncode((String)((String)nameValuePair.value)));
        }
        if (!appendedAny) {
            return path;
        }
        result.insert(0, '?');
        result.insert(0, path);
        return result.toString();
    }

    private Object evaluateXMLQuery(List<?> tuple, XMLQuery xmlQuery) throws BlockedException, TeiidComponentException, FunctionExecutionException {
        boolean emptyOnEmpty = true;
        if (xmlQuery.getEmptyOnEmpty() != null) {
            emptyOnEmpty = xmlQuery.getEmptyOnEmpty();
        }
        SaxonXQueryExpression.Result result = null;
        try {
            result = this.evaluateXQuery(xmlQuery.getXQueryExpression(), xmlQuery.getPassing(), tuple);
            XMLType xMLType = xmlQuery.getXQueryExpression().createXMLType(result.iter, this.context.getBufferManager(), emptyOnEmpty);
            return xMLType;
        }
        catch (TeiidProcessingException e) {
            throw new FunctionExecutionException(e, QueryPlugin.Util.getString("Evaluator.xmlquery", new Object[]{e.getMessage()}));
        }
        catch (XPathException e) {
            throw new FunctionExecutionException(e, QueryPlugin.Util.getString("Evaluator.xmlquery", new Object[]{e.getMessage()}));
        }
        finally {
            if (result != null) {
                result.close();
            }
        }
    }

    private Object evaluateXMLSerialize(List<?> tuple, XMLSerialize xs) throws ExpressionEvaluationException, BlockedException, TeiidComponentException, FunctionExecutionException {
        XMLType value = (XMLType)this.internalEvaluate(xs.getExpression(), tuple);
        if (value == null) {
            return null;
        }
        try {
            if (xs.isDocument() == null || !xs.isDocument().booleanValue()) {
                return this.serialize(xs, value);
            }
            if (value.getType() == XMLType.Type.UNKNOWN) {
                XMLType.Type type = StringToSQLXMLTransform.isXml((Reader)value.getCharacterStream());
                value.setType(type);
            }
            if (value.getType() == XMLType.Type.DOCUMENT || value.getType() == XMLType.Type.ELEMENT) {
                return this.serialize(xs, value);
            }
        }
        catch (SQLException e) {
            throw new FunctionExecutionException(e, e.getMessage());
        }
        catch (TransformationException e) {
            throw new FunctionExecutionException(e, e.getMessage());
        }
        throw new FunctionExecutionException(QueryPlugin.Util.getString("Evaluator.xmlserialize"));
    }

    private Object serialize(XMLSerialize xs, XMLType value) throws TransformationException {
        if (xs.getType() == DataTypeManager.DefaultDataClasses.STRING) {
            return DataTypeManager.transformValue((Object)value, xs.getType());
        }
        InputStreamFactory isf = Evaluator.getInputStreamFactory(value);
        return new ClobType((Clob)new ClobImpl(isf, -1L));
    }

    private Object evaluateTextLine(List<?> tuple, TextLine function) throws ExpressionEvaluationException, BlockedException, TeiidComponentException, FunctionExecutionException {
        List<DerivedColumn> args = function.getExpressions();
        NameValuePair<Object>[] nameValuePairs = this.getNameValuePairs(tuple, args, true);
        try {
            return TextLine.evaluate(Arrays.asList(nameValuePairs), new TextLine.ValueExtractor<NameValuePair<Object>>(){

                @Override
                public Object getValue(NameValuePair<Object> t) {
                    return t.value;
                }
            }, function.getDelimiter(), function.getQuote());
        }
        catch (TransformationException e) {
            throw new ExpressionEvaluationException(e, e.getMessage());
        }
    }

    private Object evaluateXMLForest(List<?> tuple, XMLForest function) throws ExpressionEvaluationException, BlockedException, TeiidComponentException, FunctionExecutionException {
        List<DerivedColumn> args = function.getArgs();
        NameValuePair[] nameValuePairs = this.getNameValuePairs(tuple, args, true);
        try {
            return XMLSystemFunctions.xmlForest(this.context, this.namespaces(function.getNamespaces()), nameValuePairs);
        }
        catch (TeiidProcessingException e) {
            throw new FunctionExecutionException(e, e.getMessage());
        }
    }

    private Object evaluateXMLElement(List<?> tuple, XMLElement function) throws ExpressionEvaluationException, BlockedException, TeiidComponentException, FunctionExecutionException {
        List<Expression> content = function.getContent();
        ArrayList<Object> values = new ArrayList<Object>(content.size());
        for (Expression exp : content) {
            values.add(this.internalEvaluate(exp, tuple));
        }
        try {
            NameValuePair<Object>[] attributes = null;
            if (function.getAttributes() != null) {
                attributes = this.getNameValuePairs(tuple, function.getAttributes().getArgs(), true);
            }
            return XMLSystemFunctions.xmlElement(this.context, function.getName(), this.namespaces(function.getNamespaces()), attributes, values);
        }
        catch (TeiidProcessingException e) {
            throw new FunctionExecutionException(e, e.getMessage());
        }
    }

    public SaxonXQueryExpression.Result evaluateXQuery(SaxonXQueryExpression xquery, List<DerivedColumn> cols, List<?> tuple) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Object contextItem = null;
        for (DerivedColumn passing : cols) {
            Object value = this.evaluate(passing.getExpression(), tuple);
            if (passing.getAlias() == null) {
                contextItem = value;
                continue;
            }
            parameters.put(passing.getAlias(), value);
        }
        return xquery.evaluateXQuery(contextItem, parameters);
    }

    private NameValuePair<Object>[] getNameValuePairs(List<?> tuple, List<DerivedColumn> args, boolean xmlNames) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        NameValuePair[] nameValuePairs = new NameValuePair[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            DerivedColumn symbol = args.get(i);
            String name = symbol.getAlias();
            Expression ex = symbol.getExpression();
            if (name == null && ex instanceof ElementSymbol) {
                name = ((ElementSymbol)ex).getShortName();
                if (xmlNames) {
                    name = XMLSystemFunctions.escapeName(name, true);
                }
            }
            nameValuePairs[i] = new NameValuePair<Object>(name, this.internalEvaluate(ex, tuple));
        }
        return nameValuePairs;
    }

    private NameValuePair<String>[] namespaces(XMLNamespaces namespaces) {
        if (namespaces == null) {
            return null;
        }
        List<XMLNamespaces.NamespaceItem> args = namespaces.getNamespaceItems();
        NameValuePair[] nameValuePairs = new NameValuePair[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            XMLNamespaces.NamespaceItem item = args.get(i);
            nameValuePairs[i] = new NameValuePair<String>(item.getPrefix(), item.getUri());
        }
        return nameValuePairs;
    }

    private Object evaluate(CaseExpression expr, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        Object exprVal = this.internalEvaluate(expr.getExpression(), tuple);
        for (int i = 0; i < expr.getWhenCount(); ++i) {
            if (!EquivalenceUtil.areEqual((Object)exprVal, (Object)this.internalEvaluate(expr.getWhenExpression(i), tuple))) continue;
            return this.internalEvaluate(expr.getThenExpression(i), tuple);
        }
        if (expr.getElseExpression() != null) {
            return this.internalEvaluate(expr.getElseExpression(), tuple);
        }
        return null;
    }

    private Object evaluate(SearchedCaseExpression expr, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        for (int i = 0; i < expr.getWhenCount(); ++i) {
            try {
                if (!this.evaluate(expr.getWhenCriteria(i), tuple)) continue;
                return this.internalEvaluate(expr.getThenExpression(i), tuple);
            }
            catch (ExpressionEvaluationException e) {
                throw new ExpressionEvaluationException((Throwable)((Object)e), "ERR.015.006.0033", QueryPlugin.Util.getString("ERR.015.006.0033", new Object[]{"CASE", expr.getWhenCriteria(i)}));
            }
        }
        if (expr.getElseExpression() != null) {
            return this.internalEvaluate(expr.getElseExpression(), tuple);
        }
        return null;
    }

    private Object evaluate(Function function, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        FunctionDescriptor fd = function.getFunctionDescriptor();
        Expression[] args = function.getArgs();
        Object[] values = null;
        int start = 0;
        if (fd.requiresContext()) {
            values = new Object[args.length + 1];
            values[0] = this.context;
            start = 1;
        } else {
            values = new Object[args.length];
        }
        for (int i = 0; i < args.length; ++i) {
            values[i + start] = this.internalEvaluate(args[i], tuple);
        }
        if (fd.getPushdown() == FunctionMethod.PushDown.MUST_PUSHDOWN) {
            throw new TeiidComponentException(QueryPlugin.Util.getString("ExpressionEvaluator.Must_push", new Object[]{fd.getName()}));
        }
        if (fd.getName().equalsIgnoreCase("lookup")) {
            if (this.dataMgr == null) {
                throw new ComponentNotFoundException("ERR.015.006.0055", QueryPlugin.Util.getString("ERR.015.006.0055"));
            }
            String codeTableName = (String)values[0];
            String returnElementName = (String)values[1];
            String keyElementName = (String)values[2];
            try {
                return this.dataMgr.lookupCodeValue(this.context, codeTableName, returnElementName, keyElementName, values[3]);
            }
            catch (TeiidProcessingException e) {
                throw new ExpressionEvaluationException(e, e.getMessage());
            }
        }
        Object result = fd.invokeFunction(values);
        return result;
    }

    private Object evaluate(ScalarSubquery scalarSubquery, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        ValueIterator valueIter;
        Object result = null;
        try {
            valueIter = this.evaluateSubquery(scalarSubquery, tuple);
        }
        catch (TeiidProcessingException e) {
            throw new ExpressionEvaluationException(e, e.getMessage());
        }
        if (valueIter.hasNext()) {
            result = valueIter.next();
            if (valueIter.hasNext()) {
                throw new ExpressionEvaluationException("ERR.015.006.0058", QueryPlugin.Util.getString("ERR.015.006.0058", new Object[]{scalarSubquery.getCommand()}));
            }
        }
        return result;
    }

    protected ValueIterator evaluateSubquery(SubqueryContainer container, List<?> tuple) throws TeiidProcessingException, BlockedException, TeiidComponentException {
        throw new UnsupportedOperationException("Subquery evaluation not possible with a base Evaluator");
    }

    private CommandContext getContext(LanguageObject expression) throws TeiidComponentException {
        if (this.context == null) {
            throw new TeiidComponentException("ERR.015.006.0033", QueryPlugin.Util.getString("ERR.015.006.0033", new Object[]{expression, "No value was available"}));
        }
        return this.context;
    }

    public static class NameValuePair<T> {
        public String name;
        public T value;

        public NameValuePair(String name, T value) {
            this.name = name;
            this.value = value;
        }
    }

    private final class SequenceReader
    extends Reader {
        private LinkedList<Reader> readers;
        private Reader current = null;

        public SequenceReader(LinkedList<Reader> readers) {
            this.readers = readers;
        }

        @Override
        public void close() throws IOException {
            for (Reader reader : this.readers) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int nextRead;
            if (this.current == null && !this.readers.isEmpty()) {
                this.current = this.readers.removeFirst();
            }
            if (this.current == null) {
                return -1;
            }
            int read = this.current.read(cbuf, off, len);
            if (read == -1) {
                this.current.close();
                this.current = null;
                read = 0;
            }
            if (read < len && (nextRead = this.read(cbuf, off + read, len - read)) > 0) {
                read += nextRead;
            }
            return read;
        }
    }
}

