/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.aggregate;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.function.aggregate.AggregateFunction;

public class Sum
extends AggregateFunction {
    protected static final int LONG = 0;
    protected static final int DOUBLE = 1;
    protected static final int BIG_INTEGER = 2;
    protected static final int BIG_DECIMAL = 3;
    protected int accumulatorType = 0;
    private Object sum = null;

    protected int getAccumulatorType() {
        return this.accumulatorType;
    }

    @Override
    public void initialize(Class<?> dataType, Class<?> inputType) {
        this.accumulatorType = dataType.equals(DataTypeManager.DefaultDataClasses.LONG) ? 0 : (dataType.equals(DataTypeManager.DefaultDataClasses.DOUBLE) ? 1 : (dataType.equals(DataTypeManager.DefaultDataClasses.BIG_INTEGER) ? 2 : 3));
    }

    @Override
    public void reset() {
        this.sum = null;
    }

    @Override
    public void addInputDirect(Object input, List<?> tuple) throws FunctionExecutionException, ExpressionEvaluationException, TeiidComponentException {
        if (this.sum == null) {
            switch (this.accumulatorType) {
                case 0: {
                    this.sum = new Long(0L);
                    break;
                }
                case 1: {
                    this.sum = new Double(0.0);
                    break;
                }
                case 2: {
                    this.sum = new BigInteger(String.valueOf(0));
                    break;
                }
                case 3: {
                    this.sum = new BigDecimal(0);
                }
            }
        }
        switch (this.accumulatorType) {
            case 0: {
                this.sum = new Long((Long)this.sum + ((Number)input).longValue());
                break;
            }
            case 1: {
                this.sum = new Double((Double)this.sum + ((Number)input).doubleValue());
                break;
            }
            case 2: {
                this.sum = ((BigInteger)this.sum).add((BigInteger)input);
                break;
            }
            case 3: {
                if (input instanceof BigInteger) {
                    BigInteger bigIntegerInput = (BigInteger)input;
                    this.sum = ((BigDecimal)this.sum).add(new BigDecimal(bigIntegerInput));
                    break;
                }
                this.sum = ((BigDecimal)this.sum).add((BigDecimal)input);
            }
        }
    }

    @Override
    public Object getResult() throws FunctionExecutionException, ExpressionEvaluationException, TeiidComponentException {
        return this.sum;
    }
}

