/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.metadata;

import java.util.Collection;
import java.util.List;
import org.teiid.api.exception.query.FunctionMetadataException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.metadata.InvalidFunctionItem;
import org.teiid.query.report.ActivityReport;

public class FunctionMetadataValidator {
    public static final int MAX_LENGTH = 255;

    private FunctionMetadataValidator() {
    }

    public static final void validateFunctionMethods(Collection<FunctionMethod> methods, ActivityReport report) {
        if (methods != null) {
            for (FunctionMethod method : methods) {
                FunctionMetadataValidator.validateFunctionMethod(method, report);
            }
        }
    }

    public static final void validateFunctionMethod(FunctionMethod method, ActivityReport report) {
        if (method == null) {
            FunctionMetadataValidator.updateReport(report, method, QueryPlugin.Util.getString("ERR.015.001.0052", new Object[]{"FunctionMethod"}));
            return;
        }
        try {
            FunctionMetadataValidator.validateName(method.getName());
            FunctionMetadataValidator.validateDescription(method.getDescription());
            FunctionMetadataValidator.validateCategory(method.getCategory());
            FunctionMetadataValidator.validateInvocationMethod(method.getInvocationClass(), method.getInvocationMethod(), method.getPushdown());
            List params = method.getInputParameters();
            if (params != null && !params.isEmpty()) {
                for (int i = 0; i < params.size(); ++i) {
                    FunctionMetadataValidator.validateFunctionParameter((FunctionParameter)params.get(i));
                }
            }
            FunctionMetadataValidator.validateFunctionParameter(method.getOutputParameter());
        }
        catch (FunctionMetadataException e) {
            FunctionMetadataValidator.updateReport(report, method, e.getMessage());
        }
    }

    private static final void updateReport(ActivityReport report, FunctionMethod method, String message) {
        report.addItem(new InvalidFunctionItem(method, message));
    }

    public static final void validateFunctionParameter(FunctionParameter param) throws FunctionMetadataException {
        if (param == null) {
            throw new FunctionMetadataException("ERR.015.001.0053", QueryPlugin.Util.getString("ERR.015.001.0053"));
        }
        FunctionMetadataValidator.validateName(param.getName());
        FunctionMetadataValidator.validateType(param.getType());
        FunctionMetadataValidator.validateDescription(param.getDescription());
    }

    public static final void validateName(String name) throws FunctionMetadataException {
        FunctionMetadataValidator.validateIsNotNull(name, "Name");
        FunctionMetadataValidator.validateLength(name, 255, "Name");
        FunctionMetadataValidator.validateNameCharacters(name, "Name");
    }

    public static final void validateType(String type) throws FunctionMetadataException {
        FunctionMetadataValidator.validateIsNotNull(type, "Type");
        if (DataTypeManager.getDataTypeClass((String)type) == null) {
            throw new FunctionMetadataException("ERR.015.001.0054", QueryPlugin.Util.getString("ERR.015.001.0054", new Object[]{type}));
        }
    }

    public static final void validateDescription(String description) throws FunctionMetadataException {
        if (description != null) {
            FunctionMetadataValidator.validateLength(description, 4000, "Description");
        }
    }

    public static final void validateCategory(String category) throws FunctionMetadataException {
        FunctionMetadataValidator.validateIsNotNull(category, "Category");
        FunctionMetadataValidator.validateLength(category, 255, "Category");
    }

    public static final void validateInvocationMethod(String invocationClass, String invocationMethod, FunctionMethod.PushDown pushdown) throws FunctionMetadataException {
        if (pushdown == FunctionMethod.PushDown.CAN_PUSHDOWN || pushdown == FunctionMethod.PushDown.CANNOT_PUSHDOWN) {
            FunctionMetadataValidator.validateIsNotNull(invocationClass, "Invocation class");
            FunctionMetadataValidator.validateIsNotNull(invocationMethod, "Invocation method");
            FunctionMetadataValidator.validateJavaIdentifier(invocationClass, "Invocation class", true);
            FunctionMetadataValidator.validateJavaIdentifier(invocationMethod, "Invocation method", false);
        }
    }

    private static final void validateIsNotNull(Object object, String objName) throws FunctionMetadataException {
        if (object == null) {
            throw new FunctionMetadataException("ERR.015.001.0052", QueryPlugin.Util.getString("ERR.015.001.0052", new Object[]{objName}));
        }
    }

    private static final void validateLength(String string, int maxLength, String strName) throws FunctionMetadataException {
        if (string.length() > maxLength) {
            throw new FunctionMetadataException("ERR.015.001.0055", QueryPlugin.Util.getString("ERR.015.001.0055", new Object[]{strName, new Integer(maxLength)}));
        }
    }

    private static final void validateNameCharacters(String name, String strName) throws FunctionMetadataException {
        if (name.length() > 0) {
            if (name.equals("+") || name.equals("-") || name.equals("*") || name.equals("/") || name.equals("||")) {
                return;
            }
            char firstChar = name.charAt(0);
            if (!Character.isLetter(firstChar)) {
                throw new FunctionMetadataException("ERR.015.001.0056", QueryPlugin.Util.getString("ERR.015.001.0056", new Object[]{strName, new Character(firstChar)}));
            }
            for (int i = 1; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (Character.isLetterOrDigit(ch) || ch == '_') continue;
                throw new FunctionMetadataException("ERR.015.001.0057", QueryPlugin.Util.getString("ERR.015.001.0057", new Object[]{strName, new Character(ch)}));
            }
        }
    }

    private static final void validateJavaIdentifier(String identifier, String strName, boolean allowMultiple) throws FunctionMetadataException {
        if (identifier.length() > 0) {
            char firstChar = identifier.charAt(0);
            if (!Character.isJavaIdentifierStart(firstChar)) {
                throw new FunctionMetadataException("ERR.015.001.0056", QueryPlugin.Util.getString("ERR.015.001.0056", new Object[]{strName, new Character(firstChar)}));
            }
            for (int i = 1; i < identifier.length(); ++i) {
                char ch = identifier.charAt(i);
                if (Character.isJavaIdentifierPart(ch) || allowMultiple && ch == '.') continue;
                throw new FunctionMetadataException("ERR.015.001.0057", QueryPlugin.Util.getString("ERR.015.001.0057", new Object[]{strName, new Character(ch)}));
            }
            if (identifier.charAt(identifier.length() - 1) == '.') {
                throw new FunctionMetadataException("ERR.015.001.0058", QueryPlugin.Util.getString("ERR.015.001.0058", new Object[]{strName}));
            }
        }
    }
}

