/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.mapping.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.mapping.xml.MappingAllNode;
import org.teiid.query.mapping.xml.MappingBaseNode;
import org.teiid.query.mapping.xml.MappingChoiceNode;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingException;
import org.teiid.query.mapping.xml.MappingLoader;
import org.teiid.query.mapping.xml.MappingNodeConstants;
import org.teiid.query.mapping.xml.MappingOutputter;
import org.teiid.query.mapping.xml.MappingSequenceNode;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.mapping.xml.MappingVisitor;

public class MappingDocument
extends MappingBaseNode {
    MappingBaseNode root;
    boolean formatted;
    String encoding;
    String name;

    public MappingDocument(boolean formatted) {
        this("UTF-8", formatted);
    }

    public MappingDocument(String encoding, boolean formatted) {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        this.setDocumentEncoding(encoding);
        this.setFormatted(formatted);
    }

    @Override
    public void acceptVisitor(MappingVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.name;
    }

    @Override
    public String getCanonicalName() {
        return this.name.toUpperCase();
    }

    public MappingBaseNode getRootNode() {
        return this.root;
    }

    public MappingElement getTagRootElement() {
        if (this.root instanceof MappingSourceNode) {
            return (MappingElement)this.root.getNodeChildren().get(0);
        }
        return (MappingElement)this.root;
    }

    void setRoot(MappingBaseNode root) {
        if (root != null) {
            this.root = root;
            this.getChildren().clear();
            this.addChild(root);
        }
    }

    public String getDocumentEncoding() {
        return this.encoding;
    }

    public boolean isFormatted() {
        return this.formatted;
    }

    @Override
    public boolean isDocumentNode() {
        return true;
    }

    public void setDocumentEncoding(String encoding) {
        this.encoding = encoding;
        this.setProperty(MappingNodeConstants.Properties.DOCUMENT_ENCODING, this.encoding);
    }

    public void setFormatted(boolean formatted) {
        this.formatted = formatted;
        this.setProperty(MappingNodeConstants.Properties.FORMATTED_DOCUMENT, this.formatted);
    }

    private void fixCardinality(MappingElement root) {
        root.setMaxOccurrs(1);
        root.setMinOccurrs(1);
    }

    @Override
    public MappingAllNode addAllNode(MappingAllNode elem) {
        throw new TeiidRuntimeException(QueryPlugin.Util.getString("WrongTypeChild"));
    }

    @Override
    public MappingChoiceNode addChoiceNode(MappingChoiceNode elem) {
        throw new TeiidRuntimeException(QueryPlugin.Util.getString("WrongTypeChild"));
    }

    @Override
    public MappingSequenceNode addSequenceNode(MappingSequenceNode elem) {
        throw new TeiidRuntimeException(QueryPlugin.Util.getString("WrongTypeChild"));
    }

    @Override
    public MappingElement addChildElement(MappingElement elem) {
        if (elem == null) {
            throw new TeiidRuntimeException(QueryPlugin.Util.getString("root_cannotbe_null"));
        }
        this.fixCardinality(elem);
        this.setRoot(elem);
        return elem;
    }

    @Override
    public MappingSourceNode addSourceNode(MappingSourceNode elem) {
        if (elem == null) {
            throw new TeiidRuntimeException(QueryPlugin.Util.getString("root_cannotbe_null"));
        }
        this.setRoot(elem);
        return elem;
    }

    public Object clone() {
        try {
            MappingOutputter out = new MappingOutputter();
            StringWriter stream = new StringWriter();
            out.write(this, new PrintWriter(stream));
            MappingLoader loader = new MappingLoader();
            MappingDocument doc = loader.loadDocument(new ByteArrayInputStream(stream.toString().getBytes()));
            doc.formatted = this.formatted;
            doc.encoding = this.encoding;
            doc.name = this.name;
            return doc;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (MappingException e) {
            throw new RuntimeException(e);
        }
    }
}

