/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.MergeJoinStrategy;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.util.CommandContext;

public class RulePlanSorts
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        return this.optimizeSorts(false, plan, plan);
    }

    private PlanNode optimizeSorts(boolean parentBlocking, PlanNode node, PlanNode root) {
        if ((node = NodeEditor.findNodePreOrder(node, 422, 1)) == null) {
            return root;
        }
        switch (node.getType()) {
            case 32: {
                List exprs;
                parentBlocking = true;
                if (node.hasBooleanProperty(NodeConstants.Info.IS_DUP_REMOVAL)) break;
                if (this.mergeSortWithDupRemoval(node)) {
                    node.setProperty(NodeConstants.Info.IS_DUP_REMOVAL, true);
                }
                List<SingleElementSymbol> orderColumns = ((OrderBy)node.getProperty(NodeConstants.Info.SORT_ORDER)).getSortKeys();
                PlanNode possibleSort = NodeEditor.findNodePreOrder(node, 128, 65);
                if (possibleSort == null || (exprs = (List)possibleSort.getProperty(NodeConstants.Info.GROUP_COLS)) == null || !exprs.containsAll(orderColumns)) break;
                exprs.removeAll(orderColumns);
                orderColumns.addAll(exprs);
                possibleSort.setProperty(NodeConstants.Info.GROUP_COLS, orderColumns);
                if (node.getParent() == null) {
                    root = node.getFirstChild();
                    root.removeFromParent();
                    node = root;
                    break;
                }
                PlanNode nextNode = node.getFirstChild();
                NodeEditor.removeChildNode(node.getParent(), node);
                node = nextNode;
                break;
            }
            case 2: {
                if (!parentBlocking) break;
                node.setType(32);
                node.setProperty(NodeConstants.Info.IS_DUP_REMOVAL, true);
                break;
            }
            case 128: {
                if (!node.hasCollectionProperty(NodeConstants.Info.GROUP_COLS)) break;
                if (this.mergeSortWithDupRemovalAcrossSource(node)) {
                    node.setProperty(NodeConstants.Info.IS_DUP_REMOVAL, true);
                }
                parentBlocking = true;
                break;
            }
            case 4: {
                if (node.getProperty(NodeConstants.Info.JOIN_STRATEGY) == JoinNode.JoinStrategyType.NESTED_LOOP || node.getProperty(NodeConstants.Info.JOIN_STRATEGY) == JoinNode.JoinStrategyType.NESTED_TABLE) break;
                parentBlocking = true;
                PlanNode toTest = node.getFirstChild();
                if (this.mergeSortWithDupRemovalAcrossSource(toTest)) {
                    node.setProperty(NodeConstants.Info.SORT_LEFT, (Object)MergeJoinStrategy.SortOption.SORT_DISTINCT);
                    if (node.getProperty(NodeConstants.Info.SORT_RIGHT) != MergeJoinStrategy.SortOption.SORT) {
                        node.setProperty(NodeConstants.Info.JOIN_STRATEGY, (Object)JoinNode.JoinStrategyType.MERGE);
                    }
                }
                if (!this.mergeSortWithDupRemovalAcrossSource(toTest = node.getLastChild())) break;
                node.setProperty(NodeConstants.Info.SORT_RIGHT, (Object)MergeJoinStrategy.SortOption.SORT_DISTINCT);
                if (node.getProperty(NodeConstants.Info.SORT_LEFT) == MergeJoinStrategy.SortOption.SORT) break;
                node.setProperty(NodeConstants.Info.JOIN_STRATEGY, (Object)JoinNode.JoinStrategyType.MERGE);
                break;
            }
            case 256: {
                if (node.getProperty(NodeConstants.Info.SET_OPERATION) != SetQuery.Operation.UNION) {
                    parentBlocking = true;
                    break;
                }
                if (node.hasBooleanProperty(NodeConstants.Info.USE_ALL) || parentBlocking) break;
                node.setProperty(NodeConstants.Info.IS_DUP_REMOVAL, true);
            }
        }
        for (PlanNode child : node.getChildren()) {
            root = this.optimizeSorts(parentBlocking, child, root);
        }
        return root;
    }

    private boolean mergeSortWithDupRemovalAcrossSource(PlanNode toTest) {
        PlanNode source = NodeEditor.findNodePreOrder(toTest, 64, 5);
        return source != null && this.mergeSortWithDupRemoval(source);
    }

    private boolean mergeSortWithDupRemoval(PlanNode node) {
        if (node.getFirstChild() == null) {
            return false;
        }
        switch (node.getFirstChild().getType()) {
            case 256: {
                if (node.getFirstChild().getProperty(NodeConstants.Info.SET_OPERATION) != SetQuery.Operation.UNION || node.getFirstChild().hasBooleanProperty(NodeConstants.Info.USE_ALL)) break;
                node.getFirstChild().setProperty(NodeConstants.Info.USE_ALL, true);
                return true;
            }
            case 2: {
                NodeEditor.removeChildNode(node, node.getFirstChild());
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "PlanSorts";
    }
}

