/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver;

import java.util.ArrayList;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.StringUtil;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.command.UpdateProcedureResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.validator.UpdateValidator;

public abstract class ProcedureContainerResolver
implements CommandResolver {
    public abstract void resolveProceduralCommand(Command var1, TempMetadataAdapter var2) throws QueryMetadataException, QueryResolverException, TeiidComponentException;

    public Command expandCommand(ProcedureContainer procCommand, QueryMetadataInterface metadata, AnalysisRecord analysis) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        GroupSymbol group = procCommand.getGroup();
        Command subCommand = null;
        String plan = this.getPlan(metadata, procCommand);
        if (plan == null) {
            return null;
        }
        QueryParser parser = QueryParser.getQueryParser();
        try {
            subCommand = parser.parseUpdateProcedure(plan);
        }
        catch (QueryParserException e) {
            throw new QueryResolverException((Throwable)((Object)e), "ERR.015.008.0045", QueryPlugin.Util.getString("ERR.015.008.0045", new Object[]{group}));
        }
        if (subCommand instanceof CreateUpdateProcedureCommand) {
            CreateUpdateProcedureCommand cupCommand = (CreateUpdateProcedureCommand)subCommand;
            if (!cupCommand.isUpdateProcedure()) {
                cupCommand.setProjectedSymbols(procCommand.getProjectedSymbols());
            }
            cupCommand.setVirtualGroup(procCommand.getGroup());
            cupCommand.setUserCommand(procCommand);
        } else if (subCommand instanceof TriggerAction) {
            TriggerAction ta = (TriggerAction)subCommand;
            ta.setView(procCommand.getGroup());
            TempMetadataAdapter tma = new TempMetadataAdapter(metadata, new TempMetadataStore());
            ta.setTemporaryMetadata(tma.getMetadataStore().getData());
            GroupContext externalGroups = ta.getExternalGroupContexts();
            List<ElementSymbol> viewElements = ResolverUtil.resolveElementsInGroup(ta.getView(), metadata);
            if (procCommand instanceof Update || procCommand instanceof Insert) {
                ProcedureContainerResolver.addChanging(tma.getMetadataStore(), externalGroups, viewElements);
                ProcedureContainerResolver.addScalarGroup("NEW", tma.getMetadataStore(), externalGroups, viewElements);
            }
            if (procCommand instanceof Update || procCommand instanceof Delete) {
                ProcedureContainerResolver.addScalarGroup("OLD", tma.getMetadataStore(), externalGroups, viewElements);
            }
            QueryResolver.setChildMetadata(subCommand, tma.getMetadataStore().getData(), externalGroups);
            QueryResolver.resolveCommand(subCommand, metadata);
            return ta;
        }
        TempMetadataStore childMetadata = new TempMetadataStore();
        TempMetadataAdapter resolveMetadata = new TempMetadataAdapter(metadata, childMetadata);
        GroupContext externalGroups = this.findChildCommandMetadata(procCommand, childMetadata, resolveMetadata);
        QueryResolver.setChildMetadata(subCommand, childMetadata.getData(), externalGroups);
        QueryResolver.resolveCommand(subCommand, metadata);
        return subCommand;
    }

    protected abstract String getPlan(QueryMetadataInterface var1, GroupSymbol var2) throws TeiidComponentException, QueryMetadataException, QueryResolverException;

    public GroupContext findChildCommandMetadata(ProcedureContainer container, TempMetadataStore discoveredMetadata, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        GroupSymbol group = container.getGroup();
        return ProcedureContainerResolver.createChildMetadata(discoveredMetadata, metadata, group);
    }

    static GroupContext createChildMetadata(TempMetadataStore discoveredMetadata, QueryMetadataInterface metadata, GroupSymbol group) throws QueryMetadataException, TeiidComponentException {
        GroupContext externalGroups = new GroupContext();
        List<ElementSymbol> elements = ResolverUtil.resolveElementsInGroup(group, metadata);
        ArrayList<ElementSymbol> inputElments = new ArrayList<ElementSymbol>(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            ElementSymbol virtualElmnt = elements.get(i);
            ElementSymbol inputElement = (ElementSymbol)virtualElmnt.clone();
            inputElments.add(inputElement);
        }
        ProcedureContainerResolver.addScalarGroup("INPUT", discoveredMetadata, externalGroups, inputElments);
        ProcedureContainerResolver.addScalarGroup("INPUTS", discoveredMetadata, externalGroups, inputElments);
        ProcedureContainerResolver.addChanging(discoveredMetadata, externalGroups, elements);
        return externalGroups;
    }

    private static void addChanging(TempMetadataStore discoveredMetadata, GroupContext externalGroups, List<ElementSymbol> elements) {
        ArrayList<ElementSymbol> changingElements = new ArrayList<ElementSymbol>(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            ElementSymbol virtualElmnt = elements.get(i);
            ElementSymbol changeElement = (ElementSymbol)virtualElmnt.clone();
            changeElement.setType(DataTypeManager.DefaultDataClasses.BOOLEAN);
            changingElements.add(changeElement);
        }
        ProcedureContainerResolver.addScalarGroup("CHANGING", discoveredMetadata, externalGroups, changingElements);
    }

    @Override
    public void resolveCommand(Command command, TempMetadataAdapter metadata, boolean resolveNullLiterals) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        ProcedureContainer procCommand = (ProcedureContainer)command;
        this.resolveGroup(metadata, procCommand);
        this.resolveProceduralCommand(procCommand, metadata);
        this.getPlan((QueryMetadataInterface)metadata, procCommand);
    }

    private String getPlan(QueryMetadataInterface metadata, ProcedureContainer procCommand) throws TeiidComponentException, QueryMetadataException, QueryResolverException {
        if (!procCommand.getGroup().isTempGroupSymbol() && metadata.isVirtualGroup(procCommand.getGroup().getMetadataID())) {
            String plan = this.getPlan(metadata, procCommand.getGroup());
            if (plan == null && !metadata.isProcedure(procCommand.getGroup().getMetadataID())) {
                int type = procCommand.getType();
                ProcedureContainerResolver.getUpdateInfo(procCommand.getGroup(), metadata, type);
            }
            return plan;
        }
        return null;
    }

    public static UpdateValidator.UpdateInfo getUpdateInfo(GroupSymbol group, QueryMetadataInterface metadata, int type) throws QueryMetadataException, TeiidComponentException, QueryResolverException {
        UpdateValidator.UpdateInfo info = ProcedureContainerResolver.getUpdateInfo(group, metadata);
        if (info == null) {
            return null;
        }
        if (info.isDeleteValidationError() && type == 4 || info.isUpdateValidationError() && type == 3 || info.isInsertValidationError() && type == 2) {
            String name = "Delete";
            if (type == 3) {
                name = "Update";
            } else if (type == 2) {
                name = "Insert";
            }
            throw new QueryResolverException("ERR.015.008.0009", QueryPlugin.Util.getString("ERR.015.008.0009", new Object[]{group, name}));
        }
        return info;
    }

    public static UpdateValidator.UpdateInfo getUpdateInfo(GroupSymbol group, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException, QueryResolverException {
        if (group.isTempGroupSymbol() || !metadata.isVirtualGroup(group.getMetadataID()) || !metadata.isVirtualModel(metadata.getModelID(group.getMetadataID()))) {
            return null;
        }
        String updatePlan = metadata.getUpdatePlan(group.getMetadataID());
        String deletePlan = metadata.getDeletePlan(group.getMetadataID());
        String insertPlan = metadata.getInsertPlan(group.getMetadataID());
        UpdateValidator.UpdateInfo info = (UpdateValidator.UpdateInfo)metadata.getFromMetadataCache(group.getMetadataID(), "UpdateInfo");
        if (info == null) {
            List<ElementSymbol> elements = ResolverUtil.resolveElementsInGroup(group, metadata);
            UpdateValidator validator = new UpdateValidator(metadata, ProcedureContainerResolver.determineType(insertPlan), ProcedureContainerResolver.determineType(updatePlan), ProcedureContainerResolver.determineType(deletePlan));
            info = validator.getUpdateInfo();
            validator.validate(UpdateProcedureResolver.getQueryTransformCmd(group, metadata), elements);
            metadata.addToMetadataCache(group.getMetadataID(), "UpdateInfo", info);
        }
        return info;
    }

    private static UpdateValidator.UpdateType determineType(String plan) {
        UpdateValidator.UpdateType type = UpdateValidator.UpdateType.INHERENT;
        if (plan != null) {
            type = StringUtil.startsWithIgnoreCase((String)plan, (String)"CREATE") ? UpdateValidator.UpdateType.UPDATE_PROCEDURE : UpdateValidator.UpdateType.INSTEAD_OF;
        }
        return type;
    }

    protected void resolveGroup(TempMetadataAdapter metadata, ProcedureContainer procCommand) throws TeiidComponentException, QueryResolverException {
        GroupSymbol group = procCommand.getGroup();
        ResolverUtil.resolveGroup(group, metadata);
        procCommand.setUpdateInfo(ProcedureContainerResolver.getUpdateInfo(group, metadata, procCommand.getType()));
    }

    public static GroupSymbol addScalarGroup(String name, TempMetadataStore metadata, GroupContext externalGroups, List symbols) {
        GroupSymbol variables = new GroupSymbol(name);
        externalGroups.addGroup(variables);
        TempMetadataID tid = metadata.addTempGroup(name, symbols);
        tid.setMetadataType(TempMetadataID.Type.SCALAR);
        for (TempMetadataID cid : tid.getElements()) {
            cid.setMetadataType(TempMetadataID.Type.SCALAR);
        }
        variables.setMetadataID(tid);
        return variables;
    }
}

