/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.TeiidComponentException;
import org.teiid.dqp.internal.process.Request;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.VariableResolver;
import org.teiid.query.resolver.command.BatchedUpdateResolver;
import org.teiid.query.resolver.command.DeleteResolver;
import org.teiid.query.resolver.command.DynamicCommandResolver;
import org.teiid.query.resolver.command.ExecResolver;
import org.teiid.query.resolver.command.InsertResolver;
import org.teiid.query.resolver.command.SetQueryResolver;
import org.teiid.query.resolver.command.SimpleQueryResolver;
import org.teiid.query.resolver.command.TempTableResolver;
import org.teiid.query.resolver.command.UpdateProcedureResolver;
import org.teiid.query.resolver.command.UpdateResolver;
import org.teiid.query.resolver.command.XMLQueryResolver;
import org.teiid.query.resolver.util.BindVariableVisitor;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.validator.ValidationVisitor;

public class QueryResolver {
    private static final CommandResolver SIMPLE_QUERY_RESOLVER = new SimpleQueryResolver();
    private static final CommandResolver SET_QUERY_RESOLVER = new SetQueryResolver();
    private static final CommandResolver XML_QUERY_RESOLVER = new XMLQueryResolver();
    private static final CommandResolver EXEC_RESOLVER = new ExecResolver();
    private static final CommandResolver INSERT_RESOLVER = new InsertResolver();
    private static final CommandResolver UPDATE_RESOLVER = new UpdateResolver();
    private static final CommandResolver DELETE_RESOLVER = new DeleteResolver();
    private static final CommandResolver UPDATE_PROCEDURE_RESOLVER = new UpdateProcedureResolver();
    private static final CommandResolver BATCHED_UPDATE_RESOLVER = new BatchedUpdateResolver();
    private static final CommandResolver DYNAMIC_COMMAND_RESOLVER = new DynamicCommandResolver();
    private static final CommandResolver TEMP_TABLE_RESOLVER = new TempTableResolver();

    public static Command expandCommand(ProcedureContainer proc, QueryMetadataInterface metadata, AnalysisRecord analysisRecord) throws QueryResolverException, QueryMetadataException, TeiidComponentException {
        ProcedureContainerResolver cr = (ProcedureContainerResolver)QueryResolver.chooseResolver(proc, metadata);
        return cr.expandCommand(proc, metadata, analysisRecord);
    }

    public static TempMetadataStore resolveCommand(Command command, QueryMetadataInterface metadata) throws QueryResolverException, TeiidComponentException {
        return QueryResolver.resolveCommand(command, metadata, true);
    }

    public static TempMetadataStore resolveCommand(Command currentCommand, QueryMetadataInterface metadata, boolean resolveNullLiterals) throws QueryResolverException, TeiidComponentException {
        LogManager.logTrace((String)"org.teiid.PLANNER.RESOLVER", (Object[])new Object[]{"Resolving command", currentCommand});
        TempMetadataAdapter resolverMetadata = null;
        try {
            Map tempMetadata = currentCommand.getTemporaryMetadata();
            if (tempMetadata == null) {
                currentCommand.setTemporaryMetadata(new HashMap());
            }
            TempMetadataStore discoveredMetadata = new TempMetadataStore(currentCommand.getTemporaryMetadata());
            resolverMetadata = new TempMetadataAdapter(metadata, discoveredMetadata);
            List<GroupSymbol> externalGroups = currentCommand.getAllExternalGroups();
            for (GroupSymbol extGroup : externalGroups) {
                Object metadataID = extGroup.getMetadataID();
                if (metadataID != null && (extGroup.getMetadataID() instanceof TempMetadataID || discoveredMetadata.getTempGroupID(extGroup.getName()) == null)) continue;
                metadataID = resolverMetadata.getGroupID(extGroup.getName());
                extGroup.setMetadataID(metadataID);
            }
            CommandResolver resolver = QueryResolver.chooseResolver(currentCommand, resolverMetadata);
            resolver.resolveCommand(currentCommand, resolverMetadata, resolveNullLiterals);
        }
        catch (QueryMetadataException e) {
            throw new QueryResolverException((Throwable)((Object)e), e.getMessage());
        }
        currentCommand.setIsResolved(true);
        return resolverMetadata.getMetadataStore();
    }

    private static CommandResolver chooseResolver(Command command, QueryMetadataInterface metadata) throws QueryResolverException, QueryMetadataException, TeiidComponentException {
        switch (command.getType()) {
            case 1: {
                if (command instanceof Query) {
                    if (QueryResolver.isXMLQuery((Query)command, metadata)) {
                        return XML_QUERY_RESOLVER;
                    }
                    return SIMPLE_QUERY_RESOLVER;
                }
                return SET_QUERY_RESOLVER;
            }
            case 2: {
                return INSERT_RESOLVER;
            }
            case 3: {
                return UPDATE_RESOLVER;
            }
            case 4: {
                return DELETE_RESOLVER;
            }
            case 6: {
                return EXEC_RESOLVER;
            }
            case 13: {
                return UPDATE_PROCEDURE_RESOLVER;
            }
            case 7: {
                return UPDATE_PROCEDURE_RESOLVER;
            }
            case 9: {
                return BATCHED_UPDATE_RESOLVER;
            }
            case 10: {
                return DYNAMIC_COMMAND_RESOLVER;
            }
            case 11: {
                return TEMP_TABLE_RESOLVER;
            }
            case 12: {
                return TEMP_TABLE_RESOLVER;
            }
        }
        throw new AssertionError((Object)"Unknown command type");
    }

    public static boolean isXMLQuery(Query query, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException, QueryResolverException {
        if (query.getWith() != null) {
            return false;
        }
        From from = query.getFrom();
        if (from == null) {
            return false;
        }
        if (from.getClauses().size() != 1) {
            return false;
        }
        FromClause clause = (FromClause)from.getClauses().get(0);
        if (!(clause instanceof UnaryFromClause)) {
            return false;
        }
        GroupSymbol symbol = ((UnaryFromClause)clause).getGroup();
        ResolverUtil.resolveGroup(symbol, metadata);
        if (symbol.isProcedure()) {
            return false;
        }
        Object groupID = ((UnaryFromClause)clause).getGroup().getMetadataID();
        return metadata.isXMLGroup(groupID);
    }

    public static void resolveCriteria(Criteria criteria, QueryMetadataInterface metadata) throws QueryResolverException, QueryMetadataException, TeiidComponentException {
        ResolverVisitor.resolveLanguageObject(criteria, metadata);
    }

    public static void setChildMetadata(Command subCommand, Command parent) {
        Map childMetadataMap = parent.getTemporaryMetadata();
        GroupContext parentContext = parent.getExternalGroupContexts();
        QueryResolver.setChildMetadata(subCommand, childMetadataMap, parentContext);
    }

    public static void setChildMetadata(Command subCommand, Map parentTempMetadata, GroupContext parentContext) {
        Map tempMetadata = subCommand.getTemporaryMetadata();
        if (tempMetadata == null) {
            subCommand.setTemporaryMetadata(new HashMap(parentTempMetadata));
        } else {
            tempMetadata.putAll(parentTempMetadata);
        }
        subCommand.setExternalGroupContexts(parentContext);
    }

    public static Map<String, Expression> getVariableValues(Command command, boolean changingOnly, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        CommandResolver resolver = QueryResolver.chooseResolver(command, metadata);
        if (resolver instanceof VariableResolver) {
            return ((VariableResolver)((Object)resolver)).getVariableValues(command, changingOnly, metadata);
        }
        return Collections.EMPTY_MAP;
    }

    public static void resolveSubqueries(Command command, TempMetadataAdapter metadata, Collection<GroupSymbol> externalGroups) throws QueryResolverException, TeiidComponentException {
        for (SubqueryContainer container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(command)) {
            QueryResolver.setChildMetadata(container.getCommand(), command);
            if (externalGroups != null) {
                ((Command)container.getCommand()).pushNewResolvingContext(externalGroups);
            }
            QueryResolver.resolveCommand(container.getCommand(), metadata.getMetadata(), false);
        }
    }

    public static Command resolveView(GroupSymbol virtualGroup, QueryNode qnode, String cacheString, QueryMetadataInterface qmi) throws TeiidComponentException, QueryMetadataException, QueryResolverException, QueryValidatorException {
        Command result = (Command)qmi.getFromMetadataCache(virtualGroup.getMetadataID(), "transformation/" + cacheString);
        if (result != null) {
            result = (Command)result.clone();
        } else {
            result = qnode.getCommand();
            if (result == null) {
                try {
                    result = QueryParser.getQueryParser().parseCommand(qnode.getQuery());
                }
                catch (QueryParserException e) {
                    throw new QueryResolverException((Throwable)((Object)e), "ERR.015.008.0011", QueryPlugin.Util.getString("ERR.015.008.0011", new Object[]{qnode.getGroupName()}));
                }
                List bindings = qnode.getBindings();
                if (bindings != null) {
                    BindVariableVisitor.bindReferences(result, bindings, qmi);
                }
            }
            QueryResolver.resolveCommand(result, qmi);
            Request.validateWithVisitor(new ValidationVisitor(), qmi, result);
            qmi.addToMetadataCache(virtualGroup.getMetadataID(), "transformation/" + cacheString, result.clone());
        }
        return result;
    }

    public static void buildExternalGroups(Map<GroupSymbol, List<ElementSymbol>> externalMetadata, Command currentCommand) {
        TempMetadataStore rootExternalStore = new TempMetadataStore();
        for (Map.Entry<GroupSymbol, List<ElementSymbol>> entry : externalMetadata.entrySet()) {
            GroupSymbol group = entry.getKey();
            List<ElementSymbol> elements = entry.getValue();
            rootExternalStore.addTempGroup(group.getName(), elements);
            currentCommand.addExternalGroupToContext(group);
        }
        Map tempMetadata = currentCommand.getTemporaryMetadata();
        if (tempMetadata == null) {
            currentCommand.setTemporaryMetadata(rootExternalStore.getData());
        } else {
            tempMetadata.putAll(rootExternalStore.getData());
        }
    }
}

