/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;

public class DynamicCommandResolver
implements CommandResolver {
    @Override
    public void resolveCommand(Command command, TempMetadataAdapter metadata, boolean resolveNullLiterals) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        GroupSymbol intoSymbol;
        ElementSymbol column;
        DynamicCommand dynamicCmd = (DynamicCommand)command;
        Iterator columns = dynamicCmd.getAsColumns().iterator();
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        if (dynamicCmd.getIntoGroup() == null) {
            while (columns.hasNext()) {
                column = (ElementSymbol)columns.next();
                column.setMetadataID(new TempMetadataID(column.getShortCanonicalName(), column.getType()));
            }
        } else if (dynamicCmd.getIntoGroup().isTempGroupSymbol()) {
            while (columns.hasNext()) {
                column = (ElementSymbol)columns.next();
                column.setName(dynamicCmd.getIntoGroup().getCanonicalName() + "." + column.getShortName());
            }
        }
        ResolverVisitor.resolveLanguageObject(dynamicCmd, groups, dynamicCmd.getExternalGroupContexts(), metadata);
        String sqlType = DataTypeManager.getDataTypeName((Class)dynamicCmd.getSql().getType());
        String targetType = "string";
        if (!targetType.equals(sqlType) && !DataTypeManager.isImplicitConversion((String)sqlType, (String)targetType)) {
            throw new QueryResolverException(QueryPlugin.Util.getString("DynamicCommandResolver.SQL_String", new Object[]{sqlType}));
        }
        if (dynamicCmd.getUsing() != null && !dynamicCmd.getUsing().isEmpty()) {
            for (SetClause clause : dynamicCmd.getUsing().getClauses()) {
                ElementSymbol id = clause.getSymbol();
                id.setName("DVARS." + id.getShortName());
                id.setGroupSymbol(new GroupSymbol("DVARS"));
                id.setType(clause.getValue().getType());
                id.setMetadataID(new TempMetadataID(id.getCanonicalName(), id.getType()));
            }
        }
        if ((intoSymbol = dynamicCmd.getIntoGroup()) != null) {
            if (!intoSymbol.isImplicitTempGroupSymbol()) {
                ResolverUtil.resolveGroup(intoSymbol, metadata);
            } else {
                List symbols = dynamicCmd.getAsColumns();
                ResolverUtil.resolveImplicitTempGroup(metadata, intoSymbol, symbols);
            }
        }
    }
}

