/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.AllInGroupSymbol;
import org.teiid.query.sql.symbol.AllSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.SelectSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class Select
implements LanguageObject {
    private List symbols;
    private boolean distinct;

    public Select() {
        this.symbols = new ArrayList();
    }

    public Select(List symbols) {
        this.symbols = new ArrayList(symbols);
    }

    public int getCount() {
        return this.symbols.size();
    }

    public boolean isStar() {
        return this.symbols.size() == 1 && this.symbols.get(0) instanceof AllSymbol;
    }

    public List getSymbols() {
        return this.symbols;
    }

    public void setSymbols(List symbols) {
        this.symbols = symbols;
    }

    public SelectSymbol getSymbol(int index) {
        return (SelectSymbol)this.symbols.get(index);
    }

    public void addSymbol(SelectSymbol symbol) {
        if (symbol != null) {
            this.symbols.add(symbol);
        }
    }

    public void addSymbols(Collection symbols) {
        if (symbols != null) {
            this.symbols.addAll(symbols);
        }
    }

    public void clearSymbols() {
        this.symbols.clear();
    }

    public boolean containsSymbol(SelectSymbol symbol) {
        return this.symbols.contains(symbol);
    }

    public boolean isElementBeingSelected(ElementSymbol elementSymbol) {
        boolean isBeingSelected = this.containsSymbol(elementSymbol);
        if (!isBeingSelected) {
            GroupSymbol g = elementSymbol.getGroupSymbol();
            String groupDotStarName = g.getName() + ".*";
            for (Object selectSymbol : this.getSymbols()) {
                AllInGroupSymbol aigSymbol;
                if (selectSymbol instanceof AllSymbol) {
                    isBeingSelected = true;
                    break;
                }
                if (!(selectSymbol instanceof AllInGroupSymbol) || !(aigSymbol = (AllInGroupSymbol)selectSymbol).getName().equalsIgnoreCase(groupDotStarName)) continue;
                isBeingSelected = true;
                break;
            }
        }
        return isBeingSelected;
    }

    public void setDistinct(boolean isDistinct) {
        this.distinct = isDistinct;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public List getProjectedSymbols() {
        ArrayList<SelectSymbol> projectedSymbols = new ArrayList<SelectSymbol>();
        for (SelectSymbol symbol : this.symbols) {
            if (symbol instanceof SingleElementSymbol) {
                projectedSymbols.add(symbol);
                continue;
            }
            List<ElementSymbol> multiSymbols = ((MultipleElementSymbol)symbol).getElementSymbols();
            if (multiSymbols == null) continue;
            projectedSymbols.addAll(multiSymbols);
        }
        return projectedSymbols;
    }

    @Override
    public Object clone() {
        List thisSymbols = this.getSymbols();
        ArrayList<Object> copySymbols = new ArrayList<Object>(thisSymbols.size());
        for (SelectSymbol ss : thisSymbols) {
            copySymbols.add(ss.clone());
        }
        Select copy = new Select(copySymbols);
        copy.setDistinct(this.isDistinct());
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Select)) {
            return false;
        }
        Select other = (Select)obj;
        return other.isDistinct() == this.isDistinct() && EquivalenceUtil.areEqual((Object)this.getSymbols(), (Object)other.getSymbols());
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.getSymbols()});
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

