/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;

public class ElementSymbol
extends SingleElementSymbol {
    private GroupSymbol groupSymbol;
    private Object metadataID;
    private Class<?> type;
    private boolean isExternalReference = false;
    private DisplayMode displayMode = DisplayMode.OUTPUT_NAME;

    protected ElementSymbol(String name, String canonicalName) {
        super(name, canonicalName);
    }

    public ElementSymbol(String name) {
        super(name);
    }

    public ElementSymbol(String name, boolean displayFullyQualified) {
        super(name);
        this.setDisplayFullyQualified(displayFullyQualified);
    }

    public void setDisplayMode(DisplayMode displayMode) {
        if (displayMode == null) {
            this.displayMode = DisplayMode.OUTPUT_NAME;
        }
        this.displayMode = displayMode;
    }

    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayFullyQualified(boolean displayFullyQualified) {
        this.displayMode = displayFullyQualified ? DisplayMode.FULLY_QUALIFIED : DisplayMode.SHORT_OUTPUT_NAME;
    }

    public boolean getDisplayFullyQualified() {
        return this.displayMode.equals((Object)DisplayMode.FULLY_QUALIFIED);
    }

    public void setIsExternalReference(boolean isExternalReference) {
        this.isExternalReference = isExternalReference;
    }

    public boolean isExternalReference() {
        return this.isExternalReference;
    }

    public void setGroupSymbol(GroupSymbol symbol) {
        this.groupSymbol = symbol;
    }

    public GroupSymbol getGroupSymbol() {
        return this.groupSymbol;
    }

    public Object getMetadataID() {
        return this.metadataID;
    }

    public void setMetadataID(Object metadataID) {
        this.metadataID = metadataID;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isResolved() {
        return this.metadataID != null && this.type != null;
    }

    @Override
    public Object clone() {
        ElementSymbol copy = new ElementSymbol(this.getName(), this.getCanonical());
        if (this.getGroupSymbol() != null) {
            copy.setGroupSymbol(this.getGroupSymbol().clone());
        }
        copy.setMetadataID(this.getMetadataID());
        copy.setType(this.getType());
        copy.setIsExternalReference(this.isExternalReference());
        copy.setOutputName(this.getOutputName());
        copy.setDisplayMode(this.getDisplayMode());
        return copy;
    }

    public static enum DisplayMode {
        FULLY_QUALIFIED,
        OUTPUT_NAME,
        SHORT_OUTPUT_NAME;

    }
}

