/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.util;

import java.util.HashMap;
import java.util.Map;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.symbol.ElementSymbol;

public class VariableContext {
    private Map variableMap = new HashMap();
    private VariableContext parentContext;
    private boolean delegateSets;

    public VariableContext() {
        this(false);
    }

    public VariableContext(boolean delegateSets) {
        this.delegateSets = delegateSets;
        this.variableMap = new HashMap();
    }

    public void setGlobalValue(String variable, Object value) {
        if (this.parentContext != null) {
            this.parentContext.setGlobalValue(variable, value);
        } else {
            this.variableMap.put(variable, value);
        }
    }

    public Object getGlobalValue(String variable) throws TeiidComponentException {
        if (this.parentContext != null) {
            return this.parentContext.getGlobalValue(variable);
        }
        Object value = this.variableMap.get(variable);
        if (value == null && !this.variableMap.containsKey(variable)) {
            throw new TeiidComponentException("ERR.015.006.0033", QueryPlugin.Util.getString("ERR.015.006.0033", new Object[]{variable, "No value was available"}));
        }
        return value;
    }

    public void setValue(ElementSymbol variable, Object value) {
        if (this.delegateSets && this.parentContext != null && this.parentContext.containsVariable(variable)) {
            this.parentContext.setValue(variable, value);
        } else {
            this.variableMap.put(variable, value);
        }
    }

    public Object getValue(ElementSymbol variable) {
        if (this.variableMap.containsKey(variable)) {
            return this.variableMap.get(variable);
        }
        if (this.parentContext != null) {
            return this.parentContext.getValue(variable);
        }
        return null;
    }

    public void setParentContext(VariableContext parent) {
        this.parentContext = parent;
    }

    public VariableContext getParentContext() {
        return this.parentContext;
    }

    public void getFlattenedContextMap(Map values) {
        if (this.parentContext != null) {
            this.parentContext.getFlattenedContextMap(values);
        }
        values.putAll(this.variableMap);
    }

    public boolean containsVariable(ElementSymbol variable) {
        if (!this.variableMap.containsKey(variable)) {
            if (this.parentContext != null) {
                return this.parentContext.containsVariable(variable);
            }
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        if (this.variableMap.isEmpty()) {
            if (this.parentContext != null) {
                return this.parentContext.isEmpty();
            }
            return true;
        }
        return false;
    }

    public Object remove(ElementSymbol symbol) {
        if (!this.variableMap.containsKey(symbol)) {
            if (this.parentContext != null) {
                return this.parentContext.remove(symbol);
            }
            return null;
        }
        return this.variableMap.remove(symbol);
    }

    public String toString() {
        return this.variableMap.toString();
    }

    public void clear() {
        this.variableMap.clear();
    }

    public void putAll(VariableContext other) {
        this.variableMap.putAll(other.variableMap);
    }
}

