/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.util;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import org.teiid.api.exception.query.QueryProcessingException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.util.ArgCheck;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.SecurityFunctionEvaluator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.relational.PlanToProcessConverter;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.util.VariableContext;
import org.teiid.query.tempdata.TempTableStore;

public class CommandContext
implements Cloneable,
org.teiid.CommandContext {
    private GlobalState globalState = new GlobalState();
    private VariableContext variableContext = new VariableContext();
    private TempTableStore tempTableStore;
    private LinkedList<String> recursionStack;
    private boolean nonBlocking;

    public CommandContext(Object processorID, String connectionID, String userName, Serializable commandPayload, String vdbName, int vdbVersion, Properties envProperties, boolean collectNodeStatistics) {
        this.setProcessorID(processorID);
        this.setConnectionID(connectionID);
        this.setUserName(userName);
        this.setCommandPayload(commandPayload);
        this.setVdbName(vdbName);
        this.setVdbVersion(vdbVersion);
        this.setEnvironmentProperties(envProperties);
        this.setCollectNodeStatistics(collectNodeStatistics);
    }

    public CommandContext(Object processorID, String connectionID, String userName, String vdbName, int vdbVersion) {
        this(processorID, connectionID, userName, null, vdbName, vdbVersion, null, false);
    }

    public CommandContext() {
    }

    private CommandContext(GlobalState state) {
        this.globalState = state;
    }

    public FunctionMethod.Determinism getDeterminismLevel() {
        return this.globalState.determinismLevel;
    }

    public FunctionMethod.Determinism resetDeterminismLevel() {
        FunctionMethod.Determinism result = this.globalState.determinismLevel;
        this.globalState.determinismLevel = FunctionMethod.Determinism.DETERMINISTIC;
        return result;
    }

    public void setDeterminismLevel(FunctionMethod.Determinism level) {
        if (this.globalState.determinismLevel == null || level.compareTo((Enum)this.globalState.determinismLevel) < 0) {
            this.globalState.determinismLevel = level;
        }
    }

    public Object getProcessorID() {
        return this.globalState.processorID;
    }

    public void setProcessorID(Object object) {
        ArgCheck.isNotNull((Object)object);
        this.globalState.processorID = object;
    }

    public CommandContext clone() {
        CommandContext clone = new CommandContext(this.globalState);
        clone.variableContext = this.variableContext;
        clone.tempTableStore = this.tempTableStore;
        if (this.recursionStack != null) {
            clone.recursionStack = new LinkedList<String>(this.recursionStack);
        }
        clone.setNonBlocking(this.nonBlocking);
        return clone;
    }

    public String toString() {
        return "CommandContext: " + this.globalState.processorID;
    }

    public String getConnectionID() {
        return this.globalState.connectionID;
    }

    public String getUserName() {
        return this.globalState.userName;
    }

    public String getVdbName() {
        return this.globalState.vdbName;
    }

    public int getVdbVersion() {
        return this.globalState.vdbVersion;
    }

    public void setConnectionID(String connectionID) {
        this.globalState.connectionID = connectionID;
    }

    public void setUserName(String userName) {
        this.globalState.userName = userName;
    }

    public void setVdbName(String vdbName) {
        this.globalState.vdbName = vdbName;
    }

    public void setVdbVersion(int vdbVersion) {
        this.globalState.vdbVersion = vdbVersion;
    }

    public Properties getEnvironmentProperties() {
        return this.globalState.environmentProperties;
    }

    public void setEnvironmentProperties(Properties properties) {
        this.globalState.environmentProperties = properties;
    }

    public Serializable getCommandPayload() {
        return this.globalState.commandPayload;
    }

    public void setCommandPayload(Serializable commandPayload) {
        this.globalState.commandPayload = commandPayload;
    }

    public void setCollectNodeStatistics(boolean collectNodeStatistics) {
        this.globalState.collectNodeStatistics = collectNodeStatistics;
    }

    public boolean getCollectNodeStatistics() {
        return this.globalState.collectNodeStatistics;
    }

    public int getConnectorBatchSize() {
        return this.globalState.connectorBatchSize;
    }

    public void setConnectorBatchSize(int connectorBatchSize) {
        this.globalState.connectorBatchSize = connectorBatchSize;
    }

    public int getProcessorBatchSize() {
        return this.globalState.processorBatchSize;
    }

    public void setProcessorBatchSize(int processorBatchSize) {
        this.globalState.processorBatchSize = processorBatchSize;
    }

    public double getNextRand() {
        if (this.globalState.random == null) {
            this.globalState.random = new Random();
        }
        return this.globalState.random.nextDouble();
    }

    public double getNextRand(long seed) {
        if (this.globalState.random == null) {
            this.globalState.random = new Random();
        }
        this.globalState.random.setSeed(seed);
        return this.globalState.random.nextDouble();
    }

    void setRandom(Random random) {
        this.globalState.random = random;
    }

    public void pushCall(String value) throws QueryProcessingException {
        if (this.recursionStack == null) {
            this.recursionStack = new LinkedList();
        } else if (this.recursionStack.contains(value)) {
            throw new QueryProcessingException(QueryPlugin.Util.getString("ExecDynamicSqlInstruction.3", new Object[]{value}));
        }
        this.recursionStack.push(value);
    }

    public int getCallStackDepth() {
        if (this.recursionStack == null) {
            return 0;
        }
        return this.recursionStack.size();
    }

    public void popCall() {
        if (this.recursionStack != null) {
            this.recursionStack.pop();
        }
    }

    public SecurityFunctionEvaluator getSecurityFunctionEvaluator() {
        return this.globalState.securityFunctionEvaluator;
    }

    public void setSecurityFunctionEvaluator(SecurityFunctionEvaluator securityFunctionEvaluator) {
        this.globalState.securityFunctionEvaluator = securityFunctionEvaluator;
    }

    public TempTableStore getTempTableStore() {
        return this.tempTableStore;
    }

    public void setTempTableStore(TempTableStore tempTableStore) {
        this.tempTableStore = tempTableStore;
    }

    public TimeZone getServerTimeZone() {
        return this.globalState.timezone;
    }

    public void setPlanToProcessConverter(PlanToProcessConverter planToProcessConverter) {
        this.globalState.planToProcessConverter = planToProcessConverter;
    }

    public PlanToProcessConverter getPlanToProcessConverter() {
        return this.globalState.planToProcessConverter;
    }

    public QueryProcessor.ProcessorFactory getQueryProcessorFactory() {
        return this.globalState.queryProcessorFactory;
    }

    public void setQueryProcessorFactory(QueryProcessor.ProcessorFactory queryProcessorFactory) {
        this.globalState.queryProcessorFactory = queryProcessorFactory;
    }

    public VariableContext getVariableContext() {
        return this.variableContext;
    }

    public void setVariableContext(VariableContext variableContext) {
        this.variableContext = variableContext;
    }

    public void pushVariableContext(VariableContext toPush) {
        toPush.setParentContext(this.variableContext);
        this.variableContext = toPush;
    }

    public Object getFromContext(Expression expression) throws TeiidComponentException {
        if (this.variableContext == null || !(expression instanceof ElementSymbol)) {
            throw new TeiidComponentException("ERR.015.006.0033", QueryPlugin.Util.getString("ERR.015.006.0033", new Object[]{expression, "No value was available"}));
        }
        Object value = this.variableContext.getValue((ElementSymbol)expression);
        if (value == null && !this.variableContext.containsVariable((ElementSymbol)expression)) {
            throw new TeiidComponentException("ERR.015.006.0033", QueryPlugin.Util.getString("ERR.015.006.0033", new Object[]{expression, "No value was available"}));
        }
        return value;
    }

    public Set<String> getGroups() {
        return this.globalState.groups;
    }

    public void setGroups(Set<String> groups) {
        this.globalState.groups = groups;
    }

    public long getTimeSliceEnd() {
        return this.globalState.timeSliceEnd;
    }

    public long getTimeoutEnd() {
        return this.globalState.timeoutEnd;
    }

    public void setTimeSliceEnd(long timeSliceEnd) {
        this.globalState.timeSliceEnd = timeSliceEnd;
    }

    public void setTimeoutEnd(long timeoutEnd) {
        this.globalState.timeoutEnd = timeoutEnd;
    }

    public void setMetadata(QueryMetadataInterface metadata) {
        this.globalState.metadata = metadata;
    }

    public QueryMetadataInterface getMetadata() {
        return this.globalState.metadata;
    }

    public void setValidateXML(boolean validateXML) {
        this.globalState.validateXML = validateXML;
    }

    public boolean validateXML() {
        return this.globalState.validateXML;
    }

    public BufferManager getBufferManager() {
        return this.globalState.bufferManager;
    }

    public void setBufferManager(BufferManager bm) {
        this.globalState.bufferManager = bm;
    }

    public TempTableStore getGlobalTableStore() {
        return this.globalState.globalTables;
    }

    public void setGlobalTableStore(TempTableStore tempTableStore) {
        this.globalState.globalTables = tempTableStore;
    }

    public boolean isNonBlocking() {
        return this.nonBlocking;
    }

    public void setNonBlocking(boolean nonBlocking) {
        this.nonBlocking = nonBlocking;
    }

    public void setPreparedPlanCache(SessionAwareCache<PreparedPlan> cache) {
        this.globalState.planCache = cache;
    }

    public PreparedPlan getPlan(String key) {
        if (this.globalState.planCache == null) {
            return null;
        }
        SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(new ParseInfo(), key, this.getVdbName(), this.getVdbVersion(), this.getConnectionID(), this.getUserName());
        PreparedPlan pp = (PreparedPlan)this.globalState.planCache.get(id);
        if (pp != null) {
            if (id.getSessionId() != null) {
                this.setDeterminismLevel(FunctionMethod.Determinism.USER_DETERMINISTIC);
            } else if (id.getUserName() != null) {
                this.setDeterminismLevel(FunctionMethod.Determinism.SESSION_DETERMINISTIC);
            }
            return pp;
        }
        return null;
    }

    public void putPlan(String key, PreparedPlan plan, FunctionMethod.Determinism determinismLevel) {
        if (this.globalState.planCache == null) {
            return;
        }
        SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(new ParseInfo(), key, this.getVdbName(), this.getVdbVersion(), this.getConnectionID(), this.getUserName());
        this.globalState.planCache.put(id, determinismLevel, plan, null);
    }

    public boolean isResultSetCacheEnabled() {
        return this.globalState.resultSetCacheEnabled;
    }

    public void setResultSetCacheEnabled(boolean resultSetCacheEnabled) {
        this.globalState.resultSetCacheEnabled = resultSetCacheEnabled;
    }

    private static class GlobalState {
        private Object processorID;
        private String connectionID;
        private int processorBatchSize = 512;
        private int connectorBatchSize = 1024;
        private String userName;
        private Serializable commandPayload;
        private String vdbName = "";
        private int vdbVersion;
        private Properties environmentProperties;
        private boolean collectNodeStatistics;
        private Random random = null;
        private SecurityFunctionEvaluator securityFunctionEvaluator;
        private TimeZone timezone = TimeZone.getDefault();
        private PlanToProcessConverter planToProcessConverter;
        private QueryProcessor.ProcessorFactory queryProcessorFactory;
        private FunctionMethod.Determinism determinismLevel = FunctionMethod.Determinism.DETERMINISTIC;
        private Set<String> groups;
        private long timeSliceEnd = Long.MAX_VALUE;
        private long timeoutEnd = Long.MAX_VALUE;
        private QueryMetadataInterface metadata;
        private boolean validateXML;
        private BufferManager bufferManager;
        private TempTableStore globalTables;
        private SessionAwareCache<PreparedPlan> planCache;
        private boolean resultSetCacheEnabled = true;

        private GlobalState() {
        }
    }
}

