/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.TeiidComponentException;

public class MemoryStorageManager
implements StorageManager {
    private AtomicInteger created = new AtomicInteger();
    private AtomicInteger removed = new AtomicInteger();

    @Override
    public void initialize() {
    }

    @Override
    public FileStore createFileStore(String name) {
        this.created.incrementAndGet();
        return new FileStore(){
            private ByteBuffer buffer = ByteBuffer.allocate(65536);

            @Override
            public void writeDirect(byte[] bytes, int offset, int length) throws TeiidComponentException {
                if (this.getLength() + (long)length > (long)this.buffer.capacity()) {
                    ByteBuffer newBuffer = ByteBuffer.allocate(this.buffer.capacity() * 2 + length);
                    this.buffer.position(0);
                    newBuffer.put(this.buffer);
                    this.buffer = newBuffer;
                }
                this.buffer.position((int)this.getLength());
                this.buffer.put(bytes, offset, length);
            }

            @Override
            public synchronized void removeDirect() {
                MemoryStorageManager.this.removed.incrementAndGet();
                this.buffer = ByteBuffer.allocate(0);
            }

            @Override
            public synchronized int readDirect(long fileOffset, byte[] b, int offset, int length) throws TeiidComponentException {
                if (fileOffset >= this.getLength()) {
                    return -1;
                }
                int position = (int)fileOffset;
                this.buffer.position(position);
                length = Math.min(length, (int)this.getLength() - position);
                this.buffer.get(b, offset, length);
                return length;
            }
        };
    }

    public int getCreated() {
        return this.created.get();
    }

    public int getRemoved() {
        return this.removed.get();
    }
}

