/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.id;

import org.teiid.core.CorePlugin;
import org.teiid.core.id.InvalidIDException;
import org.teiid.core.id.ObjectID;
import org.teiid.core.id.ObjectIDFactory;
import org.teiid.core.id.ParsedObjectID;
import org.teiid.core.id.StringID;

public class StringIDFactory
implements ObjectIDFactory {
    private long lastID = 0L;

    @Override
    public String getDescription() {
        return CorePlugin.Util.getString("StringIDFactory.Description");
    }

    protected long getNextValue() {
        return ++this.lastID;
    }

    @Override
    public ObjectID create() {
        return new StringID(this.getNextValue());
    }

    public boolean validate(ObjectID id) {
        return id instanceof StringID;
    }

    @Override
    public ObjectID stringWithoutProtocolToObject(String value) throws InvalidIDException {
        try {
            return new StringID(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidIDException(CorePlugin.Util.getString("StringIDFactory.The_specified_ID_value_is_invalid", new Object[]{value, this.getProtocol()}));
        }
    }

    @Override
    public ObjectID stringToObject(String value) throws InvalidIDException {
        ParsedObjectID parsedID = ParsedObjectID.parsedStringifiedObjectID(value, "mmlong");
        try {
            return new StringID(parsedID.getRemainder());
        }
        catch (NumberFormatException e) {
            throw new InvalidIDException(CorePlugin.Util.getString("StringIDFactory.The_specified_ID_value_is_invalid", new Object[]{value, this.getProtocol()}));
        }
    }

    @Override
    public String getProtocol() {
        return "strid";
    }
}

