/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.TeiidComponentException;
import org.teiid.dqp.internal.process.AuthorizationValidationVisitor;
import org.teiid.dqp.internal.process.AuthorizationValidator;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.Request;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.sql.lang.Command;

public class DataRoleAuthorizationValidator
implements AuthorizationValidator {
    private boolean useEntitlements;
    private boolean allowCreateTemporaryTablesByDefault;
    private boolean allowFunctionCallsByDefault;

    public DataRoleAuthorizationValidator(boolean useEntitlements, boolean allowCreateTemporaryTablesByDefault, boolean allowFunctionCallsByDefault) {
        this.useEntitlements = useEntitlements;
        this.allowCreateTemporaryTablesByDefault = allowCreateTemporaryTablesByDefault;
        this.allowFunctionCallsByDefault = allowFunctionCallsByDefault;
    }

    @Override
    public void validate(Command command, QueryMetadataInterface metadata, DQPWorkContext workContext) throws QueryValidatorException, TeiidComponentException {
        if (this.useEntitlements && !workContext.getVDB().getDataPolicies().isEmpty()) {
            AuthorizationValidationVisitor visitor = new AuthorizationValidationVisitor(workContext.getAllowedDataPolicies(), workContext.getUserName());
            visitor.setAllowCreateTemporaryTablesDefault(this.allowCreateTemporaryTablesByDefault);
            visitor.setAllowFunctionCallsByDefault(this.allowFunctionCallsByDefault);
            Request.validateWithVisitor(visitor, metadata, command);
        }
    }

    @Override
    public boolean hasRole(String roleName, DQPWorkContext workContext) {
        if (!this.useEntitlements) {
            return true;
        }
        return workContext.getAllowedDataPolicies().containsKey(roleName);
    }
}

