/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;

public class FunctionForm
implements Serializable,
Comparable<FunctionForm> {
    private static final long serialVersionUID = 2411783099304320334L;
    private String name;
    private String description;
    private String category;
    private List inputParamNames;
    private List inputParamDescs;
    private String outputParamName;
    private String outputParamDesc;

    public FunctionForm(FunctionMethod method) {
        Assertion.isNotNull((Object)method);
        this.name = method.getName().toUpperCase();
        this.description = method.getDescription();
        this.category = method.getCategory().toUpperCase();
        List inputParams = method.getInputParameters();
        if (inputParams == null) {
            this.inputParamNames = new ArrayList(0);
            this.inputParamDescs = new ArrayList(0);
        } else {
            this.inputParamNames = new ArrayList(inputParams.size());
            this.inputParamDescs = new ArrayList(inputParams.size());
            for (int i = 0; i < inputParams.size(); ++i) {
                this.inputParamNames.add(((FunctionParameter)inputParams.get(i)).getName().toUpperCase());
                this.inputParamDescs.add(((FunctionParameter)inputParams.get(i)).getDescription());
            }
        }
        FunctionParameter outParam = method.getOutputParameter();
        this.outputParamName = outParam.getName().toUpperCase();
        this.outputParamDesc = outParam.getDescription();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCategory() {
        return this.category;
    }

    public List getArgNames() {
        return this.inputParamNames;
    }

    public String getArgName(int index) {
        return (String)this.inputParamNames.get(index);
    }

    public List getArgDescriptions() {
        return this.inputParamDescs;
    }

    public String getArgDescription(int index) {
        return (String)this.inputParamDescs.get(index);
    }

    public String getReturnName() {
        return this.outputParamName;
    }

    public String getReturnDescription() {
        return this.outputParamDesc;
    }

    public String getDisplayString() {
        StringBuffer str = new StringBuffer();
        if (this.name.equalsIgnoreCase("cast")) {
            str.append(this.name);
            str.append("(");
            str.append(this.inputParamNames.get(0));
            if (this.name.equalsIgnoreCase("convert") || this.name.equalsIgnoreCase("cast")) {
                str.append(", ");
            } else {
                str.append(" ");
                str.append("AS");
                str.append(" ");
            }
            str.append(this.inputParamNames.get(1));
            str.append(")");
        } else if (this.name.equals("+") || this.name.equals("-") || this.name.equals("*") || this.name.equals("/") || this.name.equals("||")) {
            str.append("(");
            str.append(this.inputParamNames.get(0));
            str.append(this.name);
            str.append(this.inputParamNames.get(1));
            str.append(")");
        } else {
            str.append(this.name);
            str.append("(");
            if (this.inputParamNames.size() > 0) {
                Iterator iter = this.inputParamNames.iterator();
                str.append(iter.next());
                while (iter.hasNext()) {
                    str.append(", ");
                    str.append(iter.next());
                }
            }
            str.append(")");
        }
        return str.toString();
    }

    public String toString() {
        return this.getDisplayString();
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)this.name.hashCode(), (int)((Object)this.inputParamNames).hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FunctionForm)) {
            return false;
        }
        FunctionForm other = (FunctionForm)obj;
        return other.getName().equals(this.getName()) && ((Object)other.getArgNames()).equals(this.getArgNames());
    }

    @Override
    public int compareTo(FunctionForm other) {
        int compare = this.getName().compareTo(other.getName());
        if (compare != 0) {
            return compare;
        }
        List otherArgs = other.getArgNames();
        List myArgs = this.getArgNames();
        if (myArgs.size() < otherArgs.size()) {
            return -1;
        }
        if (myArgs.size() > otherArgs.size()) {
            return 1;
        }
        for (int i = 0; i < myArgs.size(); ++i) {
            compare = ((String)myArgs.get(i)).compareTo((String)otherArgs.get(i));
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }
}

