/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.NewCalculateCostUtil;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.MergeJoinStrategy;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.util.CommandContext;

public class RuleImplementJoinStrategy
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        block0: for (PlanNode sourceNode : NodeEditor.findAllNodes(plan, 64, 1)) {
            SymbolMap references = (SymbolMap)sourceNode.getProperty(NodeConstants.Info.CORRELATED_REFERENCES);
            if (references == null) continue;
            Set<GroupSymbol> groups = GroupsUsedByElementsVisitor.getGroups(references.getValues());
            PlanNode joinNode = NodeEditor.findParent(sourceNode, 4, 64);
            while (joinNode != null) {
                joinNode.setProperty(NodeConstants.Info.JOIN_STRATEGY, (Object)JoinNode.JoinStrategyType.NESTED_TABLE);
                if (joinNode.getProperty(NodeConstants.Info.DEPENDENT_VALUE_SOURCE) != null) {
                    throw new AssertionError((Object)"Cannot use a depenedent join when the join involves a correlated nested table.");
                }
                if (joinNode.getGroups().containsAll(groups)) continue block0;
                joinNode = NodeEditor.findParent(joinNode, 4, 64);
            }
        }
        for (PlanNode joinNode : NodeEditor.findAllNodes(plan, 4, 1)) {
            JoinNode.JoinStrategyType stype = (JoinNode.JoinStrategyType)((Object)joinNode.getProperty(NodeConstants.Info.JOIN_STRATEGY));
            if (!JoinNode.JoinStrategyType.MERGE.equals((Object)stype)) continue;
            boolean pushLeft = true;
            boolean pushRight = true;
            if (joinNode.getProperty(NodeConstants.Info.JOIN_TYPE) == JoinType.JOIN_INNER && context != null) {
                float leftCost = NewCalculateCostUtil.computeCostForTree(joinNode.getFirstChild(), metadata);
                float rightCost = NewCalculateCostUtil.computeCostForTree(joinNode.getLastChild(), metadata);
                if (leftCost != -1.0f && rightCost != -1.0f && (leftCost > (float)context.getProcessorBatchSize() || rightCost > (float)context.getProcessorBatchSize())) {
                    pushLeft = leftCost < (float)context.getProcessorBatchSize() || leftCost / rightCost < 8.0f;
                    pushRight = rightCost < (float)context.getProcessorBatchSize() || rightCost / leftCost < 8.0f || joinNode.getProperty(NodeConstants.Info.DEPENDENT_VALUE_SOURCE) != null;
                }
            }
            List leftExpressions = (List)joinNode.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS);
            List rightExpressions = (List)joinNode.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS);
            Object key = null;
            boolean right = true;
            if (joinNode.getLastChild().getType() == 1 && NewCalculateCostUtil.isSingleTable(joinNode.getLastChild())) {
                key = NewCalculateCostUtil.getKeyUsed(rightExpressions, null, metadata, null);
            }
            if (key == null && joinNode.getFirstChild().getType() == 1 && NewCalculateCostUtil.isSingleTable(joinNode.getFirstChild())) {
                key = NewCalculateCostUtil.getKeyUsed(leftExpressions, null, metadata, null);
                right = false;
            }
            if (key != null) {
                List keyCols = metadata.getElementIDsInKey(key);
                int[] reorder = new int[keyCols.size()];
                ArrayList<Integer> toCriteria = new ArrayList<Integer>(rightExpressions.size() - keyCols.size());
                List keyExpressions = right ? rightExpressions : leftExpressions;
                for (int j = 0; j < keyExpressions.size(); ++j) {
                    SingleElementSymbol ses = (SingleElementSymbol)keyExpressions.get(j);
                    if (!(ses instanceof ElementSymbol)) continue;
                    ElementSymbol es = (ElementSymbol)ses;
                    boolean found = false;
                    for (int i = 0; !found && i < keyCols.size(); ++i) {
                        if (!es.getMetadataID().equals(keyCols.get(i))) continue;
                        reorder[i] = j;
                        found = true;
                    }
                    if (found) continue;
                    toCriteria.add(j);
                }
                ArrayList<CompareCriteria> joinCriteria = (ArrayList<CompareCriteria>)joinNode.getProperty(NodeConstants.Info.JOIN_CRITERIA);
                Iterator i$ = toCriteria.iterator();
                while (i$.hasNext()) {
                    int index = (Integer)i$.next();
                    SingleElementSymbol lses = (SingleElementSymbol)leftExpressions.get(index);
                    SingleElementSymbol rses = (SingleElementSymbol)rightExpressions.get(index);
                    CompareCriteria cc = new CompareCriteria(lses, 1, rses);
                    if (joinCriteria != null && !joinCriteria.isEmpty()) continue;
                    joinCriteria = new ArrayList<CompareCriteria>();
                    joinCriteria.add(cc);
                    joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, JoinType.JOIN_INNER);
                }
                joinNode.setProperty(NodeConstants.Info.JOIN_CRITERIA, joinCriteria);
                leftExpressions = RelationalNode.projectTuple(reorder, leftExpressions);
                rightExpressions = RelationalNode.projectTuple(reorder, rightExpressions);
                joinNode.setProperty(NodeConstants.Info.LEFT_EXPRESSIONS, leftExpressions);
                joinNode.setProperty(NodeConstants.Info.RIGHT_EXPRESSIONS, rightExpressions);
            }
            boolean pushedLeft = RuleImplementJoinStrategy.insertSort(joinNode.getFirstChild(), leftExpressions, joinNode, metadata, capabilitiesFinder, pushLeft);
            RuleImplementJoinStrategy.insertSort(joinNode.getLastChild(), rightExpressions, joinNode, metadata, capabilitiesFinder, pushRight);
            if (joinNode.getProperty(NodeConstants.Info.JOIN_TYPE) != JoinType.JOIN_INNER || pushRight && pushedLeft) continue;
            joinNode.setProperty(NodeConstants.Info.JOIN_STRATEGY, (Object)JoinNode.JoinStrategyType.ENHANCED_SORT);
        }
        return plan;
    }

    static boolean insertSort(PlanNode childNode, List<SingleElementSymbol> expressions, PlanNode jnode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, boolean attemptPush) throws QueryMetadataException, TeiidComponentException {
        LinkedHashSet<SingleElementSymbol> orderSymbols = new LinkedHashSet<SingleElementSymbol>(expressions);
        PlanNode sourceNode = FrameUtil.findJoinSourceNode(childNode);
        PlanNode joinNode = childNode.getParent();
        LinkedHashSet<SingleElementSymbol> outputSymbols = new LinkedHashSet<SingleElementSymbol>((List)childNode.getProperty(NodeConstants.Info.OUTPUT_COLS));
        int oldSize = outputSymbols.size();
        outputSymbols.addAll(expressions);
        boolean needsCorrection = outputSymbols.size() > oldSize;
        PlanNode sortNode = RuleImplementJoinStrategy.createSortNode(new ArrayList<SingleElementSymbol>(orderSymbols), outputSymbols);
        if (sourceNode.getType() == 1) {
            if (NewCalculateCostUtil.usesKey(sourceNode, expressions, metadata)) {
                joinNode.setProperty(joinNode.getFirstChild() == childNode ? NodeConstants.Info.IS_LEFT_DISTINCT : NodeConstants.Info.IS_RIGHT_DISTINCT, true);
            }
            if (attemptPush && RuleRaiseAccess.canRaiseOverSort(sourceNode, metadata, capFinder, sortNode, null, false)) {
                sourceNode.getFirstChild().addAsParent(sortNode);
                if (needsCorrection) {
                    RuleImplementJoinStrategy.correctOutputElements(joinNode, outputSymbols, sortNode);
                }
                return true;
            }
        }
        joinNode.setProperty(joinNode.getFirstChild() == childNode ? NodeConstants.Info.SORT_LEFT : NodeConstants.Info.SORT_RIGHT, (Object)MergeJoinStrategy.SortOption.SORT);
        if (needsCorrection) {
            PlanNode projectNode = NodeFactory.getNewNode(8);
            projectNode.setProperty(NodeConstants.Info.PROJECT_COLS, new ArrayList(outputSymbols));
            childNode.addAsParent(projectNode);
            RuleImplementJoinStrategy.correctOutputElements(joinNode, outputSymbols, projectNode);
        }
        return false;
    }

    private static PlanNode createSortNode(List<SingleElementSymbol> orderSymbols, Collection outputElements) {
        PlanNode sortNode = NodeFactory.getNewNode(32);
        sortNode.setProperty(NodeConstants.Info.SORT_ORDER, new OrderBy(orderSymbols));
        sortNode.setProperty(NodeConstants.Info.OUTPUT_COLS, new ArrayList(outputElements));
        return sortNode;
    }

    private static void correctOutputElements(PlanNode endNode, Collection outputElements, PlanNode startNode) {
        while (startNode != endNode) {
            startNode.setProperty(NodeConstants.Info.OUTPUT_COLS, new ArrayList(outputElements));
            startNode = startNode.getParent();
        }
    }

    public String toString() {
        return "ImplementJoinStrategy";
    }
}

