/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.JoinRegion;
import org.teiid.query.optimizer.relational.rules.NewCalculateCostUtil;
import org.teiid.query.optimizer.relational.rules.RulePlanUnions;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.resolver.util.AccessPattern;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.util.CommandContext;
import org.teiid.query.util.Permutation;
import org.teiid.translator.ExecutionFactory;

public class RulePlanJoins
implements OptimizerRule {
    public static final int EXHAUSTIVE_SEARCH_GROUPS = 6;

    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        JoinRegion joinRegion2;
        LinkedList<JoinRegion> joinRegions = new LinkedList<JoinRegion>();
        RulePlanJoins.findJoinRegions(plan, null, joinRegions);
        Iterator joinRegionIter = joinRegions.iterator();
        while (joinRegionIter.hasNext()) {
            joinRegion2 = (JoinRegion)joinRegionIter.next();
            if (joinRegion2.getJoinSourceNodes().size() + joinRegion2.getDependentJoinSourceNodes().size() < 2) {
                joinRegionIter.remove();
                continue;
            }
            joinRegion2.initializeJoinInformation();
            for (PlanNode joinSource : joinRegion2.getJoinSourceNodes().keySet()) {
                SymbolMap map = (SymbolMap)joinSource.getProperty(NodeConstants.Info.CORRELATED_REFERENCES);
                if (map == null) continue;
                joinSource.setProperty(NodeConstants.Info.REQUIRED_ACCESS_PATTERN_GROUPS, GroupsUsedByElementsVisitor.getGroups(map.getValues()));
                joinRegion2.setContainsNestedTable(true);
            }
            if (joinRegion2.getUnsatisfiedAccessPatterns().isEmpty()) continue;
            if (!joinRegion2.isSatisfiable()) {
                throw new QueryPlannerException(QueryPlugin.Util.getString("RulePlanJoins.cantSatisfy", joinRegion2.getUnsatisfiedAccessPatterns()));
            }
            this.planForDependencies(joinRegion2);
        }
        for (JoinRegion joinRegion2 : joinRegions) {
            this.groupJoinsForPushing(metadata, capabilitiesFinder, joinRegion2, context);
        }
        joinRegionIter = joinRegions.iterator();
        while (joinRegionIter.hasNext()) {
            joinRegion2 = (JoinRegion)joinRegionIter.next();
            joinRegion2.getJoinSourceNodes().putAll(joinRegion2.getDependentJoinSourceNodes());
            joinRegion2.getCriteriaNodes().addAll(joinRegion2.getDependentCriteriaNodes());
            joinRegion2.getDependentJoinSourceNodes().clear();
            joinRegion2.getDependentCriteriaNodes().clear();
            if (joinRegion2.getJoinSourceNodes().size() < 2) {
                joinRegion2.reconstructJoinRegoin();
                joinRegionIter.remove();
                continue;
            }
            joinRegion2.initializeCostingInformation(metadata);
            Object[] bestOrder = this.findBestJoinOrder(joinRegion2, metadata, capabilitiesFinder, context);
            if (bestOrder == null) continue;
            joinRegion2.changeJoinOrder(bestOrder);
            joinRegion2.reconstructJoinRegoin();
        }
        return plan;
    }

    private void groupJoinsForPushing(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, JoinRegion joinRegion, CommandContext context) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        Map accessMap = this.getAccessMap(metadata, capFinder, joinRegion);
        boolean structureChanged = false;
        for (Map.Entry entry : accessMap.entrySet()) {
            List accessNodes = (List)entry.getValue();
            if (accessNodes.size() < 2) continue;
            block1: for (int i = accessNodes.size() - 1; i >= 0; --i) {
                PlanNode accessNode1 = (PlanNode)accessNodes.get(i);
                for (int k = accessNodes.size() - 1; k >= 0; --k) {
                    JoinType joinType;
                    if (k == i) continue;
                    PlanNode accessNode2 = (PlanNode)accessNodes.get(k);
                    List<PlanNode> criteriaNodes = joinRegion.getCriteriaNodes();
                    LinkedList<PlanNode> joinCriteriaNodes = new LinkedList<PlanNode>();
                    boolean hasJoinCriteria = false;
                    LinkedList<Criteria> joinCriteria = new LinkedList<Criteria>();
                    Object modelId = RuleRaiseAccess.getModelIDFromAccess(accessNode1, metadata);
                    ExecutionFactory.SupportedJoinCriteria sjc = CapabilitiesUtil.getSupportedJoinCriteria(modelId, metadata, capFinder);
                    for (PlanNode critNode : criteriaNodes) {
                        Set<PlanNode> sources = joinRegion.getCritieriaToSourceMap().get(critNode);
                        if (sources == null) continue;
                        if (sources.contains(accessNode1)) {
                            if (sources.contains(accessNode2) && sources.size() == 2) {
                                Criteria crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
                                if (!RuleRaiseAccess.isSupportedJoinCriteria(sjc, crit, modelId, metadata, capFinder, null)) continue;
                                joinCriteriaNodes.add(critNode);
                                joinCriteria.add(crit);
                                continue;
                            }
                            if (accessNodes.containsAll(sources)) continue;
                            hasJoinCriteria = true;
                            continue;
                        }
                        if (!sources.contains(accessNode2) || accessNodes.containsAll(sources)) continue;
                        hasJoinCriteria = true;
                    }
                    if (joinCriteriaNodes.isEmpty() && (hasJoinCriteria || !this.canPushCrossJoin(metadata, context, accessNode1, accessNode2))) continue;
                    List<PlanNode> toTest = Arrays.asList(accessNode1, accessNode2);
                    JoinType joinType2 = joinType = joinCriteria.isEmpty() ? JoinType.JOIN_CROSS : JoinType.JOIN_INNER;
                    if (RuleRaiseAccess.canRaiseOverJoin(toTest, metadata, capFinder, joinCriteria, joinType, null) == null) continue;
                    structureChanged = true;
                    joinRegion.getCritieriaToSourceMap().keySet().removeAll(joinCriteriaNodes);
                    joinRegion.getCriteriaNodes().removeAll(joinCriteriaNodes);
                    joinRegion.getJoinSourceNodes().remove(accessNode1);
                    joinRegion.getJoinSourceNodes().remove(accessNode2);
                    accessNodes.remove(i);
                    accessNodes.remove(k < i ? k : k - 1);
                    PlanNode joinNode = RulePlanJoins.createJoinNode();
                    joinNode.getGroups().addAll(accessNode1.getGroups());
                    joinNode.getGroups().addAll(accessNode2.getGroups());
                    joinNode.addFirstChild(accessNode2);
                    joinNode.addLastChild(accessNode1);
                    joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, joinType);
                    joinNode.setProperty(NodeConstants.Info.JOIN_CRITERIA, joinCriteria);
                    PlanNode newAccess = RuleRaiseAccess.raiseAccessOverJoin(joinNode, entry.getKey(), false);
                    for (PlanNode planNode : joinCriteriaNodes) {
                        planNode.removeFromParent();
                        planNode.removeAllChildren();
                    }
                    for (Set set : joinRegion.getCritieriaToSourceMap().values()) {
                        if (!set.remove(accessNode1) && !set.remove(accessNode2)) continue;
                        set.add(newAccess);
                    }
                    joinRegion.getJoinSourceNodes().put(newAccess, newAccess);
                    accessNodes.add(newAccess);
                    i = accessNodes.size();
                    k = accessNodes.size();
                    continue block1;
                }
            }
        }
        if (structureChanged) {
            joinRegion.reconstructJoinRegoin();
        }
    }

    private boolean canPushCrossJoin(QueryMetadataInterface metadata, CommandContext context, PlanNode accessNode1, PlanNode accessNode2) throws QueryMetadataException, TeiidComponentException {
        float cost1 = NewCalculateCostUtil.computeCostForTree(accessNode1, metadata);
        float cost2 = NewCalculateCostUtil.computeCostForTree(accessNode2, metadata);
        float acceptableCost = context == null ? 45.0f : (float)Math.sqrt(context.getProcessorBatchSize());
        return !(cost1 == -1.0f || cost2 == -1.0f || cost1 > acceptableCost && cost2 > acceptableCost);
    }

    private Map getAccessMap(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, JoinRegion joinRegion) throws QueryMetadataException, TeiidComponentException {
        HashMap<Object, List<PlanNode>> accessMap = new HashMap<Object, List<PlanNode>>();
        for (PlanNode node : joinRegion.getJoinSourceNodes().values()) {
            Object accessModelID;
            if (node.getType() != 1 || (accessModelID = RuleRaiseAccess.getModelIDFromAccess(node, metadata)) == null || !CapabilitiesUtil.supportsJoin(accessModelID, JoinType.JOIN_INNER, metadata, capFinder)) continue;
            RulePlanUnions.buildModelMap(metadata, capFinder, accessMap, node, accessModelID);
        }
        return accessMap;
    }

    private void planForDependencies(JoinRegion joinRegion) throws QueryPlannerException {
        if (joinRegion.getJoinSourceNodes().isEmpty()) {
            throw new QueryPlannerException(QueryPlugin.Util.getString("RulePlanJoins.cantSatisfy", joinRegion.getUnsatisfiedAccessPatterns()));
        }
        HashSet<GroupSymbol> currentGroups = new HashSet<GroupSymbol>();
        for (PlanNode joinSource : joinRegion.getJoinSourceNodes().keySet()) {
            currentGroups.addAll(joinSource.getGroups());
        }
        HashMap<PlanNode, PlanNode> dependentNodes = new HashMap<PlanNode, PlanNode>(joinRegion.getDependentJoinSourceNodes());
        boolean satisfiedAP = true;
        while (!dependentNodes.isEmpty() && satisfiedAP) {
            satisfiedAP = false;
            Iterator<Map.Entry<PlanNode, PlanNode>> joinSources = dependentNodes.entrySet().iterator();
            block2: while (joinSources.hasNext()) {
                Map.Entry<PlanNode, PlanNode> entry = joinSources.next();
                PlanNode joinSource = entry.getKey();
                Collection accessPatterns = (Collection)joinSource.getProperty(NodeConstants.Info.ACCESS_PATTERNS);
                for (AccessPattern ap : accessPatterns) {
                    boolean foundGroups = true;
                    HashSet<GroupSymbol> allRequiredGroups = new HashSet<GroupSymbol>();
                    for (ElementSymbol symbol : ap.getUnsatisfied()) {
                        Set<Collection<GroupSymbol>> requiredGroupsSet = joinRegion.getDependentCriteriaElements().get(symbol);
                        boolean elementSatisfied = false;
                        if (requiredGroupsSet != null) {
                            for (Collection<GroupSymbol> requiredGroups : requiredGroupsSet) {
                                if (!currentGroups.containsAll(requiredGroups)) continue;
                                elementSatisfied = true;
                                allRequiredGroups.addAll(requiredGroups);
                                break;
                            }
                        }
                        if (elementSatisfied) continue;
                        foundGroups = false;
                        break;
                    }
                    if (!foundGroups) continue;
                    joinSources.remove();
                    satisfiedAP = true;
                    joinSource.setProperty(NodeConstants.Info.ACCESS_PATTERN_USED, ap.clone());
                    joinSource.setProperty(NodeConstants.Info.REQUIRED_ACCESS_PATTERN_GROUPS, allRequiredGroups);
                    continue block2;
                }
            }
        }
        if (!dependentNodes.isEmpty()) {
            throw new QueryPlannerException(QueryPlugin.Util.getString("RulePlanJoins.cantSatisfy", joinRegion.getUnsatisfiedAccessPatterns()));
        }
    }

    static PlanNode createJoinNode() {
        PlanNode joinNode = NodeFactory.getNewNode(4);
        joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, JoinType.JOIN_CROSS);
        joinNode.setProperty(NodeConstants.Info.JOIN_STRATEGY, (Object)JoinNode.JoinStrategyType.NESTED_LOOP);
        return joinNode;
    }

    static void findJoinRegions(PlanNode root, JoinRegion currentRegion, List<JoinRegion> joinRegions) {
        switch (root.getType()) {
            case 4: {
                JoinType jt;
                boolean treatJoinAsSource;
                if (currentRegion == null) {
                    currentRegion = new JoinRegion();
                    joinRegions.add(currentRegion);
                }
                boolean bl = treatJoinAsSource = (jt = (JoinType)root.getProperty(NodeConstants.Info.JOIN_TYPE)).isOuter() || root.getProperty(NodeConstants.Info.ACCESS_PATTERNS) != null || root.hasProperty(NodeConstants.Info.MAKE_DEP);
                if (treatJoinAsSource) {
                    currentRegion.addJoinSourceNode(root);
                } else {
                    currentRegion.addParentCriteria(root);
                    currentRegion.addJoinCriteriaList((List)root.getProperty(NodeConstants.Info.JOIN_CRITERIA));
                }
                for (PlanNode child : root.getChildren()) {
                    RulePlanJoins.findJoinRegions(child, treatJoinAsSource ? null : currentRegion, joinRegions);
                }
                return;
            }
            case 64: {
                if (currentRegion != null) {
                    currentRegion.addJoinSourceNode(root);
                }
                currentRegion = null;
                break;
            }
            case 1: 
            case 512: {
                if (currentRegion != null) {
                    currentRegion.addJoinSourceNode(root);
                }
                return;
            }
        }
        if (root.getChildCount() == 0) {
            return;
        }
        for (PlanNode child : root.getChildren()) {
            RulePlanJoins.findJoinRegions(child, root.getChildCount() == 1 ? currentRegion : null, joinRegions);
        }
    }

    Object[] findBestJoinOrder(JoinRegion region, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, CommandContext context) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        int regionCount = region.getJoinSourceNodes().size();
        ArrayList<Integer> orderList = new ArrayList<Integer>(regionCount);
        for (int i = 0; i < regionCount; ++i) {
            orderList.add(new Integer(i));
        }
        double bestSubScore = Double.MAX_VALUE;
        Object[] bestSubOrder = null;
        Permutation perms = new Permutation(orderList.toArray());
        int exhaustive = regionCount;
        if (regionCount > 6) {
            exhaustive = Math.max(2, 6 - (int)Math.ceil(Math.sqrt(regionCount - 6)));
        }
        Iterator<Object[]> permIter = perms.generate(exhaustive);
        while (permIter.hasNext()) {
            Object[] order = permIter.next();
            double score = region.scoreRegion(order, 0, metadata, capFinder, context);
            if (!(score < bestSubScore)) continue;
            bestSubScore = score;
            bestSubOrder = order;
        }
        if (bestSubOrder == null) {
            return null;
        }
        if (regionCount <= exhaustive) {
            return bestSubOrder;
        }
        Object[] result = new Integer[regionCount];
        for (int i = 0; i < bestSubOrder.length; ++i) {
            result[i] = (Integer)bestSubOrder[i];
        }
        while (!orderList.isEmpty()) {
            double bestPartialScore = Double.MAX_VALUE;
            ArrayList<Object> bestOrder = null;
            for (int i = 0; i < orderList.size(); ++i) {
                Integer index = (Integer)orderList.get(i);
                ArrayList<Object> order = new ArrayList<Object>(Arrays.asList(bestSubOrder));
                order.add(index);
                double partialScore = region.scoreRegion(order.toArray(), bestSubOrder.length, metadata, capFinder, context);
                if (!(partialScore < bestPartialScore)) continue;
                bestPartialScore = partialScore;
                bestOrder = order;
            }
            if (bestOrder == null) {
                return null;
            }
            Integer next = (Integer)bestOrder.get(bestOrder.size() - 1);
            result[regionCount - orderList.size()] = next;
            orderList.remove(next);
            bestSubOrder = bestOrder.toArray();
        }
        return result;
    }

    public String toString() {
        return "PlanJoins";
    }
}

