/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.TableFunctionReference;
import org.teiid.query.sql.symbol.Expression;

public class TextTable
extends TableFunctionReference {
    private Expression file;
    private List<TextColumn> columns = new ArrayList<TextColumn>();
    private Character delimiter;
    private Character quote;
    private boolean escape;
    private Integer header;
    private Integer skip;
    private boolean fixedWidth;

    public Character getQuote() {
        return this.quote;
    }

    public void setQuote(Character quote) {
        this.quote = quote;
    }

    public boolean isEscape() {
        return this.escape;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public boolean isFixedWidth() {
        return this.fixedWidth;
    }

    public void setFixedWidth(boolean fixedWidth) {
        this.fixedWidth = fixedWidth;
    }

    public List<TextColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<TextColumn> columns) {
        this.columns = columns;
    }

    public Character getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(Character delimiter) {
        this.delimiter = delimiter;
    }

    public Integer getHeader() {
        return this.header;
    }

    public void setHeader(Integer header) {
        this.header = header;
    }

    public Integer getSkip() {
        return this.skip;
    }

    public void setSkip(Integer skip) {
        this.skip = skip;
    }

    public Expression getFile() {
        return this.file;
    }

    public void setFile(Expression file) {
        this.file = file;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public TextTable clone() {
        TextTable clone = new TextTable();
        this.copy(clone);
        clone.setDelimiter(this.delimiter);
        clone.setFile((Expression)this.file.clone());
        clone.setHeader(this.header);
        clone.setSkip(this.skip);
        clone.setQuote(this.quote);
        clone.escape = this.escape;
        for (TextColumn column : this.columns) {
            clone.getColumns().add(column.clone());
        }
        clone.fixedWidth = this.fixedWidth;
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof TextTable)) {
            return false;
        }
        TextTable other = (TextTable)obj;
        return ((Object)this.columns).equals(other.columns) && EquivalenceUtil.areEqual((Object)this.file, (Object)other.file) && EquivalenceUtil.areEqual((Object)this.delimiter, (Object)other.delimiter) && EquivalenceUtil.areEqual((Object)this.escape, (Object)other.escape) && EquivalenceUtil.areEqual((Object)this.quote, (Object)other.quote) && EquivalenceUtil.areEqual((Object)this.header, (Object)other.header) && EquivalenceUtil.areEqual((Object)this.skip, (Object)other.skip);
    }

    public static class TextColumn
    extends TableFunctionReference.ProjectedColumn {
        private Integer width;

        public TextColumn(String name, String type, Integer width) {
            super(name, type);
            this.width = width;
        }

        protected TextColumn() {
        }

        public Integer getWidth() {
            return this.width;
        }

        public void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!super.equals(obj) || !(obj instanceof TextColumn)) {
                return false;
            }
            TextColumn other = (TextColumn)obj;
            return EquivalenceUtil.areEqual((Object)this.width, (Object)other.width);
        }

        public TextColumn clone() {
            TextColumn clone = new TextColumn();
            clone.width = this.width;
            this.copyTo(clone);
            return clone;
        }
    }
}

