/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.navigator.PreOrPostOrderNavigator;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;

public class AggregateSymbolCollectorVisitor
extends LanguageVisitor {
    private Collection<AggregateSymbol> aggregates;
    private Collection<SingleElementSymbol> groupingSymbols;

    public AggregateSymbolCollectorVisitor(Collection<AggregateSymbol> aggregates, Collection<SingleElementSymbol> elements) {
        this.aggregates = aggregates;
        this.groupingSymbols = elements;
    }

    @Override
    public void visit(AggregateSymbol obj) {
        if (this.aggregates != null) {
            this.aggregates.add(obj);
        }
    }

    @Override
    public void visit(ExpressionSymbol obj) {
        if (this.groupingSymbols != null && obj.isDerivedExpression()) {
            this.groupingSymbols.add(obj);
        }
    }

    @Override
    public void visit(ElementSymbol obj) {
        if (this.groupingSymbols != null) {
            this.groupingSymbols.add(obj);
        }
    }

    public static final void getAggregates(LanguageObject obj, Collection<SingleElementSymbol> aggregates, Collection<SingleElementSymbol> elements) {
        AggregateSymbolCollectorVisitor visitor = new AggregateSymbolCollectorVisitor(new ArrayList<AggregateSymbol>(), elements);
        AggregateStopNavigator asn = new AggregateStopNavigator(visitor);
        obj.acceptVisitor(asn);
        aggregates.addAll(visitor.aggregates);
    }

    public static final Collection<AggregateSymbol> getAggregates(LanguageObject obj, boolean removeDuplicates) {
        if (obj == null) {
            return Collections.emptyList();
        }
        AbstractCollection aggregates = null;
        aggregates = removeDuplicates ? new HashSet() : new ArrayList();
        AggregateSymbolCollectorVisitor visitor = new AggregateSymbolCollectorVisitor(aggregates, null);
        AggregateStopNavigator asn = new AggregateStopNavigator(visitor);
        obj.acceptVisitor(asn);
        return aggregates;
    }

    public static class AggregateStopNavigator
    extends PreOrPostOrderNavigator {
        public AggregateStopNavigator(LanguageVisitor visitor) {
            super(visitor, false, false);
        }

        @Override
        public void visit(AggregateSymbol obj) {
            this.preVisitVisitor(obj);
            this.postVisitVisitor(obj);
        }

        @Override
        public void visit(ExpressionSymbol obj) {
            if (obj.isDerivedExpression()) {
                this.preVisitVisitor(obj);
                this.postVisitVisitor(obj);
            } else {
                super.visit(obj);
            }
        }
    }
}

