/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.teiid.common.buffer.FileStore;
import org.teiid.core.types.InputStreamFactory;

public final class FileStoreInputStreamFactory
extends InputStreamFactory {
    private final FileStore lobBuffer;
    private FileStore.FileStoreOutputStream fsos;
    private String encoding;

    public FileStoreInputStreamFactory(FileStore lobBuffer, String encoding) {
        this.encoding = encoding;
        this.lobBuffer = lobBuffer;
        this.lobBuffer.setCleanupReference((Object)this);
    }

    public InputStream getInputStream() throws IOException {
        if (this.fsos != null && !this.fsos.bytesWritten()) {
            return new ByteArrayInputStream(this.fsos.getBuffer(), 0, this.fsos.getCount());
        }
        return new BufferedInputStream(this.lobBuffer.createInputStream(0L));
    }

    public long getLength() {
        return this.lobBuffer.getLength();
    }

    public Writer getWriter() {
        return new OutputStreamWriter((OutputStream)this.getOuputStream(), Charset.forName(this.encoding));
    }

    public FileStore.FileStoreOutputStream getOuputStream() {
        if (this.fsos == null) {
            this.fsos = this.lobBuffer.createOutputStream(8192);
        }
        return this.fsos;
    }

    public void free() throws IOException {
        this.lobBuffer.remove();
    }

    public boolean isPersistent() {
        return this.fsos == null || this.fsos.bytesWritten();
    }
}

