/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.types.DataTypeManager;

public final class SizeUtility {
    public static final int REFERENCE_SIZE = 8;
    private long bigIntegerEstimate;
    private long bigDecimalEstimate;

    public SizeUtility() {
        boolean isValueCacheEnabled = DataTypeManager.isValueCacheEnabled();
        this.bigIntegerEstimate = SizeUtility.getSize(isValueCacheEnabled, DataTypeManager.DefaultDataClasses.BIG_INTEGER);
        this.bigDecimalEstimate = SizeUtility.getSize(isValueCacheEnabled, DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
    }

    public long getBatchSize(TupleBatch data) {
        return this.getBatchSize(DataTypeManager.isValueCacheEnabled(), data);
    }

    private long getBatchSize(boolean accountForValueCache, TupleBatch data) {
        int colLength = data.getDataTypes().length;
        int rowLength = data.getRowCount();
        long size = 16L + SizeUtility.alignMemory(rowLength * 8);
        size += (long)rowLength * (48L + SizeUtility.alignMemory(colLength * 8));
        for (int col = 0; col < colLength; ++col) {
            Class type = DataTypeManager.getDataTypeClass((String)data.getDataTypes()[col]);
            if (type == DataTypeManager.DefaultDataClasses.STRING || type == DataTypeManager.DefaultDataClasses.OBJECT || type == DataTypeManager.DefaultDataClasses.BIG_INTEGER || type == DataTypeManager.DefaultDataClasses.BIG_DECIMAL) {
                int estRow = 0;
                for (int row = 0; row < rowLength; ++row) {
                    boolean updateEst = row == estRow;
                    size += this.getSize(data.getTuples().get(row).get(col), updateEst, accountForValueCache);
                    if (!updateEst) continue;
                    estRow = estRow * 2 + 1;
                }
                continue;
            }
            size += (long)(SizeUtility.getSize(accountForValueCache, type) * rowLength);
        }
        return size;
    }

    static int getSize(boolean isValueCacheEnabled, Class<?> type) {
        if (type == DataTypeManager.DefaultDataClasses.STRING) {
            return isValueCacheEnabled ? 100 : 256;
        }
        if (type == DataTypeManager.DefaultDataClasses.DATE || type == DataTypeManager.DefaultDataClasses.TIME || type == DataTypeManager.DefaultDataClasses.TIMESTAMP) {
            return isValueCacheEnabled ? 20 : 28;
        }
        if (type == DataTypeManager.DefaultDataClasses.LONG || type == DataTypeManager.DefaultDataClasses.DOUBLE) {
            return isValueCacheEnabled ? 12 : 16;
        }
        if (type == DataTypeManager.DefaultDataClasses.INTEGER || type == DataTypeManager.DefaultDataClasses.FLOAT) {
            return isValueCacheEnabled ? 6 : 12;
        }
        if (type == DataTypeManager.DefaultDataClasses.CHAR || type == DataTypeManager.DefaultDataClasses.SHORT) {
            return isValueCacheEnabled ? 4 : 10;
        }
        if (type == DataTypeManager.DefaultDataClasses.OBJECT) {
            return 1024;
        }
        if (type == DataTypeManager.DefaultDataClasses.NULL) {
            return 0;
        }
        if (type == DataTypeManager.DefaultDataClasses.BYTE || type == DataTypeManager.DefaultDataClasses.BOOLEAN) {
            return 1;
        }
        if (type == DataTypeManager.DefaultDataClasses.BIG_INTEGER) {
            return isValueCacheEnabled ? 75 : 100;
        }
        if (type == DataTypeManager.DefaultDataClasses.BIG_DECIMAL) {
            return isValueCacheEnabled ? 150 : 200;
        }
        return 512;
    }

    protected long getSize(Object obj, boolean updateEstimate, boolean accountForValueCache) {
        if (obj == null) {
            return 0L;
        }
        Class type = DataTypeManager.determineDataTypeClass((Object)obj);
        if (type == DataTypeManager.DefaultDataClasses.STRING) {
            int length = ((String)obj).length();
            if (length > 0) {
                return SizeUtility.alignMemory(40 + 2 * length);
            }
            return 40L;
        }
        if (obj instanceof Iterable) {
            Iterable i = (Iterable)obj;
            long total = 16L;
            for (Object object : i) {
                total += this.getSize(object, true, false) + 8L;
            }
            return total;
        }
        if (type == DataTypeManager.DefaultDataClasses.BIG_DECIMAL) {
            if (!updateEstimate) {
                return this.bigDecimalEstimate;
            }
            int bitLength = ((BigDecimal)obj).unscaledValue().bitLength();
            long result = 88L + SizeUtility.alignMemory(4 + (bitLength >> 3));
            if (updateEstimate) {
                this.bigDecimalEstimate = (this.bigDecimalEstimate + result) / 2L;
            }
            return result;
        }
        if (type == DataTypeManager.DefaultDataClasses.BIG_INTEGER) {
            if (!updateEstimate) {
                return this.bigIntegerEstimate;
            }
            int bitLength = ((BigInteger)obj).bitLength();
            long result = 40L + SizeUtility.alignMemory(4 + (bitLength >> 3));
            if (updateEstimate) {
                this.bigIntegerEstimate = (this.bigIntegerEstimate + result) / 2L;
            }
            return result;
        }
        if (obj.getClass().isArray()) {
            Class<?> componentType = obj.getClass().getComponentType();
            if (!componentType.isPrimitive()) {
                Object[] rows = (Object[])obj;
                long total = 16L + SizeUtility.alignMemory(rows.length * 8);
                for (int i = 0; i < rows.length; ++i) {
                    total += this.getSize(rows[i], true, false);
                }
                return total;
            }
            int length = Array.getLength(obj);
            int primitiveSize = 8;
            if (componentType == Boolean.TYPE) {
                primitiveSize = 4;
            } else if (componentType == Byte.TYPE) {
                primitiveSize = 1;
            } else if (componentType == Short.TYPE) {
                primitiveSize = 2;
            } else if (componentType == Integer.TYPE || componentType == Float.TYPE) {
                primitiveSize = 4;
            }
            return SizeUtility.alignMemory(length * primitiveSize) + 16L;
        }
        return SizeUtility.getSize(accountForValueCache, type);
    }

    private static long alignMemory(long numBytes) {
        long remainder = numBytes % 8L;
        if (remainder != 0L) {
            numBytes += 8L - remainder;
        }
        return numBytes;
    }
}

