/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.teiid.CommandContext;
import org.teiid.PolicyDecider;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.impl.DataPolicyMetadata;

public class DataRolePolicyDecider
implements PolicyDecider {
    private boolean allowCreateTemporaryTablesByDefault = true;
    private boolean allowFunctionCallsByDefault = true;

    public Set<String> getInaccessibleResources(DataPolicy.PermissionType action, Set<String> resources, DataPolicy.Context context, CommandContext commandContext) {
        if (action == DataPolicy.PermissionType.EXECUTE && context == DataPolicy.Context.FUNCTION && this.allowFunctionCallsByDefault) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> results = new LinkedHashSet<String>(resources);
        for (DataPolicy p : commandContext.getAllowedDataPolicies().values()) {
            DataPolicyMetadata policy = (DataPolicyMetadata)p;
            if (results.isEmpty()) break;
            Iterator i = results.iterator();
            while (i.hasNext()) {
                if (!policy.allows((String)i.next(), action)) continue;
                i.remove();
            }
        }
        return results;
    }

    public boolean hasRole(String roleName, CommandContext context) {
        return context.getAllowedDataPolicies().containsKey(roleName);
    }

    public boolean isTempAccessable(DataPolicy.PermissionType action, String resource, DataPolicy.Context context, CommandContext commandContext) {
        for (DataPolicy p : commandContext.getAllowedDataPolicies().values()) {
            DataPolicyMetadata policy = (DataPolicyMetadata)p;
            if (policy.isAllowCreateTemporaryTables() == null) continue;
            return policy.isAllowCreateTemporaryTables();
        }
        return this.allowCreateTemporaryTablesByDefault;
    }

    public void setAllowCreateTemporaryTablesByDefault(boolean allowCreateTemporaryTablesByDefault) {
        this.allowCreateTemporaryTablesByDefault = allowCreateTemporaryTablesByDefault;
    }

    public void setAllowFunctionCallsByDefault(boolean allowFunctionCallsDefault) {
        this.allowFunctionCallsByDefault = allowFunctionCallsDefault;
    }

    public boolean validateCommand(CommandContext commandContext) {
        return !commandContext.getVdb().getDataPolicies().isEmpty();
    }
}

