/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.aggregate;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.sql.rowset.serial.SerialBlob;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.FileStoreInputStreamFactory;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.query.function.aggregate.AggregateFunction;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.TextLine;
import org.teiid.query.util.CommandContext;

public class TextAgg
extends AggregateFunction {
    private FileStoreInputStreamFactory result;
    private CommandContext context;
    private TextLine textLine;

    public TextAgg(CommandContext context, TextLine textLine) {
        this.context = context;
        this.textLine = textLine;
    }

    private FileStoreInputStreamFactory buildResult() throws TeiidProcessingException {
        try {
            FileStore fs = this.context.getBufferManager().createFileStore("textagg");
            FileStoreInputStreamFactory fisf = new FileStoreInputStreamFactory(fs, this.textLine.getEncoding() == null ? "UTF-8" : this.textLine.getEncoding());
            Writer w = fisf.getWriter();
            if (this.textLine.isIncludeHeader()) {
                w.write(TextLine.evaluate(this.textLine.getExpressions(), new TextLine.ValueExtractor<DerivedColumn>(){

                    @Override
                    public Object getValue(DerivedColumn t) {
                        if (t.getAlias() == null && t.getExpression() instanceof ElementSymbol) {
                            return ((ElementSymbol)t.getExpression()).getShortName();
                        }
                        return t.getAlias();
                    }
                }, this.textLine.getDelimiter(), this.textLine.getQuote()));
            }
            w.flush();
            return fisf;
        }
        catch (IOException e) {
            throw new TeiidProcessingException((Throwable)e);
        }
    }

    @Override
    public void reset() {
        this.result = null;
    }

    @Override
    public void addInputDirect(Object input, List<?> tuple) throws TeiidComponentException, TeiidProcessingException {
        try {
            if (this.result == null) {
                this.result = this.buildResult();
            }
            String in = (String)input;
            Writer w = this.result.getWriter();
            w.write(in);
            w.flush();
        }
        catch (IOException e) {
            throw new TeiidProcessingException((Throwable)e);
        }
    }

    @Override
    public Object getResult() throws TeiidProcessingException {
        if (this.result == null) {
            this.result = this.buildResult();
        }
        try {
            FileStore.FileStoreOutputStream fs = this.result.getOuputStream();
            fs.close();
            if (fs.bytesWritten()) {
                return new BlobType((Blob)new BlobImpl((InputStreamFactory)this.result));
            }
            return new BlobType((Blob)new SerialBlob(Arrays.copyOf(fs.getBuffer(), fs.getCount())));
        }
        catch (IOException e) {
            throw new TeiidProcessingException((Throwable)e);
        }
        catch (SQLException e) {
            throw new TeiidProcessingException((Throwable)e);
        }
    }
}

