/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.mapping.xml;

import java.util.HashMap;
import java.util.Map;
import org.teiid.query.mapping.xml.MappingBaseNode;
import org.teiid.query.mapping.xml.MappingNodeConstants;
import org.teiid.query.mapping.xml.MappingVisitor;
import org.teiid.query.mapping.xml.ResultSetInfo;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;

public class MappingSourceNode
extends MappingBaseNode {
    private transient ResultSetInfo resultSetInfo;
    private Map symbolMap = new HashMap();

    protected MappingSourceNode() {
    }

    public MappingSourceNode(String source) {
        this.setProperty(MappingNodeConstants.Properties.NODE_TYPE, "source");
        this.setSource(source);
    }

    @Override
    public void acceptVisitor(MappingVisitor visitor) {
        visitor.visit(this);
    }

    public String getResultName() {
        return (String)this.getProperty(MappingNodeConstants.Properties.RESULT_SET_NAME);
    }

    public String getAliasResultName() {
        return (String)this.getProperty(MappingNodeConstants.Properties.ALIAS_RESULT_SET_NAME);
    }

    public void setAliasResultName(String alias) {
        this.setProperty(MappingNodeConstants.Properties.ALIAS_RESULT_SET_NAME, alias);
    }

    @Override
    public MappingBaseNode setSource(String source) {
        if (source != null) {
            this.setProperty(MappingNodeConstants.Properties.RESULT_SET_NAME, source);
        }
        return this;
    }

    @Override
    public MappingSourceNode getSourceNode() {
        return this;
    }

    public boolean isRootSourceNode() {
        return this.getParentSourceNode() == null;
    }

    public MappingSourceNode getParentSourceNode() {
        for (MappingBaseNode parent = this.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!(parent instanceof MappingSourceNode)) continue;
            return (MappingSourceNode)parent;
        }
        return null;
    }

    public ResultSetInfo getResultSetInfo() {
        if (this.resultSetInfo == null) {
            this.resultSetInfo = new ResultSetInfo(this.getActualResultSetName());
            this.setProperty(MappingNodeConstants.Properties.RESULT_SET_INFO, this.resultSetInfo);
        }
        return this.resultSetInfo;
    }

    public void setResultSetInfo(ResultSetInfo resultSetInfo) {
        this.resultSetInfo = resultSetInfo;
    }

    @Override
    public String toString() {
        return "[" + this.getProperty(MappingNodeConstants.Properties.NODE_TYPE) + "]" + this.getProperty(MappingNodeConstants.Properties.RESULT_SET_NAME);
    }

    public Map getSymbolMap() {
        return this.symbolMap;
    }

    public void setSymbolMap(Map symbolMap) {
        this.symbolMap = symbolMap;
        this.updateSymbolMapDependentValues();
    }

    public void updateSymbolMapDependentValues() {
        ElementSymbol mappingClassSymbol;
        if (this.getAliasResultName() != null) {
            GroupSymbol newGroup = this.getMappedSymbol(new GroupSymbol(this.getAliasResultName()));
            this.setAliasResultName(newGroup.getName());
        }
        if ((mappingClassSymbol = this.getResultSetInfo().getMappingClassSymbol()) != null) {
            this.getResultSetInfo().setMappingClassSymbol(this.getMappedSymbol(mappingClassSymbol));
        }
    }

    public String getActualResultSetName() {
        GroupSymbol group = this.getMappedSymbol(new GroupSymbol(this.getResultName()));
        return group.getName();
    }

    public Map buildFullSymbolMap() {
        HashMap map = new HashMap();
        for (MappingSourceNode sourceNode = this; sourceNode != null; sourceNode = sourceNode.getParentSourceNode()) {
            map.putAll(sourceNode.getSymbolMap());
        }
        return map;
    }

    public ElementSymbol getMappedSymbol(ElementSymbol symbol) {
        MappingSourceNode parentSourceNode;
        ElementSymbol mappedSymbol = (ElementSymbol)this.symbolMap.get(symbol);
        if (mappedSymbol == null && (parentSourceNode = this.getParentSourceNode()) != null) {
            return parentSourceNode.getMappedSymbol(symbol);
        }
        if (mappedSymbol == null) {
            return symbol;
        }
        return mappedSymbol;
    }

    public GroupSymbol getMappedSymbol(GroupSymbol symbol) {
        MappingSourceNode parentSourceNode;
        GroupSymbol mappedSymbol = (GroupSymbol)this.symbolMap.get(symbol);
        if (mappedSymbol == null && (parentSourceNode = this.getParentSourceNode()) != null) {
            return parentSourceNode.getMappedSymbol(symbol);
        }
        if (mappedSymbol == null) {
            return symbol;
        }
        return mappedSymbol;
    }
}

