/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.id.IDGenerator;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.mapping.xml.MappingNodeLogger;
import org.teiid.query.mapping.xml.MappingRecursiveElement;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.mapping.xml.ResultSetInfo;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.CommandPlanner;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.xml.CriteriaPlanner;
import org.teiid.query.optimizer.xml.HandleNillableVisitor;
import org.teiid.query.optimizer.xml.MarkExcludeVisitor;
import org.teiid.query.optimizer.xml.NameInSourceResolverVisitor;
import org.teiid.query.optimizer.xml.SourceNodeGenaratorVisitor;
import org.teiid.query.optimizer.xml.SourceNodePlannerVisitor;
import org.teiid.query.optimizer.xml.ValidateMappedCriteriaVisitor;
import org.teiid.query.optimizer.xml.XMLPlanToProcessVisitor;
import org.teiid.query.optimizer.xml.XMLPlannerEnvironment;
import org.teiid.query.optimizer.xml.XMLProjectionMinimizer;
import org.teiid.query.optimizer.xml.XMLQueryPlanner;
import org.teiid.query.optimizer.xml.XMLStagaingQueryPlanner;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.xml.Program;
import org.teiid.query.processor.xml.XMLPlan;
import org.teiid.query.processor.xml.XMLProcessorEnvironment;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.SelectSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.util.CommandContext;

public final class XMLPlanner
implements CommandPlanner {
    @Override
    public ProcessorPlan optimize(Command command, IDGenerator idGenerator, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        XMLPlannerEnvironment env = new XMLPlannerEnvironment(metadata);
        return XMLPlanner.preparePlan(command, metadata, analysisRecord, env, idGenerator, capFinder, context);
    }

    static XMLPlan preparePlan(Command command, QueryMetadataInterface metadata, AnalysisRecord analysisRecord, XMLPlannerEnvironment planEnv, IDGenerator idGenerator, CapabilitiesFinder capFinder, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        Query xmlQuery = (Query)command;
        boolean debug = analysisRecord.recordDebug();
        if (debug) {
            analysisRecord.println("============================================================================");
            analysisRecord.println("XML COMMAND: " + xmlQuery);
        }
        GroupSymbol group = xmlQuery.getFrom().getGroups().iterator().next();
        MappingDocument doc = (MappingDocument)metadata.getMappingNode(group.getMetadataID());
        planEnv.mappingDoc = doc = doc.clone();
        planEnv.documentGroup = group;
        planEnv.xmlCommand = (Query)command;
        planEnv.analysisRecord = analysisRecord;
        planEnv.capFinder = capFinder;
        planEnv.idGenerator = idGenerator;
        planEnv.context = context;
        LogManager.logTrace((String)"org.teiid.PLANNER.XML_PLANNER", (Object[])new Object[]{"Mapping document tree", new MappingNodeLogger(planEnv.mappingDoc)});
        if (debug) {
            XMLPlanner.debugDocumentInfo("Start", planEnv);
        }
        XMLPlanner.prePlan(planEnv, debug);
        Program programPlan = XMLPlanToProcessVisitor.planProgram(planEnv.mappingDoc, planEnv);
        XMLProcessorEnvironment env = planEnv.createProcessorEnvironment(programPlan);
        XMLPlan plan = new XMLPlan(env);
        plan.setXMLSchemas(metadata.getXMLSchemas(group.getMetadataID()));
        if (debug) {
            analysisRecord.println("");
            analysisRecord.println(plan.toString());
            analysisRecord.println("============================================================================");
        }
        return plan;
    }

    private static void debugDocumentInfo(String msgTag, XMLPlannerEnvironment planEnv) {
        planEnv.analysisRecord.println("\n" + msgTag + ":============================================================================");
        planEnv.analysisRecord.println("MAPPING DOCUMENT:\n" + MappingNode.toStringNodeTree(planEnv.mappingDoc));
    }

    private static void prePlan(XMLPlannerEnvironment planEnv, boolean debug) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        planEnv.mappingDoc = SourceNodeGenaratorVisitor.extractSourceNodes(planEnv.mappingDoc);
        if (debug) {
            XMLPlanner.debugDocumentInfo("After Source Node Generation", planEnv);
        }
        SourceNodePlannerVisitor.raiseInputSet(planEnv.mappingDoc, planEnv);
        XMLPlanner.placeOrderBys(planEnv.xmlCommand.getOrderBy(), planEnv);
        Criteria crit = planEnv.xmlCommand.getCriteria();
        CriteriaPlanner.placeUserCriteria(crit, planEnv);
        XMLQueryPlanner.prePlanQueries(planEnv.mappingDoc, planEnv);
        if (debug) {
            XMLPlanner.debugDocumentInfo("After Pre Plan Queries", planEnv);
        }
        XMLPlanner.preMarkExcluded(planEnv.xmlCommand, planEnv.mappingDoc);
        if (debug) {
            XMLPlanner.debugDocumentInfo("After Mark Exclude", planEnv);
        }
        XMLPlanner.removeExcluded(planEnv.mappingDoc);
        if (debug) {
            XMLPlanner.debugDocumentInfo("After Exclude", planEnv);
        }
        NameInSourceResolverVisitor.resolveElements(planEnv.mappingDoc, planEnv);
        ValidateMappedCriteriaVisitor.validateAndCollectCriteriaElements(planEnv.mappingDoc, planEnv);
        XMLProjectionMinimizer.minimizeProjection(planEnv);
        if (debug) {
            XMLPlanner.debugDocumentInfo("After Projection Minimization", planEnv);
        }
        XMLStagaingQueryPlanner.stageQueries(planEnv.mappingDoc, planEnv);
        XMLQueryPlanner.optimizeQueries(planEnv.mappingDoc, planEnv);
        planEnv.mappingDoc = HandleNillableVisitor.execute(planEnv.mappingDoc);
    }

    static void removeExcluded(MappingNode node) {
        Iterator<MappingNode> i = node.getChildren().iterator();
        while (i.hasNext()) {
            MappingNode child = i.next();
            if (!(node instanceof MappingRecursiveElement) && child.isExcluded()) {
                i.remove();
                continue;
            }
            XMLPlanner.removeExcluded(child);
        }
    }

    static MappingDocument preMarkExcluded(Query xmlCommand, MappingDocument doc) {
        Select select = xmlCommand.getSelect();
        SelectSymbol firstSymbol = select.getSymbol(0);
        if (firstSymbol instanceof MultipleElementSymbol && ((MultipleElementSymbol)firstSymbol).getGroup() == null) {
            return doc;
        }
        Collection<ElementSymbol> validElements = ElementCollectorVisitor.getElements((LanguageObject)select, true);
        HashSet<String> elements = new HashSet<String>(validElements.size());
        for (ElementSymbol element : validElements) {
            elements.add(element.getCanonicalName());
        }
        return MarkExcludeVisitor.markExcludedNodes(doc, elements);
    }

    private static void placeOrderBys(OrderBy orderBy, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        if (orderBy == null) {
            return;
        }
        List<SingleElementSymbol> elements = orderBy.getSortKeys();
        List<Boolean> types = orderBy.getTypes();
        for (int i = 0; i < elements.size(); ++i) {
            ElementSymbol elemSymbol = (ElementSymbol)elements.get(i);
            String nodeName = planEnv.getGlobalMetadata().getFullName(elemSymbol.getMetadataID()).toUpperCase();
            MappingNode elementNode = MappingNode.findNode(planEnv.mappingDoc, nodeName);
            if (elementNode.getNameInSource() == null) {
                Object[] params = new Object[]{elementNode, orderBy};
                String msg = QueryPlugin.Util.getString("XMLPlanner.The_XML_document_element_{0}_is_not_mapped_to_data_and_cannot_be_used_in_the_ORDER_BY_clause__{1}_1", params);
                throw new QueryPlannerException(msg);
            }
            MappingSourceNode sourceNode = elementNode.getSourceNode();
            ResultSetInfo rs = sourceNode.getResultSetInfo();
            OrderBy by = rs.getOrderBy();
            if (by == null) {
                by = new OrderBy();
            }
            ElementSymbol mappedSymbol = (ElementSymbol)sourceNode.getSymbolMap().get(new ElementSymbol(elementNode.getNameInSource()));
            by.addVariable(mappedSymbol.clone(), types.get(i));
            rs.setOrderBy(by);
        }
    }
}

