/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.util.HashMap;
import java.util.Map;
import org.teiid.core.id.IDGenerator;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.ResultSetInfo;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.processor.xml.Program;
import org.teiid.query.processor.xml.XMLProcessorEnvironment;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.util.CommandContext;

public final class XMLPlannerEnvironment {
    public static final Integer XML_FORM_RESULTS_PROPERTY = new Integer(0);
    CapabilitiesFinder capFinder;
    private QueryMetadataInterface metadata;
    IDGenerator idGenerator;
    GroupSymbol documentGroup;
    MappingDocument mappingDoc;
    Query xmlCommand;
    AnalysisRecord analysisRecord;
    CommandContext context;
    private HashMap stagingResultsInfo = new HashMap();
    private Map globalTempMetadata = new HashMap();
    private Map stagingTableMap = new HashMap();
    private Map queryNodeMap = new HashMap();

    public XMLPlannerEnvironment(QueryMetadataInterface qmi) {
        this.metadata = qmi;
    }

    XMLProcessorEnvironment createProcessorEnvironment(Program mainProgram) {
        XMLProcessorEnvironment processorEnv = new XMLProcessorEnvironment(mainProgram);
        processorEnv.setDocumentGroup(this.documentGroup);
        return processorEnv;
    }

    TempMetadataAdapter getGlobalMetadata() {
        return new TempMetadataAdapter(this.metadata, new TempMetadataStore(this.globalTempMetadata), this.stagingTableMap, this.queryNodeMap);
    }

    public ResultSetInfo getStagingTableResultsInfo(String groupName) {
        ResultSetInfo info = (ResultSetInfo)this.stagingResultsInfo.get(groupName.toUpperCase());
        if (info == null) {
            info = new ResultSetInfo(groupName);
            this.stagingResultsInfo.put(info.getResultSetName().toUpperCase(), info);
        }
        return info;
    }

    public void addStagingTable(Object groupId, Object intoGroupId) {
        this.stagingTableMap.put(groupId, intoGroupId);
    }

    public boolean isStagingTable(Object groupId) {
        return this.stagingTableMap.containsKey(groupId);
    }

    public void addToGlobalMetadata(Map data) {
        this.globalTempMetadata.putAll(data);
    }

    public void addQueryNodeToMetadata(Object metadataId, QueryNode node) {
        this.queryNodeMap.put(metadataId, node);
    }

    public String unLoadResultName(String loadName) {
        return "unload_" + loadName;
    }

    public String getStagedResultName(String rsName) {
        return "autostaged_" + rsName.replace('.', '_');
    }

    public String getAliasName(String rsName) {
        String inlineViewName = rsName.replace(".".charAt(0), '_');
        return inlineViewName;
    }
}

