/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.navigator;

import java.util.List;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.AlterProcedure;
import org.teiid.query.sql.lang.AlterTrigger;
import org.teiid.query.sql.lang.AlterView;
import org.teiid.query.sql.lang.ArrayTable;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.Drop;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.TextTable;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.lang.XMLTable;
import org.teiid.query.sql.navigator.AbstractNavigator;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.BreakStatement;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.ContinueStatement;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.proc.CriteriaSelector;
import org.teiid.query.sql.proc.DeclareStatement;
import org.teiid.query.sql.proc.HasCriteria;
import org.teiid.query.sql.proc.IfStatement;
import org.teiid.query.sql.proc.LoopStatement;
import org.teiid.query.sql.proc.RaiseErrorStatement;
import org.teiid.query.sql.proc.TranslateCriteria;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.proc.WhileStatement;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.QueryString;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.TextLine;
import org.teiid.query.sql.symbol.WindowFunction;
import org.teiid.query.sql.symbol.WindowSpecification;
import org.teiid.query.sql.symbol.XMLAttributes;
import org.teiid.query.sql.symbol.XMLElement;
import org.teiid.query.sql.symbol.XMLForest;
import org.teiid.query.sql.symbol.XMLNamespaces;
import org.teiid.query.sql.symbol.XMLParse;
import org.teiid.query.sql.symbol.XMLQuery;
import org.teiid.query.sql.symbol.XMLSerialize;

public class PreOrPostOrderNavigator
extends AbstractNavigator {
    public static final boolean PRE_ORDER = true;
    public static final boolean POST_ORDER = false;
    private boolean order;
    private boolean deep;

    public PreOrPostOrderNavigator(LanguageVisitor visitor, boolean order, boolean deep) {
        super(visitor);
        this.order = order;
        this.deep = deep;
    }

    protected void preVisitVisitor(LanguageObject obj) {
        if (this.order) {
            this.visitVisitor(obj);
        }
    }

    protected void postVisitVisitor(LanguageObject obj) {
        if (!this.order) {
            this.visitVisitor(obj);
        }
    }

    @Override
    public void visit(AggregateSymbol obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getExpression());
        this.visitNode(obj.getOrderBy());
        this.visitNode(obj.getCondition());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(AliasSymbol obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getSymbol());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(MultipleElementSymbol obj) {
        this.preVisitVisitor(obj);
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(AssignmentStatement obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getVariable());
        this.visitNode(obj.getExpression());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(BatchedUpdateCommand obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getUpdateCommands());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(BetweenCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getExpression());
        this.visitNode(obj.getLowerExpression());
        this.visitNode(obj.getUpperExpression());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(Block obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getStatements());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(BreakStatement obj) {
        this.preVisitVisitor(obj);
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(CaseExpression obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getExpression());
        for (int i = 0; i < obj.getWhenCount(); ++i) {
            this.visitNode(obj.getWhenExpression(i));
            this.visitNode(obj.getThenExpression(i));
        }
        this.visitNode(obj.getElseExpression());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(CommandStatement obj) {
        this.preVisitVisitor(obj);
        if (this.deep) {
            this.visitNode(obj.getCommand());
        }
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(CompareCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getLeftExpression());
        this.visitNode(obj.getRightExpression());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(CompoundCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getCriteria());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(Constant obj) {
        this.preVisitVisitor(obj);
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(ContinueStatement obj) {
        this.preVisitVisitor(obj);
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(CreateUpdateProcedureCommand obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getBlock());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(CriteriaSelector obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getElements());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(DeclareStatement obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getVariable());
        this.visitNode(obj.getExpression());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(Delete obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getGroup());
        this.visitNode(obj.getCriteria());
        this.visitNode(obj.getOption());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(DependentSetCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getExpression());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(ElementSymbol obj) {
        this.preVisitVisitor(obj);
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(ExistsCriteria obj) {
        this.preVisitVisitor(obj);
        if (this.deep) {
            this.visitNode(obj.getCommand());
        }
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(ExpressionSymbol obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getExpression());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(From obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getClauses());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(Function obj) {
        this.preVisitVisitor(obj);
        Expression[] args = obj.getArgs();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                this.visitNode(args[i]);
            }
        }
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(GroupBy obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getSymbols());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(GroupSymbol obj) {
        this.preVisitVisitor(obj);
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(HasCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getSelector());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(IfStatement obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getCondition());
        this.visitNode(obj.getIfBlock());
        this.visitNode(obj.getElseBlock());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(Insert obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getGroup());
        this.visitNodes(obj.getVariables());
        this.visitNodes(obj.getValues());
        if (this.deep && obj.getQueryExpression() != null) {
            this.visitNode(obj.getQueryExpression());
        }
        this.visitNode(obj.getOption());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(Create obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getTable());
        this.visitNodes(obj.getColumnSymbols());
        this.visitNodes(obj.getPrimaryKey());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(Drop obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getTable());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(Into obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getGroup());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(IsNullCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getExpression());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(JoinPredicate obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getLeftClause());
        this.visitNode(obj.getJoinType());
        this.visitNode(obj.getRightClause());
        this.visitNodes(obj.getJoinCriteria());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(JoinType obj) {
        this.preVisitVisitor(obj);
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(Limit obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getOffset());
        this.visitNode(obj.getRowLimit());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(LoopStatement obj) {
        this.preVisitVisitor(obj);
        if (this.deep) {
            this.visitNode(obj.getCommand());
        }
        this.visitNode(obj.getBlock());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(MatchCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getLeftExpression());
        this.visitNode(obj.getRightExpression());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(NotCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getCriteria());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(Option obj) {
        this.preVisitVisitor(obj);
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(OrderBy obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getOrderByItems());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(OrderByItem obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getSymbol());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(Query obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getWith());
        this.visitNode(obj.getSelect());
        this.visitNode(obj.getInto());
        this.visitNode(obj.getFrom());
        this.visitNode(obj.getCriteria());
        this.visitNode(obj.getGroupBy());
        this.visitNode(obj.getHaving());
        this.visitNode(obj.getOrderBy());
        this.visitNode(obj.getLimit());
        this.visitNode(obj.getOption());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(RaiseErrorStatement obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getExpression());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(Reference obj) {
        this.preVisitVisitor(obj);
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(ScalarSubquery obj) {
        this.preVisitVisitor(obj);
        if (this.deep) {
            this.visitNode(obj.getCommand());
        }
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(SearchedCaseExpression obj) {
        this.preVisitVisitor(obj);
        for (int i = 0; i < obj.getWhenCount(); ++i) {
            this.visitNode(obj.getWhenCriteria(i));
            this.visitNode(obj.getThenExpression(i));
        }
        this.visitNode(obj.getElseExpression());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(Select obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getSymbols());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(SetCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getExpression());
        this.visitNodes(obj.getValues());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(SetQuery obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getWith());
        this.visitNodes(obj.getQueryCommands());
        this.visitNode(obj.getOrderBy());
        this.visitNode(obj.getLimit());
        this.visitNode(obj.getOption());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(StoredProcedure obj) {
        this.preVisitVisitor(obj);
        List<SPParameter> params = obj.getParameters();
        if (params != null && !params.isEmpty()) {
            for (SPParameter parameter : params) {
                Expression expression = parameter.getExpression();
                this.visitNode(expression);
            }
        }
        this.visitNode(obj.getOption());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(SubqueryCompareCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getLeftExpression());
        if (this.deep) {
            this.visitNode(obj.getCommand());
        }
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(SubqueryFromClause obj) {
        this.preVisitVisitor(obj);
        if (this.deep) {
            this.visitNode(obj.getCommand());
        }
        this.visitNode(obj.getGroupSymbol());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(SubquerySetCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getExpression());
        if (this.deep) {
            this.visitNode(obj.getCommand());
        }
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(TranslateCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getSelector());
        this.visitNodes(obj.getTranslations());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(UnaryFromClause obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getGroup());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(Update obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getGroup());
        this.visitNode(obj.getChangeList());
        this.visitNode(obj.getCriteria());
        this.visitNode(obj.getOption());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(WhileStatement obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getCondition());
        this.visitNode(obj.getBlock());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(DynamicCommand obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getSql());
        this.visitNode(obj.getIntoGroup());
        if (obj.getUsing() != null) {
            for (SetClause setClause : obj.getUsing().getClauses()) {
                this.visitNode(setClause.getValue());
            }
        }
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(SetClauseList obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getClauses());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(SetClause obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getSymbol());
        this.visitNode(obj.getValue());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(TextLine obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getExpressions());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(XMLForest obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getNamespaces());
        this.visitNodes(obj.getArgs());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(XMLAttributes obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getArgs());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(XMLElement obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getNamespaces());
        this.visitNode(obj.getAttributes());
        this.visitNodes(obj.getContent());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(XMLNamespaces obj) {
        this.preVisitVisitor(obj);
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(TextTable obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getFile());
        this.visitNode(obj.getGroupSymbol());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(XMLTable obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getNamespaces());
        this.visitNodes(obj.getPassing());
        for (XMLTable.XMLColumn column : obj.getColumns()) {
            this.visitNode(column.getDefaultExpression());
        }
        this.visitNode(obj.getGroupSymbol());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(XMLQuery obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getNamespaces());
        this.visitNodes(obj.getPassing());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(DerivedColumn obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getExpression());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(XMLSerialize obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getExpression());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(QueryString obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getPath());
        this.visitNodes(obj.getArgs());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(XMLParse obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getExpression());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(ExpressionCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getExpression());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(WithQueryCommand obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getColumns());
        if (this.deep) {
            this.visitNode(obj.getCommand());
        }
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(TriggerAction obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getBlock());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(ArrayTable obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getArrayValue());
        this.visitNode(obj.getGroupSymbol());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(AlterProcedure obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getTarget());
        if (this.deep) {
            this.visitNode((LanguageObject)obj.getDefinition());
        }
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(AlterTrigger obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getTarget());
        if (this.deep) {
            this.visitNode((LanguageObject)obj.getDefinition());
        }
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(AlterView obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getTarget());
        if (this.deep) {
            this.visitNode((LanguageObject)obj.getDefinition());
        }
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(WindowFunction obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getFunction());
        this.visitNode(obj.getWindowSpecification());
        this.postVisitVisitor(obj);
    }

    @Override
    public void visit(WindowSpecification obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getPartition());
        this.visitNode(obj.getOrderBy());
        this.postVisitVisitor(obj);
    }

    public static void doVisit(LanguageObject object, LanguageVisitor visitor, boolean order) {
        PreOrPostOrderNavigator.doVisit(object, visitor, order, false);
    }

    public static void doVisit(LanguageObject object, LanguageVisitor visitor, boolean order, boolean deep) {
        PreOrPostOrderNavigator nav = new PreOrPostOrderNavigator(visitor, order, deep);
        object.acceptVisitor(nav);
    }
}

