/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;

public class ElementSymbol
extends SingleElementSymbol {
    private GroupSymbol groupSymbol;
    private Object metadataID;
    private Class<?> type;
    private boolean isExternalReference;
    private boolean isAggregate;
    private DisplayMode displayMode = DisplayMode.OUTPUT_NAME;

    protected ElementSymbol(String name, String canonicalName) {
        super(name, canonicalName);
    }

    public ElementSymbol(String name) {
        super(name);
    }

    public ElementSymbol(String shortName, String shortCanonical, GroupSymbol group) {
        super(shortName, shortCanonical);
        this.groupSymbol = group;
    }

    public ElementSymbol(String name, boolean displayFullyQualified) {
        super(name);
        this.setDisplayFullyQualified(displayFullyQualified);
    }

    @Override
    public String getName() {
        if (this.groupSymbol != null) {
            return this.groupSymbol.getName() + "." + this.getShortName();
        }
        return super.getName();
    }

    @Override
    public String getCanonicalName() {
        if (this.groupSymbol != null) {
            return this.groupSymbol.getCanonicalName() + "." + this.getShortCanonicalName();
        }
        return super.getCanonicalName();
    }

    @Override
    public boolean equals(Object obj) {
        if (this.groupSymbol == null) {
            return super.equals(obj);
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ElementSymbol)) {
            return false;
        }
        ElementSymbol other = (ElementSymbol)obj;
        if (other.groupSymbol == null) {
            return super.equals(obj);
        }
        return this.groupSymbol.equals(other.groupSymbol) && this.getShortCanonicalName().equals(other.getShortCanonicalName());
    }

    @Override
    public int hashCode() {
        if (this.groupSymbol != null) {
            return HashCodeUtil.hashCode((int)this.groupSymbol.hashCode(), (int)this.getShortCanonicalName().hashCode());
        }
        return super.hashCode();
    }

    public void setDisplayMode(DisplayMode displayMode) {
        if (displayMode == null) {
            this.displayMode = DisplayMode.OUTPUT_NAME;
        }
        this.displayMode = displayMode;
    }

    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayFullyQualified(boolean displayFullyQualified) {
        this.displayMode = displayFullyQualified ? DisplayMode.FULLY_QUALIFIED : DisplayMode.SHORT_OUTPUT_NAME;
    }

    public boolean getDisplayFullyQualified() {
        return this.displayMode.equals((Object)DisplayMode.FULLY_QUALIFIED);
    }

    public void setIsExternalReference(boolean isExternalReference) {
        this.isExternalReference = isExternalReference;
    }

    public boolean isExternalReference() {
        return this.isExternalReference;
    }

    public void setGroupSymbol(GroupSymbol symbol) {
        this.groupSymbol = symbol;
    }

    @Override
    protected void setName(String name) {
        int index = name.lastIndexOf(46);
        if (index > 0) {
            if (this.groupSymbol != null) {
                throw new AssertionError((Object)"Attempt to set an invalid name");
            }
            GroupSymbol gs = new GroupSymbol(new String(name.substring(0, index)));
            this.setGroupSymbol(gs);
            name = new String(name.substring(index + 1));
        } else {
            this.groupSymbol = null;
        }
        super.setShortName(name);
    }

    public GroupSymbol getGroupSymbol() {
        return this.groupSymbol;
    }

    public Object getMetadataID() {
        return this.metadataID;
    }

    public void setMetadataID(Object metadataID) {
        this.metadataID = metadataID;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isResolved() {
        return this.metadataID != null && this.type != null;
    }

    @Override
    public ElementSymbol clone() {
        ElementSymbol copy = new ElementSymbol(this.getShortName(), this.getCanonical());
        if (this.getGroupSymbol() != null) {
            copy.setGroupSymbol(this.getGroupSymbol().clone());
        }
        copy.setMetadataID(this.getMetadataID());
        copy.setType(this.getType());
        copy.setIsExternalReference(this.isExternalReference());
        copy.outputName = this.outputName;
        copy.setDisplayMode(this.getDisplayMode());
        copy.isAggregate = this.isAggregate;
        return copy;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public void setAggregate(boolean isAggregate) {
        this.isAggregate = isAggregate;
    }

    public static enum DisplayMode {
        FULLY_QUALIFIED,
        OUTPUT_NAME,
        SHORT_OUTPUT_NAME;

    }
}

