/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.StringUtil;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public abstract class Symbol
implements LanguageObject {
    private String shortName;
    private String canonicalShortName;
    protected String outputName;

    protected Symbol(String name, String canonicalName) {
        this.shortName = name;
        this.canonicalShortName = canonicalName;
    }

    public Symbol(String name) {
        this.setName(name);
    }

    protected void setName(String name) {
        this.setShortName(name);
    }

    public void setShortName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0017"));
        }
        this.shortName = DataTypeManager.getCanonicalString((String)name);
        this.outputName = null;
        this.canonicalShortName = null;
    }

    public String getName() {
        return this.getShortName();
    }

    public String getCanonicalName() {
        return this.getShortCanonicalName();
    }

    public void setShortCanonicalName(String shortCanonicalName) {
        this.canonicalShortName = shortCanonicalName;
    }

    public abstract boolean isResolved();

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public int hashCode() {
        return this.getCanonicalName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Symbol)) {
            return false;
        }
        String otherFqn = ((Symbol)obj).getCanonicalName();
        String thisFqn = this.getCanonicalName();
        return thisFqn.equals(otherFqn);
    }

    @Override
    public abstract Object clone();

    protected final String getCanonical() {
        return this.canonicalShortName;
    }

    public String getOutputName() {
        return this.outputName == null ? this.getName() : this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = DataTypeManager.getCanonicalString((String)outputName);
    }

    public final String getShortName() {
        return this.shortName;
    }

    public final String getShortCanonicalName() {
        if (this.canonicalShortName == null) {
            this.canonicalShortName = DataTypeManager.getCanonicalString((String)StringUtil.toUpperCase((String)this.shortName));
        }
        return this.canonicalShortName;
    }
}

