/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class DataObjectOutputStream
extends DataOutputStream
implements ObjectOutput {
    private static final int MAX_BYTE_IDS = 254;
    static AtomicInteger counter = new AtomicInteger(2);
    static final ConcurrentHashMap<String, Byte> knownClasses = new ConcurrentHashMap();
    static final ConcurrentHashMap<Byte, String> typeMapping = new ConcurrentHashMap();
    static final int TYPE_FAT_DESCRIPTOR = 0;
    static final int TYPE_THIN_DESCRIPTOR = 1;
    ObjectOutputStream oos;

    public DataObjectOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        if (this.oos == null) {
            this.oos = new ObjectOutputStream(this){

                @Override
                protected void writeStreamHeader() throws IOException {
                    this.writeByte(5);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
                    Class<?> clazz = desc.forClass();
                    if (clazz.isPrimitive() || clazz.isArray()) {
                        this.write(0);
                        super.writeClassDescriptor(desc);
                        return;
                    }
                    String name = desc.getName();
                    Byte b = knownClasses.get(name);
                    if (b == null && counter.get() < 254) {
                        Class<DataObjectOutputStream> clazz2 = DataObjectOutputStream.class;
                        // MONITORENTER : org.teiid.common.buffer.impl.DataObjectOutputStream.class
                        b = knownClasses.get(name);
                        if (b == null && counter.get() < 254) {
                            b = (byte)counter.getAndIncrement();
                            knownClasses.put(name, b);
                            typeMapping.put(b, name);
                        }
                        // MONITOREXIT : clazz2
                    }
                    if (b != null) {
                        this.write(b.byteValue());
                        return;
                    }
                    this.write(1);
                    this.writeUTF(name);
                }
            };
        }
        this.oos.writeObject(obj);
        this.oos.flush();
    }
}

