/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkManager;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.impl.TransactionMetadata;
import org.teiid.client.xa.XATransactionException;
import org.teiid.client.xa.XidImpl;
import org.teiid.core.util.Assertion;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.dqp.service.TransactionService;
import org.teiid.query.QueryPlugin;

public class TransactionServerImpl
implements TransactionService {
    private TransactionMapping transactions = new TransactionMapping();
    private XATerminator xaTerminator;
    private TransactionManager transactionManager;
    private WorkManager workManager;

    public void setXaTerminator(XATerminator xaTerminator) {
        this.xaTerminator = xaTerminator;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    @Override
    public int prepare(String threadId, XidImpl xid, boolean singleTM) throws XATransactionException {
        TransactionContext tc = this.checkXAState(threadId, xid, true, false);
        if (!tc.getSuspendedBy().isEmpty()) {
            throw new XATransactionException(-6, QueryPlugin.Util.getString("TransactionServer.suspended_exist", new Object[]{xid}));
        }
        if (singleTM) {
            return 3;
        }
        try {
            return this.xaTerminator.prepare(tc.getXid());
        }
        catch (XAException e) {
            throw new XATransactionException((Throwable)e);
        }
    }

    @Override
    public void commit(String threadId, XidImpl xid, boolean onePhase, boolean singleTM) throws XATransactionException {
        TransactionContext tc = this.checkXAState(threadId, xid, true, false);
        try {
            if (singleTM || onePhase && 3 == this.prepare(threadId, xid, singleTM)) {
                return;
            }
            this.xaTerminator.commit(tc.getXid(), false);
        }
        catch (XAException e) {
            throw new XATransactionException((Throwable)e);
        }
        finally {
            this.transactions.removeTransactionContext(tc);
        }
    }

    @Override
    public void rollback(String threadId, XidImpl xid, boolean singleTM) throws XATransactionException {
        TransactionContext tc = this.checkXAState(threadId, xid, true, false);
        try {
            if (!singleTM) {
                this.xaTerminator.rollback(tc.getXid());
            }
        }
        catch (XAException e) {
            throw new XATransactionException((Throwable)e);
        }
        finally {
            this.transactions.removeTransactionContext(tc);
        }
    }

    @Override
    public Xid[] recover(int flag, boolean singleTM) throws XATransactionException {
        if (singleTM) {
            return new Xid[0];
        }
        try {
            return this.xaTerminator.recover(flag);
        }
        catch (XAException e) {
            throw new XATransactionException((Throwable)e);
        }
    }

    @Override
    public void forget(String threadId, XidImpl xid, boolean singleTM) throws XATransactionException {
        TransactionContext tc = this.checkXAState(threadId, xid, true, false);
        try {
            if (singleTM) {
                return;
            }
            this.xaTerminator.forget((Xid)xid);
        }
        catch (XAException err) {
            throw new XATransactionException((Throwable)err);
        }
        finally {
            this.transactions.removeTransactionContext(tc);
        }
    }

    @Override
    public void start(String threadId, XidImpl xid, int flags, int timeout, boolean singleTM) throws XATransactionException {
        TransactionContext tc = null;
        switch (flags) {
            case 0: {
                try {
                    this.checkXAState(threadId, xid, false, false);
                    tc = this.transactions.getOrCreateTransactionContext(threadId);
                    if (tc.getTransactionType() != TransactionContext.Scope.NONE) {
                        throw new XATransactionException(-6, QueryPlugin.Util.getString("TransactionServer.existing_transaction"));
                    }
                    tc.setTransactionTimeout(timeout);
                    tc.setXid((Xid)xid);
                    tc.setTransactionType(TransactionContext.Scope.GLOBAL);
                    if (singleTM) {
                        tc.setTransaction(this.transactionManager.getTransaction());
                        assert (tc.getTransaction() != null);
                        break;
                    }
                    DQPCore.FutureWork<Transaction> work = new DQPCore.FutureWork<Transaction>(new Callable<Transaction>(){

                        @Override
                        public Transaction call() throws Exception {
                            return TransactionServerImpl.this.transactionManager.getTransaction();
                        }
                    }, 0);
                    this.workManager.doWork(work, Long.MAX_VALUE, (ExecutionContext)tc, null);
                    tc.setTransaction((Transaction)work.get());
                    break;
                }
                catch (javax.resource.NotSupportedException e) {
                    throw new XATransactionException((Throwable)e, -5);
                }
                catch (WorkException e) {
                    throw new XATransactionException((Throwable)e, -5);
                }
                catch (InterruptedException e) {
                    throw new XATransactionException((Throwable)e, -5);
                }
                catch (ExecutionException e) {
                    throw new XATransactionException((Throwable)e, -5);
                }
                catch (SystemException e) {
                    throw new XATransactionException((Throwable)e, -5);
                }
            }
            case 0x200000: 
            case 0x8000000: {
                tc = this.checkXAState(threadId, xid, true, false);
                TransactionContext threadContext = this.transactions.getOrCreateTransactionContext(threadId);
                if (threadContext.getTransactionType() != TransactionContext.Scope.NONE) {
                    throw new XATransactionException(-6, QueryPlugin.Util.getString("TransactionServer.existing_transaction"));
                }
                if (flags != 0x8000000 || tc.getSuspendedBy().remove(threadId)) break;
                throw new XATransactionException(-6, QueryPlugin.Util.getString("TransactionServer.resume_failed", new Object[]{xid, threadId}));
            }
            default: {
                throw new XATransactionException(-5, QueryPlugin.Util.getString("TransactionServer.unknown_flags"));
            }
        }
        tc.setThreadId(threadId);
        this.transactions.addTransactionContext(tc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void end(String threadId, XidImpl xid, int flags, boolean singleTM) throws XATransactionException {
        TransactionContext tc = this.checkXAState(threadId, xid, true, true);
        try {
            switch (flags) {
                case 0x2000000: {
                    tc.getSuspendedBy().add(threadId);
                    return;
                }
                case 0x4000000: {
                    return;
                }
                case 0x20000000: {
                    this.cancelTransactions(threadId, false);
                    return;
                }
                default: {
                    throw new XATransactionException(-5, QueryPlugin.Util.getString("TransactionServer.unknown_flags"));
                }
            }
        }
        finally {
            tc.setThreadId(null);
            this.transactions.removeTransactionContext(threadId);
        }
    }

    private TransactionContext checkXAState(String threadId, XidImpl xid, boolean transactionExpected, boolean threadBound) throws XATransactionException {
        TransactionContext tc = this.transactions.getTransactionContext(xid);
        if (transactionExpected && tc == null) {
            throw new XATransactionException(-4, QueryPlugin.Util.getString("TransactionServer.no_global_transaction", new Object[]{xid}));
        }
        if (!transactionExpected) {
            if (tc != null) {
                throw new XATransactionException(-8, QueryPlugin.Util.getString("TransactionServer.existing_global_transaction", new Object[]{xid}));
            }
            if (!threadBound && (tc = this.transactions.getOrCreateTransactionContext(threadId)).getTransactionType() != TransactionContext.Scope.NONE) {
                throw new XATransactionException(-6, QueryPlugin.Util.getString("TransactionServer.existing_transaction", new Object[]{xid, threadId}));
            }
            return null;
        }
        if (threadBound) {
            if (!threadId.equals(tc.getThreadId())) {
                throw new XATransactionException(-6, QueryPlugin.Util.getString("TransactionServer.wrong_transaction", new Object[]{xid}));
            }
        } else if (tc.getThreadId() != null) {
            throw new XATransactionException(-6, QueryPlugin.Util.getString("TransactionServer.concurrent_transaction", new Object[]{xid}));
        }
        return tc;
    }

    private TransactionContext checkLocalTransactionState(String threadId, boolean transactionExpected) throws XATransactionException {
        TransactionContext tc = this.transactions.getOrCreateTransactionContext(threadId);
        try {
            if (tc.getTransactionType() != TransactionContext.Scope.NONE) {
                if (tc.getTransactionType() != TransactionContext.Scope.LOCAL) {
                    throw new InvalidTransactionException(QueryPlugin.Util.getString("TransactionServer.existing_transaction"));
                }
                if (!transactionExpected) {
                    throw new InvalidTransactionException(QueryPlugin.Util.getString("TransactionServer.existing_transaction"));
                }
                this.transactionManager.resume(tc.getTransaction());
            } else if (transactionExpected) {
                throw new InvalidTransactionException(QueryPlugin.Util.getString("TransactionServer.no_transaction", new Object[]{threadId}));
            }
        }
        catch (InvalidTransactionException e) {
            throw new XATransactionException((Throwable)e);
        }
        catch (SystemException e) {
            throw new XATransactionException((Throwable)e);
        }
        return tc;
    }

    private void beginDirect(TransactionContext tc) throws XATransactionException {
        try {
            this.transactionManager.begin();
            Transaction tx = this.transactionManager.suspend();
            tc.setTransaction(tx);
            tc.setCreationTime(System.currentTimeMillis());
        }
        catch (NotSupportedException err) {
            throw new XATransactionException((Throwable)err);
        }
        catch (SystemException err) {
            throw new XATransactionException((Throwable)err);
        }
    }

    private void commitDirect(TransactionContext context) throws XATransactionException {
        try {
            this.transactionManager.commit();
        }
        catch (SecurityException e) {
            throw new XATransactionException((Throwable)e);
        }
        catch (RollbackException e) {
            throw new XATransactionException((Throwable)e);
        }
        catch (HeuristicMixedException e) {
            throw new XATransactionException((Throwable)e);
        }
        catch (HeuristicRollbackException e) {
            throw new XATransactionException((Throwable)e);
        }
        catch (SystemException e) {
            throw new XATransactionException((Throwable)e);
        }
        finally {
            this.transactions.removeTransactionContext(context);
        }
    }

    private void rollbackDirect(TransactionContext tc) throws XATransactionException {
        try {
            this.transactionManager.rollback();
        }
        catch (SecurityException e) {
            throw new XATransactionException((Throwable)e);
        }
        catch (SystemException e) {
            throw new XATransactionException((Throwable)e);
        }
        finally {
            this.transactions.removeTransactionContext(tc);
        }
    }

    @Override
    public void suspend(TransactionContext context) throws XATransactionException {
        try {
            this.transactionManager.suspend();
        }
        catch (SystemException e) {
            throw new XATransactionException((Throwable)e);
        }
    }

    @Override
    public void resume(TransactionContext context) throws XATransactionException {
        try {
            this.transactionManager.resume(context.getTransaction());
        }
        catch (InvalidTransactionException e) {
            throw new XATransactionException((Throwable)e);
        }
        catch (SystemException e) {
            throw new XATransactionException((Throwable)e);
        }
    }

    @Override
    public TransactionContext begin(String threadId) throws XATransactionException {
        TransactionContext tc = this.checkLocalTransactionState(threadId, false);
        this.beginDirect(tc);
        tc.setTransactionType(TransactionContext.Scope.LOCAL);
        return tc;
    }

    @Override
    public void commit(String threadId) throws XATransactionException {
        TransactionContext tc = this.checkLocalTransactionState(threadId, true);
        this.commitDirect(tc);
    }

    @Override
    public void rollback(String threadId) throws XATransactionException {
        TransactionContext tc = this.checkLocalTransactionState(threadId, true);
        this.rollbackDirect(tc);
    }

    @Override
    public TransactionContext getOrCreateTransactionContext(String threadId) {
        return this.transactions.getOrCreateTransactionContext(threadId);
    }

    @Override
    public void begin(TransactionContext context) throws XATransactionException {
        if (context.getTransactionType() != TransactionContext.Scope.NONE) {
            throw new XATransactionException(QueryPlugin.Util.getString("TransactionServer.existing_transaction"));
        }
        this.beginDirect(context);
        context.setTransactionType(TransactionContext.Scope.REQUEST);
    }

    @Override
    public void commit(TransactionContext context) throws XATransactionException {
        Assertion.assertTrue((context.getTransactionType() == TransactionContext.Scope.REQUEST ? 1 : 0) != 0);
        this.commitDirect(context);
    }

    @Override
    public void rollback(TransactionContext context) throws XATransactionException {
        Assertion.assertTrue((context.getTransactionType() == TransactionContext.Scope.REQUEST ? 1 : 0) != 0);
        this.rollbackDirect(context);
    }

    @Override
    public void cancelTransactions(String threadId, boolean requestOnly) throws XATransactionException {
        TransactionContext tc;
        TransactionContext transactionContext = tc = requestOnly ? this.transactions.getTransactionContext(threadId) : this.transactions.removeTransactionContext(threadId);
        if (tc == null || tc.getTransactionType() == TransactionContext.Scope.NONE || requestOnly && tc.getTransactionType() != TransactionContext.Scope.REQUEST) {
            return;
        }
        try {
            tc.getTransaction().setRollbackOnly();
        }
        catch (SystemException e) {
            throw new XATransactionException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<org.teiid.adminapi.Transaction> getTransactions() {
        Set<TransactionContext> txnSet = Collections.newSetFromMap(new IdentityHashMap());
        TransactionMapping transactionMapping = this.transactions;
        synchronized (transactionMapping) {
            txnSet.addAll(this.transactions.threadToTransactionContext.values());
            txnSet.addAll(this.transactions.xidToTransactionContext.values());
        }
        ArrayList<org.teiid.adminapi.Transaction> result = new ArrayList<org.teiid.adminapi.Transaction>(txnSet.size());
        for (TransactionContext transactionContext : txnSet) {
            if (transactionContext.getTransactionType() == TransactionContext.Scope.NONE) continue;
            TransactionMetadata txnImpl = new TransactionMetadata();
            txnImpl.setAssociatedSession(transactionContext.getThreadId());
            txnImpl.setCreatedTime(transactionContext.getCreationTime());
            txnImpl.setScope(transactionContext.getTransactionType().toString());
            txnImpl.setId(transactionContext.getTransactionId());
            result.add((org.teiid.adminapi.Transaction)txnImpl);
        }
        return result;
    }

    @Override
    public void terminateTransaction(String threadId) throws AdminException {
        if (threadId == null) {
            return;
        }
        try {
            this.cancelTransactions(threadId, false);
        }
        catch (XATransactionException e) {
            throw new AdminProcessingException((Throwable)e);
        }
    }

    private static class TransactionMapping {
        private Map<String, TransactionContext> threadToTransactionContext = new HashMap<String, TransactionContext>();
        private Map<Xid, TransactionContext> xidToTransactionContext = new HashMap<Xid, TransactionContext>();

        private TransactionMapping() {
        }

        public synchronized TransactionContext getOrCreateTransactionContext(String threadId) {
            TransactionContext tc = this.threadToTransactionContext.get(threadId);
            if (tc == null) {
                tc = new TransactionContext();
                tc.setThreadId(threadId);
                this.threadToTransactionContext.put(threadId, tc);
            }
            return tc;
        }

        public synchronized TransactionContext getTransactionContext(String threadId) {
            return this.threadToTransactionContext.get(threadId);
        }

        public synchronized TransactionContext getTransactionContext(XidImpl xid) {
            return this.xidToTransactionContext.get(xid);
        }

        public synchronized TransactionContext removeTransactionContext(String threadId) {
            return this.threadToTransactionContext.remove(threadId);
        }

        public synchronized void removeTransactionContext(TransactionContext tc) {
            if (tc.getXid() != null) {
                this.xidToTransactionContext.remove(tc.getXid());
            }
            if (tc.getThreadId() != null) {
                this.threadToTransactionContext.remove(tc.getThreadId());
            }
        }

        public synchronized void addTransactionContext(TransactionContext tc) {
            if (tc.getXid() != null) {
                this.xidToTransactionContext.put(tc.getXid(), tc);
            }
            if (tc.getThreadId() != null) {
                this.threadToTransactionContext.put(tc.getThreadId(), tc);
            }
        }
    }
}

