/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import java.math.BigDecimal;
import java.util.List;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class Constant
implements Expression,
Comparable<Constant> {
    public static final Constant NULL_CONSTANT = new Constant(null);
    private Object value;
    private Class<?> type;
    private boolean multiValued;
    private boolean bindEligible;

    public Constant(Object value, Class<?> type) {
        this.value = DataTypeManager.convertToRuntimeType((Object)value);
        if (type == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0014"));
        }
        if (!DataTypeManager.getAllDataTypeClasses().contains(type)) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0015", new Object[]{type.getName()}));
        }
        assert (value == null || type.isAssignableFrom(value.getClass())) : "Invalid value for specified type.";
        this.type = type;
    }

    public Constant(Object value) {
        this.value = DataTypeManager.convertToRuntimeType((Object)value);
        this.type = this.value == null ? DataTypeManager.DefaultDataClasses.NULL : (DataTypeManager.getAllDataTypeClasses().contains(this.value.getClass()) ? this.value.getClass() : DataTypeManager.DefaultDataClasses.OBJECT);
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    public void setMultiValued(List<?> value) {
        this.multiValued = true;
        this.value = value;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Constant)) {
            return false;
        }
        Constant other = (Constant)obj;
        if (other.isNull()) {
            return this.isNull();
        }
        if (this.isNull()) {
            return false;
        }
        if (!other.getType().equals(this.getType())) {
            return false;
        }
        if (this.value instanceof BigDecimal) {
            if (this.value == other.value) {
                return true;
            }
            if (!(other.value instanceof BigDecimal)) {
                return false;
            }
            return ((BigDecimal)this.value).compareTo((BigDecimal)other.value) == 0;
        }
        return this.multiValued == other.multiValued && other.getValue().equals(this.getValue());
    }

    public int hashCode() {
        if (this.value != null) {
            if (this.value instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)this.value;
                int xsign = bd.signum();
                if (xsign == 0) {
                    return 0;
                }
                bd = bd.stripTrailingZeros();
                return bd.hashCode();
            }
            return this.value.hashCode();
        }
        return 0;
    }

    @Override
    public Object clone() {
        Constant copy = new Constant(this.getValue(), this.getType());
        copy.multiValued = this.multiValued;
        copy.bindEligible = this.bindEligible;
        return copy;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    @Override
    public int compareTo(Constant o) {
        if (this.isNull()) {
            if (o.isNull()) {
                return 0;
            }
            return -1;
        }
        if (o.isNull()) {
            return 1;
        }
        return ((Comparable)this.value).compareTo(o.getValue());
    }

    public boolean isBindEligible() {
        return this.bindEligible;
    }

    public void setBindEligible(boolean bindEligible) {
        this.bindEligible = bindEligible;
    }
}

