/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.tempdata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.teiid.api.exception.query.QueryProcessingException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.resolver.command.TempTableResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.tempdata.TempTable;
import org.teiid.query.util.CommandContext;

public class TempTableStore {
    private Map<String, TempTableSynchronization> synchronizations = new ConcurrentHashMap<String, TempTableSynchronization>();
    private TransactionMode transactionMode = TransactionMode.NONE;
    private TempMetadataStore tempMetadataStore = new TempMetadataStore(new ConcurrentHashMap<String, TempMetadataID>());
    private Map<String, TempTable> tempTables = new ConcurrentHashMap<String, TempTable>();
    private String sessionID;
    private TempTableStore parentTempTableStore;

    public TempTableStore(String sessionID, TransactionMode transactionMode) {
        this.sessionID = sessionID;
        this.transactionMode = transactionMode;
    }

    public void setParentTempTableStore(TempTableStore parentTempTableStore) {
        this.parentTempTableStore = parentTempTableStore;
    }

    public boolean hasTempTable(String tempTableName) {
        return this.tempTables.containsKey(tempTableName);
    }

    TempTable addTempTable(String tempTableName, Create create, BufferManager buffer, boolean add, CommandContext context) throws TeiidProcessingException {
        List<ElementSymbol> columns = create.getColumnSymbols();
        TempMetadataID id = this.tempMetadataStore.getTempGroupID(tempTableName);
        this.getSynchronization(context);
        if (id == null) {
            id = this.tempMetadataStore.addTempGroup(tempTableName, columns, false, true);
            TempTableResolver.addAdditionalMetadata(create, id);
        }
        columns = new ArrayList<ElementSymbol>(create.getColumnSymbols());
        if (!create.getPrimaryKey().isEmpty()) {
            List<ElementSymbol> primaryKey = create.getPrimaryKey();
            columns.removeAll(primaryKey);
            columns.addAll(0, primaryKey);
        }
        TempTable tempTable = new TempTable(id, buffer, columns, create.getPrimaryKey().size(), this.sessionID);
        if (add) {
            this.tempTables.put(tempTableName, tempTable);
        }
        return tempTable;
    }

    public void removeTempTableByName(String tempTableName, CommandContext context) throws TeiidProcessingException {
        TempTableSynchronization synch = this.getSynchronization(context);
        this.tempMetadataStore.removeTempGroup(tempTableName);
        TempTable table = this.tempTables.remove(tempTableName);
        if (table == null) {
            return;
        }
        if (this.transactionMode != TransactionMode.ISOLATE_WRITES || synch == null || !synch.existingTables.contains(table.getId())) {
            table.remove();
        }
    }

    private TempTableSynchronization getSynchronization(CommandContext context) throws TeiidProcessingException {
        TempTableSynchronization synch = null;
        if (context == null || this.transactionMode == TransactionMode.NONE) {
            return null;
        }
        TransactionContext tc = context.getTransactionContext();
        if (tc == null || tc.getTransactionType() == TransactionContext.Scope.NONE) {
            return null;
        }
        String transactionId = tc.getTransactionId();
        synch = this.synchronizations.get(transactionId);
        if (synch == null) {
            boolean success = false;
            try {
                synch = new TempTableSynchronization(transactionId);
                this.synchronizations.put(transactionId, synch);
                tc.getTransaction().registerSynchronization((Synchronization)synch);
                success = true;
            }
            catch (RollbackException e) {
                throw new TeiidProcessingException((Throwable)e);
            }
            catch (SystemException e) {
                throw new TeiidProcessingException((Throwable)e);
            }
            finally {
                if (!success) {
                    this.synchronizations.remove(transactionId);
                }
            }
        }
        return synch;
    }

    public TempMetadataStore getMetadataStore() {
        return this.tempMetadataStore;
    }

    public void removeTempTables() throws TeiidComponentException {
        for (String name : this.tempTables.keySet()) {
            try {
                this.removeTempTableByName(name, null);
            }
            catch (TeiidProcessingException e) {
                throw new TeiidComponentException((Throwable)e);
            }
        }
    }

    public void setUpdatable(String name, boolean updatable) {
        TempTable table = this.tempTables.get(name);
        if (table != null) {
            table.setUpdatable(updatable);
        }
    }

    TempTable getTempTable(String tempTableID) {
        return this.tempTables.get(tempTableID);
    }

    TempTable getOrCreateTempTable(String tempTableID, Command command, BufferManager buffer, boolean delegate, boolean forUpdate, CommandContext context) throws TeiidProcessingException {
        Insert insert;
        GroupSymbol group;
        TempTable tempTable = this.getTempTable(tempTableID, command, buffer, delegate, forUpdate, context);
        if (tempTable != null) {
            return tempTable;
        }
        List<ElementSymbol> columns = null;
        if (command instanceof Insert && (group = (insert = (Insert)command).getGroup()).isImplicitTempGroupSymbol()) {
            columns = insert.getVariables();
        }
        if (columns == null) {
            throw new QueryProcessingException(QueryPlugin.Util.getString("TempTableStore.table_doesnt_exist_error", new Object[]{tempTableID}));
        }
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Creating temporary table", tempTableID});
        Create create = new Create();
        create.setTable(new GroupSymbol(tempTableID));
        create.setElementSymbolsAsColumns(columns);
        return this.addTempTable(tempTableID, create, buffer, true, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TempTable getTempTable(String tempTableID, Command command, BufferManager buffer, boolean delegate, boolean forUpdate, CommandContext context) throws TeiidProcessingException {
        TempTable tempTable = this.tempTables.get(tempTableID);
        if (tempTable != null) {
            TempTableSynchronization synch;
            TransactionContext tc;
            if (forUpdate) {
                if (this.transactionMode == TransactionMode.ISOLATE_WRITES) {
                    TransactionContext tc2 = context.getTransactionContext();
                    if (tc2 != null) {
                        TempTableSynchronization synch2 = this.getSynchronization(context);
                        if (synch2 != null && synch2.existingTables.contains(tempTable.getId())) {
                            TempTable result = synch2.tables.get(tempTableID);
                            if (result == null) {
                                TempTableSynchronization tempTableSynchronization = synch2;
                                synchronized (tempTableSynchronization) {
                                    if (synch2.isCompleted()) {
                                        throw new AssertionError((Object)"Expected active transaction");
                                    }
                                    if (!tempTable.getActive().compareAndSet(0, 1)) {
                                        throw new TeiidProcessingException(QueryPlugin.Util.getString("TempTableStore.pending_update", new Object[]{tempTableID}));
                                    }
                                    synch2.tables.put(tempTableID, tempTable.clone());
                                }
                            }
                            return tempTable;
                        }
                    } else if (tempTable.getActive().get() != 0) {
                        throw new TeiidProcessingException(QueryPlugin.Util.getString("TempTableStore.pending_update", new Object[]{tempTableID}));
                    }
                }
            } else if (this.transactionMode == TransactionMode.ISOLATE_READS && (tc = context.getTransactionContext()) != null && tc.getIsolationLevel() > 2 && (synch = this.getSynchronization(context)) != null) {
                TempTable result = synch.tables.get(tempTableID);
                if (result == null) {
                    result = tempTable;
                    TempTableSynchronization tempTableSynchronization = synch;
                    synchronized (tempTableSynchronization) {
                        if (!synch.isCompleted()) {
                            synch.tables.put(tempTableID, tempTable);
                            result.getActive().getAndIncrement();
                        }
                    }
                }
                return result;
            }
            return tempTable;
        }
        if (delegate && this.parentTempTableStore != null) {
            return this.parentTempTableStore.getTempTable(tempTableID, command, buffer, delegate, forUpdate, context);
        }
        return null;
    }

    public Set<String> getAllTempTables() {
        return new HashSet<String>(this.tempTables.keySet());
    }

    Map<String, TempTable> getTempTables() {
        return this.tempTables;
    }

    public class TempTableSynchronization
    implements Synchronization {
        private String id;
        Set<Long> existingTables = new HashSet<Long>();
        ConcurrentHashMap<String, TempTable> tables = new ConcurrentHashMap();
        private List<TransactionCallback> callbacks = new LinkedList<TransactionCallback>();
        private boolean completed;

        public TempTableSynchronization(final String id) {
            this.id = id;
            for (TempTable tempTable : TempTableStore.this.tempTables.values()) {
                this.existingTables.add(tempTable.getId());
            }
            if (TempTableStore.this.transactionMode == TransactionMode.ISOLATE_WRITES) {
                this.addCallback(new TransactionCallback(){
                    private Map<String, TempMetadataID> clonedMetadata;
                    private Map<String, TempTable> clonedTables;
                    {
                        this.clonedMetadata = new ConcurrentHashMap<String, TempMetadataID>(TempTableStore.this.tempMetadataStore.getData());
                        this.clonedTables = new ConcurrentHashMap<String, TempTable>(TempTableStore.this.tempTables);
                    }

                    @Override
                    public void rollback() {
                        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Rolling back txn", id, "restoring", this.clonedTables.keySet(), "using rollback tables", TempTableSynchronization.this.tables});
                        TempTableStore.this.tempTables.values().removeAll(this.clonedTables.values());
                        for (TempTable table : TempTableStore.this.tempTables.values()) {
                            table.remove();
                        }
                        TempTableStore.this.tempMetadataStore.getData().clear();
                        TempTableStore.this.tempMetadataStore.getData().putAll(this.clonedMetadata);
                        TempTableStore.this.tempTables.clear();
                        TempTableStore.this.tempTables.putAll(this.clonedTables);
                        TempTableStore.this.tempTables.putAll(TempTableSynchronization.this.tables);
                    }

                    @Override
                    public void commit() {
                        this.clonedTables.values().removeAll(TempTableStore.this.tempTables.values());
                        for (TempTable table : this.clonedTables.values()) {
                            table.remove();
                        }
                    }
                });
            }
        }

        public synchronized void afterCompletion(int status) {
            this.completed = true;
            TempTableStore.this.synchronizations.remove(this.id);
            if (TempTableStore.this.transactionMode == TransactionMode.ISOLATE_READS) {
                for (TempTable table : this.tables.values()) {
                    table.getActive().decrementAndGet();
                }
            } else {
                HashSet current = new HashSet(TempTableStore.this.tempTables.values());
                current.retainAll(this.tables.values());
                for (TempTable table : current) {
                    table.getActive().set(0);
                    table.getTree().clearClonedFlags();
                }
            }
            for (TransactionCallback callback : this.callbacks) {
                if (status == 3) {
                    callback.commit();
                    continue;
                }
                callback.rollback();
            }
            this.callbacks.clear();
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public void beforeCompletion() {
        }

        public synchronized boolean addCallback(TransactionCallback callback) {
            if (!this.completed) {
                this.callbacks.add(0, callback);
            }
            return !this.completed;
        }
    }

    public static enum TransactionMode {
        ISOLATE_READS,
        ISOLATE_WRITES,
        NONE;

    }

    public static interface TransactionCallback {
        public void commit();

        public void rollback();
    }
}

