/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.dqp.internal.process.Request;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.logging.LogManager;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.BatchedUpdatePlanner;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.util.VariableContext;
import org.teiid.query.util.CommandContext;

public class PreparedStatementRequest
extends Request {
    private SessionAwareCache<PreparedPlan> prepPlanCache;
    private PreparedPlan prepPlan;

    public PreparedStatementRequest(SessionAwareCache<PreparedPlan> prepPlanCache) {
        this.prepPlanCache = prepPlanCache;
    }

    @Override
    protected void checkReferences(List<Reference> references) throws QueryValidatorException {
        this.prepPlan.setReferences(references);
    }

    @Override
    protected void resolveCommand(Command command) throws QueryResolverException, TeiidComponentException {
        this.handleCallableStatement(command);
        super.resolveCommand(command);
    }

    private void handleCallableStatement(Command command) {
        if (!this.requestMsg.isCallableStatement() || !(command instanceof StoredProcedure)) {
            return;
        }
        StoredProcedure proc = (StoredProcedure)command;
        if (!proc.isCallableStatement()) {
            return;
        }
        List values = this.requestMsg.getParameterValues();
        List<SPParameter> spParams = proc.getParameters();
        proc.clearParameters();
        int inParameterCount = values.size();
        if (this.requestMsg.isBatchedUpdate() && values.size() > 0) {
            inParameterCount = ((List)values.get(0)).size();
        }
        int index = 1;
        for (SPParameter param : spParams) {
            if (param.getParameterType() == 4) {
                ++inParameterCount;
            } else if (param.getExpression() instanceof Reference && index > inParameterCount) {
                this.prepPlan.getReferences().remove(param.getExpression());
                continue;
            }
            param.setIndex(index++);
            proc.setParameter(param);
        }
    }

    @Override
    protected void generatePlan() throws TeiidComponentException, TeiidProcessingException {
        String sqlQuery = this.requestMsg.getCommands()[0];
        SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(this.workContext, Request.createParseInfo(this.requestMsg), sqlQuery);
        this.prepPlan = this.prepPlanCache.get(id);
        if (this.prepPlan == null) {
            this.prepPlan = new PreparedPlan();
            LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Query does not exist in cache: ", sqlQuery});
            super.generatePlan();
            if (!this.addedLimit) {
                this.prepPlan.setCommand(this.userCommand);
                this.prepPlan.setPlan(this.processPlan.clone(), this.context);
                this.prepPlan.setAnalysisRecord(this.analysisRecord);
                FunctionMethod.Determinism determinismLevel = this.context.getDeterminismLevel();
                if (this.userCommand.getCacheHint() != null && this.userCommand.getCacheHint().getDeterminism() != null) {
                    LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Cache hint modified the query determinism from ", this.context.getDeterminismLevel(), " to ", determinismLevel});
                    determinismLevel = this.userCommand.getCacheHint().getDeterminism();
                }
                this.prepPlanCache.put(id, determinismLevel, this.prepPlan, this.userCommand.getCacheHint() != null ? this.userCommand.getCacheHint().getTtl() : null);
            }
        } else {
            ProcessorPlan cachedPlan = this.prepPlan.getPlan();
            this.userCommand = this.prepPlan.getCommand();
            this.validateAccess(this.userCommand);
            LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Query exist in cache: ", sqlQuery});
            this.processPlan = cachedPlan.clone();
            this.analysisRecord = this.prepPlan.getAnalysisRecord();
        }
        if (this.requestMsg.isBatchedUpdate()) {
            this.handlePreparedBatchUpdate();
        } else {
            List<Reference> params = this.prepPlan.getReferences();
            List values = this.requestMsg.getParameterValues();
            PreparedStatementRequest.resolveParameterValues(params, values, this.context, this.metadata);
        }
    }

    private void handlePreparedBatchUpdate() throws QueryMetadataException, TeiidComponentException, QueryResolverException, QueryPlannerException, QueryValidatorException {
        RelationalPlan rPlan;
        List paramValues = this.requestMsg.getParameterValues();
        if (paramValues.isEmpty()) {
            throw new QueryValidatorException("No batch values sent for prepared batch update");
        }
        boolean supportPreparedBatchUpdate = false;
        Command command = null;
        if (this.processPlan instanceof RelationalPlan && (rPlan = (RelationalPlan)this.processPlan).getRootNode() instanceof AccessNode) {
            AccessNode aNode = (AccessNode)rPlan.getRootNode();
            String modelName = aNode.getModelName();
            command = aNode.getCommand();
            SourceCapabilities caps = this.capabilitiesFinder.findCapabilities(modelName);
            supportPreparedBatchUpdate = caps.supportsCapability(SourceCapabilities.Capability.BULK_UPDATE);
        }
        LinkedList<Command> commands = new LinkedList<Command>();
        LinkedList<VariableContext> contexts = new LinkedList<VariableContext>();
        ArrayList multiValues = new ArrayList(this.prepPlan.getReferences().size());
        for (List values : paramValues) {
            PreparedStatementRequest.resolveParameterValues(this.prepPlan.getReferences(), values, this.context, this.metadata);
            contexts.add(this.context.getVariableContext());
            if (supportPreparedBatchUpdate) {
                int i;
                if (multiValues.isEmpty()) {
                    for (i = 0; i < values.size(); ++i) {
                        multiValues.add(new ArrayList(paramValues.size()));
                    }
                }
                for (i = 0; i < values.size(); ++i) {
                    List multiValue = (List)multiValues.get(i);
                    multiValue.add(values.get(i));
                }
                continue;
            }
            if (command == null) {
                command = this.prepPlan.getCommand();
            }
            command.setProcessorPlan(this.processPlan);
            commands.add(command);
        }
        if (paramValues.size() > 1) {
            this.context.setVariableContext(new VariableContext());
        }
        if (paramValues.size() == 1) {
            return;
        }
        if (supportPreparedBatchUpdate) {
            for (int i = 0; i < this.prepPlan.getReferences().size(); ++i) {
                Constant c = new Constant(null, this.prepPlan.getReferences().get(i).getType());
                c.setMultiValued((List)multiValues.get(i));
                this.context.getVariableContext().setGlobalValue(this.prepPlan.getReferences().get(i).getContextSymbol(), c);
            }
            return;
        }
        BatchedUpdateCommand buc = new BatchedUpdateCommand(commands);
        buc.setVariableContexts(contexts);
        BatchedUpdatePlanner planner = new BatchedUpdatePlanner();
        this.processPlan = planner.optimize(buc, this.idGenerator, this.metadata, this.capabilitiesFinder, this.analysisRecord, this.context);
    }

    public static void resolveParameterValues(List<Reference> params, List values, CommandContext context, QueryMetadataInterface metadata) throws QueryResolverException, TeiidComponentException, QueryValidatorException {
        VariableContext result = new VariableContext();
        if (params.size() != values.size()) {
            String msg = QueryPlugin.Util.getString("QueryUtil.wrong_number_of_values", new Object[]{new Integer(values.size()), new Integer(params.size())});
            throw new QueryResolverException(msg);
        }
        for (int i = 0; i < params.size(); ++i) {
            Reference param = params.get(i);
            Object value = values.get(i);
            if (value != null && !(value instanceof List)) {
                String msg;
                try {
                    String targetTypeName = DataTypeManager.getDataTypeName(param.getType());
                    Expression expr = ResolverUtil.convertExpression(new Constant(value), targetTypeName, metadata);
                    value = Evaluator.evaluate(expr);
                }
                catch (ExpressionEvaluationException e) {
                    msg = QueryPlugin.Util.getString("QueryUtil.Error_executing_conversion_function_to_convert_value", new Object[]{new Integer(i + 1), value, DataTypeManager.getDataTypeName(param.getType())});
                    throw new QueryResolverException(msg);
                }
                catch (QueryResolverException e) {
                    msg = QueryPlugin.Util.getString("QueryUtil.Error_executing_conversion_function_to_convert_value", new Object[]{new Integer(i + 1), value, DataTypeManager.getDataTypeName(param.getType())});
                    throw new QueryResolverException(msg);
                }
            }
            if (param.getConstraint() != null) {
                param.getConstraint().validate(value);
            }
            result.setGlobalValue(param.getContextSymbol(), value);
        }
        context.setVariableContext(result);
    }
}

