/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.id.IDGenerator;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.rules.RuleChooseJoinStrategy;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.proc.ForEachRowPlan;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.TranslatableProcedureContainer;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.SelectSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.util.CommandContext;

public final class TriggerActionPlanner {
    public ProcessorPlan optimize(ProcedureContainer userCommand, TriggerAction ta, IDGenerator idGenerator, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryMetadataException, TeiidComponentException, QueryResolverException, TeiidProcessingException {
        QueryRewriter.rewrite(ta, null, metadata, context, QueryResolver.getVariableValues(userCommand, true, metadata), userCommand.getType());
        QueryCommand query = null;
        HashMap<ElementSymbol, Expression> params = new HashMap<ElementSymbol, Expression>();
        if (userCommand instanceof Insert) {
            Insert insert = (Insert)userCommand;
            if (insert.getQueryExpression() != null) {
                query = insert.getQueryExpression();
            } else {
                query = new Query();
                ((Query)query).setSelect(new Select(RuleChooseJoinStrategy.createExpressionSymbols(insert.getValues())));
            }
        } else if (userCommand instanceof Delete) {
            query = this.createOldQuery(userCommand, ta, metadata, params);
        } else if (userCommand instanceof Update) {
            query = this.createOldQuery(userCommand, ta, metadata, params);
        } else {
            throw new AssertionError();
        }
        for (Map.Entry<ElementSymbol, Expression> entry : QueryResolver.getVariableValues(userCommand, false, metadata).entrySet()) {
            if (entry.getKey().getGroupSymbol().getShortName().equalsIgnoreCase("INPUTS")) {
                Expression value = entry.getValue() instanceof SingleElementSymbol ? entry.getValue() : new ExpressionSymbol("x", entry.getValue());
                ElementSymbol newElementSymbol = entry.getKey().clone();
                newElementSymbol.getGroupSymbol().setName("NEW");
                params.put(newElementSymbol, value);
                if (!(userCommand instanceof Update)) continue;
                ((Query)query).getSelect().addSymbol((SelectSymbol)((Object)value));
                continue;
            }
            params.put(entry.getKey(), entry.getValue());
        }
        ForEachRowPlan result = new ForEachRowPlan();
        result.setParams(params);
        ProcessorPlan queryPlan = QueryOptimizer.optimizePlan(query, metadata, idGenerator, capFinder, analysisRecord, context);
        result.setQueryPlan(queryPlan);
        result.setLookupMap(RelationalNode.createLookupMap(query.getProjectedSymbols()));
        ProcedurePlan rowProcedure = (ProcedurePlan)QueryOptimizer.optimizePlan(new CreateUpdateProcedureCommand(ta.getBlock()), metadata, idGenerator, capFinder, analysisRecord, context);
        result.setRowProcedure(rowProcedure);
        return result;
    }

    private QueryCommand createOldQuery(ProcedureContainer userCommand, TriggerAction ta, QueryMetadataInterface metadata, Map<ElementSymbol, Expression> params) throws QueryMetadataException, TeiidComponentException {
        ArrayList<ElementSymbol> selectSymbols = new ArrayList<ElementSymbol>();
        List<ElementSymbol> allSymbols = ResolverUtil.resolveElementsInGroup(ta.getView(), metadata);
        for (ElementSymbol elementSymbol : allSymbols) {
            params.put(new ElementSymbol("OLD." + elementSymbol.getShortName()), elementSymbol);
            if (!(userCommand instanceof Update)) continue;
            params.put(new ElementSymbol("NEW." + elementSymbol.getShortName()), elementSymbol);
        }
        selectSymbols.addAll(LanguageObject.Util.deepClone(allSymbols, ElementSymbol.class));
        Query query = new Query(new Select(selectSymbols), new From(Arrays.asList(new UnaryFromClause(ta.getView()))), ((TranslatableProcedureContainer)userCommand).getCriteria(), null, null);
        return query;
    }
}

