/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.teiid.core.TeiidException;
import org.teiid.core.util.Assertion;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;

public class JoinUtil {
    private JoinUtil() {
    }

    static final JoinType optimizeJoinType(PlanNode critNode, PlanNode joinNode, QueryMetadataInterface metadata) {
        if (critNode.getGroups().isEmpty() || !joinNode.getGroups().containsAll(critNode.getGroups())) {
            return null;
        }
        JoinType joinType = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        if (!joinType.isOuter()) {
            return null;
        }
        PlanNode left = joinNode.getFirstChild();
        left = FrameUtil.findJoinSourceNode(left);
        PlanNode right = joinNode.getLastChild();
        right = FrameUtil.findJoinSourceNode(right);
        Set<GroupSymbol> outerGroups = left.getGroups();
        Set<GroupSymbol> innerGroups = right.getGroups();
        if (joinType == JoinType.JOIN_RIGHT_OUTER) {
            outerGroups = innerGroups;
            innerGroups = left.getGroups();
        }
        if ((joinType == JoinType.JOIN_LEFT_OUTER || joinType == JoinType.JOIN_RIGHT_OUTER) && outerGroups.containsAll(critNode.getGroups())) {
            return null;
        }
        Criteria crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        boolean isNullDepdendent = JoinUtil.isNullDependent(metadata, innerGroups, crit);
        JoinType result = JoinType.JOIN_INNER;
        if (joinType == JoinType.JOIN_LEFT_OUTER || joinType == JoinType.JOIN_RIGHT_OUTER) {
            if (isNullDepdendent) {
                return null;
            }
        } else {
            boolean isNullDepdendentOther = JoinUtil.isNullDependent(metadata, outerGroups, crit);
            if (isNullDepdendent && isNullDepdendentOther) {
                return null;
            }
            if (isNullDepdendent && !isNullDepdendentOther) {
                result = JoinType.JOIN_LEFT_OUTER;
            } else if (!isNullDepdendent && isNullDepdendentOther) {
                JoinUtil.swapJoinChildren(joinNode);
                result = JoinType.JOIN_LEFT_OUTER;
            }
        }
        joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, result);
        return result;
    }

    public static boolean isNullDependent(QueryMetadataInterface metadata, Collection<GroupSymbol> innerGroups, Criteria crit) {
        Criteria simplifiedCrit = (Criteria)JoinUtil.replaceWithNullValues(innerGroups, crit);
        try {
            simplifiedCrit = QueryRewriter.rewriteCriteria(simplifiedCrit, null, null, metadata);
        }
        catch (TeiidException err) {
            return true;
        }
        return !simplifiedCrit.equals(QueryRewriter.FALSE_CRITERIA) && !simplifiedCrit.equals(QueryRewriter.UNKNOWN_CRITERIA);
    }

    public static boolean isNullDependent(QueryMetadataInterface metadata, Collection<GroupSymbol> innerGroups, Expression expr) {
        Expression simplifiedExpression = (Expression)JoinUtil.replaceWithNullValues(innerGroups, expr);
        try {
            simplifiedExpression = QueryRewriter.rewriteExpression(simplifiedExpression, null, null, metadata);
        }
        catch (TeiidException err) {
            return true;
        }
        return !QueryRewriter.isNull(simplifiedExpression);
    }

    private static LanguageObject replaceWithNullValues(final Collection<GroupSymbol> innerGroups, LanguageObject obj) {
        ExpressionMappingVisitor emv = new ExpressionMappingVisitor(null){

            @Override
            public Expression replaceExpression(Expression element) {
                if (!(element instanceof ElementSymbol)) {
                    return element;
                }
                ElementSymbol symbol = (ElementSymbol)element;
                if (innerGroups.contains(symbol.getGroupSymbol())) {
                    return new Constant(null, symbol.getType());
                }
                return element;
            }
        };
        if (obj instanceof ElementSymbol) {
            return emv.replaceExpression((ElementSymbol)obj);
        }
        obj = (LanguageObject)obj.clone();
        PreOrderNavigator.doVisit(obj, emv);
        return obj;
    }

    static JoinType getJoinTypePreventingCriteriaOptimization(PlanNode joinNode, PlanNode critNode) {
        Set<GroupSymbol> groups = critNode.getGroups();
        if (groups.size() == 0) {
            if ((critNode = FrameUtil.findOriginatingNode(critNode, groups)) == null) {
                return null;
            }
            groups = critNode.getGroups();
        }
        return JoinUtil.getJoinTypePreventingCriteriaOptimization(joinNode, groups);
    }

    public static JoinType getJoinTypePreventingCriteriaOptimization(PlanNode joinNode, Set<GroupSymbol> groups) {
        JoinType joinType = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        if (!joinType.isOuter()) {
            return null;
        }
        if (joinType.equals(JoinType.JOIN_FULL_OUTER)) {
            return joinType;
        }
        Set<GroupSymbol> innerGroups = JoinUtil.getInnerSideJoinNodes(joinNode)[0].getGroups();
        for (GroupSymbol group : groups) {
            if (!innerGroups.contains(group)) continue;
            return joinType;
        }
        return null;
    }

    static PlanNode[] getInnerSideJoinNodes(PlanNode joinNode) {
        Assertion.assertTrue((joinNode.getType() == 4 ? 1 : 0) != 0);
        JoinType jt = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        if (jt == JoinType.JOIN_INNER || jt == JoinType.JOIN_CROSS) {
            return new PlanNode[]{joinNode.getFirstChild(), joinNode.getLastChild()};
        }
        if (jt == JoinType.JOIN_RIGHT_OUTER) {
            return new PlanNode[]{joinNode.getFirstChild()};
        }
        if (jt == JoinType.JOIN_LEFT_OUTER) {
            return new PlanNode[]{joinNode.getLastChild()};
        }
        return new PlanNode[0];
    }

    static void swapJoinChildren(PlanNode joinNode) {
        PlanNode leftChild = joinNode.getFirstChild();
        joinNode.removeChild(leftChild);
        joinNode.addLastChild(leftChild);
        List leftExpressions = (List)joinNode.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS);
        List rightExpressions = (List)joinNode.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS);
        joinNode.setProperty(NodeConstants.Info.LEFT_EXPRESSIONS, rightExpressions);
        joinNode.setProperty(NodeConstants.Info.RIGHT_EXPRESSIONS, leftExpressions);
        JoinType jt = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, jt.getReverseType());
    }
}

