/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.Comparator;
import java.util.List;
import org.teiid.language.SortSpecification;
import org.teiid.query.sql.symbol.Constant;

public class ListNestedSortComparator<T extends Comparable<? super T>>
implements Comparator<List<T>> {
    private int[] sortParameters;
    private boolean ascendingOrder = false;
    private List<Boolean> orderTypes = null;
    private boolean isDistinct = true;
    private int distinctIndex;
    private List<SortSpecification.NullOrdering> nullOrdering;

    public ListNestedSortComparator(int[] sortParameters) {
        this(sortParameters, true);
    }

    public ListNestedSortComparator(int[] sortParameters, boolean ascending) {
        this.sortParameters = sortParameters;
        this.ascendingOrder = ascending;
    }

    public ListNestedSortComparator(int[] sortParameters, List<Boolean> orderTypes) {
        this.sortParameters = sortParameters;
        this.orderTypes = orderTypes;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public void setDistinctIndex(int distinctIndex) {
        this.distinctIndex = distinctIndex;
    }

    public void setNullOrdering(List<SortSpecification.NullOrdering> nullOrdering) {
        this.nullOrdering = nullOrdering;
    }

    @Override
    public int compare(List<T> list1, List<T> list2) {
        int compare = 0;
        for (int k = 0; k < this.sortParameters.length; ++k) {
            SortSpecification.NullOrdering no;
            if (list1.size() <= this.sortParameters[k]) {
                return 1;
            }
            Comparable param1 = (Comparable)list1.get(this.sortParameters[k]);
            if (list2.size() <= this.sortParameters[k]) {
                return -1;
            }
            Comparable param2 = (Comparable)list2.get(this.sortParameters[k]);
            if (param1 == null) {
                if (param2 == null) {
                    compare = 0;
                } else {
                    compare = -1;
                    no = this.getNullOrdering(k);
                    if (no != null) {
                        if (this.nullOrdering.get(k) == SortSpecification.NullOrdering.FIRST) {
                            return -1;
                        }
                        return 1;
                    }
                }
            } else if (param2 == null) {
                compare = 1;
                no = this.getNullOrdering(k);
                if (no != null) {
                    if (this.nullOrdering.get(k) == SortSpecification.NullOrdering.FIRST) {
                        return 1;
                    }
                    return -1;
                }
            } else {
                compare = Constant.compare(param1, param2);
            }
            if (compare != 0) {
                boolean asc = this.orderTypes != null ? this.orderTypes.get(k) : this.ascendingOrder;
                return asc ? compare : -compare;
            }
            if (k != this.distinctIndex) continue;
            this.isDistinct = false;
        }
        return 0;
    }

    private SortSpecification.NullOrdering getNullOrdering(int index) {
        if (this.nullOrdering != null) {
            return this.nullOrdering.get(index);
        }
        return null;
    }

    public int[] getSortParameters() {
        return this.sortParameters;
    }

    public void setSortParameters(int[] sortParameters) {
        this.sortParameters = sortParameters;
    }
}

