/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.Assertion;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.processor.xml.DocumentInProgress;
import org.teiid.query.processor.xml.ProcessorInstruction;
import org.teiid.query.processor.xml.XMLContext;
import org.teiid.query.processor.xml.XMLProcessorEnvironment;
import org.xml.sax.SAXException;

public class MoveDocInstruction
extends ProcessorInstruction {
    public static final int UP = 0;
    public static final int DOWN = 1;
    private int direction;

    public MoveDocInstruction(int direction) {
        this.direction = direction;
    }

    @Override
    public XMLContext process(XMLProcessorEnvironment env, XMLContext context) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        DocumentInProgress doc = env.getDocumentInProgress();
        switch (this.direction) {
            case 0: {
                LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"UP in document"});
                try {
                    doc.moveToParent();
                    break;
                }
                catch (SAXException err) {
                    throw new TeiidComponentException((Throwable)err, "Failed to move UP in document");
                }
            }
            case 1: {
                LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"LAST child in document"});
                doc.moveToLastChild();
                break;
            }
            default: {
                Assertion.failed((String)QueryPlugin.Util.getString("ERR.015.006.0051", new Object[]{this.direction}));
            }
        }
        env.incrementCurrentProgramCounter();
        return context;
    }

    public String toString() {
        if (this.direction == 0) {
            return "UP";
        }
        return "LAST";
    }

    @Override
    public PlanNode getDescriptionProperties() {
        if (this.direction == 0) {
            return new PlanNode("UP IN DOCUMENT");
        }
        return new PlanNode("NEXT IN DOCUMENT");
    }
}

