/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.rewriter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.language.Like;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.function.FunctionMethods;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.optimizer.relational.rules.RuleMergeCriteria;
import org.teiid.query.optimizer.relational.rules.RulePlaceAccess;
import org.teiid.query.processor.relational.RelationalNodeUtil;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.AbstractSetCriteria;
import org.teiid.query.sql.lang.ArrayTable;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.PredicateCriteria;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.TextTable;
import org.teiid.query.sql.lang.TranslatableProcedureContainer;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.lang.XMLTable;
import org.teiid.query.sql.navigator.DeepPostOrderNavigator;
import org.teiid.query.sql.navigator.PostOrderNavigator;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.proc.CriteriaSelector;
import org.teiid.query.sql.proc.ExpressionStatement;
import org.teiid.query.sql.proc.HasCriteria;
import org.teiid.query.sql.proc.IfStatement;
import org.teiid.query.sql.proc.LoopStatement;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.proc.TranslateCriteria;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.proc.WhileStatement;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.SelectSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;
import org.teiid.query.sql.visitor.CorrelatedReferenceCollectorVisitor;
import org.teiid.query.sql.visitor.CriteriaTranslatorVisitor;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.query.sql.visitor.FunctionCollectorVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.util.CommandContext;
import org.teiid.query.validator.UpdateValidator;

public class QueryRewriter {
    public static final CompareCriteria TRUE_CRITERIA = new CompareCriteria(new Constant(1, DataTypeManager.DefaultDataClasses.INTEGER), 1, new Constant(1, DataTypeManager.DefaultDataClasses.INTEGER));
    public static final CompareCriteria FALSE_CRITERIA = new CompareCriteria(new Constant(1, DataTypeManager.DefaultDataClasses.INTEGER), 1, new Constant(0, DataTypeManager.DefaultDataClasses.INTEGER));
    public static final CompareCriteria UNKNOWN_CRITERIA = new CompareCriteria(new Constant(null, DataTypeManager.DefaultDataClasses.STRING), 2, new Constant(null, DataTypeManager.DefaultDataClasses.STRING));
    private static final Map<String, String> ALIASED_FUNCTIONS = new HashMap<String, String>();
    private static final Set<String> PARSE_FORMAT_TYPES;
    private QueryMetadataInterface metadata;
    private CommandContext context;
    private CreateUpdateProcedureCommand procCommand;
    private boolean rewriteSubcommands;
    private boolean processing;
    private Evaluator evaluator;
    private Map<ElementSymbol, Expression> variables;
    private int commandType;
    private Integer INTEGER_ZERO = new Integer(0);
    private Double DOUBLE_ZERO = new Double(0.0);
    private Float FLOAT_ZERO = new Float(0.0f);
    private Long LONG_ZERO = new Long(0L);
    private BigInteger BIG_INTEGER_ZERO = new BigInteger("0");
    private BigDecimal BIG_DECIMAL_ZERO = new BigDecimal("0");
    private Short SHORT_ZERO = new Short(0);
    private Byte BYTE_ZERO = new Byte(0);
    private boolean rewriteAggs = true;
    private static Map<String, Integer> FUNCTION_MAP;

    private QueryRewriter(QueryMetadataInterface metadata, CommandContext context, CreateUpdateProcedureCommand procCommand) {
        this.metadata = metadata;
        this.context = context;
        this.procCommand = procCommand;
        this.evaluator = new Evaluator(Collections.emptyMap(), null, context);
    }

    public static Command evaluateAndRewrite(Command command, Evaluator eval, CommandContext context, QueryMetadataInterface metadata) throws TeiidProcessingException, TeiidComponentException {
        QueryRewriter queryRewriter = new QueryRewriter(metadata, context, null);
        queryRewriter.evaluator = eval;
        queryRewriter.rewriteSubcommands = true;
        queryRewriter.processing = true;
        return queryRewriter.rewriteCommand(command, false);
    }

    public static Command rewrite(Command command, CreateUpdateProcedureCommand procCommand, QueryMetadataInterface metadata, CommandContext context, Map<ElementSymbol, Expression> variableValues, int commandType) throws TeiidComponentException, TeiidProcessingException {
        QueryRewriter rewriter = new QueryRewriter(metadata, context, procCommand);
        rewriter.rewriteSubcommands = true;
        rewriter.variables = variableValues;
        rewriter.commandType = commandType;
        return rewriter.rewriteCommand(command, false);
    }

    public static Command rewrite(Command command, QueryMetadataInterface metadata, CommandContext context) throws TeiidComponentException, TeiidProcessingException {
        return QueryRewriter.rewrite(command, null, metadata, context, null, 0);
    }

    private Command rewriteCommand(Command command, boolean removeOrderBy) throws TeiidComponentException, TeiidProcessingException {
        boolean oldRewriteAggs = this.rewriteAggs;
        QueryMetadataInterface oldMetadata = this.metadata;
        CreateUpdateProcedureCommand oldProcCommand = this.procCommand;
        Map tempMetadata = command.getTemporaryMetadata();
        if (tempMetadata != null) {
            this.metadata = new TempMetadataAdapter(this.metadata, new TempMetadataStore(tempMetadata));
        }
        switch (command.getType()) {
            case 1: {
                QueryCommand queryCommand = (QueryCommand)command;
                if (removeOrderBy && queryCommand.getLimit() == null) {
                    queryCommand.setOrderBy(null);
                }
                if (queryCommand.getWith() != null) {
                    for (WithQueryCommand withQueryCommand : queryCommand.getWith()) {
                        if (withQueryCommand.getColumns() == null) {
                            List<ElementSymbol> columns = ResolverUtil.resolveElementsInGroup(withQueryCommand.getGroupSymbol(), this.metadata);
                            withQueryCommand.setColumns(LanguageObject.Util.deepClone(columns, ElementSymbol.class));
                        }
                        this.rewriteSubqueryContainer(withQueryCommand, true);
                    }
                }
                if (command instanceof Query) {
                    command = this.rewriteQuery((Query)command);
                    break;
                }
                command = this.rewriteSetQuery((SetQuery)command);
                break;
            }
            case 6: {
                command = this.rewriteExec((StoredProcedure)command);
                break;
            }
            case 2: {
                command = this.rewriteInsert((Insert)command);
                break;
            }
            case 3: {
                command = this.rewriteUpdate((Update)command);
                break;
            }
            case 4: {
                command = this.rewriteDelete((Delete)command);
                break;
            }
            case 7: {
                this.procCommand = (CreateUpdateProcedureCommand)command;
                command = this.rewriteUpdateProcedure((CreateUpdateProcedureCommand)command);
                break;
            }
            case 9: {
                List<Command> subCommands = ((BatchedUpdateCommand)command).getUpdateCommands();
                for (int i = 0; i < subCommands.size(); ++i) {
                    Command subCommand = subCommands.get(i);
                    subCommand = this.rewriteCommand(subCommand, false);
                    subCommands.set(i, subCommand);
                }
                break;
            }
            case 13: {
                TriggerAction ta = (TriggerAction)command;
                ta.setBlock(this.rewriteBlock(ta.getBlock()));
            }
        }
        this.rewriteAggs = oldRewriteAggs;
        this.metadata = oldMetadata;
        this.procCommand = oldProcCommand;
        return command;
    }

    private Command rewriteUpdateProcedure(CreateUpdateProcedureCommand command) throws TeiidComponentException, TeiidProcessingException {
        Map<ElementSymbol, Expression> oldVariables = this.variables;
        if (command.getUserCommand() != null) {
            this.variables = QueryResolver.getVariableValues(command.getUserCommand(), false, this.metadata);
            this.commandType = command.getUserCommand().getType();
        }
        Block block = this.rewriteBlock(command.getBlock());
        command.setBlock(block);
        this.variables = oldVariables;
        return command;
    }

    private Block rewriteBlock(Block block) throws TeiidComponentException, TeiidProcessingException {
        List<Statement> statements = block.getStatements();
        Iterator<Statement> stmtIter = statements.iterator();
        ArrayList<Statement> newStmts = new ArrayList<Statement>(statements.size());
        while (stmtIter.hasNext()) {
            Statement stmnt = stmtIter.next();
            this.rewriteStatement(stmnt, newStmts);
        }
        block.setStatements(newStmts);
        return block;
    }

    private void rewriteStatement(Statement statement, List<Statement> newStmts) throws TeiidComponentException, TeiidProcessingException {
        int stmtType = statement.getType();
        switch (stmtType) {
            case 1: {
                IfStatement ifStmt = (IfStatement)statement;
                Criteria ifCrit = ifStmt.getCondition();
                Criteria evalCrit = this.rewriteCriteria(ifCrit);
                ifStmt.setCondition(evalCrit);
                if (evalCrit.equals(TRUE_CRITERIA)) {
                    Block ifblock = this.rewriteBlock(ifStmt.getIfBlock());
                    newStmts.addAll(ifblock.getStatements());
                    return;
                }
                if (evalCrit.equals(FALSE_CRITERIA) || evalCrit.equals(UNKNOWN_CRITERIA)) {
                    if (ifStmt.hasElseBlock()) {
                        Block elseBlock = this.rewriteBlock(ifStmt.getElseBlock());
                        newStmts.addAll(elseBlock.getStatements());
                        return;
                    }
                    return;
                }
                Block ifblock = this.rewriteBlock(ifStmt.getIfBlock());
                ifStmt.setIfBlock(ifblock);
                if (!ifStmt.hasElseBlock()) break;
                Block elseBlock = this.rewriteBlock(ifStmt.getElseBlock());
                ifStmt.setElseBlock(elseBlock);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                ExpressionStatement exprStmt = (ExpressionStatement)((Object)statement);
                Expression expr = exprStmt.getExpression();
                if (expr == null) break;
                expr = this.rewriteExpressionDirect(expr);
                exprStmt.setExpression(expr);
                break;
            }
            case 2: {
                Update update;
                CommandStatement cmdStmt = (CommandStatement)statement;
                this.rewriteSubqueryContainer(cmdStmt, false);
                if (cmdStmt.getCommand().getType() != 3 || !(update = (Update)cmdStmt.getCommand()).getChangeList().isEmpty()) break;
                return;
            }
            case 6: {
                LoopStatement loop = (LoopStatement)statement;
                this.rewriteSubqueryContainer(loop, false);
                this.rewriteBlock(loop.getBlock());
                if (!loop.getBlock().getStatements().isEmpty()) break;
                return;
            }
            case 7: {
                WhileStatement whileStatement = (WhileStatement)statement;
                Criteria crit = whileStatement.getCondition();
                crit = this.rewriteCriteria(crit);
                whileStatement.setCondition(crit);
                if (crit.equals(TRUE_CRITERIA)) {
                    throw new QueryValidatorException(QueryPlugin.Util.getString("QueryRewriter.infinite_while"));
                }
                if (crit.equals(FALSE_CRITERIA) || crit.equals(UNKNOWN_CRITERIA)) {
                    return;
                }
                whileStatement.setBlock(this.rewriteBlock(whileStatement.getBlock()));
                if (!whileStatement.getBlock().getStatements().isEmpty()) break;
                return;
            }
        }
        newStmts.add(statement);
    }

    private void rewriteSubqueryContainer(SubqueryContainer container, boolean removeOrderBy) throws TeiidComponentException, TeiidProcessingException {
        if (this.rewriteSubcommands && container.getCommand() != null && (((Command)container.getCommand()).getProcessorPlan() == null || this.processing)) {
            container.setCommand(this.rewriteCommand((Command)container.getCommand(), removeOrderBy));
        }
    }

    private Criteria rewriteCriteria(HasCriteria hasCrit) {
        int selectorType;
        Criteria userCrit = null;
        Command userCommand = this.procCommand.getUserCommand();
        int cmdType = userCommand.getType();
        switch (cmdType) {
            case 4: {
                userCrit = ((Delete)userCommand).getCriteria();
                break;
            }
            case 3: {
                userCrit = ((Update)userCommand).getCriteria();
                break;
            }
            default: {
                return FALSE_CRITERIA;
            }
        }
        if (userCrit == null) {
            return FALSE_CRITERIA;
        }
        CriteriaSelector selector = hasCrit.getSelector();
        List hasCritElmts = null;
        if (selector.hasElements()) {
            hasCritElmts = selector.getElements();
            Collection<ElementSymbol> userElmnts = ElementCollectorVisitor.getElements((LanguageObject)userCrit, true);
            if (!userElmnts.containsAll(hasCritElmts)) {
                return FALSE_CRITERIA;
            }
        }
        if ((selectorType = selector.getSelectorType()) == 0) {
            return TRUE_CRITERIA;
        }
        block10: for (Criteria predicateCriteria : Criteria.separateCriteriaByAnd(userCrit)) {
            CompareCriteria compCrit;
            Collection<ElementSymbol> predElmnts = ElementCollectorVisitor.getElements((LanguageObject)predicateCriteria, true);
            if (selector.hasElements()) {
                Iterator hasIter = hasCritElmts.iterator();
                boolean containsElmnt = false;
                while (hasIter.hasNext()) {
                    ElementSymbol hasElmnt = (ElementSymbol)hasIter.next();
                    if (!predElmnts.contains(hasElmnt)) continue;
                    containsElmnt = true;
                }
                if (!containsElmnt) continue;
            }
            switch (selectorType) {
                case 8: {
                    if (!(predicateCriteria instanceof SetCriteria)) continue block10;
                    return TRUE_CRITERIA;
                }
                case 7: {
                    if (!(predicateCriteria instanceof MatchCriteria)) continue block10;
                    return TRUE_CRITERIA;
                }
                case 9: {
                    if (!(predicateCriteria instanceof IsNullCriteria)) continue block10;
                    return TRUE_CRITERIA;
                }
                case 10: {
                    if (!(predicateCriteria instanceof BetweenCriteria)) continue block10;
                    return TRUE_CRITERIA;
                }
            }
            if (!(predicateCriteria instanceof CompareCriteria) || (compCrit = (CompareCriteria)predicateCriteria).getOperator() != selectorType) continue;
            return TRUE_CRITERIA;
        }
        return FALSE_CRITERIA;
    }

    private Criteria rewriteCriteria(TranslateCriteria transCrit) throws TeiidComponentException, TeiidProcessingException {
        Criteria translatedCriteria = null;
        Command userCmd = this.procCommand.getUserCommand();
        if (!(userCmd instanceof TranslatableProcedureContainer)) {
            return FALSE_CRITERIA;
        }
        Criteria userCriteria = ((TranslatableProcedureContainer)userCmd).getCriteria();
        if (userCriteria == null) {
            return TRUE_CRITERIA;
        }
        CriteriaTranslatorVisitor translateVisitor = new CriteriaTranslatorVisitor(this.procCommand.getSymbolMap());
        translateVisitor.setCriteriaSelector(transCrit.getSelector());
        if (transCrit.hasTranslations()) {
            translateVisitor.setTranslations(transCrit.getTranslations());
        }
        Criteria userClone = (Criteria)userCriteria.clone();
        userClone = translateVisitor.translate(userClone);
        ((TranslatableProcedureContainer)userCmd).addImplicitParameters(translateVisitor.getImplicitParams());
        translatedCriteria = this.rewriteCriteria(userClone);
        try {
            ResolverVisitor.resolveLanguageObject(translatedCriteria, this.metadata);
        }
        catch (TeiidException ex) {
            throw new QueryValidatorException(ex, "ERR.015.009.0002", QueryPlugin.Util.getString("ERR.015.009.0002", new Object[]{translatedCriteria}));
        }
        return translatedCriteria;
    }

    private Command rewriteQuery(Query query) throws TeiidComponentException, TeiidProcessingException {
        Criteria having;
        From from = query.getFrom();
        if (from != null) {
            ArrayList<FromClause> clauses = new ArrayList<FromClause>(from.getClauses().size());
            Iterator<FromClause> clauseIter = from.getClauses().iterator();
            while (clauseIter.hasNext()) {
                clauses.add(this.rewriteFromClause(query, clauseIter.next()));
            }
            from.setClauses(clauses);
        } else {
            query.setOrderBy(null);
        }
        Criteria crit = query.getCriteria();
        if (crit != null) {
            if (query.getIsXML()) {
                this.rewriteExpressions(crit);
            } else {
                crit = this.rewriteCriteria(crit);
            }
            if (crit == TRUE_CRITERIA) {
                query.setCriteria(null);
            } else if (crit == UNKNOWN_CRITERIA) {
                query.setCriteria(FALSE_CRITERIA);
            } else {
                query.setCriteria(crit);
            }
        }
        if (from != null && !query.getIsXML()) {
            this.rewriteSubqueriesAsJoins(query);
        }
        if ((having = (query = this.rewriteGroupBy(query)).getHaving()) != null) {
            crit = this.rewriteCriteria(having);
            if (crit == TRUE_CRITERIA) {
                query.setHaving(null);
            } else {
                query.setHaving(crit);
            }
        }
        this.rewriteExpressions(query.getSelect());
        if (!query.getIsXML()) {
            query = (Query)this.rewriteOrderBy(query);
        }
        if (query.getLimit() != null) {
            query.setLimit(this.rewriteLimitClause(query.getLimit()));
        }
        if (query.getInto() != null) {
            return this.rewriteSelectInto(query);
        }
        return query;
    }

    private void rewriteSubqueriesAsJoins(Query query) throws TeiidComponentException, QueryMetadataException, QueryResolverException {
        if (query.getCriteria() == null) {
            return;
        }
        RuleMergeCriteria rmc = new RuleMergeCriteria(null, null, null, this.context, this.metadata);
        List<Criteria> current = Criteria.separateCriteriaByAnd(query.getCriteria());
        query.setCriteria(null);
        List<GroupSymbol> groups = query.getFrom().getGroups();
        HashSet<String> names = new HashSet<String>();
        for (GroupSymbol gs : groups) {
            names.add(gs.getCanonicalName());
        }
        Iterator<Criteria> crits = current.iterator();
        while (crits.hasNext()) {
            boolean requiresDistinct;
            RuleMergeCriteria.PlannedResult plannedResult = rmc.findSubquery(crits.next());
            if (plannedResult.not || plannedResult.query == null || plannedResult.query.getProcessorPlan() != null || plannedResult.query.getWith() != null) continue;
            if (plannedResult.query.getCorrelatedReferences() == null) {
                ArrayList<Reference> correlatedReferences = new ArrayList<Reference>();
                CorrelatedReferenceCollectorVisitor.collectReferences(plannedResult.query, groups, correlatedReferences);
                if (!correlatedReferences.isEmpty()) {
                    SymbolMap map = new SymbolMap();
                    for (Reference reference : correlatedReferences) {
                        map.addMapping(reference.getExpression(), reference.getExpression());
                    }
                    plannedResult.query.setCorrelatedReferences(map);
                }
            }
            if (!rmc.planQuery(groups, requiresDistinct = this.requiresDistinctRows(query), plannedResult)) continue;
            crits.remove();
            GroupSymbol viewName = RulePlaceAccess.recontextSymbol(new GroupSymbol("X"), names);
            viewName.setName(viewName.getCanonicalName());
            viewName.setDefinition(null);
            Query q = QueryRewriter.createInlineViewQuery(viewName, plannedResult.query, this.metadata, plannedResult.query.getSelect().getProjectedSymbols());
            Iterator<SingleElementSymbol> iter = q.getSelect().getProjectedSymbols().iterator();
            HashMap<Expression, Expression> expressionMap = new HashMap<Expression, Expression>();
            for (SingleElementSymbol symbol : plannedResult.query.getSelect().getProjectedSymbols()) {
                expressionMap.put(SymbolMap.getExpression(symbol), SymbolMap.getExpression(iter.next()));
            }
            for (int i = 0; i < plannedResult.leftExpressions.size(); ++i) {
                plannedResult.nonEquiJoinCriteria.add(new CompareCriteria(SymbolMap.getExpression((Expression)plannedResult.leftExpressions.get(i)), 1, (Expression)plannedResult.rightExpressions.get(i)));
            }
            Criteria mappedCriteria = Criteria.combineCriteria(plannedResult.nonEquiJoinCriteria);
            ExpressionMappingVisitor.mapExpressions(mappedCriteria, expressionMap);
            query.setCriteria(Criteria.combineCriteria(query.getCriteria(), mappedCriteria));
            FromClause clause = q.getFrom().getClauses().get(0);
            if (plannedResult.makeInd) {
                clause.setMakeInd(true);
            }
            query.getFrom().addClause(clause);
            query.getTemporaryMetadata().putAll(q.getTemporaryMetadata());
        }
        query.setCriteria(Criteria.combineCriteria(query.getCriteria(), Criteria.combineCriteria(current)));
    }

    private boolean requiresDistinctRows(Query query) {
        HashSet<AggregateSymbol> aggs = new HashSet<AggregateSymbol>();
        aggs.addAll(AggregateSymbolCollectorVisitor.getAggregates(query.getSelect(), false));
        aggs.addAll(AggregateSymbolCollectorVisitor.getAggregates(query.getHaving(), false));
        if (!aggs.isEmpty() || query.getGroupBy() != null) {
            if (!AggregateSymbol.areAggregatesCardinalityDependent(aggs)) {
                return false;
            }
        } else if (query.getSelect().isDistinct()) {
            for (SingleElementSymbol projectSymbol : query.getSelect().getProjectedSymbols()) {
                Expression ex = SymbolMap.getExpression(projectSymbol);
                if (FunctionCollectorVisitor.isNonDeterministic(ex)) {
                    return true;
                }
                if (ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(ex).isEmpty()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private Query rewriteGroupBy(Query query) throws TeiidComponentException, TeiidProcessingException {
        if (query.getGroupBy() == null) {
            this.rewriteAggs = false;
            return query;
        }
        if (QueryRewriter.isDistinctWithGroupBy(query)) {
            query.getSelect().setDistinct(false);
        }
        this.rewriteExpressions(query.getGroupBy());
        return query;
    }

    public static boolean isDistinctWithGroupBy(Query query) {
        GroupBy groupBy = query.getGroupBy();
        if (groupBy == null) {
            return false;
        }
        HashSet<Expression> selectExpressions = new HashSet<Expression>();
        for (SingleElementSymbol selectExpr : query.getSelect().getProjectedSymbols()) {
            selectExpressions.add(SymbolMap.getExpression(selectExpr));
        }
        for (Expression groupByExpr : groupBy.getSymbols()) {
            if (selectExpressions.contains(groupByExpr)) continue;
            return false;
        }
        return true;
    }

    private void rewriteExpressions(LanguageObject obj) throws TeiidComponentException, TeiidProcessingException {
        if (obj == null) {
            return;
        }
        ExpressionMappingVisitor visitor = new ExpressionMappingVisitor(null){

            @Override
            public Expression replaceExpression(Expression element) {
                try {
                    return QueryRewriter.this.rewriteExpressionDirect(element);
                }
                catch (TeiidException err) {
                    throw new TeiidRuntimeException((Throwable)err);
                }
            }
        };
        try {
            PostOrderNavigator.doVisit(obj, visitor);
        }
        catch (TeiidRuntimeException err) {
            if (err.getCause() instanceof TeiidComponentException) {
                throw (TeiidComponentException)err.getCause();
            }
            if (err.getCause() instanceof TeiidProcessingException) {
                throw (TeiidProcessingException)err.getCause();
            }
            throw err;
        }
    }

    public QueryCommand rewriteOrderBy(QueryCommand queryCommand) throws TeiidComponentException {
        OrderBy orderBy = queryCommand.getOrderBy();
        if (orderBy == null) {
            return queryCommand;
        }
        Select select = queryCommand.getProjectedQuery().getSelect();
        List<SingleElementSymbol> projectedSymbols = select.getProjectedSymbols();
        LinkedList<OrderByItem> unrelatedItems = new LinkedList<OrderByItem>();
        QueryRewriter.rewriteOrderBy(queryCommand, orderBy, projectedSymbols, unrelatedItems);
        return queryCommand;
    }

    public static void rewriteOrderBy(QueryCommand queryCommand, OrderBy orderBy, List projectedSymbols, LinkedList<OrderByItem> unrelatedItems) {
        HashSet<Expression> previousExpressions = new HashSet<Expression>();
        for (int i = 0; i < orderBy.getVariableCount(); ++i) {
            SingleElementSymbol querySymbol = orderBy.getVariable(i);
            int index = orderBy.getExpressionPosition(i);
            boolean isUnrelated = false;
            if (index == -1) {
                unrelatedItems.add(orderBy.getOrderByItems().get(i));
                isUnrelated = querySymbol instanceof ExpressionSymbol;
            } else {
                querySymbol = (SingleElementSymbol)projectedSymbols.get(index);
            }
            Expression expr = SymbolMap.getExpression(querySymbol);
            if (!previousExpressions.add(expr) || queryCommand instanceof Query && EvaluatableVisitor.willBecomeConstant(expr)) {
                orderBy.removeOrderByItem(i--);
                continue;
            }
            if (isUnrelated) continue;
            orderBy.getOrderByItems().get(i).setSymbol((SingleElementSymbol)querySymbol.clone());
        }
        if (orderBy.getVariableCount() == 0) {
            queryCommand.setOrderBy(null);
        }
    }

    private Insert rewriteSelectInto(Query query) throws TeiidProcessingException {
        Into into = query.getInto();
        try {
            ArrayList<ElementSymbol> allIntoElements = LanguageObject.Util.deepClone(ResolverUtil.resolveElementsInGroup(into.getGroup(), this.metadata), ElementSymbol.class);
            Insert insert = new Insert(into.getGroup(), allIntoElements, Collections.emptyList());
            insert.setSourceHint(query.getSourceHint());
            query.setSourceHint(null);
            query.setInto(null);
            insert.setQueryExpression(query);
            return this.rewriteInsert(this.correctDatatypes(insert));
        }
        catch (QueryMetadataException err) {
            throw new QueryValidatorException((Throwable)((Object)err), err.getMessage());
        }
        catch (TeiidComponentException err) {
            throw new QueryValidatorException(err, err.getMessage());
        }
    }

    private Insert correctDatatypes(Insert insert) {
        boolean needsView = false;
        for (int i = 0; !needsView && i < insert.getVariables().size(); ++i) {
            SingleElementSymbol ses = insert.getVariables().get(i);
            if (ses.getType() == insert.getQueryExpression().getProjectedSymbols().get(i).getType()) continue;
            needsView = true;
        }
        if (needsView) {
            try {
                insert.setQueryExpression(QueryRewriter.createInlineViewQuery(new GroupSymbol("X"), insert.getQueryExpression(), this.metadata, insert.getVariables()));
            }
            catch (TeiidException err) {
                throw new TeiidRuntimeException((Throwable)err);
            }
        }
        return insert;
    }

    private void correctProjectedTypes(List actualSymbolTypes, Query query) {
        List<SingleElementSymbol> symbols = query.getSelect().getProjectedSymbols();
        List newSymbols = SetQuery.getTypedProjectedSymbols(symbols, actualSymbolTypes, this.metadata);
        query.getSelect().setSymbols(newSymbols);
    }

    private SetQuery rewriteSetQuery(SetQuery setQuery) throws TeiidComponentException, TeiidProcessingException {
        if (setQuery.getProjectedTypes() != null) {
            for (QueryCommand command : setQuery.getQueryCommands()) {
                if (!(command instanceof Query)) continue;
                this.correctProjectedTypes(setQuery.getProjectedTypes(), (Query)command);
            }
            setQuery.setProjectedTypes(null, null);
        }
        setQuery.setLeftQuery((QueryCommand)this.rewriteCommand(setQuery.getLeftQuery(), true));
        setQuery.setRightQuery((QueryCommand)this.rewriteCommand(setQuery.getRightQuery(), true));
        this.rewriteOrderBy(setQuery);
        if (setQuery.getLimit() != null) {
            setQuery.setLimit(this.rewriteLimitClause(setQuery.getLimit()));
        }
        return setQuery;
    }

    private FromClause rewriteFromClause(Query parent, FromClause clause) throws TeiidComponentException, TeiidProcessingException {
        if (clause instanceof JoinPredicate) {
            return this.rewriteJoinPredicate(parent, (JoinPredicate)clause);
        }
        if (clause instanceof SubqueryFromClause) {
            this.rewriteSubqueryContainer((SubqueryFromClause)clause, true);
        } else if (clause instanceof TextTable) {
            TextTable tt = (TextTable)clause;
            tt.setFile(this.rewriteExpressionDirect(tt.getFile()));
        } else if (clause instanceof XMLTable) {
            XMLTable xt = (XMLTable)clause;
            xt.rewriteDefaultColumn();
            this.rewriteExpressions(clause);
        } else if (clause instanceof ArrayTable) {
            ArrayTable at = (ArrayTable)clause;
            at.setArrayValue(this.rewriteExpressionDirect(at.getArrayValue()));
        }
        return clause;
    }

    private JoinPredicate rewriteJoinPredicate(Query parent, JoinPredicate predicate) throws TeiidComponentException, TeiidProcessingException {
        List joinCrits = predicate.getJoinCriteria();
        if (joinCrits != null && joinCrits.size() > 0) {
            Criteria criteria = new CompoundCriteria(new ArrayList(joinCrits));
            joinCrits.clear();
            criteria = this.rewriteCriteria(criteria);
            if (criteria instanceof CompoundCriteria && ((CompoundCriteria)criteria).getOperator() == 0) {
                joinCrits.addAll(((CompoundCriteria)criteria).getCriteria());
            } else {
                joinCrits.add(criteria);
            }
            predicate.setJoinCriteria(joinCrits);
        }
        if (predicate.getJoinType() == JoinType.JOIN_UNION) {
            predicate.setJoinType(JoinType.JOIN_FULL_OUTER);
            predicate.setJoinCriteria(new ArrayList<CompareCriteria>(Arrays.asList(FALSE_CRITERIA)));
        } else if (predicate.getJoinType() == JoinType.JOIN_RIGHT_OUTER) {
            predicate.setJoinType(JoinType.JOIN_LEFT_OUTER);
            FromClause leftClause = predicate.getLeftClause();
            predicate.setLeftClause(predicate.getRightClause());
            predicate.setRightClause(leftClause);
        }
        predicate.setLeftClause(this.rewriteFromClause(parent, predicate.getLeftClause()));
        predicate.setRightClause(this.rewriteFromClause(parent, predicate.getRightClause()));
        return predicate;
    }

    public static Criteria rewriteCriteria(Criteria criteria, CreateUpdateProcedureCommand procCommand, CommandContext context, QueryMetadataInterface metadata) throws TeiidComponentException, TeiidProcessingException {
        return new QueryRewriter(metadata, context, procCommand).rewriteCriteria(criteria);
    }

    private Criteria rewriteCriteria(Criteria criteria) throws TeiidComponentException, TeiidProcessingException {
        if (criteria instanceof CompoundCriteria) {
            return this.rewriteCriteria((CompoundCriteria)criteria, true);
        }
        if (criteria instanceof NotCriteria) {
            criteria = this.rewriteCriteria((NotCriteria)criteria);
        } else if (criteria instanceof CompareCriteria) {
            criteria = this.rewriteCriteria((CompareCriteria)criteria);
        } else if (criteria instanceof SubqueryCompareCriteria) {
            criteria = this.rewriteCriteria((SubqueryCompareCriteria)criteria);
        } else if (criteria instanceof MatchCriteria) {
            criteria = this.rewriteCriteria((MatchCriteria)criteria);
        } else if (criteria instanceof SetCriteria) {
            criteria = this.rewriteCriteria((SetCriteria)criteria);
        } else if (criteria instanceof IsNullCriteria) {
            criteria = this.rewriteCriteria((IsNullCriteria)criteria);
        } else if (criteria instanceof BetweenCriteria) {
            criteria = this.rewriteCriteria((BetweenCriteria)criteria);
        } else if (criteria instanceof HasCriteria) {
            criteria = this.rewriteCriteria((HasCriteria)criteria);
        } else if (criteria instanceof TranslateCriteria) {
            criteria = this.rewriteCriteria((TranslateCriteria)criteria);
        } else if (criteria instanceof ExistsCriteria) {
            ExistsCriteria exists = (ExistsCriteria)criteria;
            if (exists.shouldEvaluate() && this.processing) {
                return this.getCriteria(this.evaluator.evaluate(exists, null));
            }
            this.rewriteSubqueryContainer((SubqueryContainer)((Object)criteria), true);
            if (!RelationalNodeUtil.shouldExecute(exists.getCommand(), false, true)) {
                return exists.isNegated() ? TRUE_CRITERIA : FALSE_CRITERIA;
            }
            if (exists.getCommand().getProcessorPlan() == null) {
                Query query;
                if (exists.getCommand() instanceof Query && ((query = (Query)exists.getCommand()).getLimit() == null || query.getOrderBy() == null) && query.getSelect().getProjectedSymbols().size() > 1) {
                    query.getSelect().clearSymbols();
                    query.getSelect().addSymbol(new ExpressionSymbol("x", new Constant(1)));
                }
                this.addImplicitLimit(exists, 1);
            }
        } else if (criteria instanceof SubquerySetCriteria) {
            SubquerySetCriteria sub = (SubquerySetCriteria)criteria;
            if (this.rewriteLeftExpression(sub)) {
                return UNKNOWN_CRITERIA;
            }
            this.rewriteSubqueryContainer(sub, true);
            if (!RelationalNodeUtil.shouldExecute(sub.getCommand(), false, true)) {
                return this.getSimpliedCriteria(criteria, sub.getExpression(), !sub.isNegated(), true);
            }
        } else if (criteria instanceof DependentSetCriteria) {
            criteria = this.rewriteDependentSetCriteria((DependentSetCriteria)criteria);
        } else if (criteria instanceof ExpressionCriteria) {
            return this.rewriteCriteria(new CompareCriteria(((ExpressionCriteria)criteria).getExpression(), 1, new Constant(Boolean.TRUE)));
        }
        return this.evaluateCriteria(criteria);
    }

    private void addImplicitLimit(SubqueryContainer<QueryCommand> container, int rowLimit) {
        if (container.getCommand().getLimit() != null) {
            Constant c;
            Limit lim = container.getCommand().getLimit();
            if (lim.getRowLimit() instanceof Constant && !(c = (Constant)lim.getRowLimit()).isMultiValued() && Integer.valueOf(rowLimit).compareTo((Integer)c.getValue()) <= 0) {
                lim.setRowLimit(new Constant(rowLimit));
                if (lim.getRowLimit() == null) {
                    lim.setImplicit(true);
                    container.getCommand().setOrderBy(null);
                }
            }
            return;
        }
        boolean addLimit = true;
        if (container.getCommand() instanceof Query) {
            Query query = (Query)container.getCommand();
            boolean bl = addLimit = !query.hasAggregates() || query.getGroupBy() != null;
        }
        if (addLimit) {
            Limit lim = new Limit(null, new Constant(rowLimit));
            lim.setImplicit(true);
            container.getCommand().setLimit(lim);
        }
    }

    private Criteria rewriteDependentSetCriteria(DependentSetCriteria dsc) throws TeiidComponentException, TeiidProcessingException {
        if (!this.processing && this.rewriteLeftExpression(dsc)) {
            return UNKNOWN_CRITERIA;
        }
        return dsc;
    }

    public static Criteria optimizeCriteria(CompoundCriteria criteria, QueryMetadataInterface metadata) {
        try {
            return new QueryRewriter(metadata, null, null).rewriteCriteria(criteria, false);
        }
        catch (TeiidException err) {
            return criteria;
        }
    }

    private Criteria rewriteCriteria(CompoundCriteria criteria, boolean rewrite) throws TeiidComponentException, TeiidProcessingException {
        List<Criteria> crits = criteria.getCriteria();
        int operator = criteria.getOperator();
        LinkedHashSet<Criteria> newCrits = new LinkedHashSet<Criteria>(crits.size());
        HashMap<Expression, Criteria> exprMap = new HashMap<Expression, Criteria>();
        for (Criteria converted : crits) {
            CompoundCriteria other;
            if (rewrite) {
                converted = this.rewriteCriteria(converted);
            } else if (converted instanceof CompoundCriteria) {
                converted = this.rewriteCriteria((CompoundCriteria)converted, false);
            }
            List<Criteria> critList = null;
            if (converted instanceof CompoundCriteria && (other = (CompoundCriteria)converted).getOperator() == criteria.getOperator()) {
                critList = other.getCriteria();
            }
            if (critList == null) {
                critList = Arrays.asList(converted);
            }
            for (Criteria criteria2 : critList) {
                CompareCriteria cc;
                PredicateCriteria other2;
                Criteria crit;
                converted = criteria2;
                if (TRUE_CRITERIA.equals(converted)) {
                    if (operator != 1) continue;
                    return converted;
                }
                if (FALSE_CRITERIA.equals(converted)) {
                    if (operator != 0) continue;
                    return converted;
                }
                if (UNKNOWN_CRITERIA.equals(converted)) {
                    if (operator != 0) continue;
                    return FALSE_CRITERIA;
                }
                if (operator == 0) {
                    if ((converted = this.rewriteAndConjunct(converted, exprMap, newCrits)) == null) continue;
                    return converted;
                }
                if (converted instanceof SetCriteria) {
                    SetCriteria sc = (SetCriteria)converted;
                    if (!sc.isNegated() && sc.isAllConstants()) {
                        crit = exprMap.get(sc.getExpression());
                        if (crit == null) {
                            exprMap.put(sc.getExpression(), sc);
                        } else {
                            if (crit instanceof SetCriteria) {
                                other2 = (SetCriteria)crit;
                                ((SetCriteria)other2).getValues().addAll(sc.getValues());
                                continue;
                            }
                            newCrits.remove(crit);
                            CompareCriteria cc2 = (CompareCriteria)crit;
                            sc.getValues().add(cc2.getRightExpression());
                        }
                    }
                } else if (converted instanceof CompareCriteria && (cc = (CompareCriteria)converted).getOperator() == 1 && cc.getRightExpression() instanceof Constant) {
                    crit = exprMap.get(cc.getLeftExpression());
                    if (crit == null) {
                        exprMap.put(cc.getLeftExpression(), cc);
                    } else {
                        if (crit instanceof SetCriteria) {
                            other2 = (SetCriteria)crit;
                            ((SetCriteria)other2).getValues().add(cc.getRightExpression());
                            continue;
                        }
                        newCrits.remove(crit);
                        other2 = (CompareCriteria)crit;
                        SetCriteria sc = new SetCriteria(cc.getLeftExpression(), new LinkedHashSet());
                        sc.setAllConstants(true);
                        sc.getValues().add(cc.getRightExpression());
                        sc.getValues().add(((CompareCriteria)other2).getRightExpression());
                        exprMap.put(sc.getExpression(), sc);
                        converted = sc;
                    }
                }
                newCrits.add(converted);
            }
        }
        if (newCrits.size() == 0) {
            if (operator == 0) {
                return TRUE_CRITERIA;
            }
            return FALSE_CRITERIA;
        }
        if (newCrits.size() == 1) {
            return (Criteria)newCrits.iterator().next();
        }
        criteria.getCriteria().clear();
        criteria.getCriteria().addAll(newCrits);
        return criteria;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Criteria rewriteAndConjunct(Criteria converted, Map<Expression, Criteria> exprMap, LinkedHashSet<Criteria> newCrits) throws ExpressionEvaluationException {
        if (converted instanceof IsNullCriteria) {
            IsNullCriteria inc = (IsNullCriteria)converted;
            if (!inc.isNegated()) {
                Criteria crit = exprMap.get(inc.getExpression());
                if (crit == null) {
                    exprMap.put(inc.getExpression(), converted);
                } else if (!(crit instanceof IsNullCriteria)) {
                    return FALSE_CRITERIA;
                }
            }
        } else if (converted instanceof SetCriteria) {
            SetCriteria sc = (SetCriteria)converted;
            Criteria crit = exprMap.get(sc.getExpression());
            if (crit instanceof IsNullCriteria) {
                return FALSE_CRITERIA;
            }
            if (!sc.isNegated() && sc.isAllConstants()) {
                if (crit == null) {
                    exprMap.put(sc.getExpression(), converted);
                } else {
                    if (crit instanceof SetCriteria) {
                        SetCriteria sc1 = (SetCriteria)crit;
                        newCrits.remove(sc1);
                        sc1.getValues().retainAll(sc.getValues());
                        if (sc1.getValues().isEmpty()) {
                            return FALSE_CRITERIA;
                        }
                        newCrits.add(sc1);
                        exprMap.put(sc1.getExpression(), sc1);
                        return null;
                    }
                    CompareCriteria cc = (CompareCriteria)crit;
                    Iterator exprIter = sc.getValues().iterator();
                    while (exprIter.hasNext()) {
                        if (Evaluator.compare(cc, ((Constant)exprIter.next()).getValue(), ((Constant)cc.getRightExpression()).getValue()).booleanValue()) continue;
                        exprIter.remove();
                    }
                    if (sc.getValues().isEmpty()) {
                        return FALSE_CRITERIA;
                    }
                    if (cc.getOperator() == 1) return null;
                    newCrits.remove(cc);
                    exprMap.put(sc.getExpression(), sc);
                }
            }
        } else if (converted instanceof CompareCriteria) {
            CompareCriteria cc = (CompareCriteria)converted;
            Criteria crit = exprMap.get(cc.getLeftExpression());
            if (crit instanceof IsNullCriteria) {
                return FALSE_CRITERIA;
            }
            if (cc.getRightExpression() instanceof Constant) {
                if (crit == null) {
                    exprMap.put(cc.getLeftExpression(), cc);
                } else if (crit instanceof SetCriteria) {
                    SetCriteria sc = (SetCriteria)crit;
                    boolean modified = false;
                    Iterator exprIter = sc.getValues().iterator();
                    while (exprIter.hasNext()) {
                        if (Evaluator.compare(cc, ((Constant)exprIter.next()).getValue(), ((Constant)cc.getRightExpression()).getValue()).booleanValue()) continue;
                        if (!modified) {
                            modified = true;
                            newCrits.remove(sc);
                        }
                        exprIter.remove();
                    }
                    if (sc.getValues().isEmpty()) {
                        return FALSE_CRITERIA;
                    }
                    if (cc.getOperator() == 1) {
                        exprMap.put(cc.getLeftExpression(), cc);
                    } else if (modified) {
                        newCrits.add(sc);
                        exprMap.put(sc.getExpression(), sc);
                        return null;
                    }
                } else {
                    CompareCriteria cc1 = (CompareCriteria)crit;
                    if (cc1.getOperator() == 2) {
                        exprMap.put(cc.getLeftExpression(), cc);
                    } else if (cc1.getOperator() == 1) {
                        if (Evaluator.compare(cc1, ((Constant)cc1.getRightExpression()).getValue(), ((Constant)cc.getRightExpression()).getValue()).booleanValue()) return null;
                        return FALSE_CRITERIA;
                    }
                    if (cc.getOperator() == 1) {
                        if (!Evaluator.compare(cc1, ((Constant)cc.getRightExpression()).getValue(), ((Constant)cc1.getRightExpression()).getValue()).booleanValue()) {
                            return FALSE_CRITERIA;
                        }
                        exprMap.put(cc.getLeftExpression(), cc);
                        newCrits.remove(cc1);
                    }
                }
            }
        }
        newCrits.add(converted);
        return null;
    }

    private Criteria evaluateCriteria(Criteria crit) throws TeiidComponentException, TeiidProcessingException {
        if (EvaluatableVisitor.isFullyEvaluatable(crit, !this.processing)) {
            try {
                Boolean eval = this.evaluator.evaluateTVL(crit, Collections.emptyList());
                return this.getCriteria(eval);
            }
            catch (ExpressionEvaluationException e) {
                throw new QueryValidatorException((Throwable)((Object)e), "ERR.015.009.0001", QueryPlugin.Util.getString("ERR.015.009.0001", new Object[]{crit}));
            }
        }
        return crit;
    }

    private Criteria getCriteria(Boolean eval) {
        if (eval == null) {
            return UNKNOWN_CRITERIA;
        }
        if (Boolean.TRUE.equals(eval)) {
            return TRUE_CRITERIA;
        }
        return FALSE_CRITERIA;
    }

    private Criteria rewriteCriteria(NotCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        Criteria innerCrit = criteria.getCriteria();
        if (innerCrit instanceof CompoundCriteria) {
            return this.rewriteCriteria(Criteria.applyDemorgan(innerCrit));
        }
        if (innerCrit instanceof PredicateCriteria.Negatable) {
            ((PredicateCriteria.Negatable)((Object)innerCrit)).negate();
            return this.rewriteCriteria(innerCrit);
        }
        if (innerCrit instanceof NotCriteria) {
            return this.rewriteCriteria(((NotCriteria)innerCrit).getCriteria());
        }
        if ((innerCrit = this.rewriteCriteria(innerCrit)) == TRUE_CRITERIA) {
            return FALSE_CRITERIA;
        }
        if (innerCrit == FALSE_CRITERIA) {
            return TRUE_CRITERIA;
        }
        if (innerCrit == UNKNOWN_CRITERIA) {
            return UNKNOWN_CRITERIA;
        }
        criteria.setCriteria(innerCrit);
        return criteria;
    }

    private Criteria rewriteCriteria(BetweenCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        CompareCriteria lowerCriteria = new CompareCriteria(criteria.getExpression(), criteria.isNegated() ? 3 : 6, criteria.getLowerExpression());
        CompareCriteria upperCriteria = new CompareCriteria(criteria.getExpression(), criteria.isNegated() ? 4 : 5, criteria.getUpperExpression());
        CompoundCriteria newCriteria = new CompoundCriteria(criteria.isNegated() ? 1 : 0, lowerCriteria, upperCriteria);
        return this.rewriteCriteria(newCriteria);
    }

    private Criteria rewriteCriteria(CompareCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        Expression leftExpr = this.rewriteExpressionDirect(criteria.getLeftExpression());
        Expression rightExpr = this.rewriteExpressionDirect(criteria.getRightExpression());
        criteria.setLeftExpression(leftExpr);
        criteria.setRightExpression(rightExpr);
        if (QueryRewriter.isNull(leftExpr) || QueryRewriter.isNull(rightExpr)) {
            return UNKNOWN_CRITERIA;
        }
        boolean rightConstant = false;
        if (EvaluatableVisitor.willBecomeConstant(rightExpr)) {
            rightConstant = true;
        } else if (EvaluatableVisitor.willBecomeConstant(leftExpr)) {
            criteria.setLeftExpression(rightExpr);
            criteria.setRightExpression(leftExpr);
            switch (criteria.getOperator()) {
                case 3: {
                    criteria.setOperator(4);
                    break;
                }
                case 5: {
                    criteria.setOperator(6);
                    break;
                }
                case 4: {
                    criteria.setOperator(3);
                    break;
                }
                case 6: {
                    criteria.setOperator(5);
                }
            }
            rightConstant = true;
        }
        Function f = null;
        while (rightConstant && f != criteria.getLeftExpression() && criteria.getLeftExpression() instanceof Function) {
            f = (Function)criteria.getLeftExpression();
            Criteria result = this.simplifyWithInverse(criteria);
            if (!(result instanceof CompareCriteria)) {
                return result;
            }
            criteria = (CompareCriteria)result;
        }
        Criteria modCriteria = this.simplifyTimestampMerge(criteria);
        if (modCriteria instanceof CompareCriteria) {
            modCriteria = this.simplifyTimestampMerge2((CompareCriteria)modCriteria);
        }
        return modCriteria;
    }

    public static boolean isNull(Expression expr) {
        return expr instanceof Constant && ((Constant)expr).isNull();
    }

    private Criteria rewriteCriteria(SubqueryCompareCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        Expression leftExpr;
        if (criteria.getCommand().getProcessorPlan() == null) {
            if (criteria.getOperator() == 1 && criteria.getPredicateQuantifier() != 4 || criteria.getOperator() == 2 && criteria.getPredicateQuantifier() == 4) {
                SubquerySetCriteria result = new SubquerySetCriteria(criteria.getLeftExpression(), criteria.getCommand());
                result.setNegated(criteria.getOperator() == 2);
                return this.rewriteCriteria(result);
            }
            if (criteria.getPredicateQuantifier() != 4 && criteria.getOperator() != 1 && criteria.getOperator() != 2) {
                CompareCriteria cc = new CompareCriteria();
                cc.setLeftExpression(criteria.getLeftExpression());
                Query q = QueryRewriter.createInlineViewQuery(new GroupSymbol("X"), criteria.getCommand(), this.metadata, criteria.getCommand().getProjectedSymbols());
                SingleElementSymbol ses = q.getProjectedSymbols().get(0);
                Expression expr = SymbolMap.getExpression(ses);
                q.getSelect().clearSymbols();
                AggregateSymbol.Type type = AggregateSymbol.Type.MAX;
                if (criteria.getOperator() == 4 || criteria.getOperator() == 6) {
                    type = AggregateSymbol.Type.MIN;
                }
                q.getSelect().addSymbol(new AggregateSymbol(ses.getName(), type.name(), false, expr));
                cc.setRightExpression(new ScalarSubquery(q));
                cc.setOperator(criteria.getOperator());
                return this.rewriteCriteria(cc);
            }
        }
        if (QueryRewriter.isNull(leftExpr = this.rewriteExpressionDirect(criteria.getLeftExpression()))) {
            return UNKNOWN_CRITERIA;
        }
        criteria.setLeftExpression(leftExpr);
        if (criteria.getPredicateQuantifier() == 3) {
            criteria.setPredicateQuantifier(2);
        }
        this.rewriteSubqueryContainer(criteria, true);
        if (!RelationalNodeUtil.shouldExecute(criteria.getCommand(), false, true)) {
            return this.getSimpliedCriteria(criteria, criteria.getLeftExpression(), criteria.getPredicateQuantifier() == 4, true);
        }
        return criteria;
    }

    private Criteria simplifyWithInverse(CompareCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        Expression leftExpr = criteria.getLeftExpression();
        Function leftFunction = (Function)leftExpr;
        if (this.isSimpleMathematicalFunction(leftFunction)) {
            return this.simplifyMathematicalCriteria(criteria);
        }
        if (FunctionLibrary.isConvert(leftFunction)) {
            return this.simplifyConvertFunction(criteria);
        }
        return this.simplifyParseFormatFunction(criteria);
    }

    private boolean isSimpleMathematicalFunction(Function function) {
        Expression[] args;
        String funcName = function.getName();
        return !(!funcName.equals("+") && !funcName.equals("-") && !funcName.equals("*") && !funcName.equals("/") || !((args = function.getArgs())[0] instanceof Constant) && !(args[1] instanceof Constant));
    }

    private CompareCriteria simplifyMathematicalCriteria(CompareCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        Object value;
        Expression leftExpr = criteria.getLeftExpression();
        Expression rightExpr = criteria.getRightExpression();
        Function function = (Function)leftExpr;
        String funcName = function.getName();
        Expression[] args = function.getArgs();
        Constant const1 = null;
        Expression expr = null;
        if (args[1] instanceof Constant) {
            const1 = (Constant)args[1];
            expr = args[0];
        } else if (funcName.equals("+") || funcName.equals("*")) {
            const1 = (Constant)args[0];
            expr = args[1];
        } else {
            return criteria;
        }
        int operator = criteria.getOperator();
        String oppFunc = null;
        switch (funcName.charAt(0)) {
            case '+': {
                oppFunc = "-";
                break;
            }
            case '-': {
                oppFunc = "+";
                break;
            }
            case '*': {
                oppFunc = "/";
                break;
            }
            case '/': {
                oppFunc = "*";
            }
        }
        Expression combinedConst = null;
        FunctionLibrary funcLib = this.metadata.getFunctionLibrary();
        FunctionDescriptor descriptor = funcLib.findFunction(oppFunc, new Class[]{rightExpr.getType(), const1.getType()});
        if (descriptor == null) {
            return criteria;
        }
        if (rightExpr instanceof Constant) {
            Constant const2 = (Constant)rightExpr;
            try {
                Object result = descriptor.invokeFunction(new Object[]{const2.getValue(), const1.getValue()});
                combinedConst = new Constant(result, descriptor.getReturnType());
            }
            catch (FunctionExecutionException e) {
                throw new QueryValidatorException((Throwable)((Object)e), "ERR.015.009.0003", QueryPlugin.Util.getString("ERR.015.009.0003", new Object[]{e.getMessage()}));
            }
        } else {
            Function conversion = new Function(descriptor.getName(), new Expression[]{rightExpr, const1});
            conversion.setType(leftExpr.getType());
            conversion.setFunctionDescriptor(descriptor);
            combinedConst = conversion;
        }
        if (operator != 1 && operator != 2 && (oppFunc.equals("*") || oppFunc.equals("/")) && (value = const1.getValue()) != null) {
            Class<?> type = const1.getType();
            Number comparisonObject = null;
            if (type.equals(DataTypeManager.DefaultDataClasses.INTEGER)) {
                comparisonObject = this.INTEGER_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.DOUBLE)) {
                comparisonObject = this.DOUBLE_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.FLOAT)) {
                comparisonObject = this.FLOAT_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.LONG)) {
                comparisonObject = this.LONG_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.BIG_INTEGER)) {
                comparisonObject = this.BIG_INTEGER_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.BIG_DECIMAL)) {
                comparisonObject = this.BIG_DECIMAL_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.SHORT)) {
                comparisonObject = this.SHORT_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.BYTE)) {
                comparisonObject = this.BYTE_ZERO;
            } else {
                return criteria;
            }
            if (comparisonObject.compareTo(value) > 0) {
                switch (operator) {
                    case 5: {
                        operator = 6;
                        break;
                    }
                    case 3: {
                        operator = 4;
                        break;
                    }
                    case 6: {
                        operator = 5;
                        break;
                    }
                    case 4: {
                        operator = 3;
                    }
                }
            }
        }
        criteria.setLeftExpression(expr);
        criteria.setRightExpression(combinedConst);
        criteria.setOperator(operator);
        return criteria;
    }

    private Criteria simplifyConvertFunction(CompareCriteria crit) {
        Function leftFunction = (Function)crit.getLeftExpression();
        Expression leftExpr = leftFunction.getArgs()[0];
        if (!(crit.getRightExpression() instanceof Constant) || crit.getOperator() != 1 && crit.getOperator() != 2) {
            return crit;
        }
        Constant rightConstant = (Constant)crit.getRightExpression();
        String leftExprTypeName = DataTypeManager.getDataTypeName((Class)leftExpr.getType());
        Constant result = ResolverUtil.convertConstant(DataTypeManager.getDataTypeName(rightConstant.getType()), leftExprTypeName, rightConstant);
        if (result == null) {
            return this.getSimpliedCriteria(crit, leftExpr, crit.getOperator() != 1, true);
        }
        Constant other = ResolverUtil.convertConstant(leftExprTypeName, DataTypeManager.getDataTypeName(rightConstant.getType()), result);
        if (other == null || ((Comparable)rightConstant.getValue()).compareTo(other.getValue()) != 0) {
            return this.getSimpliedCriteria(crit, leftExpr, crit.getOperator() != 1, true);
        }
        if (!DataTypeManager.isImplicitConversion((String)leftExprTypeName, (String)DataTypeManager.getDataTypeName(rightConstant.getType()))) {
            return crit;
        }
        crit.setRightExpression(result);
        crit.setLeftExpression(leftExpr);
        return crit;
    }

    private Criteria simplifyConvertFunction(SetCriteria crit) throws TeiidComponentException, TeiidProcessingException {
        Function leftFunction = (Function)crit.getExpression();
        Expression leftExpr = leftFunction.getArgs()[0];
        String leftExprTypeName = DataTypeManager.getDataTypeName((Class)leftExpr.getType());
        Iterator i = crit.getValues().iterator();
        ArrayList<Constant> newValues = new ArrayList<Constant>(crit.getNumberOfValues());
        boolean convertedAll = true;
        boolean removedSome = false;
        while (i.hasNext()) {
            Constant other;
            Object next = i.next();
            if (!(next instanceof Constant)) {
                convertedAll = false;
                continue;
            }
            Constant rightConstant = (Constant)next;
            Constant result = ResolverUtil.convertConstant(DataTypeManager.getDataTypeName(rightConstant.getType()), leftExprTypeName, rightConstant);
            if (result != null && ((other = ResolverUtil.convertConstant(leftExprTypeName, DataTypeManager.getDataTypeName(rightConstant.getType()), result)) == null || ((Comparable)rightConstant.getValue()).compareTo(other.getValue()) != 0)) {
                result = null;
            }
            if (result == null) {
                removedSome = true;
                i.remove();
                continue;
            }
            if (DataTypeManager.isImplicitConversion((String)leftExprTypeName, (String)DataTypeManager.getDataTypeName(rightConstant.getType()))) {
                newValues.add(result);
                continue;
            }
            convertedAll = false;
        }
        if (!convertedAll) {
            if (!removedSome) {
                return crit;
            }
        } else {
            if (newValues.isEmpty()) {
                return this.getSimpliedCriteria(crit, leftExpr, !crit.isNegated(), true);
            }
            crit.setExpression(leftExpr);
            crit.setValues(newValues);
        }
        return this.rewriteCriteria(crit);
    }

    private Criteria simplifyParseFormatFunction(CompareCriteria crit) {
        String type;
        if (crit.getOperator() != 1 && crit.getOperator() != 2) {
            return crit;
        }
        boolean isFormat = false;
        Function leftFunction = (Function)crit.getLeftExpression();
        String funcName = leftFunction.getName().toLowerCase();
        String inverseFunction = null;
        if (funcName.startsWith("parse")) {
            type = funcName.substring(5);
            if (!PARSE_FORMAT_TYPES.contains(type)) {
                return crit;
            }
            inverseFunction = "format" + type;
        } else if (funcName.startsWith("format")) {
            type = funcName.substring(6);
            if (!PARSE_FORMAT_TYPES.contains(type)) {
                return crit;
            }
            inverseFunction = "parse" + type;
            isFormat = true;
        } else {
            return crit;
        }
        Expression rightExpr = crit.getRightExpression();
        if (!(rightExpr instanceof Constant)) {
            return crit;
        }
        Expression leftExpr = leftFunction.getArgs()[0];
        Expression formatExpr = leftFunction.getArgs()[1];
        if (!(formatExpr instanceof Constant)) {
            return crit;
        }
        String format = (String)((Constant)formatExpr).getValue();
        FunctionLibrary funcLib = this.metadata.getFunctionLibrary();
        FunctionDescriptor descriptor = funcLib.findFunction(inverseFunction, new Class[]{rightExpr.getType(), formatExpr.getType()});
        if (descriptor == null) {
            return crit;
        }
        Object value = ((Constant)rightExpr).getValue();
        try {
            Object result = descriptor.invokeFunction(new Object[]{((Constant)rightExpr).getValue(), format});
            result = leftFunction.getFunctionDescriptor().invokeFunction(new Object[]{result, format});
            if (((Comparable)value).compareTo(result) != 0) {
                return this.getSimpliedCriteria(crit, leftExpr, crit.getOperator() != 1, true);
            }
        }
        catch (FunctionExecutionException e) {
            return crit;
        }
        if (!isFormat) {
            return crit;
        }
        return crit;
    }

    private Criteria simplifyTimestampMerge2(CompareCriteria criteria) {
        if (criteria.getOperator() != 1) {
            return criteria;
        }
        Expression leftExpr = criteria.getLeftExpression();
        Expression rightExpr = criteria.getRightExpression();
        Function tsCreateFunction = null;
        Constant timestampConstant = null;
        if (!(leftExpr instanceof Function) || !(rightExpr instanceof Constant)) {
            return criteria;
        }
        tsCreateFunction = (Function)leftExpr;
        timestampConstant = (Constant)rightExpr;
        if (!timestampConstant.getType().equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
            return criteria;
        }
        if (!tsCreateFunction.getName().equalsIgnoreCase("timestampCreate")) {
            return criteria;
        }
        Timestamp ts = (Timestamp)timestampConstant.getValue();
        String tsStr = ts.toString();
        java.sql.Date date = java.sql.Date.valueOf(tsStr.substring(0, 10));
        Time time = Time.valueOf(tsStr.substring(11, 19));
        Expression[] args = tsCreateFunction.getArgs();
        CompareCriteria dateCrit = new CompareCriteria(args[0], 1, new Constant(date, DataTypeManager.DefaultDataClasses.DATE));
        CompareCriteria timeCrit = new CompareCriteria(args[1], 1, new Constant(time, DataTypeManager.DefaultDataClasses.TIME));
        CompoundCriteria compCrit = new CompoundCriteria(0, dateCrit, timeCrit);
        return compCrit;
    }

    private Criteria simplifyTimestampMerge(CompareCriteria criteria) {
        if (criteria.getOperator() != 1) {
            return criteria;
        }
        Expression leftExpr = criteria.getLeftExpression();
        Expression rightExpr = criteria.getRightExpression();
        Function concatFunction = null;
        Constant timestampConstant = null;
        if (!(leftExpr instanceof Function) || !(rightExpr instanceof Constant)) {
            return criteria;
        }
        concatFunction = (Function)leftExpr;
        timestampConstant = (Constant)rightExpr;
        if (!timestampConstant.getType().equals(DataTypeManager.DefaultDataClasses.STRING)) {
            return criteria;
        }
        if (!concatFunction.getName().equalsIgnoreCase("concat") && !concatFunction.getName().equals("||")) {
            return criteria;
        }
        Expression[] args = concatFunction.getArgs();
        if (!(args[0] instanceof Function) || !(args[1] instanceof Function)) {
            return criteria;
        }
        Function formatDateFunction = (Function)args[0];
        Function formatTimeFunction = (Function)args[1];
        if (!formatDateFunction.getName().equalsIgnoreCase("formatdate") || !formatTimeFunction.getName().equalsIgnoreCase("formattime")) {
            return criteria;
        }
        if (!(formatDateFunction.getArgs()[1] instanceof Constant) || !(formatTimeFunction.getArgs()[1] instanceof Constant)) {
            return criteria;
        }
        String dateFormat = (String)((Constant)formatDateFunction.getArgs()[1]).getValue();
        String timeFormat = (String)((Constant)formatTimeFunction.getArgs()[1]).getValue();
        String timestampValue = (String)timestampConstant.getValue();
        try {
            Timestamp ts = FunctionMethods.parseTimestamp(timestampValue, dateFormat + timeFormat);
            Constant dateConstant = new Constant(TimestampWithTimezone.createDate((Date)ts));
            CompareCriteria dateCompare = new CompareCriteria(formatDateFunction.getArgs()[0], 1, dateConstant);
            Constant timeConstant = new Constant(TimestampWithTimezone.createTime((Date)ts));
            CompareCriteria timeCompare = new CompareCriteria(formatTimeFunction.getArgs()[0], 1, timeConstant);
            CompoundCriteria compCrit = new CompoundCriteria(0, dateCompare, timeCompare);
            return compCrit;
        }
        catch (FunctionExecutionException e) {
            return criteria;
        }
    }

    private Criteria rewriteCriteria(MatchCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        criteria.setLeftExpression(this.rewriteExpressionDirect(criteria.getLeftExpression()));
        criteria.setRightExpression(this.rewriteExpressionDirect(criteria.getRightExpression()));
        if (QueryRewriter.isNull(criteria.getLeftExpression()) || QueryRewriter.isNull(criteria.getRightExpression())) {
            return UNKNOWN_CRITERIA;
        }
        Expression rightExpr = criteria.getRightExpression();
        if (rightExpr instanceof Constant && rightExpr.getType().equals(DataTypeManager.DefaultDataClasses.STRING)) {
            Constant constant = (Constant)rightExpr;
            String value = (String)constant.getValue();
            if (criteria.getMode() != Like.MatchMode.REGEX) {
                char escape = criteria.getEscapeChar();
                if (escape != '\u0000' && value.indexOf(escape) < 0) {
                    criteria.setEscapeChar('\u0000');
                }
                if (value.equals(String.valueOf('%'))) {
                    return this.getSimpliedCriteria(criteria, criteria.getLeftExpression(), !criteria.isNegated(), true);
                }
                if (criteria.getMode() == Like.MatchMode.SIMILAR) {
                    criteria.setMode(Like.MatchMode.REGEX);
                    criteria.setRightExpression(new Constant(Evaluator.SIMILAR_TO_REGEX.getPatternString(value, escape)));
                    criteria.setEscapeChar('\u0000');
                } else if (DataTypeManager.DefaultDataClasses.STRING.equals(criteria.getLeftExpression().getType()) && value.indexOf(escape) < 0 && value.indexOf(95) < 0 && value.indexOf(37) < 0) {
                    return this.rewriteCriteria(new CompareCriteria(criteria.getLeftExpression(), criteria.isNegated() ? 2 : 1, criteria.getRightExpression()));
                }
            }
        }
        return criteria;
    }

    private Criteria getSimpliedCriteria(Criteria crit, Expression a, boolean outcome, boolean nullPossible) {
        if (nullPossible) {
            if (outcome) {
                if (this.processing) {
                    return crit;
                }
                IsNullCriteria inc = new IsNullCriteria(a);
                inc.setNegated(true);
                return inc;
            }
        } else if (outcome) {
            return TRUE_CRITERIA;
        }
        return FALSE_CRITERIA;
    }

    private boolean rewriteLeftExpression(AbstractSetCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        criteria.setExpression(this.rewriteExpressionDirect(criteria.getExpression()));
        return QueryRewriter.isNull(criteria.getExpression());
    }

    private Criteria rewriteCriteria(SetCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        Function leftFunction;
        if (criteria.isAllConstants() && criteria.getValues().size() > 1) {
            return criteria;
        }
        criteria.setExpression(this.rewriteExpressionDirect(criteria.getExpression()));
        if (this.rewriteLeftExpression(criteria)) {
            return UNKNOWN_CRITERIA;
        }
        Collection vals = criteria.getValues();
        LinkedHashSet<Expression> newVals = new LinkedHashSet<Expression>(vals.size());
        Iterator valIter = vals.iterator();
        boolean allConstants = true;
        boolean hasNull = false;
        while (valIter.hasNext()) {
            Expression value = this.rewriteExpressionDirect((Expression)valIter.next());
            if (QueryRewriter.isNull(value)) {
                hasNull = true;
                continue;
            }
            allConstants &= value instanceof Constant;
            newVals.add(value);
        }
        int size = newVals.size();
        if (size == 1) {
            Expression value = (Expression)newVals.iterator().next();
            return this.rewriteCriteria(new CompareCriteria(criteria.getExpression(), criteria.isNegated() ? 2 : 1, value));
        }
        criteria.setValues(newVals);
        if (allConstants) {
            criteria.setAllConstants(true);
        }
        if (size == 0) {
            if (hasNull) {
                return UNKNOWN_CRITERIA;
            }
            return this.getSimpliedCriteria(criteria, criteria.getExpression(), !criteria.isNegated(), true);
        }
        if (criteria.getExpression() instanceof Function && FunctionLibrary.isConvert(leftFunction = (Function)criteria.getExpression())) {
            return this.simplifyConvertFunction(criteria);
        }
        return criteria;
    }

    private Criteria rewriteCriteria(IsNullCriteria criteria) throws TeiidComponentException, TeiidProcessingException {
        criteria.setExpression(this.rewriteExpressionDirect(criteria.getExpression()));
        return criteria;
    }

    public static Expression rewriteExpression(Expression expression, CreateUpdateProcedureCommand procCommand, CommandContext context, QueryMetadataInterface metadata) throws TeiidComponentException, TeiidProcessingException {
        return new QueryRewriter(metadata, context, procCommand).rewriteExpressionDirect(expression);
    }

    private Expression rewriteExpressionDirect(Expression expression) throws TeiidComponentException, TeiidProcessingException {
        if (expression instanceof Constant) {
            return expression;
        }
        if (expression instanceof ElementSymbol) {
            ElementSymbol es = (ElementSymbol)expression;
            Class<?> type = es.getType();
            if (!this.processing && es.isExternalReference()) {
                if (this.variables == null) {
                    return new Reference(es);
                }
                Expression value = this.variables.get(es);
                if (value == null) {
                    if (es.getGroupSymbol().getSchema() == null) {
                        String grpName = es.getGroupSymbol().getShortCanonicalName();
                        if (grpName.equals("INPUTS")) {
                            return new Constant(null, es.getType());
                        }
                        if (grpName.equals("CHANGING")) {
                            Assertion.failed((String)"Changing value should not be null");
                        }
                    }
                } else if (value instanceof Constant) {
                    if (value.getType() == type) {
                        return value;
                    }
                    try {
                        return new Constant(FunctionMethods.convert(((Constant)value).getValue(), DataTypeManager.getDataTypeName(type)), es.getType());
                    }
                    catch (FunctionExecutionException e) {
                        throw new QueryValidatorException((Throwable)((Object)e), e.getMessage());
                    }
                }
                return new Reference(es);
            }
            return expression;
        }
        boolean isBindEligible = true;
        if (expression instanceof Function) {
            isBindEligible = !this.isConstantConvert(expression);
            expression = this.rewriteFunction((Function)expression);
        } else if (expression instanceof CaseExpression) {
            expression = this.rewriteCaseExpression((CaseExpression)expression);
        } else if (expression instanceof SearchedCaseExpression) {
            expression = this.rewriteCaseExpression((SearchedCaseExpression)expression);
        } else {
            if (expression instanceof ScalarSubquery) {
                ScalarSubquery subquery = (ScalarSubquery)expression;
                if (subquery.shouldEvaluate() && this.processing) {
                    return new Constant(this.evaluator.evaluate((Expression)subquery, null), subquery.getType());
                }
                this.rewriteSubqueryContainer(subquery, true);
                if (!RelationalNodeUtil.shouldExecute(subquery.getCommand(), false, true)) {
                    return new Constant(null, subquery.getType());
                }
                if (subquery.getCommand().getProcessorPlan() == null) {
                    this.addImplicitLimit(subquery, 2);
                }
                return expression;
            }
            if (expression instanceof ExpressionSymbol) {
                expression = expression instanceof AggregateSymbol ? this.rewriteExpression((AggregateSymbol)expression) : this.rewriteExpressionDirect(((ExpressionSymbol)expression).getExpression());
            } else if (expression instanceof Criteria) {
                expression = this.rewriteCriteria((Criteria)expression);
            } else {
                this.rewriteExpressions(expression);
            }
        }
        if (!this.processing ? !EvaluatableVisitor.isFullyEvaluatable(expression, true) : !(expression instanceof Reference) && !EvaluatableVisitor.isEvaluatable(expression, EvaluatableVisitor.EvaluationLevel.PROCESSING)) {
            return expression;
        }
        return this.evaluate(expression, isBindEligible);
    }

    private Constant evaluate(Expression expression, boolean isBindEligible) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        Object value = this.evaluator.evaluate(expression, Collections.emptyList());
        if (value instanceof Constant) {
            return (Constant)value;
        }
        Constant result = new Constant(value, expression.getType());
        result.setBindEligible(isBindEligible);
        return result;
    }

    private boolean isConstantConvert(Expression ex) {
        if (ex instanceof Constant) {
            return true;
        }
        if (!(ex instanceof Function)) {
            return false;
        }
        Function f = (Function)ex;
        if (!FunctionLibrary.isConvert(f)) {
            return false;
        }
        return this.isConstantConvert(f.getArg(0));
    }

    private Expression rewriteExpression(AggregateSymbol expression) {
        if (expression.isBoolean()) {
            if (expression.getAggregateFunction() == AggregateSymbol.Type.EVERY) {
                expression.setAggregateFunction(AggregateSymbol.Type.MIN);
            } else {
                expression.setAggregateFunction(AggregateSymbol.Type.MAX);
            }
        }
        if (expression.getAggregateFunction() == AggregateSymbol.Type.MAX || expression.getAggregateFunction() == AggregateSymbol.Type.MIN) {
            if (expression.isDistinct()) {
                expression.setDistinct(false);
            }
            if (this.rewriteAggs && expression.getExpression() != null && EvaluatableVisitor.willBecomeConstant(expression.getExpression())) {
                return expression.getExpression();
            }
        }
        if (expression.getExpression() != null && expression.getCondition() != null && !expression.respectsNulls()) {
            Expression cond = expression.getCondition();
            Expression ex = expression.getExpression();
            if (!(cond instanceof Criteria)) {
                cond = new ExpressionCriteria(cond);
            }
            SearchedCaseExpression sce = new SearchedCaseExpression(Arrays.asList(cond), Arrays.asList(ex));
            sce.setType(ex.getType());
            expression.setCondition(null);
            expression.setExpression(sce);
        }
        return expression;
    }

    private Expression rewriteFunction(Function function) throws TeiidComponentException, TeiidProcessingException {
        Expression[] newArgs;
        Expression[] args;
        Integer code;
        FunctionDescriptor descriptor;
        String functionLowerName = function.getName().toLowerCase();
        String actualName = ALIASED_FUNCTIONS.get(functionLowerName);
        FunctionLibrary funcLibrary = this.metadata.getFunctionLibrary();
        if (actualName != null) {
            function.setName(actualName);
            Expression[] args2 = function.getArgs();
            Class[] types = new Class[args2.length];
            for (int i = 0; i < args2.length; ++i) {
                types[i] = args2[i].getType();
            }
            descriptor = funcLibrary.findFunction(actualName, types);
            function.setFunctionDescriptor(descriptor);
        }
        if ((code = FUNCTION_MAP.get(functionLowerName)) != null) {
            switch (code) {
                case 0: {
                    Function result = new Function("repeat", new Expression[]{new Constant(" "), function.getArg(0)});
                    descriptor = funcLibrary.findFunction("repeat", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.INTEGER});
                    result.setFunctionDescriptor(descriptor);
                    result.setType(DataTypeManager.DefaultDataClasses.STRING);
                    function = result;
                    break;
                }
                case 1: {
                    Function result = new Function("timestampadd", new Expression[]{new Constant("SQL_TSI_SECOND"), function.getArg(0), new Constant(new Timestamp(0L))});
                    descriptor = funcLibrary.findFunction("timestampadd", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.INTEGER, DataTypeManager.DefaultDataClasses.TIMESTAMP});
                    result.setFunctionDescriptor(descriptor);
                    result.setType(DataTypeManager.DefaultDataClasses.TIMESTAMP);
                    function = result;
                    break;
                }
                case 2: {
                    List<Criteria> when = Arrays.asList(new CompareCriteria(function.getArg(0), 1, function.getArg(1)));
                    Constant nullConstant = new Constant(null, function.getType());
                    List<Expression> then = Arrays.asList(nullConstant);
                    SearchedCaseExpression caseExpr = new SearchedCaseExpression(when, then);
                    caseExpr.setElseExpression(function.getArg(0));
                    caseExpr.setType(function.getType());
                    return this.rewriteExpressionDirect(caseExpr);
                }
                case 3: {
                    args = function.getArgs();
                    if (args.length != 2) break;
                    Function result = new Function("ifnull", new Expression[]{function.getArg(0), function.getArg(1)});
                    FunctionDescriptor descriptor2 = funcLibrary.findFunction("ifnull", new Class[]{function.getType(), function.getType()});
                    result.setFunctionDescriptor(descriptor2);
                    result.setType(function.getType());
                    function = result;
                    break;
                }
                case 4: {
                    FunctionDescriptor descriptor3;
                    args = function.getArgs();
                    newArgs = new Function[args.length];
                    for (int i = 0; i < args.length; ++i) {
                        newArgs[i] = new Function("ifnull", new Expression[]{args[i], new Constant("")});
                        ((Function)newArgs[i]).setType(args[i].getType());
                        Assertion.assertTrue((args[i].getType() == DataTypeManager.DefaultDataClasses.STRING ? 1 : 0) != 0);
                        descriptor3 = funcLibrary.findFunction("ifnull", new Class[]{args[i].getType(), DataTypeManager.DefaultDataClasses.STRING});
                        ((Function)newArgs[i]).setFunctionDescriptor(descriptor3);
                    }
                    Function concat = new Function("concat", newArgs);
                    concat.setType(DataTypeManager.DefaultDataClasses.STRING);
                    descriptor3 = funcLibrary.findFunction("concat", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.STRING});
                    concat.setFunctionDescriptor(descriptor3);
                    List<Criteria> when = Arrays.asList(new CompoundCriteria(0, new IsNullCriteria(args[0]), new IsNullCriteria(args[1])));
                    Constant nullConstant = new Constant(null, DataTypeManager.DefaultDataClasses.STRING);
                    List<Expression> then = Arrays.asList(nullConstant);
                    SearchedCaseExpression caseExpr = new SearchedCaseExpression(when, then);
                    caseExpr.setElseExpression(concat);
                    caseExpr.setType(DataTypeManager.DefaultDataClasses.STRING);
                    return this.rewriteExpressionDirect(caseExpr);
                }
                case 5: {
                    if (function.getType() == DataTypeManager.DefaultDataClasses.TIMESTAMP) break;
                    FunctionDescriptor descriptor4 = funcLibrary.findFunction("timestampadd", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.INTEGER, DataTypeManager.DefaultDataClasses.TIMESTAMP});
                    function.setFunctionDescriptor(descriptor4);
                    Class type = function.getType();
                    function.setType(DataTypeManager.DefaultDataClasses.TIMESTAMP);
                    function.getArgs()[2] = ResolverUtil.getConversion(function.getArg(2), DataTypeManager.getDataTypeName((Class)type), "timestamp", false, funcLibrary);
                    function = ResolverUtil.getConversion(function, "timestamp", DataTypeManager.getDataTypeName((Class)type), false, funcLibrary);
                    break;
                }
                case 6: 
                case 7: {
                    FunctionDescriptor descriptor4 = funcLibrary.findFunction("parsetimestamp", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.STRING});
                    function.setName("parsetimestamp");
                    function.setFunctionDescriptor(descriptor4);
                    Class type = function.getType();
                    function.setType(DataTypeManager.DefaultDataClasses.TIMESTAMP);
                    function = ResolverUtil.getConversion(function, "timestamp", DataTypeManager.getDataTypeName((Class)type), false, funcLibrary);
                    break;
                }
                case 8: 
                case 9: {
                    FunctionDescriptor descriptor4 = funcLibrary.findFunction("formattimestamp", new Class[]{DataTypeManager.DefaultDataClasses.TIMESTAMP, DataTypeManager.DefaultDataClasses.STRING});
                    function.setName("formattimestamp");
                    function.setFunctionDescriptor(descriptor4);
                    function.getArgs()[0] = ResolverUtil.getConversion(function.getArg(0), DataTypeManager.getDataTypeName((Class)function.getArg(0).getType()), "timestamp", false, funcLibrary);
                    break;
                }
                case 10: {
                    FunctionDescriptor descriptor2;
                    if (!new Constant(" ").equals(function.getArg(1))) break;
                    String spec = (String)((Constant)function.getArg(0)).getValue();
                    Expression string = function.getArg(2);
                    if (!"TRAILING".equalsIgnoreCase(spec)) {
                        function = new Function("ltrim", new Expression[]{string});
                        descriptor2 = funcLibrary.findFunction("ltrim", new Class[]{DataTypeManager.DefaultDataClasses.STRING});
                        function.setFunctionDescriptor(descriptor2);
                        function.setType(DataTypeManager.DefaultDataClasses.STRING);
                        string = function;
                    }
                    if ("LEADING".equalsIgnoreCase(spec)) break;
                    function = new Function("rtrim", new Expression[]{string});
                    descriptor2 = funcLibrary.findFunction("rtrim", new Class[]{DataTypeManager.DefaultDataClasses.STRING});
                    function.setFunctionDescriptor(descriptor2);
                    function.setType(DataTypeManager.DefaultDataClasses.STRING);
                }
            }
        }
        args = function.getArgs();
        newArgs = new Expression[args.length];
        for (int i = 0; i < args.length; ++i) {
            newArgs[i] = this.rewriteExpressionDirect(args[i]);
            if (!QueryRewriter.isNull(newArgs[i]) || function.getFunctionDescriptor().isNullDependent()) continue;
            return new Constant(null, function.getType());
        }
        function.setArgs(newArgs);
        if (FunctionLibrary.isConvert(function)) {
            Class srcType = newArgs[0].getType();
            Class tgtType = function.getType();
            if (srcType != null && tgtType != null && srcType.equals(tgtType)) {
                return newArgs[0];
            }
            if (!(newArgs[0] instanceof Function) || tgtType == DataTypeManager.DefaultDataClasses.OBJECT) {
                return function;
            }
            Function nested = (Function)newArgs[0];
            if (!FunctionLibrary.isConvert(nested)) {
                return function;
            }
            Class nestedType = nested.getArgs()[0].getType();
            Transform t = DataTypeManager.getTransform((Class)nestedType, (Class)nested.getType());
            if (t.isExplicit()) {
                return function;
            }
            if (DataTypeManager.getTransform((Class)nestedType, (Class)tgtType) == null) {
                return function;
            }
            if (tgtType == DataTypeManager.DefaultDataClasses.STRING && (nestedType == DataTypeManager.DefaultDataClasses.BOOLEAN || nestedType == DataTypeManager.DefaultDataClasses.DATE || nestedType == DataTypeManager.DefaultDataClasses.TIME || tgtType == DataTypeManager.DefaultDataClasses.BIG_DECIMAL || tgtType == DataTypeManager.DefaultDataClasses.FLOAT || tgtType == DataTypeManager.DefaultDataClasses.DOUBLE && srcType != DataTypeManager.DefaultDataClasses.FLOAT)) {
                return function;
            }
            return this.rewriteExpressionDirect(ResolverUtil.getConversion(nested.getArgs()[0], DataTypeManager.getDataTypeName((Class)nestedType), DataTypeManager.getDataTypeName((Class)tgtType), false, funcLibrary));
        }
        if (function.getName().equalsIgnoreCase("decodestring") || function.getName().equalsIgnoreCase("decodeinteger")) {
            return this.convertDecodeFunction(function);
        }
        return function;
    }

    private Expression convertDecodeFunction(Function function) {
        Expression[] exprs = function.getArgs();
        String decodeString = (String)((Constant)exprs[1]).getValue();
        String decodeDelimiter = ",";
        if (exprs.length == 3) {
            decodeDelimiter = (String)((Constant)exprs[2]).getValue();
        }
        ArrayList<IsNullCriteria> newWhens = new ArrayList<IsNullCriteria>();
        ArrayList<Constant> newThens = new ArrayList<Constant>();
        Constant elseConst = null;
        StringTokenizer tokenizer = new StringTokenizer(decodeString, decodeDelimiter);
        while (tokenizer.hasMoreTokens()) {
            String compareString = QueryRewriter.convertString(tokenizer.nextToken().trim());
            if (tokenizer.hasMoreTokens()) {
                String resultString = QueryRewriter.convertString(tokenizer.nextToken().trim());
                PredicateCriteria crit = compareString == null ? new IsNullCriteria((Expression)exprs[0].clone()) : new CompareCriteria((Expression)exprs[0].clone(), 1, new Constant(compareString));
                newWhens.add((IsNullCriteria)crit);
                newThens.add(new Constant(resultString));
                continue;
            }
            elseConst = new Constant(compareString);
        }
        SearchedCaseExpression newCaseExpr = new SearchedCaseExpression(newWhens, newThens);
        if (elseConst != null) {
            newCaseExpr.setElseExpression(elseConst);
        } else {
            newCaseExpr.setElseExpression(exprs[0]);
        }
        newCaseExpr.setType(DataTypeManager.DefaultDataClasses.STRING);
        if (function.getName().equalsIgnoreCase("decodeinteger")) {
            return ResolverUtil.getConversion(newCaseExpr, "string", "integer", false, this.metadata.getFunctionLibrary());
        }
        return newCaseExpr;
    }

    private static String convertString(String string) {
        if (string.equals("")) {
            return null;
        }
        if (string.equalsIgnoreCase("null")) {
            return null;
        }
        if (string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'")) {
            if (string.length() == 2) {
                string = "";
            } else if (!string.equalsIgnoreCase("'") && !string.equalsIgnoreCase("\"")) {
                string = string.substring(1);
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    private Expression rewriteCaseExpression(CaseExpression expr) throws TeiidComponentException, TeiidProcessingException {
        ArrayList<CompareCriteria> whens = new ArrayList<CompareCriteria>(expr.getWhenCount());
        for (Expression expression : expr.getWhen()) {
            whens.add(new CompareCriteria((Expression)expr.getExpression().clone(), 1, expression));
        }
        SearchedCaseExpression sce = new SearchedCaseExpression(whens, expr.getThen());
        sce.setElseExpression(expr.getElseExpression());
        sce.setType(expr.getType());
        return this.rewriteCaseExpression(sce);
    }

    private Expression rewriteCaseExpression(SearchedCaseExpression expr) throws TeiidComponentException, TeiidProcessingException {
        int whenCount = expr.getWhenCount();
        ArrayList<Criteria> whens = new ArrayList<Criteria>(whenCount);
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            Criteria rewrittenWhen = this.rewriteCriteria(expr.getWhenCriteria(i));
            if (rewrittenWhen == TRUE_CRITERIA) {
                return this.rewriteExpressionDirect(expr.getThenExpression(i));
            }
            if (rewrittenWhen == FALSE_CRITERIA || rewrittenWhen == UNKNOWN_CRITERIA) continue;
            whens.add(rewrittenWhen);
            thens.add(this.rewriteExpressionDirect(expr.getThenExpression(i)));
        }
        if (expr.getElseExpression() != null) {
            expr.setElseExpression(this.rewriteExpressionDirect(expr.getElseExpression()));
        }
        Expression elseExpr = expr.getElseExpression();
        if (whens.size() == 0) {
            if (elseExpr == null) {
                return new Constant(null, expr.getType());
            }
            return elseExpr;
        }
        expr.setWhen(whens, thens);
        if (elseExpr != null) {
            boolean bAllMatch = true;
            for (int i = 0; i < whenCount; ++i) {
                if (((Expression)thens.get(i)).equals(elseExpr)) continue;
                bAllMatch = false;
                break;
            }
            if (bAllMatch) {
                return elseExpr;
            }
        }
        return expr;
    }

    private Command rewriteExec(StoredProcedure storedProcedure) throws TeiidComponentException, TeiidProcessingException {
        storedProcedure.setDisplayNamedParameters(false);
        for (SPParameter param : storedProcedure.getInputParameters()) {
            if (!this.processing) {
                param.setExpression(this.rewriteExpressionDirect(param.getExpression()));
                continue;
            }
            if (param.getExpression() instanceof Constant) continue;
            boolean isBindEligible = !this.isConstantConvert(param.getExpression());
            param.setExpression(this.evaluate(param.getExpression(), isBindEligible));
        }
        return storedProcedure;
    }

    private Insert rewriteInsert(Insert insert) throws TeiidComponentException, TeiidProcessingException {
        UpdateValidator.UpdateInfo info = insert.getUpdateInfo();
        if (info != null && info.isInherentInsert()) {
            UpdateValidator.UpdateMapping mapping = info.findInsertUpdateMapping(insert, true);
            if (mapping == null) {
                throw new QueryValidatorException(QueryPlugin.Util.getString("ValidationVisitor.nonUpdatable", insert.getVariables()));
            }
            Map<ElementSymbol, ElementSymbol> symbolMap = mapping.getUpdatableViewSymbols();
            ArrayList<ElementSymbol> mappedSymbols = new ArrayList<ElementSymbol>(insert.getVariables().size());
            for (ElementSymbol symbol : insert.getVariables()) {
                mappedSymbols.add(symbolMap.get(symbol));
            }
            insert.setVariables(mappedSymbols);
            insert.setGroup(mapping.getGroup().clone());
            insert.setUpdateInfo(ProcedureContainerResolver.getUpdateInfo(insert.getGroup(), this.metadata, 2));
            return this.rewriteInsert(insert);
        }
        if (insert.getQueryExpression() != null) {
            insert.setQueryExpression((QueryCommand)this.rewriteCommand(insert.getQueryExpression(), true));
            return this.correctDatatypes(insert);
        }
        List expressions = insert.getValues();
        ArrayList<Expression> evalExpressions = new ArrayList<Expression>(expressions.size());
        for (Expression exp : expressions) {
            evalExpressions.add(this.rewriteExpressionDirect(exp));
        }
        insert.setValues(evalExpressions);
        return insert;
    }

    public static Query createInlineViewQuery(GroupSymbol inlineGroup, Command nested, QueryMetadataInterface metadata, List<? extends SingleElementSymbol> actualSymbols) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        Query query = new Query();
        Select select = new Select();
        query.setSelect(select);
        From from = new From();
        from.addClause(new UnaryFromClause(inlineGroup));
        TempMetadataStore store = new TempMetadataStore();
        TempMetadataAdapter tma = new TempMetadataAdapter(metadata, store);
        if (nested instanceof QueryCommand) {
            Query firstProject = ((QueryCommand)nested).getProjectedQuery();
            QueryRewriter.makeSelectUnique(firstProject.getSelect(), false);
        }
        TempMetadataID gid = store.addTempGroup(inlineGroup.getName(), nested.getProjectedSymbols());
        inlineGroup.setMetadataID(gid);
        ArrayList<Class> actualTypes = new ArrayList<Class>(nested.getProjectedSymbols().size());
        for (SingleElementSymbol singleElementSymbol : actualSymbols) {
            actualTypes.add(singleElementSymbol.getType());
        }
        List selectSymbols = SetQuery.getTypedProjectedSymbols(ResolverUtil.resolveElementsInGroup(inlineGroup, tma), actualTypes, tma);
        Iterator<? extends SingleElementSymbol> iterator = actualSymbols.iterator();
        for (SingleElementSymbol ses : selectSymbols) {
            ses = (SingleElementSymbol)ses.clone();
            SingleElementSymbol actual = iterator.next();
            if (!ses.getShortCanonicalName().equals(actual.getShortCanonicalName())) {
                if (ses instanceof AliasSymbol) {
                    ((AliasSymbol)ses).setShortName(actual.getShortName());
                } else {
                    ses = new AliasSymbol(actual.getShortName(), ses);
                }
            }
            select.addSymbol(ses);
        }
        query.setFrom(from);
        QueryResolver.resolveCommand(query, tma);
        query.setOption(nested.getOption());
        from.getClauses().clear();
        SubqueryFromClause sqfc = new SubqueryFromClause(inlineGroup.getName());
        sqfc.setCommand(nested);
        sqfc.getGroupSymbol().setMetadataID(inlineGroup.getMetadataID());
        from.addClause(sqfc);
        query.getTemporaryMetadata().putAll(store.getData());
        return query;
    }

    public static void makeSelectUnique(Select select, boolean expressionSymbolsOnly) {
        select.setSymbols(select.getProjectedSymbols());
        List<SelectSymbol> symbols = select.getSymbols();
        HashSet<String> uniqueNames = new HashSet<String>();
        for (int i = 0; i < symbols.size(); ++i) {
            String baseName;
            SingleElementSymbol symbol = (SingleElementSymbol)symbols.get(i);
            String name = baseName = symbol.getShortCanonicalName();
            int exprID = 0;
            while (!uniqueNames.add(name)) {
                name = baseName + '_' + exprID++;
            }
            if (expressionSymbolsOnly && !(symbol instanceof ExpressionSymbol)) continue;
            boolean hasAlias = false;
            if (symbol instanceof AliasSymbol) {
                symbol = ((AliasSymbol)symbol).getSymbol();
                hasAlias = true;
            }
            if ((!(symbol instanceof ExpressionSymbol) || hasAlias) && name.equalsIgnoreCase(baseName)) continue;
            symbols.set(i, new AliasSymbol(name, symbol));
        }
    }

    private Command rewriteUpdate(Update update) throws TeiidComponentException, TeiidProcessingException {
        UpdateValidator.UpdateInfo info = update.getUpdateInfo();
        if (info != null && info.isInherentUpdate()) {
            if (!info.getUnionBranches().isEmpty()) {
                ArrayList<Command> batchedUpdates = new ArrayList<Command>(info.getUnionBranches().size() + 1);
                for (UpdateValidator.UpdateInfo branchInfo : info.getUnionBranches()) {
                    batchedUpdates.add(this.rewriteInherentUpdate((Update)update.clone(), branchInfo));
                }
                batchedUpdates.add(0, this.rewriteInherentUpdate(update, info));
                return new BatchedUpdateCommand(batchedUpdates);
            }
            return this.rewriteInherentUpdate(update, info);
        }
        if (this.commandType == 3 && this.variables != null) {
            SetClauseList newChangeList = new SetClauseList();
            for (SetClause entry : update.getChangeList().getClauses()) {
                Expression rightExpr = entry.getValue();
                boolean retainChange = this.checkInputVariables(rightExpr);
                if (!retainChange) continue;
                newChangeList.addClause(entry.getSymbol(), entry.getValue());
            }
            update.setChangeList(newChangeList);
        }
        for (SetClause entry : update.getChangeList().getClauses()) {
            entry.setValue(this.rewriteExpressionDirect(entry.getValue()));
        }
        Criteria crit = update.getCriteria();
        if (crit != null) {
            update.setCriteria(this.rewriteCriteria(crit));
        }
        return update;
    }

    private Command rewriteInherentUpdate(Update update, UpdateValidator.UpdateInfo info) throws QueryValidatorException, QueryMetadataException, TeiidComponentException, QueryResolverException, TeiidProcessingException {
        UpdateValidator.UpdateMapping mapping = info.findUpdateMapping(update.getChangeList().getClauseMap().keySet(), false);
        if (mapping == null) {
            throw new QueryValidatorException(QueryPlugin.Util.getString("ValidationVisitor.nonUpdatable", new Object[]{update.getChangeList().getClauseMap().keySet()}));
        }
        Map<ElementSymbol, ElementSymbol> symbolMap = mapping.getUpdatableViewSymbols();
        if (info.isSimple()) {
            update.setGroup(mapping.getGroup().clone());
            for (SetClause clause : update.getChangeList().getClauses()) {
                clause.setSymbol(symbolMap.get(clause.getSymbol()));
            }
            DeepPostOrderNavigator.doVisit(update, new ExpressionMappingVisitor(symbolMap, true));
            if (info.getViewDefinition().getCriteria() != null) {
                update.setCriteria(Criteria.combineCriteria(update.getCriteria(), (Criteria)info.getViewDefinition().getCriteria().clone()));
            }
            update.setUpdateInfo(ProcedureContainerResolver.getUpdateInfo(update.getGroup(), this.metadata, 3));
            return this.rewriteUpdate(update);
        }
        Query query = (Query)info.getViewDefinition().clone();
        query.setOrderBy(null);
        SymbolMap expressionMapping = SymbolMap.createSymbolMap(update.getGroup(), query.getProjectedSymbols(), this.metadata);
        ArrayList<SingleElementSymbol> selectSymbols = this.mapChangeList(update, symbolMap);
        query.setSelect(new Select(selectSymbols));
        ExpressionMappingVisitor emv = new ExpressionMappingVisitor(expressionMapping.asMap(), true);
        PostOrderNavigator.doVisit(query.getSelect(), emv);
        Criteria crit = update.getCriteria();
        if (crit != null) {
            PostOrderNavigator.doVisit(crit, emv);
            query.setCriteria(Criteria.combineCriteria(query.getCriteria(), crit));
        }
        GroupSymbol group = mapping.getGroup();
        String correlationName = mapping.getCorrelatedName().getName();
        return this.createUpdateProcedure(update, query, group, correlationName);
    }

    private ArrayList<SingleElementSymbol> mapChangeList(Update update, Map<ElementSymbol, ElementSymbol> symbolMap) {
        ArrayList<SingleElementSymbol> selectSymbols = new ArrayList<SingleElementSymbol>(update.getChangeList().getClauses().size());
        int i = 0;
        for (SetClause clause : update.getChangeList().getClauses()) {
            Expression ex = clause.getValue();
            SingleElementSymbol selectSymbol = null;
            if (!EvaluatableVisitor.willBecomeConstant(ex)) {
                selectSymbol = !(ex instanceof SingleElementSymbol) ? new ExpressionSymbol("expr", ex) : (SingleElementSymbol)ex;
                selectSymbols.add(new AliasSymbol("s_" + i, selectSymbol));
                ex = new ElementSymbol("s_" + i);
            }
            if (symbolMap != null) {
                clause.setSymbol(symbolMap.get(clause.getSymbol()));
            }
            ++i;
        }
        return selectSymbols;
    }

    private Command createUpdateProcedure(Update update, Query query, GroupSymbol group, String correlationName) throws TeiidComponentException, QueryMetadataException, QueryResolverException, TeiidProcessingException {
        Update newUpdate = new Update();
        newUpdate.setChangeList(update.getChangeList());
        newUpdate.setGroup(group.clone());
        List<Criteria> pkCriteria = this.createPkCriteria(group, correlationName, query);
        newUpdate.setCriteria(new CompoundCriteria(pkCriteria));
        return this.asLoopProcedure(update.getGroup(), query, newUpdate);
    }

    private Command asLoopProcedure(GroupSymbol group, Query query, ProcedureContainer newUpdate) throws QueryResolverException, TeiidComponentException, TeiidProcessingException {
        Block b = new Block();
        b.addStatement(new CommandStatement(newUpdate));
        CreateUpdateProcedureCommand cupc = new CreateUpdateProcedureCommand();
        Block parent = new Block();
        LoopStatement ls = new LoopStatement(b, query, "X");
        parent.addStatement(ls);
        AssignmentStatement as = new AssignmentStatement();
        ElementSymbol rowsUpdate = new ElementSymbol("VARIABLES.ROWS_UPDATED");
        as.setVariable(rowsUpdate);
        as.setExpression(new Function("+", new Expression[]{rowsUpdate, new Constant(1)}));
        b.addStatement(as);
        cupc.setBlock(parent);
        cupc.setVirtualGroup(group);
        QueryResolver.resolveCommand(cupc, this.metadata);
        return QueryRewriter.rewrite(cupc, this.metadata, this.context);
    }

    private List<Criteria> createPkCriteria(GroupSymbol group, String correlationName, Query query) throws TeiidComponentException, QueryMetadataException {
        Object pk = this.metadata.getPrimaryKey(group.getMetadataID());
        if (pk == null) {
            pk = this.metadata.getUniqueKeysInGroup(group.getMetadataID()).iterator().next();
        }
        int i = query.getSelect().getSymbols().size();
        List ids = this.metadata.getElementIDsInKey(pk);
        ArrayList<Criteria> pkCriteria = new ArrayList<Criteria>(ids.size());
        for (Object object : ids) {
            ElementSymbol es = new ElementSymbol(correlationName + "." + this.metadata.getName(object));
            query.getSelect().addSymbol(new AliasSymbol("s_" + i, es));
            es = new ElementSymbol(group.getName() + "." + this.metadata.getName(object));
            pkCriteria.add(new CompareCriteria(es, 1, new ElementSymbol("X.s_" + i)));
            ++i;
        }
        return pkCriteria;
    }

    private boolean checkInputVariables(Expression expr) throws TeiidComponentException, TeiidProcessingException {
        Boolean result = null;
        for (ElementSymbol var : ElementCollectorVisitor.getElements((LanguageObject)expr, false)) {
            if (!var.isExternalReference() || var.getGroupSymbol().getSchema() != null || !var.getGroupSymbol().getShortName().equalsIgnoreCase("INPUTS")) continue;
            var = var.clone();
            var.getGroupSymbol().setShortName("CHANGING");
            Boolean changingValue = (Boolean)((Constant)this.variables.get(var)).getValue();
            if (result == null) {
                result = changingValue;
                continue;
            }
            if (result.equals(changingValue)) continue;
            throw new QueryValidatorException(QueryPlugin.Util.getString("VariableSubstitutionVisitor.Input_vars_should_have_same_changing_state", new Object[]{expr}));
        }
        if (result != null) {
            return result;
        }
        return true;
    }

    private Command rewriteDelete(Delete delete) throws TeiidComponentException, TeiidProcessingException {
        UpdateValidator.UpdateInfo info = delete.getUpdateInfo();
        if (info != null && info.isInherentDelete()) {
            if (!info.getUnionBranches().isEmpty()) {
                ArrayList<Command> batchedUpdates = new ArrayList<Command>(info.getUnionBranches().size() + 1);
                for (UpdateValidator.UpdateInfo branchInfo : info.getUnionBranches()) {
                    batchedUpdates.add(this.rewriteInherentDelete((Delete)delete.clone(), branchInfo));
                }
                batchedUpdates.add(0, this.rewriteInherentDelete(delete, info));
                return new BatchedUpdateCommand(batchedUpdates);
            }
            return this.rewriteInherentDelete(delete, info);
        }
        Criteria crit = delete.getCriteria();
        if (crit != null) {
            delete.setCriteria(this.rewriteCriteria(crit));
        }
        return delete;
    }

    private Command rewriteInherentDelete(Delete delete, UpdateValidator.UpdateInfo info) throws QueryMetadataException, TeiidComponentException, QueryResolverException, TeiidProcessingException {
        UpdateValidator.UpdateMapping mapping = info.getDeleteTarget();
        if (info.isSimple()) {
            delete.setGroup(mapping.getGroup().clone());
            DeepPostOrderNavigator.doVisit(delete, new ExpressionMappingVisitor(mapping.getUpdatableViewSymbols(), true));
            delete.setUpdateInfo(ProcedureContainerResolver.getUpdateInfo(delete.getGroup(), this.metadata, 4));
            if (info.getViewDefinition().getCriteria() != null) {
                delete.setCriteria(Criteria.combineCriteria(delete.getCriteria(), (Criteria)info.getViewDefinition().getCriteria().clone()));
            }
            return this.rewriteDelete(delete);
        }
        Query query = (Query)info.getViewDefinition().clone();
        query.setOrderBy(null);
        SymbolMap expressionMapping = SymbolMap.createSymbolMap(delete.getGroup(), query.getProjectedSymbols(), this.metadata);
        query.setSelect(new Select());
        ExpressionMappingVisitor emv = new ExpressionMappingVisitor(expressionMapping.asMap(), true);
        Criteria crit = delete.getCriteria();
        if (crit != null) {
            PostOrderNavigator.doVisit(crit, emv);
            query.setCriteria(Criteria.combineCriteria(query.getCriteria(), crit));
        }
        GroupSymbol group = mapping.getGroup();
        String correlationName = mapping.getCorrelatedName().getName();
        return this.createDeleteProcedure(delete, query, group, correlationName);
    }

    public static Command createDeleteProcedure(Delete delete, QueryMetadataInterface metadata, CommandContext context) throws QueryResolverException, QueryMetadataException, TeiidComponentException, TeiidProcessingException {
        QueryRewriter rewriter = new QueryRewriter(metadata, context, null);
        Criteria crit = delete.getCriteria();
        Query query = new Query(new Select(), new From(Arrays.asList(new UnaryFromClause(delete.getGroup()))), crit, null, null);
        return rewriter.createDeleteProcedure(delete, query, delete.getGroup(), delete.getGroup().getName());
    }

    public static Command createUpdateProcedure(Update update, QueryMetadataInterface metadata, CommandContext context) throws QueryResolverException, QueryMetadataException, TeiidComponentException, TeiidProcessingException {
        QueryRewriter rewriter = new QueryRewriter(metadata, context, null);
        Criteria crit = update.getCriteria();
        ArrayList<SingleElementSymbol> selectSymbols = rewriter.mapChangeList(update, null);
        Query query = new Query(new Select(selectSymbols), new From(Arrays.asList(new UnaryFromClause(update.getGroup()))), crit, null, null);
        return rewriter.createUpdateProcedure(update, query, update.getGroup(), update.getGroup().getName());
    }

    private Command createDeleteProcedure(Delete delete, Query query, GroupSymbol group, String correlationName) throws TeiidComponentException, QueryMetadataException, QueryResolverException, TeiidProcessingException {
        Delete newUpdate = new Delete();
        newUpdate.setGroup(group.clone());
        List<Criteria> pkCriteria = this.createPkCriteria(group, correlationName, query);
        newUpdate.setCriteria(new CompoundCriteria(pkCriteria));
        return this.asLoopProcedure(delete.getGroup(), query, newUpdate);
    }

    private Limit rewriteLimitClause(Limit limit) throws TeiidComponentException, TeiidProcessingException {
        if (limit.getOffset() != null) {
            limit.setOffset(this.rewriteExpressionDirect(limit.getOffset()));
            if (new Constant(0).equals(limit.getOffset())) {
                limit.setOffset(null);
            }
        }
        if (limit.getRowLimit() != null) {
            limit.setRowLimit(this.rewriteExpressionDirect(limit.getRowLimit()));
        }
        return limit;
    }

    static {
        ALIASED_FUNCTIONS.put("lower", "lcase");
        ALIASED_FUNCTIONS.put("upper", "ucase");
        ALIASED_FUNCTIONS.put("cast", "convert");
        ALIASED_FUNCTIONS.put("nvl", "ifnull");
        ALIASED_FUNCTIONS.put("||", "concat");
        ALIASED_FUNCTIONS.put("chr", "char");
        PARSE_FORMAT_TYPES = new HashSet<String>(Arrays.asList("time", "date", "timestamp", "bigdecimal", "biginteger", "integer", "long", "float", "double"));
        FUNCTION_MAP = new HashMap<String, Integer>();
        FUNCTION_MAP.put("space".toLowerCase(), 0);
        FUNCTION_MAP.put("from_unixtime".toLowerCase(), 1);
        FUNCTION_MAP.put("nullif".toLowerCase(), 2);
        FUNCTION_MAP.put("coalesce".toLowerCase(), 3);
        FUNCTION_MAP.put("CONCAT2".toLowerCase(), 4);
        FUNCTION_MAP.put("timestampadd".toLowerCase(), 5);
        FUNCTION_MAP.put("parsedate".toLowerCase(), 6);
        FUNCTION_MAP.put("parsetime".toLowerCase(), 7);
        FUNCTION_MAP.put("formatdate".toLowerCase(), 8);
        FUNCTION_MAP.put("formattime".toLowerCase(), 9);
        FUNCTION_MAP.put("trim".toLowerCase(), 10);
    }
}

