/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.Symbol;

public class GroupSymbol
extends Symbol
implements Comparable<GroupSymbol> {
    public static final String TEMP_GROUP_PREFIX = "#";
    private String definition;
    private Object metadataID;
    private boolean isTempTable;
    private boolean isGlobalTable;
    private boolean isProcedure;
    private Object modelMetadataId;
    private String outputDefinition;
    private String schema;
    private String canonicalSchema;

    protected GroupSymbol(String name, String canonicalName, String definition) {
        super(name, canonicalName);
        this.setDefinition(definition);
    }

    public GroupSymbol(String name) {
        super(name);
    }

    public GroupSymbol(String name, String definition) {
        super(name);
        this.setDefinition(definition);
    }

    public Object getModelMetadataId() {
        return this.modelMetadataId;
    }

    public void setModelMetadataId(Object modelMetadataId) {
        this.modelMetadataId = modelMetadataId;
    }

    public String getNonCorrelationName() {
        if (this.definition == null) {
            return this.getName();
        }
        return this.getDefinition();
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
        this.outputDefinition = definition;
    }

    public Object getMetadataID() {
        return this.metadataID;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public void setMetadataID(Object metadataID) {
        if (metadataID == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0016"));
        }
        this.metadataID = metadataID;
    }

    @Override
    public boolean isResolved() {
        return this.metadataID != null;
    }

    public boolean isTempGroupSymbol() {
        return this.isTempTable || this.isImplicitTempGroupSymbol();
    }

    public boolean isImplicitTempGroupSymbol() {
        return GroupSymbol.isTempGroupName(this.getNonCorrelationName());
    }

    @Override
    public int compareTo(GroupSymbol o) {
        return this.getCanonicalName().compareTo(o.getCanonicalName());
    }

    @Override
    public GroupSymbol clone() {
        GroupSymbol copy = new GroupSymbol(this.getShortName(), this.getCanonical(), this.getDefinition());
        copy.schema = this.schema;
        copy.canonicalSchema = this.canonicalSchema;
        if (this.getMetadataID() != null) {
            copy.setMetadataID(this.getMetadataID());
        }
        copy.setIsTempTable(this.isTempTable);
        copy.setProcedure(this.isProcedure);
        copy.setOutputDefinition(this.getOutputDefinition());
        copy.outputName = this.outputName;
        copy.isGlobalTable = this.isGlobalTable;
        copy.modelMetadataId = this.modelMetadataId;
        return copy;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GroupSymbol)) {
            return false;
        }
        GroupSymbol other = (GroupSymbol)obj;
        if (this.schema == null || other.schema == null) {
            return this.getCanonicalName().equals(other.getCanonicalName());
        }
        return EquivalenceUtil.areEqual((Object)this.getCanonicalSchema(), (Object)other.getCanonicalSchema()) && this.getShortCanonicalName().equals(other.getShortCanonicalName());
    }

    public boolean hasAlias() {
        return this.getDefinition() != null;
    }

    public void setIsTempTable(boolean isTempTable) {
        this.isTempTable = isTempTable;
    }

    public static boolean isTempGroupName(String name) {
        if (name == null) {
            return false;
        }
        return name.startsWith(TEMP_GROUP_PREFIX);
    }

    public boolean isTempTable() {
        return this.isTempTable;
    }

    public boolean isProcedure() {
        return this.isProcedure;
    }

    public void setProcedure(boolean isProcedure) {
        this.isProcedure = isProcedure;
    }

    public String getOutputDefinition() {
        return this.outputDefinition;
    }

    public void setOutputDefinition(String outputDefinition) {
        this.outputDefinition = outputDefinition;
    }

    public boolean isGlobalTable() {
        return this.isGlobalTable;
    }

    public void setGlobalTable(boolean isGlobalTable) {
        this.isGlobalTable = isGlobalTable;
    }

    @Override
    public String getName() {
        if (this.schema != null) {
            return this.schema + "." + this.getShortName();
        }
        return super.getName();
    }

    @Override
    public String getCanonicalName() {
        if (this.schema != null) {
            return this.getCanonicalSchema() + "." + this.getShortCanonicalName();
        }
        return super.getCanonicalName();
    }

    @Override
    public int hashCode() {
        if (this.schema != null) {
            return HashCodeUtil.hashCode((int)this.getCanonicalSchema().hashCode(), (int)this.getShortCanonicalName().hashCode());
        }
        return super.hashCode();
    }

    @Override
    public void setName(String name) {
        int index = name.indexOf(46);
        if (index > 0) {
            this.schema = new String(name.substring(0, index));
            name = new String(name.substring(index + 1));
        } else {
            this.schema = null;
        }
        this.canonicalSchema = null;
        super.setShortName(name);
    }

    private String getCanonicalSchema() {
        if (this.canonicalSchema == null && this.schema != null) {
            this.canonicalSchema = DataTypeManager.getCanonicalString((String)StringUtil.toUpperCase((String)this.schema));
        }
        return this.canonicalSchema;
    }

    public String getSchema() {
        return this.schema;
    }
}

