/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.source;

import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.SecurityFunctionEvaluator;
import org.teiid.query.util.CommandContext;

public class SecuritySystemFunctions {
    public static boolean hasRole(CommandContext context, String roleName) throws FunctionExecutionException {
        SecurityFunctionEvaluator eval = context.getSecurityFunctionEvaluator();
        if (eval == null) {
            return true;
        }
        try {
            return eval.hasRole("data", roleName);
        }
        catch (TeiidComponentException err) {
            throw new FunctionExecutionException(QueryPlugin.Event.TEIID30435, err, err.getMessage());
        }
    }

    public static boolean hasRole(CommandContext context, String roleType, String roleName) throws FunctionExecutionException {
        SecurityFunctionEvaluator eval = context.getSecurityFunctionEvaluator();
        if (eval == null) {
            return true;
        }
        try {
            return eval.hasRole(roleType, roleName);
        }
        catch (TeiidComponentException err) {
            throw new FunctionExecutionException(QueryPlugin.Event.TEIID30436, err, err.getMessage());
        }
    }
}

