/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.metadata.FunctionMetadataValidator;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.report.ActivityReport;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.validator.Validator;
import org.teiid.query.validator.ValidatorFailure;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.translator.TranslatorException;

public class MetadataValidator {
    public static ValidatorReport validate(VDBMetaData vdb, MetadataStore store) {
        ValidatorReport report = new ValidatorReport();
        if (store != null && !store.getSchemaList().isEmpty()) {
            new SourceModelArtifacts().execute(vdb, store, report);
            new ResolveQueryPlans().execute(vdb, store, report);
            new CrossSchemaResolver().execute(vdb, store, report);
            new MinimalMetadata().execute(vdb, store, report);
        }
        return report;
    }

    private static void log(ValidatorReport report, ModelMetaData model, String msg) {
        model.addError(ModelMetaData.ValidationError.Severity.ERROR.name(), msg);
        LogManager.logInfo((String)"org.teiid.PLANNER.RESOLVER", (Object)msg);
        report.handleValidationError(msg);
    }

    private static void validate(VDBMetaData vdb, ModelMetaData model, AbstractMetadataRecord record, MetadataStore store, ValidatorReport report) {
        QueryMetadataInterface metadata = (QueryMetadataInterface)vdb.getAttachment(QueryMetadataInterface.class);
        metadata = new TempMetadataAdapter(metadata, new TempMetadataStore());
        ActivityReport resolverReport = null;
        try {
            Command command;
            if (record instanceof Procedure) {
                Procedure p = (Procedure)record;
                command = QueryParser.getQueryParser().parseCommand(p.getQueryPlan());
                QueryResolver.resolveCommand(command, new GroupSymbol(p.getFullName()), 6, metadata);
                resolverReport = Validator.validate(command, metadata);
            } else if (record instanceof Table) {
                Table t = (Table)record;
                if (t.isVirtual() && (t.getColumns() == null || t.getColumns().isEmpty())) {
                    command = (QueryCommand)QueryParser.getQueryParser().parseCommand(t.getSelectTransformation());
                    QueryResolver.resolveCommand(command, metadata);
                    resolverReport = Validator.validate(command, metadata);
                    if (!resolverReport.hasItems()) {
                        List<Expression> symbols = command.getProjectedSymbols();
                        for (Expression column : symbols) {
                            try {
                                MetadataValidator.addColumn(Symbol.getShortName(column), MetadataValidator.getDataType(store.getDatatypes().values(), column.getType()), t);
                            }
                            catch (TranslatorException e) {
                                MetadataValidator.log(report, model, e.getMessage());
                            }
                        }
                    }
                }
                GroupSymbol symbol = new GroupSymbol(t.getName(), t.getFullName());
                ResolverUtil.resolveGroup(symbol, metadata);
                QueryResolver.resolveView(symbol, new QueryNode(t.getSelectTransformation()), "SELECT", metadata);
            }
            if (resolverReport != null && resolverReport.hasItems()) {
                for (ValidatorFailure v : resolverReport.getItems()) {
                    if (v.getStatus() != ValidatorFailure.Status.ERROR) continue;
                    MetadataValidator.log(report, model, v.getMessage());
                }
            }
        }
        catch (QueryParserException e) {
            MetadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31080, new Object[]{record.getFullName(), e.getFullMessage()}));
        }
        catch (QueryResolverException e) {
            MetadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31080, new Object[]{record.getFullName(), e.getFullMessage()}));
        }
        catch (TeiidComponentException e) {
            MetadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31080, new Object[]{record.getFullName(), e.getFullMessage()}));
        }
        catch (QueryValidatorException e) {
            MetadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31080, new Object[]{record.getFullName(), e.getFullMessage()}));
        }
    }

    private static Datatype getDataType(Collection<Datatype> dataTypes, Class clazz) {
        for (Datatype type : dataTypes) {
            if (!type.getJavaClassName().equals(clazz.getName())) continue;
            return type;
        }
        return null;
    }

    private static Column addColumn(String name, Datatype type, Table table) throws TranslatorException {
        Column column = new Column();
        column.setName(name);
        if (table.getColumns() != null) {
            for (Column c : table.getColumns()) {
                if (!c.getName().equalsIgnoreCase(name)) continue;
                throw new TranslatorException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31087, new Object[]{name, table.getFullName()}));
            }
        }
        table.addColumn(column);
        column.setPosition(table.getColumns().size());
        if (type == null) {
            throw new TranslatorException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31086, new Object[]{name, table.getFullName()}));
        }
        column.setDatatype(type);
        column.setDatatypeUUID(type.getUUID());
        column.setLength(type.getLength());
        column.setPrecision(type.getPrecisionLength());
        column.setRadix(type.getRadix());
        column.setRuntimeType(type.getRuntimeTypeName());
        column.setCaseSensitive(type.isCaseSensitive());
        column.setAutoIncremented(type.isAutoIncrement());
        column.setSigned(type.isSigned());
        column.setUUID("mmuuid:" + UUID.randomUUID());
        return column;
    }

    static class CrossSchemaResolver
    implements MetadataRule {
        CrossSchemaResolver() {
        }

        private boolean keyMatches(List<String> names, KeyRecord record) {
            if (names.size() != record.getColumns().size()) {
                return false;
            }
            for (int i = 0; i < names.size(); ++i) {
                if (names.get(i).equals(((Column)record.getColumns().get(i)).getName())) continue;
                return false;
            }
            return true;
        }

        @Override
        public void execute(VDBMetaData vdb, MetadataStore store, ValidatorReport report) {
            for (Schema schema : store.getSchemas().values()) {
                ModelMetaData model = vdb.getModel(schema.getName());
                for (Table t : schema.getTables().values()) {
                    List fks;
                    if (t.isVirtual() && t.isMaterialized() && t.getMaterializedTable() != null) {
                        String matTableName = t.getMaterializedTable().getName();
                        int index = matTableName.indexOf(46);
                        if (index == -1) {
                            MetadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31088, new Object[]{matTableName, t.getName()}));
                        } else {
                            String schemaName = matTableName.substring(0, index);
                            Schema matSchema = store.getSchema(schemaName);
                            if (matSchema == null) {
                                MetadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31089, new Object[]{schemaName, matTableName, t.getName()}));
                            } else {
                                Table matTable = matSchema.getTable(matTableName.substring(index + 1));
                                if (matTable == null) {
                                    MetadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31090, new Object[]{matTableName.substring(index + 1), schemaName, t.getName()}));
                                } else {
                                    t.setMaterializedTable(matTable);
                                }
                            }
                        }
                    }
                    if ((fks = t.getForeignKeys()) == null || fks.isEmpty()) continue;
                    for (ForeignKey fk : fks) {
                        if (fk.getPrimaryKey() != null) continue;
                        String referenceTableName = fk.getReferenceTableName();
                        if (referenceTableName == null && fk.getPrimaryKey() == null) {
                            MetadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31091, new Object[]{t.getName()}));
                            continue;
                        }
                        Table referenceTable = null;
                        String referenceSchemaName = schema.getName();
                        int index = referenceTableName.indexOf(46);
                        if (index == -1) {
                            referenceTable = schema.getTable(referenceTableName);
                        } else {
                            referenceSchemaName = referenceTableName.substring(0, index);
                            Schema referenceSchema = store.getSchema(referenceSchemaName);
                            if (referenceSchema == null) {
                                MetadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31093, new Object[]{referenceSchemaName, t.getName()}));
                                continue;
                            }
                            referenceTable = referenceSchema.getTable(referenceTableName.substring(index + 1));
                        }
                        if (referenceTable == null) {
                            MetadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31092, new Object[]{t.getName(), referenceTableName.substring(index + 1), referenceSchemaName}));
                            continue;
                        }
                        KeyRecord uniqueKey = null;
                        if (fk.getReferenceColumns() == null || fk.getReferenceColumns().isEmpty()) {
                            if (referenceTable.getPrimaryKey() == null) {
                                MetadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31094, new Object[]{t.getName(), referenceTableName.substring(index + 1), referenceSchemaName}));
                            } else {
                                uniqueKey = referenceTable.getPrimaryKey();
                            }
                        } else {
                            for (KeyRecord record : referenceTable.getUniqueKeys()) {
                                if (!this.keyMatches(fk.getReferenceColumns(), record)) continue;
                                uniqueKey = record;
                                break;
                            }
                            if (uniqueKey == null && referenceTable.getPrimaryKey() != null && this.keyMatches(fk.getReferenceColumns(), referenceTable.getPrimaryKey())) {
                                uniqueKey = referenceTable.getPrimaryKey();
                            }
                        }
                        if (uniqueKey == null) {
                            MetadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31095, new Object[]{t.getName(), referenceTableName.substring(index + 1), referenceSchemaName, fk.getReferenceColumns()}));
                            continue;
                        }
                        fk.setPrimaryKey(uniqueKey);
                        fk.setUniqueKeyID(uniqueKey.getUUID());
                    }
                }
            }
        }
    }

    static class ResolveQueryPlans
    implements MetadataRule {
        ResolveQueryPlans() {
        }

        @Override
        public void execute(VDBMetaData vdb, MetadataStore store, ValidatorReport report) {
            for (Schema schema : store.getSchemas().values()) {
                ModelMetaData model = vdb.getModel(schema.getName());
                for (Table t : schema.getTables().values()) {
                    if (t.getTableType() == Table.Type.Document || t.getTableType() == Table.Type.XmlMappingClass || t.getTableType() == Table.Type.XmlStagingTable || !t.isVirtual()) continue;
                    if (t.getSelectTransformation() == null) {
                        MetadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31079, new Object[]{t.getName(), model.getName()}));
                        continue;
                    }
                    MetadataValidator.validate(vdb, model, (AbstractMetadataRecord)t, store, report);
                }
                for (Procedure p : schema.getProcedures().values()) {
                    if (!p.isVirtual() || p.isFunction()) continue;
                    if (p.getQueryPlan() == null) {
                        MetadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31081, new Object[]{p.getName(), model.getName()}));
                        continue;
                    }
                    MetadataValidator.validate(vdb, model, (AbstractMetadataRecord)p, store, report);
                }
            }
        }
    }

    static class SourceModelArtifacts
    implements MetadataRule {
        SourceModelArtifacts() {
        }

        @Override
        public void execute(VDBMetaData vdb, MetadataStore store, ValidatorReport report) {
            for (Schema schema : store.getSchemas().values()) {
                ModelMetaData model = vdb.getModel(schema.getName());
                for (Table t : schema.getTables().values()) {
                    if (t.isVirtual() && model.isSource()) {
                        MetadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31074, new Object[]{t.getName(), model.getName()}));
                    }
                    if (!t.isPhysical() || model.isSource()) continue;
                    MetadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31075, new Object[]{t.getName(), model.getName()}));
                }
                for (Procedure p : schema.getProcedures().values()) {
                    if (p.isVirtual() && model.isSource()) {
                        MetadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31076, new Object[]{p.getName(), model.getName()}));
                    }
                    if (p.isVirtual() || model.isSource()) continue;
                    MetadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31077, new Object[]{p.getName(), model.getName()}));
                }
                for (FunctionMethod func : schema.getFunctions().values()) {
                    if (!func.getPushdown().equals((Object)FunctionMethod.PushDown.MUST_PUSHDOWN) || model.isSource()) continue;
                    MetadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31078, new Object[]{func.getName(), model.getName()}));
                }
            }
        }
    }

    static class MinimalMetadata
    implements MetadataRule {
        MinimalMetadata() {
        }

        @Override
        public void execute(VDBMetaData vdb, MetadataStore store, ValidatorReport report) {
            for (Schema schema : store.getSchemas().values()) {
                ModelMetaData model = vdb.getModel(schema.getName());
                if (schema.getTables().isEmpty() && schema.getProcedures().isEmpty() && schema.getFunctions().isEmpty()) {
                    MetadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31070, new Object[]{model.getName()}));
                }
                for (Table t : schema.getTables().values()) {
                    if (t.getColumns() != null && t.getColumns().size() != 0) continue;
                    MetadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31071, new Object[]{t.getName()}));
                }
                if (schema.getFunctions().isEmpty()) continue;
                ActivityReport funcReport = new ActivityReport("Translator metadata load " + model.getName());
                FunctionMetadataValidator.validateFunctionMethods(schema.getFunctions().values(), report);
                if (!report.hasItems()) continue;
                MetadataValidator.log(report, model, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31073, new Object[]{funcReport}));
            }
        }
    }

    static interface MetadataRule {
        public void execute(VDBMetaData var1, MetadataStore var2, ValidatorReport var3);
    }
}

