/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.xml.XMLPlannerEnvironment;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.navigator.DeepPreOrderNavigator;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.ReferenceCollectorVisitor;
import org.teiid.query.util.CommandContext;

public class QueryUtil {
    static Command getQuery(String groupName, QueryNode queryNode, XMLPlannerEnvironment env) throws QueryPlannerException {
        Command query = queryNode.getCommand();
        if (query == null) {
            try {
                query = QueryParser.getQueryParser().parseCommand(queryNode.getQuery());
                QueryResolver.resolveWithBindingMetadata(query, env.getGlobalMetadata().getDesignTimeMetadata(), queryNode, true);
            }
            catch (TeiidException e) {
                throw new QueryPlannerException(QueryPlugin.Event.TEIID30281, e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30281, new Object[]{groupName, queryNode.getQuery()}));
            }
        }
        return query;
    }

    static Command rewriteQuery(Command query, QueryMetadataInterface metadata, CommandContext context) throws QueryPlannerException, TeiidComponentException {
        try {
            return QueryRewriter.rewrite(query, metadata, context);
        }
        catch (TeiidProcessingException e) {
            throw new QueryPlannerException(QueryPlugin.Event.TEIID30282, e, e.getMessage());
        }
    }

    static QueryNode getQueryNode(String groupName, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        QueryNode queryNode = null;
        try {
            GroupSymbol gs = new GroupSymbol(groupName);
            ResolverUtil.resolveGroup(gs, metadata);
            queryNode = metadata.getVirtualPlan(gs.getMetadataID());
        }
        catch (QueryResolverException e) {
            throw new QueryPlannerException(QueryPlugin.Event.TEIID30283, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30283, new Object[]{groupName}));
        }
        return queryNode;
    }

    static Query wrapQuery(FromClause fromClause, String groupName) {
        Select select = new Select();
        select.addSymbol(new MultipleElementSymbol(groupName));
        Query query = new Query();
        query.setSelect(select);
        From from = new From();
        from.addClause(fromClause);
        query.setFrom(from);
        return query;
    }

    public static GroupSymbol createResolvedGroup(String groupName, QueryMetadataInterface metadata) throws TeiidComponentException {
        GroupSymbol group = new GroupSymbol(groupName);
        return QueryUtil.createResolvedGroup(group, metadata);
    }

    public static GroupSymbol createResolvedGroup(GroupSymbol group, QueryMetadataInterface metadata) throws TeiidComponentException {
        try {
            ResolverUtil.resolveGroup(group, metadata);
            return group;
        }
        catch (QueryResolverException e) {
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30284, (Throwable)((Object)e));
        }
    }

    static Command getQueryFromQueryNode(String groupName, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        QueryNode queryNode = QueryUtil.getQueryNode(groupName, planEnv.getGlobalMetadata());
        Command command = QueryUtil.getQuery(groupName, queryNode, planEnv);
        return command;
    }

    static void markBindingsAsNonExternal(LanguageObject object, Collection<ElementSymbol> allBindings) {
        ArrayList elements = new ArrayList();
        ElementCollectorVisitor visitor = new ElementCollectorVisitor(elements);
        DeepPreOrderNavigator.doVisit(object, visitor);
        for (ElementSymbol elementSymbol : elements) {
            if (!allBindings.contains(elementSymbol)) continue;
            elementSymbol.setIsExternalReference(false);
            elementSymbol.setMetadataID(null);
        }
    }

    static Collection<ElementSymbol> getBindingElements(QueryNode queryNode) throws TeiidComponentException {
        HashSet<ElementSymbol> set = new HashSet<ElementSymbol>();
        ElementCollectorVisitor.getElements(QueryResolver.parseBindings(queryNode), set);
        return set;
    }

    static List<ElementSymbol> getBindingsReferences(LanguageObject object, Collection<ElementSymbol> allBindings) {
        LinkedList<ElementSymbol> elements = new LinkedList<ElementSymbol>();
        ElementCollectorVisitor visitor = new ElementCollectorVisitor(elements);
        DeepPreOrderNavigator.doVisit(object, visitor);
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            ElementSymbol elementSymbol = (ElementSymbol)i.next();
            if (elementSymbol.isExternalReference() && allBindings.contains(elementSymbol)) continue;
            i.remove();
        }
        return elements;
    }

    static Map createSymbolMap(GroupSymbol oldGroup, String newGroup, Collection projectedElements) {
        HashMap<Symbol, Symbol> symbolMap = new HashMap<Symbol, Symbol>();
        symbolMap.put(oldGroup, new GroupSymbol(newGroup));
        for (ElementSymbol element : projectedElements) {
            symbolMap.put(element, new ElementSymbol(newGroup + "." + element.getShortName()));
        }
        return symbolMap;
    }

    static List<Reference> getReferences(Command command) {
        ArrayList<Reference> boundList = new ArrayList<Reference>();
        for (Reference ref : ReferenceCollectorVisitor.getReferences(command)) {
            ElementSymbol expr = ref.getExpression();
            if (!(expr instanceof ElementSymbol)) continue;
            ElementSymbol elem = expr;
            if (!command.getExternalGroupContexts().getGroups().contains(elem.getGroupSymbol())) continue;
            boundList.add(ref);
        }
        return boundList;
    }
}

