/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.proc;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.client.plan.PlanNode;
import org.teiid.client.xa.XATransactionException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.IndexedTupleSource;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.Assertion;
import org.teiid.dqp.internal.process.DataTierTupleSource;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.dqp.service.TransactionService;
import org.teiid.events.EventDistributor;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.processor.BatchIterator;
import org.teiid.query.processor.CollectionTupleSource;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.proc.Program;
import org.teiid.query.processor.proc.ProgramInstruction;
import org.teiid.query.processor.proc.RepeatedInstruction;
import org.teiid.query.processor.relational.SubqueryAwareEvaluator;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.util.VariableContext;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.query.util.CommandContext;

public class ProcedurePlan
extends ProcessorPlan {
    private Program originalProgram;
    private ProcessorDataManager dataMgr;
    private ProcessorDataManager parentDataMrg;
    private BufferManager bufferMgr;
    private int batchSize;
    private boolean done = false;
    private CursorState currentState;
    private TupleSource finalTupleSource;
    private int beginBatch = 1;
    private List<Object> batchRows;
    private boolean lastBatch = false;
    private LinkedHashMap<ElementSymbol, Expression> params;
    private List<ElementSymbol> outParams;
    private QueryMetadataInterface metadata;
    private Map<String, CursorState> cursorStates = new HashMap<String, CursorState>();
    static ElementSymbol ROWCOUNT = new ElementSymbol("VARIABLES.ROWCOUNT");
    private VariableContext currentVarContext;
    private TupleSource lastTupleSource;
    private List outputElements;
    private SubqueryAwareEvaluator evaluator;
    private Stack<Program> programs = new Stack();
    private boolean evaluatedParams;
    private boolean requiresTransaction = true;
    private TransactionContext blockContext;
    private boolean inTxn;
    private LinkedList<WeakReference<DataTierTupleSource>> txnTupleSources = new LinkedList();

    public ProcedurePlan(Program originalProgram) {
        this.originalProgram = originalProgram;
        this.createVariableContext();
    }

    public Program getOriginalProgram() {
        return this.originalProgram;
    }

    @Override
    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        this.bufferMgr = bufferMgr;
        this.batchSize = bufferMgr.getProcessorBatchSize(this.getOutputElements());
        this.setContext(context.clone());
        this.dataMgr = new ProcessorDataManager(){

            @Override
            public TupleSource registerRequest(CommandContext context, Command command, String modelName, String connectorBindingId, int nodeID, int limit) throws TeiidComponentException, TeiidProcessingException {
                TupleSource ts = ProcedurePlan.this.parentDataMrg.registerRequest(context, command, modelName, connectorBindingId, nodeID, limit);
                if (ProcedurePlan.this.blockContext != null && ts instanceof DataTierTupleSource) {
                    ProcedurePlan.this.txnTupleSources.add(new WeakReference<DataTierTupleSource>((DataTierTupleSource)ts));
                }
                return ts;
            }

            @Override
            public Object lookupCodeValue(CommandContext context, String codeTableName, String returnElementName, String keyElementName, Object keyValue) throws BlockedException, TeiidComponentException, TeiidProcessingException {
                return ProcedurePlan.this.parentDataMrg.lookupCodeValue(context, codeTableName, returnElementName, keyElementName, keyValue);
            }

            @Override
            public EventDistributor getEventDistributor() {
                return ProcedurePlan.this.parentDataMrg.getEventDistributor();
            }
        };
        this.parentDataMrg = dataMgr;
        if (this.evaluator == null) {
            this.evaluator = new SubqueryAwareEvaluator(Collections.emptyMap(), this.getDataManager(), this.getContext(), this.bufferMgr);
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.evaluator != null) {
            this.evaluator.reset();
        }
        this.evaluatedParams = false;
        this.cursorStates.clear();
        this.createVariableContext();
        this.lastTupleSource = null;
        this.done = false;
        this.currentState = null;
        this.finalTupleSource = null;
        this.beginBatch = 1;
        this.batchRows = null;
        this.lastBatch = false;
        this.inTxn = false;
        this.programs.clear();
        LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"ProcedurePlan reset"});
    }

    public ProcessorDataManager getDataManager() {
        return this.dataMgr;
    }

    @Override
    public void open() throws TeiidProcessingException, TeiidComponentException {
        if (!this.evaluatedParams) {
            if (this.outParams != null) {
                for (ElementSymbol elementSymbol : this.outParams) {
                    this.setParameterValue(elementSymbol, this.getCurrentVariableContext(), null);
                }
            }
            if (this.params != null) {
                for (Map.Entry entry : this.params.entrySet()) {
                    ElementSymbol param = (ElementSymbol)entry.getKey();
                    Expression expr = (Expression)entry.getValue();
                    VariableContext context = this.getCurrentVariableContext();
                    Object value = this.evaluateExpression(expr);
                    this.checkNotNull(param, value);
                    this.setParameterValue(param, context, value);
                }
            }
            this.push(this.originalProgram);
        }
        this.evaluatedParams = true;
    }

    private void checkNotNull(ElementSymbol param, Object value) throws TeiidComponentException, QueryMetadataException, QueryValidatorException {
        if (value == null && !this.metadata.elementSupports(param.getMetadataID(), 4)) {
            throw new QueryValidatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30164, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30164, new Object[]{param}));
        }
    }

    protected void setParameterValue(ElementSymbol param, VariableContext context, Object value) {
        context.setValue(param, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TupleBatch nextBatch() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.blockContext != null && !this.inTxn) {
            this.getContext().getTransactionServer().resume(this.blockContext);
            this.inTxn = true;
        }
        try {
            TupleBatch tupleBatch = this.nextBatchDirect();
            return tupleBatch;
        }
        finally {
            if (this.blockContext != null) {
                this.inTxn = false;
                this.getContext().getTransactionServer().suspend(this.blockContext);
            }
        }
    }

    public TupleBatch nextBatchDirect() throws TeiidComponentException, TeiidProcessingException, BlockedException {
        if (this.done) {
            TupleBatch emptyTerminationBatch = new TupleBatch(this.beginBatch, new List[0]);
            emptyTerminationBatch.setTerminationFlag(true);
            return emptyTerminationBatch;
        }
        if (this.finalTupleSource == null) {
            this.finalTupleSource = this.processProcedure();
        }
        while (!this.isBatchFull()) {
            List<?> tuple = this.finalTupleSource.nextTuple();
            if (tuple == null) {
                if (this.outParams != null) {
                    VariableContext vc = this.getCurrentVariableContext();
                    List<Object> paramTuple = Arrays.asList(new Object[this.getOutputElements().size()]);
                    int i = this.getOutputElements().size() - this.outParams.size();
                    for (ElementSymbol param : this.outParams) {
                        Object value = vc.getValue(param);
                        this.checkNotNull(param, value);
                        paramTuple.set(i++, value);
                    }
                    this.addBatchRow(paramTuple, true);
                }
                this.terminateBatches();
                this.done = true;
                break;
            }
            this.addBatchRow(tuple, false);
        }
        return this.pullBatch();
    }

    private TupleSource processProcedure() throws TeiidComponentException, TeiidProcessingException, BlockedException {
        ProgramInstruction inst = null;
        while (!this.programs.empty()) {
            Program program = this.peek();
            inst = program.getCurrentInstruction();
            if (inst == null) {
                LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Finished program", program});
                this.pop(true);
                continue;
            }
            if (inst instanceof RepeatedInstruction) {
                LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Executing repeated instruction", inst});
                RepeatedInstruction loop = (RepeatedInstruction)((Object)inst);
                if (loop.testCondition(this)) {
                    LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Passed condition, executing program " + loop.getNestedProgram()});
                    inst.process(this);
                    this.push(loop.getNestedProgram());
                    continue;
                }
                LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Exiting repeated instruction", inst});
                loop.postInstruction(this);
            } else {
                LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Executing instruction", inst});
                inst.process(this);
            }
            program.incrementProgramCounter();
        }
        if (this.lastTupleSource == null) {
            return CollectionTupleSource.createNullTupleSource();
        }
        return this.lastTupleSource;
    }

    @Override
    public void close() throws TeiidComponentException {
        if (!this.cursorStates.isEmpty()) {
            ArrayList<String> cursors = new ArrayList<String>(this.cursorStates.keySet());
            for (String rsName : cursors) {
                this.removeResults(rsName);
            }
        }
        while (!this.programs.isEmpty()) {
            try {
                this.pop(false);
            }
            catch (TeiidComponentException e) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Throwable)e, (Object[])new Object[]{"Error closing program"});
            }
        }
        if (this.evaluator != null) {
            this.evaluator.close();
        }
        this.dataMgr = this.parentDataMrg;
        this.txnTupleSources.clear();
        this.blockContext = null;
    }

    public String toString() {
        return "ProcedurePlan:\n" + this.originalProgram;
    }

    @Override
    public ProcessorPlan clone() {
        ProcedurePlan plan = new ProcedurePlan((Program)this.originalProgram.clone());
        plan.setOutputElements(this.getOutputElements());
        plan.setParams(this.params);
        plan.setOutParams(this.outParams);
        plan.setMetadata(this.metadata);
        plan.requiresTransaction = this.requiresTransaction;
        return plan;
    }

    private void addBatchRow(List<?> row, boolean last) {
        if (this.batchRows == null) {
            this.batchRows = new ArrayList<Object>(this.batchSize / 4);
        }
        if (!last && this.outParams != null) {
            List<Object> newRow = Arrays.asList(new Object[row.size() + this.outParams.size()]);
            for (int i = 0; i < row.size(); ++i) {
                newRow.set(i, row.get(i));
            }
            row = newRow;
        }
        this.batchRows.add(row);
    }

    protected void terminateBatches() {
        this.lastBatch = true;
    }

    protected boolean isBatchFull() {
        return this.batchRows != null && this.batchRows.size() == this.batchSize;
    }

    protected TupleBatch pullBatch() {
        TupleBatch batch = null;
        if (this.batchRows != null) {
            batch = new TupleBatch(this.beginBatch, this.batchRows);
            this.beginBatch += this.batchRows.size();
        } else {
            batch = new TupleBatch(this.beginBatch, Collections.EMPTY_LIST);
        }
        batch.setTerminationFlag(this.lastBatch);
        this.batchRows = null;
        this.lastBatch = false;
        return batch;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode node = this.originalProgram.getDescriptionProperties();
        node.addProperty("Output Columns", AnalysisRecord.getOutputColumnProperties(this.getOutputElements()));
        return node;
    }

    public void setMetadata(QueryMetadataInterface metadata) {
        this.metadata = metadata;
    }

    public void setOutParams(List<ElementSymbol> outParams) {
        this.outParams = outParams;
    }

    public void setParams(LinkedHashMap<ElementSymbol, Expression> params) {
        this.params = params;
    }

    private void createVariableContext() {
        this.currentVarContext = new VariableContext(true);
        this.currentVarContext.setValue(ROWCOUNT, 0);
    }

    public VariableContext getCurrentVariableContext() {
        return this.currentVarContext;
    }

    public void executePlan(ProcessorPlan command, String rsName, Map<ElementSymbol, ElementSymbol> procAssignments, boolean keepRs) throws TeiidComponentException, TeiidProcessingException {
        CursorState state = this.cursorStates.get(rsName.toUpperCase());
        if (state == null) {
            if (this.currentState == null) {
                command.reset();
                CommandContext subContext = this.getContext().clone();
                subContext.setVariableContext(this.currentVarContext);
                state = new CursorState();
                state.processor = new QueryProcessor(command, subContext, this.bufferMgr, this.dataMgr);
                state.ts = new BatchIterator(state.processor);
                if (procAssignments != null && state.processor.getOutputElements().size() - procAssignments.size() > 0) {
                    state.resultsBuffer = this.bufferMgr.createTupleBuffer(state.processor.getOutputElements().subList(0, state.processor.getOutputElements().size() - procAssignments.size()), this.getContext().getConnectionId(), BufferManager.TupleSourceType.PROCESSOR);
                } else if (this.blockContext != null) {
                    state.resultsBuffer = this.bufferMgr.createTupleBuffer(state.processor.getOutputElements(), this.getContext().getConnectionId(), BufferManager.TupleSourceType.PROCESSOR);
                }
                this.currentState = state;
            }
            this.currentState.ts.hasNext();
            if (procAssignments != null) {
                while (this.currentState.ts.hasNext()) {
                    if (this.currentState.currentRow != null && this.currentState.resultsBuffer != null) {
                        this.currentState.resultsBuffer.addTuple(this.currentState.currentRow.subList(0, this.currentState.resultsBuffer.getSchema().size()));
                        this.currentState.currentRow = null;
                    }
                    this.currentState.currentRow = this.currentState.ts.nextTuple();
                }
                Assertion.assertTrue((this.currentState.currentRow != null ? 1 : 0) != 0);
                for (Map.Entry<ElementSymbol, ElementSymbol> entry : procAssignments.entrySet()) {
                    if (entry.getValue() == null || !this.metadata.elementSupports(entry.getValue().getMetadataID(), 5)) continue;
                    int index = this.currentState.processor.getOutputElements().indexOf(entry.getKey());
                    this.getCurrentVariableContext().setValue(entry.getValue(), DataTypeManager.transformValue(this.currentState.currentRow.get(index), entry.getValue().getType()));
                }
                if (this.currentState.resultsBuffer == null) {
                    this.currentState.processor.closeProcessing();
                    this.currentState = null;
                    return;
                }
                this.currentState.resultsBuffer.close();
                this.currentState.ts = this.currentState.resultsBuffer.createIndexedTupleSource();
            } else if (this.blockContext != null) {
                while (this.currentState.ts.hasNext()) {
                    List<?> tuple = this.currentState.ts.nextTuple();
                    this.currentState.resultsBuffer.addTuple(tuple);
                }
                this.currentState.resultsBuffer.close();
                this.currentState.ts = this.currentState.resultsBuffer.createIndexedTupleSource();
            }
            this.cursorStates.put(rsName.toUpperCase(), this.currentState);
            if (keepRs) {
                this.lastTupleSource = this.currentState.ts;
            }
            this.currentState = null;
        }
    }

    public void pop(boolean success) throws TeiidComponentException {
        Program program = this.programs.pop();
        if (this.currentVarContext.getParentContext() != null) {
            this.currentVarContext = this.currentVarContext.getParentContext();
        }
        program.getTempTableStore().removeTempTables();
        if (program.startedTxn() && this.blockContext != null) {
            TransactionService ts = this.getContext().getTransactionServer();
            TransactionContext tc = this.blockContext;
            this.blockContext = null;
            try {
                if (!this.inTxn) {
                    this.getContext().getTransactionServer().resume(tc);
                }
                for (WeakReference weakReference : this.txnTupleSources) {
                    DataTierTupleSource dtts = (DataTierTupleSource)weakReference.get();
                    if (dtts == null) continue;
                    dtts.fullyCloseSource();
                }
                this.txnTupleSources.clear();
                if (success) {
                    ts.commit(tc);
                } else {
                    ts.rollback(tc);
                }
            }
            catch (XATransactionException e) {
                throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30165, (Throwable)e);
            }
        }
    }

    public void push(Program program) throws XATransactionException {
        TransactionContext tc;
        program.reset(this.getContext().getConnectionId());
        TempTableStore tts = this.getTempTableStore();
        this.getContext().setTempTableStore(program.getTempTableStore());
        program.getTempTableStore().setParentTempTableStore(tts);
        this.programs.push(program);
        VariableContext context = new VariableContext(true);
        context.setParentContext(this.currentVarContext);
        this.currentVarContext = context;
        if (program.isAtomic() && (tc = this.getContext().getTransactionContext()) != null && tc.getTransactionType() == TransactionContext.Scope.NONE) {
            this.getContext().getTransactionServer().begin(tc);
            this.inTxn = true;
            this.blockContext = tc;
            this.peek().setStartedTxn(true);
        }
    }

    public void incrementProgramCounter() throws TeiidComponentException {
        if (this.programs.isEmpty()) {
            return;
        }
        Program program = this.peek();
        ProgramInstruction instr = program.getCurrentInstruction();
        if (instr instanceof RepeatedInstruction) {
            RepeatedInstruction repeated = (RepeatedInstruction)((Object)instr);
            repeated.postInstruction(this);
        }
        this.peek().incrementProgramCounter();
    }

    public List<?> getCurrentRow(String rsName) throws TeiidComponentException {
        return this.getCursorState((String)rsName.toUpperCase()).currentRow;
    }

    public boolean iterateCursor(String rsName) throws TeiidComponentException, TeiidProcessingException {
        String rsKey = rsName.toUpperCase();
        CursorState state = this.getCursorState(rsKey);
        state.currentRow = state.ts.nextTuple();
        return state.currentRow != null;
    }

    private CursorState getCursorState(String rsKey) throws TeiidComponentException {
        CursorState state = this.cursorStates.get(rsKey);
        if (state == null) {
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30166, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30166, new Object[]{rsKey}));
        }
        return state;
    }

    public void removeResults(String rsName) {
        String rsKey = rsName.toUpperCase();
        CursorState state = this.cursorStates.remove(rsKey);
        if (state != null) {
            state.processor.closeProcessing();
            if (state.resultsBuffer != null) {
                state.resultsBuffer.remove();
            }
        }
    }

    public List getSchema(String rsName) throws TeiidComponentException {
        String rsKey = rsName.toUpperCase();
        CursorState cursorState = this.getCursorState(rsKey);
        List schema = cursorState.processor.getOutputElements();
        return schema;
    }

    public boolean resultSetExists(String rsName) {
        String rsKey = rsName.toUpperCase();
        boolean exists = this.cursorStates.containsKey(rsKey);
        return exists;
    }

    @Override
    public CommandContext getContext() {
        CommandContext context = super.getContext();
        if (this.evaluatedParams) {
            context.setVariableContext(this.currentVarContext);
        }
        return context;
    }

    @Override
    public List getOutputElements() {
        return this.outputElements;
    }

    public void setOutputElements(List outputElements) {
        this.outputElements = outputElements;
    }

    public TempTableStore getTempTableStore() {
        if (this.programs.isEmpty()) {
            return null;
        }
        return this.peek().getTempTableStore();
    }

    boolean evaluateCriteria(Criteria condition) throws BlockedException, TeiidProcessingException, TeiidComponentException {
        this.evaluator.initialize(this.getContext(), this.getDataManager());
        boolean result = this.evaluator.evaluate(condition, Collections.emptyList());
        this.evaluator.close();
        return result;
    }

    Object evaluateExpression(Expression expression) throws BlockedException, TeiidProcessingException, TeiidComponentException {
        this.evaluator.initialize(this.getContext(), this.getDataManager());
        Object result = this.evaluator.evaluate(expression, Collections.emptyList());
        this.evaluator.close();
        return result;
    }

    public Program peek() {
        return this.programs.peek();
    }

    public void setRequiresTransaction(boolean requiresTransaction) {
        this.requiresTransaction = requiresTransaction;
    }

    @Override
    public boolean requiresTransaction(boolean transactionalReads) {
        return this.requiresTransaction || transactionalReads;
    }

    static {
        ROWCOUNT.setType(DataTypeManager.DefaultDataClasses.INTEGER);
    }

    private static class CursorState {
        QueryProcessor processor;
        IndexedTupleSource ts;
        List<?> currentRow;
        TupleBuffer resultsBuffer;

        private CursorState() {
        }
    }
}

