/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.AbstractSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.teiid.common.buffer.IndexedTupleSource;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.Assertion;
import org.teiid.query.processor.relational.TupleSourceValueIterator;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.util.ValueIterator;
import org.teiid.query.sql.util.ValueIteratorSource;

public class DependentValueSource
implements ValueIteratorSource {
    private TupleBuffer buffer;
    private Map<Expression, Set<Object>> cachedSets;
    private boolean unused;
    private boolean distinct;

    public DependentValueSource(TupleBuffer tupleSourceID) {
        this.buffer = tupleSourceID;
    }

    public TupleBuffer getTupleBuffer() {
        return this.buffer;
    }

    @Override
    public ValueIterator getValueIterator(Expression valueExpression) throws TeiidComponentException {
        IndexedTupleSource its = this.buffer.createIndexedTupleSource();
        int index = 0;
        if (valueExpression != null) {
            index = this.buffer.getSchema().indexOf(valueExpression);
            Assertion.assertTrue((index != -1 ? 1 : 0) != 0);
        }
        return new TupleSourceValueIterator(its, index);
    }

    @Override
    public Set<Object> getCachedSet(Expression valueExpression) throws TeiidComponentException, TeiidProcessingException {
        AbstractSet result = null;
        if (this.cachedSets != null) {
            result = this.cachedSets.get(valueExpression);
        }
        if (result == null) {
            if (this.buffer.getRowCount() > this.buffer.getBatchSize()) {
                return null;
            }
            IndexedTupleSource its = this.buffer.createIndexedTupleSource();
            int index = 0;
            if (valueExpression != null) {
                index = this.buffer.getSchema().indexOf(valueExpression);
            }
            Assertion.assertTrue((index != -1 ? 1 : 0) != 0);
            Class<?> type = this.buffer.getSchema().get(index).getType();
            result = !DataTypeManager.isHashable(type) ? new TreeSet<Object>() : new HashSet<Object>();
            while (its.hasNext()) {
                Object value = its.nextTuple().get(index);
                if (value == null) continue;
                result.add(value);
            }
            its.closeSource();
            if (this.cachedSets == null) {
                this.cachedSets = new HashMap<Expression, Set<Object>>();
            }
            this.cachedSets.put(valueExpression, result);
        }
        return result;
    }

    @Override
    public boolean isUnused() {
        return this.unused;
    }

    @Override
    public void setUnused(boolean unused) {
        this.unused = unused;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }
}

