/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.sql.Blob;
import java.sql.SQLXML;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.activation.DataSource;
import javax.xml.transform.Source;
import org.teiid.client.SourceWarning;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.FileStoreInputStreamFactory;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.StandardXMLTranslator;
import org.teiid.core.types.Streamable;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.XMLTranslator;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.dqp.internal.datamgr.ConnectorWork;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DataTierManagerImpl;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.AtomicResultsMessage;
import org.teiid.events.EventDistributor;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.processor.relational.RelationalNodeUtil;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.translator.CacheDirective;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.TranslatorException;

public class DataTierTupleSource
implements TupleSource,
DQPCore.CompletionListener<AtomicResultsMessage> {
    private final AtomicRequestMessage aqr;
    private final RequestWorkItem workItem;
    private final ConnectorWork cwi;
    private final DataTierManagerImpl dtm;
    private boolean[] convertToRuntimeType;
    private boolean[] convertToDesiredRuntimeType;
    private boolean[] isLob;
    private FileStore lobStore;
    private byte[] lobBuffer;
    private Class<?>[] schema;
    private int limit = -1;
    private int index;
    private int rowsProcessed;
    private AtomicResultsMessage arm;
    private AtomicBoolean closed = new AtomicBoolean();
    private volatile boolean canAsynchClose;
    private volatile boolean canceled;
    private volatile boolean cancelAsynch;
    private boolean executed;
    private volatile boolean done;
    private boolean explicitClose;
    private volatile DQPCore.FutureWork<AtomicResultsMessage> futureResult;
    private volatile boolean running;
    boolean errored;
    CacheDirective.Scope scope;
    private long waitUntil;
    private ScheduledFuture<?> scheduledFuture;

    public DataTierTupleSource(AtomicRequestMessage aqr, RequestWorkItem workItem, ConnectorWork cwi, DataTierManagerImpl dtm, int limit) {
        this.aqr = aqr;
        this.workItem = workItem;
        this.cwi = cwi;
        this.dtm = dtm;
        this.limit = limit;
        List<Expression> symbols = this.aqr.getCommand().getProjectedSymbols();
        this.schema = new Class[symbols.size()];
        this.convertToDesiredRuntimeType = new boolean[symbols.size()];
        this.convertToRuntimeType = new boolean[symbols.size()];
        this.isLob = new boolean[symbols.size()];
        for (int i = 0; i < symbols.size(); ++i) {
            Expression symbol = symbols.get(i);
            this.schema[i] = symbol.getType();
            this.convertToDesiredRuntimeType[i] = true;
            this.convertToRuntimeType[i] = true;
            this.isLob[i] = DataTypeManager.isLOB(this.schema[i]);
        }
        Assertion.isNull((Object)workItem.getConnectorRequest(aqr.getAtomicRequestID()));
        workItem.addConnectorRequest(aqr.getAtomicRequestID(), this);
        if (!aqr.isSerial()) {
            this.addWork();
        }
    }

    private void addWork() {
        this.canAsynchClose = true;
        this.futureResult = this.workItem.addWork(new Callable<AtomicResultsMessage>(){

            @Override
            public AtomicResultsMessage call() throws Exception {
                return DataTierTupleSource.this.getResults();
            }
        }, this, 100);
    }

    private List<?> correctTypes(List<Object> row) throws TransformationException, TeiidComponentException {
        for (int i = 0; i < row.size(); ++i) {
            Streamable<?> result;
            Object value = row.get(i);
            if (value == null) continue;
            if (this.convertToRuntimeType[i]) {
                result = this.convertToRuntimeType(value, this.schema[i]);
                if (value == result && !DataTypeManager.DefaultDataClasses.OBJECT.equals(this.schema[i])) {
                    this.convertToRuntimeType[i] = false;
                } else {
                    if (this.isLob[i] && !this.cwi.copyLobs() && !this.cwi.areLobsUsableAfterClose() && DataTypeManager.isLOB(value.getClass())) {
                        this.explicitClose = true;
                    }
                    row.set(i, result);
                    value = result;
                }
            }
            if (this.convertToDesiredRuntimeType[i]) {
                if (value == null) continue;
                result = DataTypeManager.transformValue((Object)value, value.getClass(), this.schema[i]);
                if (this.isLob[i] && this.cwi.copyLobs()) {
                    if (this.lobStore == null) {
                        this.lobStore = this.dtm.getBufferManager().createFileStore("lobs");
                        this.lobBuffer = new byte[16384];
                    }
                    result = this.dtm.getBufferManager().persistLob((Streamable)result, this.lobStore, this.lobBuffer);
                } else if (value == result) {
                    this.convertToDesiredRuntimeType[i] = false;
                    continue;
                }
                row.set(i, result);
                continue;
            }
            if (!DataTypeManager.isValueCacheEnabled()) continue;
            row.set(i, DataTypeManager.getCanonicalValue((Object)value));
        }
        return row;
    }

    private Object convertToRuntimeType(Object value, Class<?> desiredType) throws TransformationException {
        if (value instanceof DataSource && (!(value instanceof Source) || desiredType != DataTypeManager.DefaultDataClasses.XML)) {
            if (value instanceof InputStreamFactory) {
                return new BlobType((Blob)new BlobImpl((InputStreamFactory)value));
            }
            FileStore fs = this.dtm.getBufferManager().createFileStore("bytes");
            FileStoreInputStreamFactory fsisf = new FileStoreInputStreamFactory(fs, "UTF-8");
            try {
                ObjectConverterUtil.write((OutputStream)fsisf.getOuputStream(), (InputStream)((DataSource)value).getInputStream(), (int)-1);
            }
            catch (IOException e) {
                throw new TransformationException((BundleUtil.Event)QueryPlugin.Event.TEIID30500, (Throwable)e, e.getMessage());
            }
            return new BlobType((Blob)new BlobImpl((InputStreamFactory)fsisf));
        }
        if (value instanceof Source) {
            SQLXMLImpl sqlxml;
            if (value instanceof InputStreamFactory) {
                return new XMLType((SQLXML)new SQLXMLImpl((InputStreamFactory)value));
            }
            StandardXMLTranslator sxt = new StandardXMLTranslator((Source)value);
            try {
                sqlxml = XMLSystemFunctions.saveToBufferManager(this.dtm.getBufferManager(), (XMLTranslator)sxt);
            }
            catch (TeiidComponentException e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
            catch (TeiidProcessingException e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
            return new XMLType((SQLXML)sqlxml);
        }
        return DataTypeManager.convertToRuntimeType((Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<?> nextTuple() throws TeiidComponentException, TeiidProcessingException {
        if (this.waitUntil > 0L && this.waitUntil > System.currentTimeMillis()) {
            if (!this.cwi.isDataAvailable()) {
                throw BlockedException.block(this.aqr.getAtomicRequestID(), "Blocking until", this.waitUntil);
            }
            this.waitUntil = 0L;
        }
        while (true) {
            if (this.arm == null) {
                AtomicResultsMessage results;
                boolean partial;
                block17: {
                    if (this.isDone()) {
                        return null;
                    }
                    partial = false;
                    results = null;
                    boolean noResults = false;
                    try {
                        long ts;
                        results = this.futureResult != null || !this.aqr.isSerial() ? this.asynchGet() : this.getResults();
                        if (this.index != 0 || !this.dtm.detectChangeEvents()) break block17;
                        Command command = this.aqr.getCommand();
                        int commandIndex = 0;
                        if (RelationalNodeUtil.isUpdate(command)) {
                            ts = System.currentTimeMillis();
                            this.checkForUpdates(results, command, this.dtm.getEventDistributor(), commandIndex, ts);
                            break block17;
                        }
                        if (!(command instanceof BatchedUpdateCommand)) break block17;
                        ts = System.currentTimeMillis();
                        BatchedUpdateCommand bac = (BatchedUpdateCommand)command;
                        for (Command uc : bac.getUpdateCommands()) {
                            this.checkForUpdates(results, uc, this.dtm.getEventDistributor(), commandIndex++, ts);
                        }
                    }
                    catch (TranslatorException e) {
                        this.errored = true;
                        results = this.exceptionOccurred(e);
                        partial = true;
                    }
                    catch (BlockedException e) {
                        noResults = true;
                        throw e;
                    }
                    catch (DataNotAvailableException e) {
                        noResults = true;
                        this.handleDataNotAvailable(e);
                        continue;
                    }
                    finally {
                        if (noResults || results != null) continue;
                        this.errored = true;
                        continue;
                    }
                }
                this.receiveResults(results, partial);
            }
            if (this.index < this.arm.getResults().length) {
                if (this.limit-- == 0) {
                    this.done = true;
                    this.arm = null;
                    return null;
                }
                return this.correctTypes(this.arm.getResults()[this.index++]);
            }
            this.arm = null;
            if (this.isDone()) break;
        }
        return null;
    }

    private void handleDataNotAvailable(DataNotAvailableException e) throws BlockedException {
        if (e.getWaitUntil() != null) {
            long timeDiff = e.getWaitUntil().getTime() - System.currentTimeMillis();
            if (timeDiff <= 0L) {
                return;
            }
            if (e.isStrict()) {
                this.waitUntil = e.getWaitUntil().getTime();
            }
            this.scheduleMoreWork(timeDiff);
        } else if (e.getRetryDelay() >= 0L) {
            if (e.isStrict()) {
                this.waitUntil = System.currentTimeMillis() + e.getRetryDelay();
            }
            this.scheduleMoreWork(e.getRetryDelay());
        } else {
            if (this.cwi.isDataAvailable()) {
                return;
            }
            if (e.isStrict()) {
                this.waitUntil = Long.MAX_VALUE;
            }
        }
        throw BlockedException.block(this.aqr.getAtomicRequestID(), "Blocking on DataNotAvailableException", this.aqr.getAtomicRequestID());
    }

    private void scheduleMoreWork(long timeDiff) {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        this.scheduledFuture = this.workItem.scheduleWork(new MoreWorkTask(this.workItem), 10, timeDiff);
    }

    private void checkForUpdates(AtomicResultsMessage results, Command command, EventDistributor distributor, int commandIndex, long ts) {
        if (!RelationalNodeUtil.isUpdate(command) || !(command instanceof ProcedureContainer)) {
            return;
        }
        ProcedureContainer pc = (ProcedureContainer)this.aqr.getCommand();
        GroupSymbol gs = pc.getGroup();
        Integer zero = 0;
        if (results.getResults().length <= commandIndex || zero.equals(results.getResults()[commandIndex].get(0))) {
            return;
        }
        Object metadataId = gs.getMetadataID();
        if (metadataId == null) {
            return;
        }
        if (!(metadataId instanceof Table)) {
            return;
        }
        Table t = (Table)metadataId;
        t.setLastDataModification(ts);
        if (distributor != null) {
            distributor.dataModification(this.workItem.getDqpWorkContext().getVdbName(), this.workItem.getDqpWorkContext().getVdbVersion(), ((Schema)t.getParent()).getName(), new String[]{t.getName()});
        }
    }

    private AtomicResultsMessage asynchGet() throws BlockedException, TeiidProcessingException, TeiidComponentException, TranslatorException {
        if (this.futureResult == null) {
            this.addWork();
        }
        if (!this.futureResult.isDone()) {
            throw BlockedException.block(this.aqr.getAtomicRequestID(), "Blocking on source query", this.aqr.getAtomicRequestID());
        }
        DQPCore.FutureWork<AtomicResultsMessage> currentResults = this.futureResult;
        this.futureResult = null;
        AtomicResultsMessage results = null;
        try {
            results = (AtomicResultsMessage)currentResults.get();
            if (results.getFinalRow() < 0) {
                this.addWork();
            }
        }
        catch (InterruptedException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30503, (Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof TeiidProcessingException) {
                throw (TeiidProcessingException)e.getCause();
            }
            if (e.getCause() instanceof TeiidComponentException) {
                throw (TeiidComponentException)e.getCause();
            }
            if (e.getCause() instanceof TranslatorException) {
                throw (TranslatorException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        return results;
    }

    AtomicResultsMessage getResults() throws BlockedException, TeiidComponentException, TranslatorException {
        AtomicResultsMessage results = null;
        if (this.cancelAsynch) {
            return null;
        }
        this.running = true;
        if (!this.executed) {
            this.cwi.execute();
            this.executed = true;
        }
        results = this.cwi.more();
        return results;
    }

    public boolean isQueued() {
        DQPCore.FutureWork<AtomicResultsMessage> future = this.futureResult;
        return !this.running && future != null && !future.isDone();
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void fullyCloseSource() {
        this.cancelAsynch = true;
        if (this.closed.compareAndSet(false, true)) {
            this.workItem.closeAtomicRequest(this.aqr.getAtomicRequestID());
            if (this.aqr.isSerial()) {
                this.cwi.close();
            } else if (!this.canAsynchClose) {
                this.workItem.addHighPriorityWork(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        DataTierTupleSource.this.cwi.close();
                        return null;
                    }
                });
            }
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void cancelRequest() {
        this.canceled = true;
        this.cwi.cancel();
    }

    @Override
    public void closeSource() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
        this.lobBuffer = null;
        this.lobStore = null;
        this.cancelAsynch = true;
        if (!this.explicitClose) {
            this.fullyCloseSource();
        }
    }

    AtomicResultsMessage exceptionOccurred(TranslatorException exception) throws TeiidComponentException, TeiidProcessingException {
        if (this.workItem.requestMsg.supportsPartialResults()) {
            AtomicResultsMessage emptyResults = new AtomicResultsMessage(new List[0]);
            emptyResults.setWarnings(Arrays.asList(new Exception[]{exception}));
            emptyResults.setFinalRow(this.rowsProcessed);
            return emptyResults;
        }
        this.fullyCloseSource();
        if (exception.getCause() instanceof TeiidComponentException) {
            throw (TeiidComponentException)exception.getCause();
        }
        if (exception.getCause() instanceof TeiidProcessingException) {
            throw (TeiidProcessingException)exception.getCause();
        }
        throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30504, (Throwable)exception, this.getConnectorName() + ": " + exception.getMessage());
    }

    void receiveResults(AtomicResultsMessage response, boolean partial) {
        this.arm = response;
        this.scope = response.getScope();
        this.explicitClose |= !this.arm.supportsImplicitClose();
        this.rowsProcessed += response.getResults().length;
        this.index = 0;
        if (response.getWarnings() != null) {
            for (Exception warning : response.getWarnings()) {
                SourceWarning sourceFailure = new SourceWarning(this.aqr.getModelName(), this.aqr.getConnectorName(), (Throwable)warning, partial);
                this.workItem.addSourceFailureDetails(sourceFailure);
            }
        }
        if (response.getFinalRow() >= 0) {
            this.done = true;
        }
    }

    public AtomicRequestMessage getAtomicRequestMessage() {
        return this.aqr;
    }

    public String getConnectorName() {
        return this.aqr.getConnectorName();
    }

    public boolean isTransactional() {
        return this.aqr.isTransactional();
    }

    @Override
    public void onCompletion(DQPCore.FutureWork<AtomicResultsMessage> future) {
        if (!this.cancelAsynch) {
            this.workItem.moreWork();
        }
        this.canAsynchClose = false;
        if (this.closed.get()) {
            this.cwi.close();
        }
        this.running = false;
    }

    private static final class MoreWorkTask
    implements Runnable {
        WeakReference<RequestWorkItem> ref;

        public MoreWorkTask(RequestWorkItem workItem) {
            this.ref = new WeakReference<RequestWorkItem>(workItem);
        }

        @Override
        public void run() {
            RequestWorkItem item = (RequestWorkItem)this.ref.get();
            if (item != null) {
                item.moreWork();
            }
        }
    }
}

