/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import org.teiid.client.RequestMessage;
import org.teiid.client.ResultsMessage;
import org.teiid.client.SourceWarning;
import org.teiid.client.lob.LobChunk;
import org.teiid.client.metadata.ParameterInfo;
import org.teiid.client.util.ResultsReceiver;
import org.teiid.client.xa.XATransactionException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.process.AbstractWorkItem;
import org.teiid.dqp.internal.process.AuthorizationValidator;
import org.teiid.dqp.internal.process.CachedResults;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.DataTierTupleSource;
import org.teiid.dqp.internal.process.LobWorkItem;
import org.teiid.dqp.internal.process.Request;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.internal.process.ThreadReuseExecutor;
import org.teiid.dqp.message.AtomicRequestID;
import org.teiid.dqp.message.RequestID;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.dqp.service.TransactionService;
import org.teiid.jdbc.EnhancedTimer;
import org.teiid.logging.CommandLogMessage;
import org.teiid.logging.LogManager;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.util.CommandContext;

public class RequestWorkItem
extends AbstractWorkItem
implements ThreadReuseExecutor.PrioritizedRunnable {
    private static final int OUTPUT_BUFFER_MAX_BATCHES = 20;
    private ProcessingState state = ProcessingState.NEW;
    private TransactionState transactionState = TransactionState.NONE;
    private int totalThreads;
    private LinkedList<WorkWrapper<?>> queue = new LinkedList();
    protected final DQPCore dqpCore;
    final RequestMessage requestMsg;
    final RequestID requestID;
    private Request request;
    private final int processorTimeslice;
    private SessionAwareCache.CacheID cid;
    private final TransactionService transactionService;
    private final DQPWorkContext dqpWorkContext;
    boolean active;
    private volatile QueryProcessor processor;
    private BatchCollector collector;
    private Command originalCommand;
    private AnalysisRecord analysisRecord;
    private TransactionContext transactionContext;
    TupleBuffer resultsBuffer;
    private boolean returnsUpdateCount;
    private Throwable processingException;
    private Map<AtomicRequestID, DataTierTupleSource> connectorInfo = Collections.synchronizedMap(new HashMap(4));
    private List<TeiidException> warnings = new LinkedList<TeiidException>();
    private volatile boolean doneProducingBatches;
    private volatile boolean isClosed;
    private volatile boolean isCanceled;
    private volatile boolean closeRequested;
    private ResultsReceiver<ResultsMessage> resultsReceiver;
    private int begin;
    private int end;
    private TupleBatch savedBatch;
    private Map<Integer, LobWorkItem> lobStreams = Collections.synchronizedMap(new HashMap(4));
    private long processingTimestamp = System.currentTimeMillis();
    protected boolean useCallingThread;
    private volatile boolean hasThread;
    private EnhancedTimer.Task cancelTask;

    public RequestWorkItem(DQPCore dqpCore, RequestMessage requestMsg, Request request, ResultsReceiver<ResultsMessage> receiver, RequestID requestID, DQPWorkContext workContext) {
        this.requestMsg = requestMsg;
        this.requestID = requestID;
        this.processorTimeslice = dqpCore.getProcessorTimeSlice();
        this.transactionService = dqpCore.getTransactionService();
        this.dqpCore = dqpCore;
        this.request = request;
        this.dqpWorkContext = workContext;
        this.requestResults(1, requestMsg.getFetchSize(), receiver);
    }

    private boolean isForwardOnly() {
        return this.cid == null && this.requestMsg.getCursorType() == 1003;
    }

    synchronized void requestResults(int beginRow, int endRow, ResultsReceiver<ResultsMessage> receiver) {
        if (this.resultsReceiver != null) {
            throw new IllegalStateException("Results already requested");
        }
        this.resultsReceiver = receiver;
        this.begin = beginRow;
        this.end = endRow;
    }

    @Override
    protected boolean isDoneProcessing() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.hasThread = true;
        try {
            while (!this.isDoneProcessing()) {
                super.run();
                if (!this.useCallingThread) {
                    return;
                }
                RequestWorkItem requestWorkItem = this;
                synchronized (requestWorkItem) {
                    if (this.resultsReceiver == null) {
                        return;
                    }
                    if (this.getThreadState() == AbstractWorkItem.ThreadState.MORE_WORK) {
                        continue;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        try {
                            this.requestCancel();
                        }
                        catch (TeiidComponentException e1) {
                            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30543, (Throwable)e1);
                        }
                    }
                }
            }
            return;
        }
        finally {
            this.hasThread = false;
        }
    }

    @Override
    protected void resumeProcessing() {
        if (!this.useCallingThread) {
            this.dqpCore.addWork(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMoreWork() {
        boolean run = false;
        RequestWorkItem requestWorkItem = this;
        synchronized (requestWorkItem) {
            this.moreWork();
            if (!this.useCallingThread || this.getThreadState() != AbstractWorkItem.ThreadState.MORE_WORK) {
                return;
            }
            run = !this.hasThread;
        }
        if (run) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Restarting processing using the calling thread", this.requestID});
            this.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process() {
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Request Thread", this.requestID, "with state", this.state});
        try {
            if (this.state == ProcessingState.NEW) {
                this.state = ProcessingState.PROCESSING;
                this.processNew();
                if (this.isCanceled) {
                    this.setCanceledException();
                    this.state = ProcessingState.CLOSE;
                }
            }
            this.resume();
            if (this.state == ProcessingState.PROCESSING) {
                if (!this.closeRequested) {
                    this.processMore();
                }
                if (this.closeRequested) {
                    this.state = ProcessingState.CLOSE;
                }
            }
        }
        catch (BlockedException e) {
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Request Thread", this.requestID, "- processor blocked"});
            }
        }
        catch (QueryProcessor.ExpiredTimeSliceException e) {
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Request Thread", this.requestID, "- time slice expired"});
            }
            this.moreWork();
        }
        catch (Throwable e) {
            this.handleThrowable(e);
        }
        finally {
            if (this.isClosed) {
                if (this.processingException == null) {
                    this.processingException = new IllegalStateException("Request is already closed");
                }
                this.sendError();
            } else if (this.state == ProcessingState.CLOSE) {
                this.close();
            }
            this.suspend();
        }
    }

    private void setCanceledException() {
        this.processingException = new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30563, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30563, new Object[]{this.requestID}));
    }

    private void handleThrowable(Throwable e) {
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Throwable)e, (Object[])new Object[]{"Request Thread", this.requestID, "- error occurred"});
        if (!this.isCanceled()) {
            this.dqpCore.logMMCommand(this, CommandLogMessage.Event.ERROR, null);
            if (e instanceof TeiidProcessingException) {
                Throwable cause;
                for (cause = e; cause.getCause() != null && cause.getCause() != cause; cause = cause.getCause()) {
                }
                StackTraceElement[] elems = cause.getStackTrace();
                Object elem = null;
                elem = elems.length > 0 ? cause.getStackTrace()[0] : cause.getMessage();
                LogManager.logWarning((String)"org.teiid.PROCESSOR", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30020, new Object[]{e.getMessage(), this.requestID, e.getClass().getName(), elem}));
            } else {
                LogManager.logError((String)"org.teiid.PROCESSOR", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30019, new Object[]{this.requestID}));
            }
        }
        this.processingException = e;
        this.state = ProcessingState.CLOSE;
    }

    private void resume() throws XATransactionException {
        if (this.transactionState == TransactionState.ACTIVE && this.isSuspendable()) {
            this.transactionService.resume(this.transactionContext);
        }
    }

    private boolean isSuspendable() {
        return !this.useCallingThread && this.transactionContext.getTransaction() != null;
    }

    private void suspend() {
        if (this.transactionState != TransactionState.NONE && this.isSuspendable()) {
            try {
                this.transactionService.suspend(this.transactionContext);
            }
            catch (XATransactionException e) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Throwable)e, (Object[])new Object[]{"Error suspending active transaction"});
            }
        }
    }

    protected void processMore() throws BlockedException, TeiidException {
        if (!this.doneProducingBatches) {
            this.processor.getContext().setTimeSliceEnd(System.currentTimeMillis() + (long)this.processorTimeslice);
            this.sendResultsIfNeeded(null);
            this.resultsBuffer = this.collector.collectTuples();
            if (!this.doneProducingBatches) {
                this.done();
            }
        }
        if (this.transactionState == TransactionState.ACTIVE) {
            for (DataTierTupleSource connectorRequest : this.getConnectorRequests()) {
                if (!connectorRequest.isTransactional()) continue;
                connectorRequest.fullyCloseSource();
            }
            this.transactionState = TransactionState.DONE;
            if (this.transactionContext.getTransactionType() == TransactionContext.Scope.REQUEST) {
                this.transactionService.commit(this.transactionContext);
            } else {
                this.suspend();
            }
        }
        this.sendResultsIfNeeded(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        int rowcount = -1;
        try {
            this.cancelCancelTask();
            if (this.resultsBuffer != null) {
                if (this.processor != null) {
                    this.processor.closeProcessing();
                    if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Removing tuplesource for the request " + this.requestID});
                    }
                    rowcount = this.resultsBuffer.getRowCount();
                    if (this.cid == null || !this.doneProducingBatches) {
                        this.resultsBuffer.remove();
                    } else {
                        try {
                            this.resultsBuffer.persistLobs();
                        }
                        catch (TeiidComponentException e) {
                            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{QueryPlugin.Util.getString("failed_to_cache")});
                        }
                    }
                    for (DataTierTupleSource dataTierTupleSource : this.getConnectorRequests()) {
                        dataTierTupleSource.fullyCloseSource();
                    }
                    CommandContext cc = this.processor.getContext();
                    cc.close();
                }
                this.resultsBuffer = null;
                if (!this.lobStreams.isEmpty()) {
                    ArrayList<LobWorkItem> lobs = null;
                    Map<Integer, LobWorkItem> map = this.lobStreams;
                    synchronized (map) {
                        lobs = new ArrayList<LobWorkItem>(this.lobStreams.values());
                    }
                    for (LobWorkItem lobWorkItem : lobs) {
                        lobWorkItem.close();
                    }
                }
            }
            if (this.transactionState == TransactionState.ACTIVE) {
                this.transactionState = TransactionState.DONE;
                if (this.transactionContext.getTransactionType() == TransactionContext.Scope.REQUEST) {
                    try {
                        this.transactionService.rollback(this.transactionContext);
                    }
                    catch (XATransactionException e1) {
                        LogManager.logWarning((String)"org.teiid.PROCESSOR", (Throwable)e1, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30028, new Object[0]));
                    }
                } else {
                    this.suspend();
                }
            }
            RequestWorkItem e1 = this;
            synchronized (e1) {
                if (this.processingException == null && this.resultsReceiver != null) {
                    this.setCanceledException();
                }
            }
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        finally {
            this.isClosed = true;
            this.dqpCore.removeRequest(this);
            if (this.processingException != null) {
                this.sendError();
            } else {
                this.dqpCore.logMMCommand(this, CommandLogMessage.Event.END, rowcount);
            }
        }
    }

    private void cancelCancelTask() {
        if (this.cancelTask != null) {
            this.cancelTask.cancel();
            this.cancelTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processNew() throws TeiidProcessingException, TeiidComponentException {
        boolean canUseCached;
        SessionAwareCache<CachedResults> rsCache = this.dqpCore.getRsCache();
        boolean cachable = false;
        SessionAwareCache.CacheID cacheId = null;
        boolean bl = canUseCached = !this.requestMsg.getRequestOptions().isContinuous() && (this.requestMsg.useResultSetCache() || this.getCacheHint() != null);
        if (rsCache != null) {
            if (!canUseCached) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{this.requestID, "Non-cachable command."});
            } else {
                ParseInfo pi = Request.createParseInfo(this.requestMsg);
                cacheId = new SessionAwareCache.CacheID(this.dqpWorkContext, pi, this.requestMsg.getCommandString());
                cachable = cacheId.setParameters(this.requestMsg.getParameterValues());
                if (cachable) {
                    CachedResults cr = rsCache.get(cacheId);
                    if (cr != null && (cr.getRowLimit() == 0 || this.requestMsg.getRowLimit() != 0 && this.requestMsg.getRowLimit() <= cr.getRowLimit())) {
                        this.resultsBuffer = cr.getResults();
                        this.request.initMetadata();
                        this.originalCommand = cr.getCommand(this.requestMsg.getCommandString(), this.request.metadata, pi);
                        if (!this.request.validateAccess(this.requestMsg.getCommands(), this.originalCommand, AuthorizationValidator.CommandType.CACHED)) {
                            this.doneProducingBatches();
                            return;
                        }
                        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{this.requestID, "Cached result command to be modified, will not use the cached results", cacheId});
                    }
                } else {
                    LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{this.requestID, "Parameters are not serializable - cache cannot be used for", cacheId});
                }
            }
        }
        try {
            this.request.processRequest();
        }
        finally {
            this.analysisRecord = this.request.analysisRecord;
        }
        this.originalCommand = this.request.userCommand;
        if (cachable && (this.requestMsg.useResultSetCache() || this.originalCommand.getCacheHint() != null) && rsCache != null && this.originalCommand.areResultsCachable()) {
            this.cid = cacheId;
            this.request.processor.getContext().setDataObjects(new HashSet<Object>(4));
        }
        this.processor = this.request.processor;
        this.dqpCore.logMMCommand(this, CommandLogMessage.Event.PLAN, null);
        this.collector = new BatchCollector(this.processor, this.processor.getBufferManager(), this.request.context, this.isForwardOnly()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void flushBatchDirect(TupleBatch batch, boolean add) throws TeiidComponentException, TeiidProcessingException {
                RequestWorkItem.this.resultsBuffer = this.getTupleBuffer();
                if (RequestWorkItem.this.cid != null) {
                    super.flushBatchDirect(batch, add);
                }
                if (batch.getTerminationFlag()) {
                    RequestWorkItem.this.done();
                }
                Map map = RequestWorkItem.this.lobStreams;
                synchronized (map) {
                    if (RequestWorkItem.this.resultsBuffer.isLobs()) {
                        super.flushBatchDirect(batch, false);
                    }
                    add = RequestWorkItem.this.sendResultsIfNeeded(batch);
                    if (RequestWorkItem.this.cid != null) {
                        return;
                    }
                    super.flushBatchDirect(batch, add);
                    if (!add && !RequestWorkItem.this.processor.hasFinalBuffer()) {
                        RequestWorkItem.this.resultsBuffer.setRowCount(batch.getEndRow());
                    } else if (!RequestWorkItem.this.processor.hasFinalBuffer() && !batch.getTerminationFlag() && RequestWorkItem.this.transactionState != TransactionState.ACTIVE && this.getTupleBuffer().getManagedRowCount() >= 20 * this.getTupleBuffer().getBatchSize()) {
                        if (!RequestWorkItem.this.dqpCore.hasWaitingPlans(RequestWorkItem.this)) {
                            throw BlockedException.block(RequestWorkItem.this.requestID, "Blocking due to full results TupleBuffer", this.getTupleBuffer(), "rows", this.getTupleBuffer().getManagedRowCount(), "batch size", this.getTupleBuffer().getBatchSize());
                        }
                        if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{RequestWorkItem.this.requestID, "Exceeding buffer limit since there are pending active plans."});
                        }
                    }
                }
            }
        };
        if (!this.request.addedLimit && this.requestMsg.getRowLimit() > 0 && !this.request.isReturingParams()) {
            this.collector.setRowLimit(this.requestMsg.getRowLimit());
        }
        this.resultsBuffer = this.collector.getTupleBuffer();
        if (this.resultsBuffer == null) {
            this.resultsBuffer = this.processor.getBufferManager().createTupleBuffer(this.originalCommand.getProjectedSymbols(), this.request.context.getConnectionId(), BufferManager.TupleSourceType.FINAL);
        }
        this.transactionContext = this.request.transactionContext;
        if (this.transactionContext != null && this.transactionContext.getTransactionType() != TransactionContext.Scope.NONE) {
            if (this.requestMsg.getRequestOptions().isContinuous()) {
                throw new IllegalStateException("Continuous requests are not allowed to be transactional.");
            }
            this.transactionState = TransactionState.ACTIVE;
        }
        if (this.requestMsg.isNoExec()) {
            this.doneProducingBatches();
            this.resultsBuffer.close();
            this.cid = null;
        }
        this.returnsUpdateCount = this.request.returnsUpdateCount;
        if (this.returnsUpdateCount && this.requestMsg.getRequestOptions().isContinuous()) {
            throw new IllegalStateException("Continuous requests are not allowed to be updates.");
        }
        this.request = null;
    }

    private CacheHint getCacheHint() {
        if (this.requestMsg.getCommand() != null) {
            return ((Command)this.requestMsg.getCommand()).getCacheHint();
        }
        return QueryParser.getQueryParser().parseCacheHint(this.requestMsg.getCommandString());
    }

    private void addToCache() {
        if (!this.doneProducingBatches || this.cid == null) {
            return;
        }
        FunctionMethod.Determinism determinismLevel = this.processor.getContext().getDeterminismLevel();
        CachedResults cr = new CachedResults();
        cr.setCommand(this.originalCommand);
        cr.setResults(this.resultsBuffer, this.processor.getProcessorPlan());
        if (this.requestMsg.getRowLimit() > 0 && this.resultsBuffer.getRowCount() == this.requestMsg.getRowLimit()) {
            cr.setRowLimit(this.resultsBuffer.getRowCount());
        }
        if (this.originalCommand.getCacheHint() != null) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{this.requestID, "Using cache hint", this.originalCommand.getCacheHint()});
            this.resultsBuffer.setPrefersMemory(this.originalCommand.getCacheHint().isPrefersMemory());
            if (this.originalCommand.getCacheHint().getDeterminism() != null) {
                determinismLevel = this.originalCommand.getCacheHint().getDeterminism();
                LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Cache hint modified the query determinism from ", this.processor.getContext().getDeterminismLevel(), " to ", determinismLevel});
            }
            if (!this.originalCommand.getCacheHint().isUpdatable(true)) {
                cr.getAccessInfo().setSensitiveToMetadataChanges(false);
                cr.getAccessInfo().getObjectsAccessed().clear();
            }
        }
        if (determinismLevel.compareTo((Enum)FunctionMethod.Determinism.SESSION_DETERMINISTIC) <= 0) {
            LogManager.logInfo((String)"org.teiid.PROCESSOR", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30008, new Object[]{this.originalCommand}));
        }
        this.dqpCore.getRsCache().put(this.cid, determinismLevel, cr, this.originalCommand.getCacheHint() != null ? this.originalCommand.getCacheHint().getTtl() : null);
    }

    public SessionAwareCache<CachedResults> getRsCache() {
        return this.dqpCore.getRsCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sendResultsIfNeeded(TupleBatch batch) throws TeiidComponentException {
        ResultsMessage response = null;
        ResultsReceiver<ResultsMessage> receiver = null;
        boolean result = true;
        RequestWorkItem requestWorkItem = this;
        synchronized (requestWorkItem) {
            StoredProcedure proc;
            List<Exception> currentWarnings22;
            if (this.resultsReceiver == null || this.begin > (batch != null ? batch.getEndRow() : this.resultsBuffer.getRowCount()) && !this.doneProducingBatches || this.transactionState == TransactionState.ACTIVE) {
                return result;
            }
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"[RequestWorkItem.sendResultsIfNeeded] requestID:", this.requestID, "resultsID:", this.resultsBuffer, "done:", this.doneProducingBatches});
            }
            boolean fromBuffer = false;
            if (batch == null || !batch.containsRow(this.begin) && (!batch.getTerminationFlag() || batch.getEndRow() > this.begin)) {
                batch = this.savedBatch != null && this.savedBatch.containsRow(this.begin) ? this.savedBatch : this.resultsBuffer.getBatch(this.begin);
                this.savedBatch = null;
                fromBuffer = true;
            }
            int count = this.end - this.begin + 1;
            if (batch.getRowCount() > count) {
                int beginRow = Math.min(this.begin, batch.getEndRow() - count + 1);
                int endRow = Math.min(beginRow + count - 1, batch.getEndRow());
                boolean last = false;
                if (endRow == batch.getEndRow()) {
                    last = batch.getTerminationFlag();
                } else if (fromBuffer && this.isForwardOnly()) {
                    this.savedBatch = batch;
                }
                List<List<?>> memoryRows = batch.getTuples();
                batch = new TupleBatch(beginRow, memoryRows.subList(beginRow - batch.getBeginRow(), endRow - batch.getBeginRow() + 1));
                batch.setTerminationFlag(last);
            } else if (!fromBuffer) {
                boolean bl = result = !this.isForwardOnly();
            }
            int finalRowCount = this.resultsBuffer.isFinal() && !this.requestMsg.getRequestOptions().isContinuous() ? this.resultsBuffer.getRowCount() : (batch.getTerminationFlag() ? batch.getEndRow() : -1);
            response = this.createResultsMessage(batch.getTuples(), this.originalCommand.getProjectedSymbols());
            response.setFirstRow(batch.getBeginRow());
            response.setLastRow(batch.getEndRow());
            response.setUpdateResult(this.returnsUpdateCount);
            response.setFinalRow(finalRowCount);
            ArrayList<Throwable> responseWarnings = new ArrayList<Throwable>();
            if (this.processor != null && (currentWarnings22 = this.processor.getAndClearWarnings()) != null) {
                responseWarnings.addAll(currentWarnings22);
            }
            List<TeiidException> currentWarnings22 = this.warnings;
            synchronized (currentWarnings22) {
                responseWarnings.addAll(this.warnings);
                this.warnings.clear();
            }
            response.setWarnings(responseWarnings);
            if (this.originalCommand instanceof StoredProcedure && (proc = (StoredProcedure)this.originalCommand).returnParameters()) {
                response.setParameters(RequestWorkItem.getParameterInfo(proc));
            }
            receiver = this.resultsReceiver;
            this.resultsReceiver = null;
        }
        this.cancelCancelTask();
        receiver.receiveResults((Object)response);
        return result;
    }

    public ResultsMessage createResultsMessage(List<? extends List<?>> batch, List<? extends Expression> columnSymbols) {
        String[] columnNames = new String[columnSymbols.size()];
        String[] dataTypes = new String[columnSymbols.size()];
        for (int i = 0; i < columnSymbols.size(); ++i) {
            Expression symbol = columnSymbols.get(i);
            columnNames[i] = Symbol.getShortName(Symbol.getOutputName(symbol));
            dataTypes[i] = DataTypeManager.getDataTypeName(symbol.getType());
        }
        ResultsMessage result = new ResultsMessage(batch, columnNames, dataTypes);
        result.setClientSerializationVersion(this.dqpWorkContext.getClientVersion().getClientSerializationVersion());
        this.setAnalysisRecords(result);
        return result;
    }

    private void setAnalysisRecords(ResultsMessage response) {
        if (this.analysisRecord != null) {
            if (this.requestMsg.getShowPlan() != RequestMessage.ShowPlan.OFF) {
                if (this.processor != null) {
                    response.setPlanDescription(this.processor.getProcessorPlan().getDescriptionProperties());
                }
                if (this.analysisRecord.getAnnotations() != null && !this.analysisRecord.getAnnotations().isEmpty()) {
                    response.setAnnotations(this.analysisRecord.getAnnotations());
                    this.analysisRecord.getAnnotations().clear();
                }
            }
            if (this.requestMsg.getShowPlan() == RequestMessage.ShowPlan.DEBUG) {
                response.setDebugLog(this.analysisRecord.getDebugLog());
                this.analysisRecord.stopDebugLog();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendError() {
        ResultsReceiver<ResultsMessage> receiver = null;
        RequestWorkItem requestWorkItem = this;
        synchronized (requestWorkItem) {
            receiver = this.resultsReceiver;
            this.resultsReceiver = null;
            if (receiver == null) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Throwable)this.processingException, (Object[])new Object[]{"Unable to send error to client as results were already sent.", this.requestID});
                return;
            }
        }
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Throwable)this.processingException, (Object[])new Object[]{"Sending error to client", this.requestID});
        ResultsMessage response = new ResultsMessage();
        Throwable exception = this.processingException;
        if (this.isCanceled) {
            exception = this.addCancelCode(exception);
        }
        response.setException(exception);
        this.setAnalysisRecords(response);
        receiver.receiveResults((Object)response);
    }

    private Throwable addCancelCode(Throwable exception) {
        TeiidException te;
        if (exception instanceof TeiidException && "57014".equals((te = (TeiidException)exception).getCode())) {
            return exception;
        }
        return new TeiidProcessingException(exception, "57014");
    }

    private static List<ParameterInfo> getParameterInfo(StoredProcedure procedure) {
        ArrayList<ParameterInfo> paramInfos = new ArrayList<ParameterInfo>();
        for (SPParameter param : procedure.getParameters()) {
            ParameterInfo info = new ParameterInfo(param.getParameterType(), param.getResultSetColumns().size());
            paramInfos.add(info);
        }
        return paramInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLobChunkRequest(String id, int streamRequestId, ResultsReceiver<LobChunk> chunckReceiver) {
        LobWorkItem workItem = null;
        Map<Integer, LobWorkItem> map = this.lobStreams;
        synchronized (map) {
            workItem = this.lobStreams.get(streamRequestId);
            if (workItem == null) {
                workItem = new LobWorkItem(this, this.dqpCore, id, streamRequestId);
                this.lobStreams.put(streamRequestId, workItem);
            }
        }
        workItem.setResultsReceiver(chunckReceiver);
        if (this.dqpWorkContext.useCallingThread()) {
            workItem.run();
        } else {
            this.dqpCore.addWork((Runnable)((Object)workItem));
        }
    }

    public void removeLobStream(int streamRequestId) {
        this.lobStreams.remove(streamRequestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestCancel() throws TeiidComponentException {
        RequestWorkItem requestWorkItem = this;
        synchronized (requestWorkItem) {
            if (this.isCanceled || this.closeRequested) {
                return false;
            }
            this.isCanceled = true;
        }
        if (this.processor != null) {
            this.processor.requestCanceled();
        }
        try {
            for (DataTierTupleSource connectorRequest : this.getConnectorRequests()) {
                connectorRequest.cancelRequest();
            }
        }
        finally {
            block19: {
                try {
                    if (this.transactionService == null) break block19;
                    try {
                        this.transactionService.cancelTransactions(this.requestID.getConnectionID(), true);
                    }
                    catch (XATransactionException err) {
                        throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30544, (Throwable)err);
                    }
                }
                finally {
                    this.moreWork();
                }
            }
        }
        return true;
    }

    public boolean requestAtomicRequestCancel(AtomicRequestID ari) throws TeiidComponentException {
        if (!this.requestMsg.supportsPartialResults()) {
            return this.requestCancel();
        }
        DataTierTupleSource connectorRequest = this.connectorInfo.get(ari);
        if (connectorRequest != null) {
            connectorRequest.cancelRequest();
            return true;
        }
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Connector request not found. AtomicRequestID=", ari});
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestClose() throws TeiidComponentException {
        RequestWorkItem requestWorkItem = this;
        synchronized (requestWorkItem) {
            if (this.state == ProcessingState.CLOSE || this.closeRequested) {
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                    LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Request already closing" + this.requestID});
                }
                return;
            }
        }
        if (!this.doneProducingBatches) {
            this.requestCancel();
        }
        this.closeRequested = true;
        this.doMoreWork();
    }

    public void requestMore(int batchFirst, int batchLast, ResultsReceiver<ResultsMessage> receiver) {
        this.requestResults(batchFirst, batchLast, receiver);
        this.doMoreWork();
    }

    public void closeAtomicRequest(AtomicRequestID atomicRequestId) {
        this.connectorInfo.remove(atomicRequestId);
        LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"closed atomic-request:", atomicRequestId});
    }

    public void addConnectorRequest(AtomicRequestID atomicRequestId, DataTierTupleSource connInfo) {
        this.connectorInfo.put(atomicRequestId, connInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceFailureDetails(SourceWarning details) {
        List<TeiidException> list = this.warnings;
        synchronized (list) {
            this.warnings.add((TeiidException)details);
        }
    }

    boolean isCanceled() {
        return this.isCanceled;
    }

    Command getOriginalCommand() throws TeiidProcessingException {
        if (this.originalCommand == null) {
            if (this.processingException != null) {
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30545, this.processingException);
            }
            throw new IllegalStateException("Original command is not available");
        }
        return this.originalCommand;
    }

    void setOriginalCommand(Command originalCommand) {
        this.originalCommand = originalCommand;
    }

    TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<DataTierTupleSource> getConnectorRequests() {
        Map<AtomicRequestID, DataTierTupleSource> map = this.connectorInfo;
        synchronized (map) {
            return new ArrayList<DataTierTupleSource>(this.connectorInfo.values());
        }
    }

    DataTierTupleSource getConnectorRequest(AtomicRequestID id) {
        return this.connectorInfo.get(id);
    }

    public List<TeiidException> getWarnings() {
        return this.warnings;
    }

    @Override
    public String toString() {
        return this.requestID.toString();
    }

    @Override
    public DQPWorkContext getDqpWorkContext() {
        return this.dqpWorkContext;
    }

    public long getProcessingTimestamp() {
        return this.processingTimestamp;
    }

    @Override
    public void release() {
        try {
            this.requestCancel();
        }
        catch (TeiidComponentException e) {
            LogManager.logWarning((String)"org.teiid.PROCESSOR", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30026, new Object[]{this.requestID}));
        }
    }

    private void done() {
        this.doneProducingBatches();
        if (this.resultsBuffer.getLobCount() == 0) {
            for (DataTierTupleSource connectorRequest : this.getConnectorRequests()) {
                connectorRequest.fullyCloseSource();
            }
        }
        this.addToCache();
    }

    private void doneProducingBatches() {
        this.doneProducingBatches = true;
        this.dqpCore.finishProcessing(this);
    }

    @Override
    public int getPriority() {
        return this.closeRequested || this.isCanceled ? 0 : 1000;
    }

    @Override
    public long getCreationTime() {
        return this.processingTimestamp;
    }

    <T> DQPCore.FutureWork<T> addHighPriorityWork(Callable<T> callable) {
        DQPCore.FutureWork<T> work = new DQPCore.FutureWork<T>(callable, 0);
        this.dqpCore.addWork(work);
        return work;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> DQPCore.FutureWork<T> addWork(Callable<T> callable, DQPCore.CompletionListener<T> listener, int priority) {
        DQPCore.FutureWork<T> work = new DQPCore.FutureWork<T>(callable, priority);
        WorkWrapper<T> wl = new WorkWrapper<T>(work);
        work.addCompletionListener(wl);
        work.addCompletionListener(listener);
        LinkedList<WorkWrapper<?>> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.totalThreads < this.dqpCore.getUserRequestSourceConcurrency()) {
                this.dqpCore.addWork(work);
                ++this.totalThreads;
                wl.submitted = true;
            } else {
                this.queue.add(wl);
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{this.requestID, " reached max source concurrency of ", this.dqpCore.getUserRequestSourceConcurrency()});
            }
        }
        return work;
    }

    ScheduledFuture<?> scheduleWork(Runnable r, int priority, long delay) {
        return this.dqpCore.scheduleWork(r, priority, delay);
    }

    public void setCancelTask(EnhancedTimer.Task cancelTask) {
        this.cancelTask = cancelTask;
    }

    public QueryProcessor getProcessor() {
        return this.processor;
    }

    private static enum TransactionState {
        NONE,
        ACTIVE,
        DONE;

    }

    private static enum ProcessingState {
        NEW,
        PROCESSING,
        CLOSE;

    }

    private final class WorkWrapper<T>
    implements DQPCore.CompletionListener<T> {
        boolean submitted;
        DQPCore.FutureWork<T> work;

        public WorkWrapper(DQPCore.FutureWork<T> work) {
            this.work = work;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompletion(DQPCore.FutureWork<T> future) {
            WorkWrapper nextWork = null;
            LinkedList linkedList = RequestWorkItem.this.queue;
            synchronized (linkedList) {
                if (!this.submitted) {
                    return;
                }
                nextWork = (WorkWrapper)RequestWorkItem.this.queue.pollFirst();
                if (nextWork == null) {
                    RequestWorkItem.this.totalThreads--;
                } else {
                    nextWork.submitted = true;
                }
            }
            if (nextWork != null) {
                RequestWorkItem.this.dqpCore.addWork(nextWork.work);
            }
        }
    }
}

