/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.CriteriaCapabilityValidatorVisitor;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.NewCalculateCostUtil;
import org.teiid.query.optimizer.relational.rules.RuleChooseJoinStrategy;
import org.teiid.query.optimizer.relational.rules.RuleMergeCriteria;
import org.teiid.query.optimizer.relational.rules.RulePushLimit;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.optimizer.relational.rules.RuleRemoveOptionalJoins;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.navigator.DeepPostOrderNavigator;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.util.CommandContext;

public final class RuleCollapseSource
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        for (PlanNode accessNode : NodeEditor.findAllNodes(plan, 1)) {
            ProcessorPlan nonRelationalPlan = FrameUtil.getNestedPlan(accessNode);
            Command command = FrameUtil.getNonQueryCommand(accessNode);
            if (nonRelationalPlan != null) {
                accessNode.setProperty(NodeConstants.Info.PROCESSOR_PLAN, nonRelationalPlan);
            } else if (RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata) == null) {
                accessNode.setProperty(NodeConstants.Info.IS_COMMON_TABLE, Boolean.TRUE);
            } else if (command == null) {
                PlanNode commandRoot = accessNode;
                GroupSymbol intoGroup = (GroupSymbol)accessNode.getFirstChild().getProperty(NodeConstants.Info.INTO_GROUP);
                if (intoGroup != null) {
                    commandRoot = NodeEditor.findNodePreOrder(accessNode, 64).getFirstChild();
                }
                plan = this.removeUnnecessaryInlineView(plan, commandRoot);
                QueryCommand queryCommand = this.createQuery(metadata, capFinder, accessNode, commandRoot);
                this.addDistinct(metadata, capFinder, accessNode, queryCommand);
                command = queryCommand;
                if (intoGroup != null) {
                    Insert insertCommand = (Insert)commandRoot.getParent().getProperty(NodeConstants.Info.VIRTUAL_COMMAND);
                    if (insertCommand == null) {
                        insertCommand = new Insert(intoGroup, ResolverUtil.resolveElementsInGroup(intoGroup, metadata), null);
                    }
                    insertCommand.setQueryExpression(queryCommand);
                    command = insertCommand;
                }
            }
            if (command != null) {
                accessNode.setProperty(NodeConstants.Info.ATOMIC_REQUEST, command);
            }
            accessNode.removeAllChildren();
        }
        return plan;
    }

    private void addDistinct(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode accessNode, QueryCommand queryCommand) throws QueryMetadataException, TeiidComponentException {
        if (queryCommand.getLimit() != null) {
            return;
        }
        if (queryCommand.getOrderBy() == null) {
            return;
        }
        if (RuleRemoveOptionalJoins.useNonDistinctRows(accessNode.getParent())) {
            return;
        }
        for (Expression ses : queryCommand.getProjectedSymbols()) {
            if (!DataTypeManager.isNonComparable((String)DataTypeManager.getDataTypeName(ses.getType()))) continue;
            return;
        }
        if (queryCommand instanceof SetQuery) {
            ((SetQuery)queryCommand).setAll(false);
        } else if (CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_SELECT_DISTINCT, RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata), metadata, capFinder)) {
            Query query = (Query)queryCommand;
            HashSet<GroupSymbol> keyPreservingGroups = new HashSet<GroupSymbol>();
            ResolverUtil.findKeyPreserved(query, keyPreservingGroups, metadata);
            if (!QueryRewriter.isDistinctWithGroupBy(query) && !NewCalculateCostUtil.usesKey(query.getSelect().getProjectedSymbols(), keyPreservingGroups, metadata, true)) {
                ((Query)queryCommand).getSelect().setDistinct(true);
            }
        }
    }

    private PlanNode removeUnnecessaryInlineView(PlanNode root, PlanNode accessNode) {
        PlanNode child = accessNode.getFirstChild();
        if (child.hasBooleanProperty(NodeConstants.Info.INLINE_VIEW)) {
            child.removeProperty((Object)NodeConstants.Info.INLINE_VIEW);
            root = RuleRaiseAccess.performRaise(root, child, accessNode);
            accessNode.getGroups().clear();
            PlanNode sourceNode = FrameUtil.findJoinSourceNode(accessNode.getFirstChild());
            if (sourceNode != null) {
                accessNode.addGroups(sourceNode.getGroups());
            }
            accessNode.setProperty(NodeConstants.Info.OUTPUT_COLS, accessNode.getFirstChild().getProperty(NodeConstants.Info.OUTPUT_COLS));
        }
        return root;
    }

    private QueryCommand createQuery(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode accessRoot, PlanNode node) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        PlanNode groupNode;
        Object modelID;
        PlanNode setOpNode = NodeEditor.findNodePreOrder(node, 256, 64);
        if (setOpNode != null) {
            PlanNode limit;
            SetQuery.Operation setOp = (SetQuery.Operation)((Object)setOpNode.getProperty(NodeConstants.Info.SET_OPERATION));
            SetQuery unionCommand = new SetQuery(setOp);
            boolean unionAll = (Boolean)setOpNode.getProperty(NodeConstants.Info.USE_ALL);
            unionCommand.setAll(unionAll);
            PlanNode sort = NodeEditor.findNodePreOrder(node, 32, 256);
            if (sort != null) {
                this.processOrderBy(sort, unionCommand);
            }
            if ((limit = NodeEditor.findNodePreOrder(node, 1024, 256)) != null) {
                this.processLimit(limit, unionCommand, metadata);
            }
            int count = 0;
            for (PlanNode child : setOpNode.getChildren()) {
                QueryCommand command = this.createQuery(metadata, capFinder, accessRoot, child);
                if (count == 0) {
                    unionCommand.setLeftQuery(command);
                } else if (count == 1) {
                    unionCommand.setRightQuery(command);
                } else {
                    unionCommand = new SetQuery(setOp, unionAll, unionCommand, command);
                }
                ++count;
            }
            return unionCommand;
        }
        Query query = new Query();
        Select select = new Select();
        List columns = (List)node.getProperty(NodeConstants.Info.OUTPUT_COLS);
        this.prepareSubqueries(ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(columns));
        select.addSymbols(columns);
        query.setSelect(select);
        query.setFrom(new From());
        this.buildQuery(accessRoot, node, query, metadata, capFinder);
        if (query.getCriteria() instanceof CompoundCriteria) {
            query.setCriteria(QueryRewriter.optimizeCriteria((CompoundCriteria)query.getCriteria(), metadata));
        }
        if (!CapabilitiesUtil.useAnsiJoin(modelID = RuleRaiseAccess.getModelIDFromAccess(accessRoot, metadata), metadata, capFinder)) {
            this.simplifyFromClause(query);
        }
        if (columns.isEmpty()) {
            if (CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, modelID, metadata, capFinder)) {
                select.addSymbol(new ExpressionSymbol("dummy", new Constant(1)));
            } else {
                select.addSymbol(this.selectOutputElement(query.getFrom().getGroups(), metadata));
            }
        }
        if ((groupNode = NodeEditor.findNodePreOrder(node, 128, 64)) != null) {
            if (query.getOrderBy() != null) {
                query.setOrderBy(query.getOrderBy().clone());
            }
            if (query.getHaving() != null) {
                query.setHaving((Criteria)query.getHaving().clone());
            }
            query.setSelect(query.getSelect().clone());
            SymbolMap symbolMap = (SymbolMap)groupNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
            ExpressionMappingVisitor.mapExpressions(query.getOrderBy(), symbolMap.asMap());
            ExpressionMappingVisitor.mapExpressions(query.getSelect(), symbolMap.asMap());
            ExpressionMappingVisitor.mapExpressions(query.getHaving(), symbolMap.asMap());
            if (!CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_FUNCTIONS_IN_GROUP_BY, modelID, metadata, capFinder)) {
                query = RuleCollapseSource.rewriteGroupByExpressionsAsView(query, metadata);
            }
        }
        return query;
    }

    private ElementSymbol selectOutputElement(Collection<GroupSymbol> groups, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        for (GroupSymbol group : groups) {
            List<ElementSymbol> elements = ResolverUtil.resolveElementsInGroup(group, metadata);
            for (ElementSymbol element : elements) {
                if (!metadata.elementSupports(element.getMetadataID(), 0)) continue;
                element = element.clone();
                element.setGroupSymbol(group);
                return element;
            }
        }
        return null;
    }

    void buildQuery(PlanNode accessRoot, PlanNode node, Query query, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        switch (node.getType()) {
            case 4: {
                this.prepareSubqueries(node.getSubqueryContainers());
                JoinType joinType = (JoinType)node.getProperty(NodeConstants.Info.JOIN_TYPE);
                ArrayList<Criteria> crits = (ArrayList<Criteria>)node.getProperty(NodeConstants.Info.JOIN_CRITERIA);
                if (crits == null || crits.isEmpty()) {
                    crits = new ArrayList<Criteria>();
                } else {
                    RuleChooseJoinStrategy.filterOptionalCriteria(crits);
                    if (crits.isEmpty() && joinType == JoinType.JOIN_INNER) {
                        joinType = JoinType.JOIN_CROSS;
                    }
                }
                PlanNode left = node.getFirstChild();
                PlanNode right = node.getLastChild();
                Criteria savedCriteria = null;
                this.buildQuery(accessRoot, left, query, metadata, capFinder);
                if (joinType == JoinType.JOIN_LEFT_OUTER) {
                    savedCriteria = query.getCriteria();
                    query.setCriteria(null);
                }
                this.buildQuery(accessRoot, right, query, metadata, capFinder);
                if (joinType == JoinType.JOIN_LEFT_OUTER) {
                    this.moveWhereClauseIntoOnClause(query, crits);
                    query.setCriteria(savedCriteria);
                }
                From from = query.getFrom();
                List<FromClause> clauses = from.getClauses();
                int lastClause = clauses.size() - 1;
                FromClause clause1 = clauses.get(lastClause - 1);
                FromClause clause2 = clauses.get(lastClause);
                if (joinType != JoinType.JOIN_CROSS && crits.isEmpty()) {
                    crits.add(QueryRewriter.TRUE_CRITERIA);
                } else if (joinType == JoinType.JOIN_CROSS && !crits.isEmpty()) {
                    joinType = JoinType.JOIN_INNER;
                }
                JoinPredicate jp = new JoinPredicate(clause1, clause2, joinType, crits);
                clauses.remove(lastClause);
                clauses.set(lastClause - 1, jp);
                return;
            }
            case 64: {
                if (Boolean.TRUE.equals(node.getProperty(NodeConstants.Info.INLINE_VIEW))) {
                    PlanNode child = node.getFirstChild();
                    QueryCommand newQuery = this.createQuery(metadata, capFinder, accessRoot, child);
                    GroupSymbol symbol = node.getGroups().iterator().next();
                    SubqueryFromClause sfc = new SubqueryFromClause(symbol, (Command)newQuery);
                    query.getFrom().addClause(sfc);
                    return;
                }
                query.getFrom().addGroup(node.getGroups().iterator().next());
            }
        }
        for (PlanNode childNode : node.getChildren()) {
            this.buildQuery(accessRoot, childNode, query, metadata, capFinder);
        }
        switch (node.getType()) {
            case 16: {
                Criteria crit = (Criteria)node.getProperty(NodeConstants.Info.SELECT_CRITERIA);
                this.prepareSubqueries(node.getSubqueryContainers());
                if (!node.hasBooleanProperty(NodeConstants.Info.IS_HAVING)) {
                    query.setCriteria(CompoundCriteria.combineCriteria(query.getCriteria(), crit));
                    break;
                }
                query.setHaving(CompoundCriteria.combineCriteria(query.getHaving(), crit));
                break;
            }
            case 32: {
                this.processOrderBy(node, query);
                break;
            }
            case 2: {
                query.getSelect().setDistinct(true);
                break;
            }
            case 128: {
                List groups = (List)node.getProperty(NodeConstants.Info.GROUP_COLS);
                if (groups == null || groups.isEmpty()) break;
                query.setGroupBy(new GroupBy(groups));
                break;
            }
            case 1024: {
                this.processLimit(node, query, metadata);
            }
        }
    }

    private void prepareSubqueries(List<SubqueryContainer> containers) {
        for (SubqueryContainer container : containers) {
            RuleCollapseSource.prepareSubquery(container);
        }
    }

    public static void prepareSubquery(SubqueryContainer container) {
        RelationalPlan subqueryPlan = (RelationalPlan)((Command)container.getCommand()).getProcessorPlan();
        AccessNode aNode = CriteriaCapabilityValidatorVisitor.getAccessNode(subqueryPlan);
        QueryCommand command = CriteriaCapabilityValidatorVisitor.getQueryCommand(aNode);
        if (command == null) {
            return;
        }
        SymbolMap map = ((Command)container.getCommand()).getCorrelatedReferences();
        if (map != null) {
            RuleMergeCriteria.ReferenceReplacementVisitor visitor = new RuleMergeCriteria.ReferenceReplacementVisitor(map);
            DeepPostOrderNavigator.doVisit(command, visitor);
        }
        command.setProcessorPlan(((Command)container.getCommand()).getProcessorPlan());
        boolean removeLimit = false;
        if (container instanceof ExistsCriteria) {
            removeLimit = !((ExistsCriteria)container).shouldEvaluate();
        } else if (container instanceof ScalarSubquery) {
            boolean bl = removeLimit = !((ScalarSubquery)container).shouldEvaluate();
        }
        if (removeLimit && command.getLimit() != null && command.getLimit().isImplicit()) {
            command.setLimit(null);
        }
        container.setCommand(command);
    }

    private void processLimit(PlanNode node, QueryCommand query, QueryMetadataInterface metadata) {
        Expression limit = (Expression)node.getProperty(NodeConstants.Info.MAX_TUPLE_LIMIT);
        Expression offset = (Expression)node.getProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT);
        PlanNode limitNode = NodeFactory.getNewNode(1024);
        Expression childLimit = null;
        Expression childOffset = null;
        if (query.getLimit() != null) {
            childLimit = query.getLimit().getRowLimit();
            childOffset = query.getLimit().getOffset();
        }
        RulePushLimit.combineLimits(limitNode, metadata, limit, offset, childLimit, childOffset);
        Limit lim = new Limit((Expression)limitNode.getProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT), (Expression)limitNode.getProperty(NodeConstants.Info.MAX_TUPLE_LIMIT));
        lim.setImplicit(node.hasBooleanProperty(NodeConstants.Info.IS_IMPLICIT_LIMIT));
        query.setLimit(lim);
    }

    private void moveWhereClauseIntoOnClause(Query query, List joinCrits) {
        if (query.getCriteria() == null) {
            return;
        }
        LinkedHashSet<Criteria> combinedCrits = new LinkedHashSet<Criteria>();
        combinedCrits.addAll(joinCrits);
        combinedCrits.addAll(Criteria.separateCriteriaByAnd(query.getCriteria()));
        joinCrits.clear();
        joinCrits.addAll(combinedCrits);
        query.setCriteria(null);
    }

    private void processOrderBy(PlanNode node, QueryCommand query) {
        OrderBy orderBy = (OrderBy)node.getProperty(NodeConstants.Info.SORT_ORDER);
        query.setOrderBy(orderBy);
        if (query instanceof Query) {
            List<Expression> cols = query.getProjectedSymbols();
            for (OrderByItem item : orderBy.getOrderByItems()) {
                item.setExpressionPosition(cols.indexOf(item.getSymbol()));
            }
            QueryRewriter.rewriteOrderBy(query, orderBy, query.getProjectedSymbols(), new LinkedList<OrderByItem>());
        }
    }

    private void simplifyFromClause(Query query) {
        From from = query.getFrom();
        List<FromClause> clauses = from.getClauses();
        FromClause rootClause = clauses.get(0);
        if (!RuleCollapseSource.hasOuterJoins(rootClause)) {
            from.setClauses(new ArrayList<FromClause>());
            this.shredJoinTree(rootClause, query);
        }
    }

    private void shredJoinTree(FromClause clause, Query query) {
        if (clause instanceof UnaryFromClause || clause instanceof SubqueryFromClause) {
            query.getFrom().addClause(clause);
        } else {
            JoinPredicate jp = (JoinPredicate)clause;
            List crits = jp.getJoinCriteria();
            if (crits != null && crits.size() > 0) {
                Criteria joinCrit = null;
                joinCrit = crits.size() > 1 ? new CompoundCriteria(crits) : (Criteria)crits.get(0);
                query.setCriteria(CompoundCriteria.combineCriteria(joinCrit, query.getCriteria()));
            }
            this.shredJoinTree(jp.getLeftClause(), query);
            this.shredJoinTree(jp.getRightClause(), query);
        }
    }

    static boolean hasOuterJoins(FromClause clause) {
        if (clause instanceof UnaryFromClause || clause instanceof SubqueryFromClause) {
            return false;
        }
        JoinPredicate jp = (JoinPredicate)clause;
        if (jp.getJoinType().isOuter()) {
            return true;
        }
        boolean childHasOuter = RuleCollapseSource.hasOuterJoins(jp.getLeftClause());
        if (childHasOuter) {
            return true;
        }
        return RuleCollapseSource.hasOuterJoins(jp.getRightClause());
    }

    public String toString() {
        return "CollapseSource";
    }

    public static Query rewriteGroupByExpressionsAsView(Query query, QueryMetadataInterface metadata) {
        if (query.getGroupBy() == null) {
            return query;
        }
        boolean hasExpression = false;
        Iterator<Expression> iterator = query.getGroupBy().getSymbols().iterator();
        while (!hasExpression && iterator.hasNext()) {
            hasExpression = !(iterator.next() instanceof ElementSymbol);
        }
        if (!hasExpression) {
            return query;
        }
        Select select = query.getSelect();
        GroupBy groupBy = query.getGroupBy();
        query.setGroupBy(null);
        Criteria having = query.getHaving();
        query.setHaving(null);
        OrderBy orderBy = query.getOrderBy();
        query.setOrderBy(null);
        Limit limit = query.getLimit();
        query.setLimit(null);
        HashSet<Expression> newSelectColumns = new HashSet<Expression>();
        Iterator<Expression> iterator2 = groupBy.getSymbols().iterator();
        while (iterator2.hasNext()) {
            newSelectColumns.add(iterator2.next());
        }
        HashSet<AggregateSymbol> aggs = new HashSet<AggregateSymbol>();
        aggs.addAll(AggregateSymbolCollectorVisitor.getAggregates(select, true));
        if (having != null) {
            aggs.addAll(AggregateSymbolCollectorVisitor.getAggregates(having, true));
        }
        for (AggregateSymbol aggregateSymbol : aggs) {
            for (Expression expr : aggregateSymbol.getArgs()) {
                newSelectColumns.add(SymbolMap.getExpression(expr));
            }
        }
        Select innerSelect = new Select();
        for (Expression expr : newSelectColumns) {
            innerSelect.addSymbol(expr);
        }
        query.setSelect(innerSelect);
        Query outerQuery = null;
        try {
            outerQuery = QueryRewriter.createInlineViewQuery(new GroupSymbol("X"), query, metadata, query.getSelect().getProjectedSymbols());
        }
        catch (TeiidException err) {
            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30257, (Throwable)err);
        }
        Iterator<Expression> iter = outerQuery.getSelect().getProjectedSymbols().iterator();
        HashMap<Expression, Expression> expressionMap = new HashMap<Expression, Expression>();
        for (Expression symbol : query.getSelect().getProjectedSymbols()) {
            expressionMap.put(SymbolMap.getExpression(symbol), iter.next());
        }
        ExpressionMappingVisitor.mapExpressions(groupBy, expressionMap);
        outerQuery.setGroupBy(groupBy);
        ExpressionMappingVisitor.mapExpressions(having, expressionMap);
        outerQuery.setHaving(having);
        ExpressionMappingVisitor.mapExpressions(orderBy, expressionMap);
        outerQuery.setOrderBy(orderBy);
        outerQuery.setLimit(limit);
        ExpressionMappingVisitor.mapExpressions(select, expressionMap);
        outerQuery.setSelect(select);
        outerQuery.setOption(query.getOption());
        query = outerQuery;
        return query;
    }
}

