/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.StringUtil;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Table;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionMethods;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.parser.ParseException;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.Token;
import org.teiid.query.sql.lang.AlterTrigger;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.SourceHint;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.translator.TranslatorException;

public class SQLParserUtil {
    static Pattern udtPattern = Pattern.compile("(\\w+)\\s*\\(\\s*(\\d+),\\s*(\\d+),\\s*(\\d+)\\)");
    public static final boolean DECIMAL_AS_DOUBLE = PropertiesUtils.getBooleanProperty((Properties)System.getProperties(), (String)"org.teiid.decimalAsDouble", (boolean)false);
    private static Pattern SOURCE_HINT = Pattern.compile("\\s*sh(?::((?:'[^']*')+))?\\s*", 34);
    private static Pattern SOURCE_HINT_ARG = Pattern.compile("\\s*([^:]+):((?:'[^']*')+)", 34);
    private static Pattern CACHE_HINT = Pattern.compile("/\\*\\+?\\s*cache(\\(\\s*(pref_mem)?\\s*(ttl:\\d{1,19})?\\s*(updatable)?\\s*(scope:(session|vdb|user))?[^\\)]*\\))?[^\\*]*\\*\\/.*", 34);

    String prependSign(String sign, String literal) {
        if (sign != null && sign.charAt(0) == '-') {
            return sign + literal;
        }
        return literal;
    }

    void convertToParameters(List<Expression> values, StoredProcedure storedProcedure) {
        for (Expression value : values) {
            SPParameter parameter = new SPParameter(storedProcedure.getParameters().size() + 1, value);
            parameter.setParameterType(1);
            storedProcedure.setParameter(parameter);
        }
    }

    String matchesAny(String arg, String ... expected) {
        for (String string : expected) {
            if (!string.equalsIgnoreCase(arg)) continue;
            return arg;
        }
        return null;
    }

    String normalizeStringLiteral(String s) {
        int start = 1;
        boolean unescape = false;
        if (s.charAt(0) == 'N') {
            ++start;
        } else if (s.charAt(0) == 'E') {
            ++start;
            unescape = true;
        }
        char tickChar = s.charAt(start - 1);
        s = s.substring(start, s.length() - 1);
        String result = SQLParserUtil.removeEscapeChars(s, String.valueOf(tickChar));
        if (unescape) {
            result = FunctionMethods.unescape(result);
        }
        return result;
    }

    public static String normalizeId(String s) {
        if (s.indexOf(34) == -1) {
            return s;
        }
        LinkedList<String> nameParts = new LinkedList<String>();
        block0: while (s.length() > 0) {
            if (s.charAt(0) == '\"') {
                boolean escape = false;
                for (int i = 1; i < s.length(); ++i) {
                    boolean end;
                    if (s.charAt(i) != '\"') continue;
                    escape = !escape;
                    boolean bl = end = i == s.length() - 1;
                    if (!end && (!escape || s.charAt(i + 1) != '.')) continue;
                    String part = s.substring(1, i);
                    s = s.substring(i + (end ? 1 : 2));
                    nameParts.add(SQLParserUtil.removeEscapeChars(part, "\""));
                    continue block0;
                }
                continue;
            }
            int index = s.indexOf(46);
            if (index == -1) {
                nameParts.add(s);
                break;
            }
            nameParts.add(s.substring(0, index));
            s = s.substring(index + 1);
        }
        StringBuilder sb = new StringBuilder();
        Iterator i = nameParts.iterator();
        while (i.hasNext()) {
            sb.append((String)i.next());
            if (!i.hasNext()) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    boolean isStringLiteral(String str, ParseInfo info) {
        if (info.useAnsiQuotedIdentifiers() || str.charAt(0) != '\"' || str.charAt(str.length() - 1) != '\"') {
            return false;
        }
        for (int index = 1; index < str.length() - 1; index += 2) {
            if ((index = str.indexOf(34, index)) == -1 || index + 1 == str.length()) {
                return true;
            }
            if (str.charAt(index + 1) == '\"') continue;
            return false;
        }
        return true;
    }

    String validateAlias(String id) throws ParseException {
        return this.validateName(id, false);
    }

    private String validateName(String id, boolean element) throws ParseException {
        if (id.indexOf(46) != -1) {
            String key = "SQLParser.Invalid_alias";
            if (element) {
                key = "SQLParser.Invalid_short_name";
            }
            throw new ParseException(QueryPlugin.Util.getString(key, new Object[]{id}));
        }
        return id;
    }

    String validateElementName(String id) throws ParseException {
        return this.validateName(id, true);
    }

    static String removeEscapeChars(String str, String tickChar) {
        return StringUtil.replaceAll((String)str, (String)(tickChar + tickChar), (String)tickChar);
    }

    void setFromClauseOptions(Token groupID, FromClause fromClause) {
        String[] parts = this.getComment(groupID).split("\\s");
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].equalsIgnoreCase("optional")) {
                fromClause.setOptional(true);
                continue;
            }
            if (parts[i].equalsIgnoreCase("MAKEDEP")) {
                fromClause.setMakeDep(true);
                continue;
            }
            if (parts[i].equalsIgnoreCase("MAKENOTDEP")) {
                fromClause.setMakeNotDep(true);
                continue;
            }
            if (parts[i].equalsIgnoreCase(FromClause.MAKEIND)) {
                fromClause.setMakeInd(true);
                continue;
            }
            if (!parts[i].equalsIgnoreCase(ExistsCriteria.SubqueryHint.NOUNNEST)) continue;
            fromClause.setNoUnnest(true);
        }
    }

    ExistsCriteria.SubqueryHint getSubqueryHint(Token t) {
        ExistsCriteria.SubqueryHint hint = new ExistsCriteria.SubqueryHint();
        String[] parts = this.getComment(t).split("\\s");
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].equalsIgnoreCase(ExistsCriteria.SubqueryHint.MJ)) {
                hint.setMergeJoin(true);
                continue;
            }
            if (parts[i].equalsIgnoreCase(ExistsCriteria.SubqueryHint.NOUNNEST)) {
                hint.setNoUnnest(true);
                continue;
            }
            if (!parts[i].equalsIgnoreCase(ExistsCriteria.SubqueryHint.DJ)) continue;
            hint.setDepJoin(true);
        }
        return hint;
    }

    String getComment(Token t) {
        Token optToken = t.specialToken;
        if (optToken == null) {
            return "";
        }
        String image = optToken.image;
        while (optToken.specialToken != null) {
            optToken = optToken.specialToken;
            image = optToken.image + image;
        }
        String hint = image.substring(2, image.length() - 2);
        if (hint.startsWith("+")) {
            hint = hint.substring(1);
        }
        return hint;
    }

    SourceHint getSourceHint(Token t) {
        String comment = this.getComment(t);
        Matcher matcher = SOURCE_HINT.matcher(comment);
        if (!matcher.find()) {
            return null;
        }
        SourceHint sourceHint = new SourceHint();
        String generalHint = matcher.group(1);
        if (generalHint != null) {
            sourceHint.setGeneralHint(this.normalizeStringLiteral(generalHint));
        }
        int end = matcher.end();
        matcher = SOURCE_HINT_ARG.matcher(comment);
        while (matcher.find(end)) {
            end = matcher.end();
            sourceHint.setSourceHint(matcher.group(1), this.normalizeStringLiteral(matcher.group(2)));
        }
        return sourceHint;
    }

    boolean isNonStrictHint(Token t) {
        String[] parts = this.getComment(t).split("\\s");
        for (int i = 0; i < parts.length; ++i) {
            if (!parts[i].equalsIgnoreCase(Limit.NON_STRICT)) continue;
            return true;
        }
        return false;
    }

    static CacheHint getQueryCacheOption(String query) {
        Matcher match = CACHE_HINT.matcher(query);
        if (match.matches()) {
            String scope;
            String ttl;
            CacheHint hint = new CacheHint();
            if (match.group(2) != null) {
                hint.setPrefersMemory(true);
            }
            if ((ttl = match.group(3)) != null) {
                hint.setTtl(Long.valueOf(ttl.substring(4)));
            }
            if (match.group(4) != null) {
                hint.setUpdatable(true);
            }
            if ((scope = match.group(5)) != null) {
                scope = scope.substring(6);
                hint.setScope(scope);
            }
            return hint;
        }
        return null;
    }

    JoinType getJoinType(Token joinTypeToken) throws ParseException {
        if (joinTypeToken == null) {
            return JoinType.JOIN_INNER;
        }
        String joinType = joinTypeToken.image;
        if (joinType.equalsIgnoreCase("INNER")) {
            return JoinType.JOIN_INNER;
        }
        if (joinType.equalsIgnoreCase("CROSS")) {
            return JoinType.JOIN_CROSS;
        }
        if (joinType.equalsIgnoreCase("LEFT")) {
            return JoinType.JOIN_LEFT_OUTER;
        }
        if (joinType.equalsIgnoreCase("RIGHT")) {
            return JoinType.JOIN_RIGHT_OUTER;
        }
        if (joinType.equalsIgnoreCase("FULL")) {
            return JoinType.JOIN_FULL_OUTER;
        }
        if (joinType.equalsIgnoreCase("UNION")) {
            return JoinType.JOIN_UNION;
        }
        Object[] params = new Object[]{joinType};
        throw new ParseException(QueryPlugin.Util.getString("SQLParser.Unknown_join_type", params));
    }

    int getOperator(String opString) {
        if (opString.equals("=")) {
            return 1;
        }
        if (opString.equals("<>") || opString.equals("!=")) {
            return 2;
        }
        if (opString.equals("<")) {
            return 3;
        }
        if (opString.equals(">")) {
            return 4;
        }
        if (opString.equals("<=")) {
            return 5;
        }
        if (opString.equals(">=")) {
            return 6;
        }
        Assertion.failed((String)"unknown operator");
        return 0;
    }

    SetQuery addQueryToSetOperation(QueryCommand query, QueryCommand rightQuery, SetQuery.Operation type, boolean all) {
        SetQuery setQuery = new SetQuery(type, all, query, rightQuery);
        return setQuery;
    }

    static Block asBlock(Statement stmt) {
        if (stmt == null) {
            return null;
        }
        if (stmt instanceof Block) {
            return (Block)stmt;
        }
        return new Block(stmt);
    }

    void setColumnOptions(BaseColumn c) throws ParseException {
        Map props = c.getProperties();
        this.setCommonProperties((AbstractMetadataRecord)c, props);
        String v = (String)props.remove("RADIX");
        if (v != null) {
            c.setRadix(Integer.parseInt(v));
        }
        if (c instanceof Column) {
            this.setColumnOptions((Column)c, props);
        }
    }

    private void setColumnOptions(Column c, Map<String, String> props) throws ParseException {
        String v = props.remove("CASE_SENSITIVE");
        if (v != null) {
            c.setCaseSensitive(SQLParserUtil.isTrue(v));
        }
        if ((v = props.remove("SELECTABLE")) != null) {
            c.setSelectable(SQLParserUtil.isTrue(v));
        }
        if ((v = props.remove("UPDATABLE")) != null) {
            c.setUpdatable(SQLParserUtil.isTrue(v));
        }
        if ((v = props.remove("SIGNED")) != null) {
            c.setSigned(SQLParserUtil.isTrue(v));
        }
        if ((v = props.remove("CURRENCY")) != null) {
            c.setSigned(SQLParserUtil.isTrue(v));
        }
        if ((v = props.remove("FIXED_LENGTH")) != null) {
            c.setFixedLength(SQLParserUtil.isTrue(v));
        }
        if ((v = props.remove("SEARCHABLE")) != null) {
            c.setSearchType(Column.SearchType.valueOf((String)v.toUpperCase()));
        }
        if ((v = props.remove("MIN_VALUE")) != null) {
            c.setMinimumValue(v);
        }
        if ((v = props.remove("MAX_VALUE")) != null) {
            c.setMaximumValue(v);
        }
        if ((v = props.remove("CHAR_OCTET_LENGTH")) != null) {
            c.setCharOctetLength(Integer.parseInt(v));
        }
        if ((v = props.remove("NATIVE_TYPE")) != null) {
            c.setNativeType(v);
        }
        if ((v = props.remove("NULL_VALUE_COUNT")) != null) {
            c.setNullValues(Integer.parseInt(v));
        }
        if ((v = props.remove("DISTINCT_VALUES")) != null) {
            c.setDistinctValues(Integer.parseInt(v));
        }
        if ((v = props.remove("UDT")) != null) {
            Matcher matcher = udtPattern.matcher(v);
            Map datatypes = SystemMetadata.getInstance().getSystemStore().getDatatypes();
            if (matcher.matches() && datatypes.get(matcher.group(1)) != null) {
                c.setDatatype((Datatype)datatypes.get(matcher.group(1)));
                c.setLength(Integer.parseInt(matcher.group(2)));
                c.setPrecision(Integer.parseInt(matcher.group(3)));
                c.setScale(Integer.parseInt(matcher.group(4)));
            } else {
                throw new ParseException(QueryPlugin.Util.getString("udt_format_wrong", new Object[]{c.getName()}));
            }
        }
    }

    void setCommonProperties(AbstractMetadataRecord c, Map<String, String> props) {
        String v = props.remove("UUID");
        if (v != null) {
            c.setUUID(v);
        }
        if ((v = props.remove("ANNOTATION")) != null) {
            c.setAnnotation(v);
        }
        if ((v = props.remove("NAMEINSOURCE")) != null) {
            c.setNameInSource(v);
        }
    }

    void setTableOptions(Table table) {
        Map props = table.getProperties();
        this.setCommonProperties((AbstractMetadataRecord)table, props);
        String value = (String)props.remove("MATERIALIZED");
        if (value != null) {
            table.setMaterialized(SQLParserUtil.isTrue(value));
        }
        if ((value = (String)props.remove("MATERIALIZED_TABLE")) != null) {
            Table mattable = new Table();
            mattable.setName(value);
            table.setMaterializedTable(mattable);
        }
        if ((value = (String)props.remove("UPDATABLE")) != null) {
            table.setSupportsUpdate(SQLParserUtil.isTrue(value));
        }
        if ((value = (String)props.remove("CARDINALITY")) != null) {
            table.setCardinality(Integer.parseInt(value));
        }
    }

    static void replaceProcedureWithFunction(MetadataFactory factory, Procedure proc) throws ParseException {
        FunctionMethod method = new FunctionMethod();
        method.setName(proc.getName());
        method.setPushdown(proc.isVirtual() ? FunctionMethod.PushDown.CAN_PUSHDOWN : FunctionMethod.PushDown.MUST_PUSHDOWN);
        ArrayList<FunctionParameter> ins = new ArrayList<FunctionParameter>();
        for (ProcedureParameter pp : proc.getParameters()) {
            if (pp.getType() == ProcedureParameter.Type.InOut || pp.getType() == ProcedureParameter.Type.Out) {
                throw new ParseException(QueryPlugin.Util.getString("SQLParser.function_in", new Object[]{proc.getName()}));
            }
            FunctionParameter fp = new FunctionParameter(pp.getName(), pp.getRuntimeType(), pp.getAnnotation());
            if (pp.getType() == ProcedureParameter.Type.In) {
                fp.setVarArg(pp.isVarArg());
                ins.add(fp);
                continue;
            }
            method.setOutputParameter(fp);
        }
        method.setInputParameters(ins);
        if (proc.getResultSet() != null || method.getOutputParameter() == null) {
            throw new ParseException(QueryPlugin.Util.getString("SQLParser.function_return", new Object[]{proc.getName()}));
        }
        method.setAnnotation(proc.getAnnotation());
        method.setNameInSource(proc.getNameInSource());
        method.setUUID(proc.getUUID());
        Map props = proc.getProperties();
        String value = (String)props.remove("CATEGORY");
        method.setCategory(value);
        value = (String)props.remove("DETERMINISM");
        if (value != null) {
            method.setDeterminism(FunctionMethod.Determinism.valueOf((String)value.toUpperCase()));
        }
        value = (String)props.remove("JAVA_CLASS");
        method.setInvocationClass(value);
        value = (String)props.remove("JAVA_METHOD");
        method.setInvocationMethod(value);
        for (String key : props.keySet()) {
            value = (String)props.get(key);
            method.setProperty(key, value);
        }
        FunctionMethod.convertExtensionMetadata((Procedure)proc, (FunctionMethod)method);
        factory.getSchema().addFunction(method);
        factory.getSchema().getProcedures().remove(proc.getName());
    }

    void setProcedureOptions(Procedure proc) {
        Map props = proc.getProperties();
        this.setCommonProperties((AbstractMetadataRecord)proc, props);
        String value = (String)props.remove("UPDATECOUNT");
        if (value != null) {
            proc.setUpdateCount(Integer.parseInt(value));
        }
    }

    public static boolean isTrue(String text) {
        return Boolean.valueOf(text);
    }

    Column getColumn(String columnName, Table table) throws ParseException {
        Column c = table.getColumnByName(columnName);
        if (c != null) {
            return c;
        }
        throw new ParseException(QueryPlugin.Util.getString("SQLParser.no_column", new Object[]{columnName, table.getName()}));
    }

    void createDDLTrigger(MetadataFactory schema, AlterTrigger trigger) {
        GroupSymbol group = trigger.getTarget();
        Table table = schema.getSchema().getTable(group.getName());
        if (trigger.getEvent().equals((Object)Table.TriggerEvent.INSERT)) {
            table.setInsertPlan(((TriggerAction)trigger.getDefinition()).toString());
        } else if (trigger.getEvent().equals((Object)Table.TriggerEvent.UPDATE)) {
            table.setUpdatePlan(((TriggerAction)trigger.getDefinition()).toString());
        } else if (trigger.getEvent().equals((Object)Table.TriggerEvent.DELETE)) {
            table.setDeletePlan(((TriggerAction)trigger.getDefinition()).toString());
        }
    }

    BaseColumn addProcColumn(MetadataFactory factory, Procedure proc, String name, ParsedDataType type, boolean rs) throws ParseException {
        try {
            name = this.validateElementName(name);
            Column column = null;
            if (rs) {
                column = factory.addProcedureResultSetColumn(name, type.type, proc);
            } else {
                boolean added = false;
                for (ProcedureParameter pp : proc.getParameters()) {
                    if (pp.getType() != ProcedureParameter.Type.ReturnValue) continue;
                    added = true;
                    if (pp.getDatatype() == factory.getDataTypes().get(type.type)) continue;
                    throw new ParseException(QueryPlugin.Util.getString("SQLParser.proc_type_conflict", new Object[]{proc.getName(), pp.getDatatype(), type.type}));
                }
                if (!added) {
                    column = factory.addProcedureParameter(name, type.type, ProcedureParameter.Type.ReturnValue, proc);
                }
            }
            this.setTypeInfo(type, (BaseColumn)column);
            return column;
        }
        catch (TranslatorException e) {
            throw new ParseException(e.getMessage());
        }
    }

    void setTypeInfo(ParsedDataType type, BaseColumn column) {
        if (type.length != null) {
            column.setLength(type.length.intValue());
        }
        if (type.scale != null) {
            column.setScale(type.scale.intValue());
        }
        if (type.precision != null) {
            column.setPrecision(type.precision.intValue());
        }
    }

    static String resolvePropertyKey(MetadataFactory factory, String key) {
        int index = key.indexOf(58);
        if (index > 0 && index < key.length() - 1) {
            String prefix = key.substring(0, index);
            String uri = (String)factory.getNamespaces().get(prefix);
            if (uri != null) {
                key = '{' + uri + '}' + key.substring(index + 1, key.length());
            }
        }
        return key;
    }

    static class ParsedDataType {
        String type;
        Integer length;
        Integer scale;
        Integer precision;

        public ParsedDataType(String type) {
            this.type = type;
        }

        public ParsedDataType(String type, int length, boolean precision) {
            this.type = type;
            if (precision) {
                this.precision = length;
            } else {
                this.length = length;
            }
        }

        public ParsedDataType(String type, int length, int scale, boolean precision) {
            this.type = type;
            this.scale = scale;
            if (precision) {
                this.precision = length;
            } else {
                this.length = length;
            }
        }
    }
}

